## Why is this an issue?

Regardless of the logging framework in use (Microsoft.Extension.Logging, Serilog, Log4net, NLog, …​​), logger fields should be:

- **private**: this restricts access to the logger from outside the enclosing type (class, struct, record…​). Using any other access
  modifier would allow other types to use the logger to log messages in the type where it’s defined.
- **static**: making the logger field `static` will ensure that the lifetime of the object doesn’t depend on the lifetime
  of the instance of the enclosing type.
- **readonly**: marking the field as `readonly` will prevent modifications to the reference of the logger. This ensures
  that the reference to the logger remains consistent and doesn’t get accidentally reassigned during the lifetime of the enclosing type.

This rule should be activated when [Service Locator Design pattern](https://en.wikipedia.org/wiki/Service_locator_pattern) is followed
in place of [Dependency Injection](https://en.wikipedia.org/wiki/Dependency_injection) for logging.

The rule supports the most popular logging frameworks:

- [Microsoft.Extensions.Logging](https://www.nuget.org/packages/Microsoft.Extensions.Logging)
- [Serilog](https://www.nuget.org/packages/Serilog)
- [Castle.Core](https://www.nuget.org/packages/Castle.Core)
- [NLog](https://www.nuget.org/packages/NLog)
- [log4net](https://www.nuget.org/packages/log4net)

## How to fix it

Make the logging field `{private static readonly}`.

### Noncompliant code example

    public Logger logger;

### Compliant solution

    private static readonly Logger logger;

## Resources

### Documentation

- Microsoft Learn - [Access
  modifiers](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/access-modifiers)
- Microsoft Learn - [`static` class members](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/static-classes-and-static-class-members)
- Microsoft Learn - [`readonly`
  keyword](https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/readonly)
- Wikipedia - [Service locator pattern](https://en.wikipedia.org/wiki/Service_locator_pattern)
- Wikipedia - [Dependency injection](https://en.wikipedia.org/wiki/Dependency_injection)

### Articles & blog posts

- [C# `private`, `static`, and
  `readonly`](https://stackoverflow.com/questions/968132/c-sharp-private-static-and-readonly)