## Why is this an issue?

This rule applies whenever an `if` statement is followed by one or more `else if` statements; the final `else if`
should be followed by an `else` statement.

The requirement for a final `else` statement is defensive programming.

The `else` statement should either take appropriate action or contain a suitable comment as to why no action is taken. This is
consistent with the requirement to have a final `default` clause in a `switch` statement.

### Noncompliant code example

    if (x == 0)
    {
        DoSomething();
    }
    else if (x == 1)
    {
        DoSomethingElse();
    }

### Compliant solution

    if (x == 0)
    {
        DoSomething();
    }
    else if (x == 1)
    {
        DoSomethingElse();
    }
    else
    {
        throw new InvalidOperationException();
    }

### Exceptions

None