## Why is this an issue?

While it is technically correct to assign to parameters from within method bodies, doing so before the parameter value is read is likely a bug.
Instead, initial values of parameters, caught exceptions, and foreach parameters should be, if not treated as `final`, then at least read
before reassignment.

### Noncompliant code example

    public void DoTheThing(string str, int i, List<string> strings)
    {
      str = i.ToString(i);  // Noncompliant
    
      foreach (var s in strings)
      {
        s = "hello world";  // Noncompliant
      }
    }