## Why is this an issue?

Putting multiple statements on a single line lowers the code readability and makes debugging the code more complex.

    if (someCondition) DoSomething(); // Noncompliant

Write one statement per line to improve readability.

    if (someCondition)
    {
      DoSomething();
    }

### Exceptions

The rule ignores:

- block statements
- anonymous functions containing a single statement

    Func<object, bool> item1 = o => { return true; }; // Compliant by exception
    Func<object, bool> item1 = o => { var r = false; return r; }; // Noncompliant

## Resources

### Documentation

- [C# formatting options](https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/style-rules/csharp-formatting-options)