Control structures are code statements that impact the program’s control flow (e.g., if statements, for loops, etc.)

## Why is this an issue?

While not technically incorrect, the omission of curly braces can be misleading and may lead to the introduction of errors during maintenance.

In the following example, the two calls seem to be attached to the `if` statement, but only the first one is, and
`CheckSomething` will always be executed:

    if (condition) // Noncompliant
      ExecuteSomething();
      CheckSomething();

Adding curly braces improves the code readability and its robustness:

    if (condition)
    {
      ExecuteSomething();
      CheckSomething();
    }

The rule raises an issue when a control structure has no curly braces.