## Why is this an issue?

Duplicated string literals make the process of refactoring complex and error-prone, as any change would need to be propagated on all
occurrences.

### Exceptions

The following are ignored:

- literals with fewer than 5 characters
- literals matching one of the parameter names
- literals used in attributes

## How to fix it

Use constants to replace the duplicated string literals. Constants can be referenced from many places, but only need to be updated in a single
place.

### Code examples

#### Noncompliant code example

    public class Foo
    {
        private string name = "foobar"; // Noncompliant
    
        public string DefaultName { get; } = "foobar"; // Noncompliant
    
        public Foo(string value = "foobar") // Noncompliant
        {
            var something = value ?? "foobar"; // Noncompliant
        }
    }

#### Compliant solution

    public class Foo
    {
        private const string Foobar = "foobar";
    
        private string name = Foobar;
    
        public string DefaultName { get; } = Foobar;
    
        public Foo(string value = Foobar)
        {
            var something = value ?? Foobar;
        }
    }