## Why is this an issue?

An empty method is generally considered bad practice and can lead to confusion, readability, and maintenance issues. Empty methods bring no
functionality and are misleading to others as they might think the method implementation fulfills a specific and identified requirement.

There are several reasons for a method not to have a body:

- It is an unintentional omission, and should be fixed to prevent an unexpected behavior in production.
- It is not yet, or never will be, supported. In this case an exception should be thrown.
- The method is an intentionally-blank override. In this case a nested comment should explain the reason for the blank override.

### Exceptions

The following empty methods are considered compliant:

- empty `virtual` methods as the implementation might not be required in the base class
- empty methods that override an `abstract` method as the implementation is mandatory for child class
- empty overrides in test assemblies for mocking purposes

## How to fix it

### Code examples

#### Noncompliant code example

    public void ShouldNotBeEmpty() {  // Noncompliant - method is empty
    }
    
    public void NotImplementedYet() {  // Noncompliant - method is empty
    }
    
    public void WillNeverBeImplemented() {  // Noncompliant - method is empty
    }
    
    public void EmptyOnPurpose() {  // Noncompliant - method is empty
    }

#### Compliant solution

    public void ShouldNotBeEmpty() {
        DoSomething();
    }
    
    public void NotImplementedYet() {
        throw new NotImplementedException();
    }
    
    public void WillNeverBeImplemented() {
        throw new NotSupportedException();
    }
    
    public void EmptyOnPurpose() {
      // comment explaining why the method is empty
    }

#### Compliant solution