## Why is this an issue?

A typical code smell known as unused function parameters refers to parameters declared in a function but not used anywhere within the function’s
body. While this might seem harmless at first glance, it can lead to confusion and potential errors in your code. Disregarding the values passed to
such parameters, the function’s behavior will be the same, but the programmer’s intention won’t be clearly expressed anymore. Therefore, removing
function parameters that are not being utilized is considered best practice.

This rule raises an issue when a `private` method or constructor of a class/struct takes a parameter without using it.

### Exceptions

This rule doesn’t raise any issue in the following contexts:

- The `this` parameter of extension methods.
- Methods decorated with attributes.
- Empty methods.
- Methods which only throw `NotImplementedException`.
- The Main method of the application.
- `virtual`, `override` methods.
- interface implementations.

## How to fix it

Having unused function parameters in your code can lead to confusion and misunderstanding of a developer’s intention. They reduce code readability
and introduce the potential for errors. To avoid these problems, developers should remove unused parameters from function declarations.

### Code examples

#### Noncompliant code example

    private void DoSomething(int a, int b) // Noncompliant, "b" is unused
    {
        Compute(a);
    }
    
    private void DoSomething2(int a) // Noncompliant, the value of "a" is unused
    {
        a = 10;
        Compute(a);
    }

#### Compliant solution

    private void DoSomething(int a)
    {
        Compute(a);
    }
    
    private void DoSomething2()
    {
        var a = 10;
        Compute(a);
    }