## Why is this an issue?

If an exception is already being thrown within the `try` block or caught in a `catch` block, throwing another exception in
the `finally` block will override the original exception. This means that the original exception’s message and stack trace will be lost,
potentially making it challenging to diagnose and troubleshoot the root cause of the problem.

    try
    {
      // Some work which end up throwing an exception
      throw new ArgumentException();
    }
    finally
    {
      // Cleanup
      throw new InvalidOperationException(); // Noncompliant: will mask the ArgumentException
    }

    try
    {
      // Some work which end up throwing an exception
      throw new ArgumentException();
    }
    finally
    {
      // Cleanup without throwing
    }

## Resources

### Documentation

- [Exceptions and Exception Handling](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/exceptions/)
- [Finally blocks](https://learn.microsoft.com/en-us/dotnet/standard/exceptions/how-to-use-finally-blocks)
- [How to execute
  cleanup code using finally](https://learn.microsoft.com/en-us/dotnet/csharp/fundamentals/exceptions/how-to-execute-cleanup-code-using-finally)