## Why is this an issue?

The `switch` statement should be used only to clearly define some new branches in the control flow. As soon as a `case`
clause contains too many statements this highly decreases the readability of the overall control flow statement. In such case, the content of the
`case` clause should be extracted into a dedicated method.

### Noncompliant code example

With the default threshold of 8:

    switch (myVariable)
    {
        case 0: // Noncompliant: 9 statements in the case
            methodCall1("");
            methodCall2("");
            methodCall3("");
            methodCall4("");
            methodCall5("");
            methodCall6("");
            methodCall7("");
            methodCall8("");
            methodCall9("");
            break;
        case 1:
            ...
    }

### Compliant solution

    switch (myVariable)
    {
        case 0:
            DoSomething()
            break;
        case 1:
            ...
    }
    ...
    private void DoSomething()
    {
        methodCall1("");
        methodCall2("");
        methodCall3("");
        methodCall4("");
        methodCall5("");
        methodCall6("");
        methodCall7("");
        methodCall8("");
        methodCall9("");
    }