## Why is this an issue?

Developers often use `TODO` tags to mark areas in the code where additional work or improvements are needed but are not implemented
immediately. However, these `TODO` tags sometimes get overlooked or forgotten, leading to incomplete or unfinished code. This rule aims to
identify and address unattended `TODO` tags to ensure a clean and maintainable codebase. This description explores why this is a problem
and how it can be fixed to improve the overall code quality.

### What is the potential impact?

Unattended `TODO` tags in code can have significant implications for the development process and the overall codebase.

Incomplete Functionality: When developers leave `TODO` tags without implementing the corresponding code, it results in incomplete
functionality within the software. This can lead to unexpected behavior or missing features, adversely affecting the end-user experience.

Missed Bug Fixes: If developers do not promptly address `TODO` tags, they might overlook critical bug fixes and security updates.
Delayed bug fixes can result in more severe issues and increase the effort required to resolve them later.

Impact on Collaboration: In team-based development environments, unattended `TODO` tags can hinder collaboration. Other team members
might not be aware of the intended changes, leading to conflicts or redundant efforts in the codebase.

Codebase Bloat: The accumulation of unattended `TODO` tags over time can clutter the codebase and make it difficult to distinguish
between work in progress and completed code. This bloat can make it challenging to maintain an organized and efficient codebase.

Addressing this code smell is essential to ensure a maintainable, readable, reliable codebase and promote effective collaboration among
developers.

### Noncompliant code example

    private void DoSomething()
    {
      // TODO
    }

## Resources

- CWE - [CWE-546 - Suspicious Comment](https://cwe.mitre.org/data/definitions/546)