## Why is this an issue?

A boolean literal can be represented in two different ways: `true` or `false`. They can be combined with logical operators
(`!, &&, ||, ==, !=`) to produce logical expressions that represent truth values. However, comparing a boolean literal to a
variable or expression that evaluates to a boolean value is unnecessary and can make the code harder to read and understand. The more complex a
boolean expression is, the harder it will be for developers to understand its meaning and expected behavior, and it will favour the introduction of
new bugs.

## How to fix it

Remove redundant boolean literals from expressions to improve readability and make the code more maintainable.

### Code examples

#### Noncompliant code example

    if (booleanMethod() == true) { /* ... */ }
    if (booleanMethod() == false) { /* ... */ }
    if (booleanMethod() || false) { /* ... */ }
    doSomething(!false);
    doSomething(booleanMethod() == true);
    
    booleanVariable = booleanMethod() ? true : false;
    booleanVariable = booleanMethod() ? true : exp;
    booleanVariable = booleanMethod() ? false : exp;
    booleanVariable = booleanMethod() ? exp : true;
    booleanVariable = booleanMethod() ? exp : false;
    
    for (var x = 0; true; x++)
    {
     ...
    }

#### Compliant solution

    if (booleanMethod()) { /* ... */ }
    if (!booleanMethod()) { /* ... */ }
    if (booleanMethod()) { /* ... */ }
    doSomething(true);
    doSomething(booleanMethod());
    
    booleanVariable = booleanMethod();
    booleanVariable = booleanMethod() || exp;
    booleanVariable = !booleanMethod() && exp;
    booleanVariable = !booleanMethod() || exp;
    booleanVariable = booleanMethod() && exp;
    
    for (var x = 0; ; x++)
    {
     ...
    }