## Why is this an issue?

The `Obsolete` attribute can be applied with or without a message argument. Marking something `Obsolete` without including
advice on why it’s obsolete or what to use instead will lead maintainers to waste time trying to figure those things out.

### Noncompliant code example

    public class Car
    {
    
      [Obsolete]  // Noncompliant
      public void CrankEngine(int turnsOfCrank)
      { ... }
    }

### Compliant solution

    public class Car
    {
    
      [Obsolete("Replaced by the automatic starter")]
      public void CrankEngine(int turnsOfCrank)
      { ... }
    }