## Why is this an issue?

Shadowing occurs when a local variable has the same name as a variable, field, or property in an outer scope.

This can lead to three main problems:

- Confusion: The same name can refer to different variables in different parts of the scope, making the code hard to read and understand.
- Unintended Behavior: You might accidentally use the wrong variable, leading to hard-to-detect bugs.
- Maintenance Issues: If the inner variable is removed or renamed, the code’s behavior might change unexpectedly because the outer variable is
  now being used.

To avoid these problems, rename the shadowing, shadowed, or both variables/fields/properties to accurately represent their purpose with unique and
meaningful names. It improves clarity and allows reasoning locally about the code without considering other software parts.

This rule focuses on variables shadowing fields or properties.

### Noncompliant code example

    class Foo
    {
      public int myField;
      public int MyProperty { get; set; }
    
      public void DoSomething()
      {
        int myField = 0;    // Noncompliant
        int MyProperty = 0; // Noncompliant
      }
    }

## Resources

### Documentation

- Microsoft Learn - [Fields](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/fields)
- Microsoft Learn - [Properties](https://learn.microsoft.com/en-us/dotnet/csharp/programming-guide/classes-and-structs/properties)

### Related rules

- {rule:csharpsquid:S2387} - Child class fields should not shadow parent class fields
- {rule:csharpsquid:S3218} - Inner class members should not shadow outer class "static" or type members