## Why is this an issue?

Empty statements represented by a semicolon `;` are statements that do not perform any operation. They are often the result of a typo or
a misunderstanding of the language syntax. It is a good practice to remove empty statements since they don’t add value and lead to confusion and
errors.

### Code examples

#### Noncompliant code example

    void DoSomething()
    {
        ; // Noncompliant - was used as a kind of TODO marker
    }
    
    void DoSomethingElse()
    {
        Console.WriteLine("Hello, world!");;  // Noncompliant - double ;
        // ...
        // Rarely, they are used on purpose as the body of a loop. It is a bad practice to
        // have side-effects outside of the loop:
        for (int i = 0; i < 3; Console.WriteLine(i), i++); // Noncompliant
        // ...
    }

#### Compliant solution

    void DoSomething()
    {
    }
    
    void DoSomethingElse()
    {
        Console.WriteLine("Hello, world!");
        // ...
        for (int i = 0; i < 3; i++)
        {
            Console.WriteLine(i);
         }
        // ...
    }