## Why is this an issue?

Parentheses can disambiguate the order of operations in complex expressions and make the code easier to understand.

    a = (b * c) + (d * e); // Compliant: the intent is clear.

Redundant parentheses are parenthesis that do not change the behavior of the code, and do not clarify the intent. They can mislead and complexify
the code. They should be removed.

### Noncompliant code example

    int x = ((y / 2 + 1)); // Noncompliant
    
    if (a && ((x + y > 0))) { // Noncompliant
      return ((x + 1)); // Noncompliant
    }

### Compliant solution

    int x = (y / 2 + 1);
    
    if (a && (x + y > 0)) {
      return (x + 1);
    }