## Why is this an issue?

Shared coding conventions make it possible for a team to efficiently collaborate. This rule makes it mandatory to place a close curly brace at the
beginning of a line.

### Noncompliant code example

    if(condition)
    {
      doSomething();}

### Compliant solution

    if(condition)
    {
      doSomething();
    }

### Exceptions

When blocks are inlined (open and close curly braces on the same line), no issue is triggered.

    if(condition) {doSomething();}