## Why is this an issue?

The complexity of an expression is defined by the number of `&&`, `||` and `condition ? ifTrue : ifFalse`
operators it contains.

A single expression’s complexity should not become too high to keep the code readable.

### Noncompliant code example

With the default threshold value of 3

    if (((condition1 && condition2) || (condition3 && condition4)) && condition5) { ... }

### Compliant solution

    if ((MyFirstCondition() || MySecondCondition()) && MyLastCondition()) { ... }