## Why is this an issue?

Nested code - blocks of code inside blocks of code - is eventually necessary, but increases complexity. This is why keeping the code as flat as
possible, by avoiding unnecessary nesting, is considered a good practice.

Merging `if` statements when possible will decrease the nesting of the code and improve its readability.

Code like

    if (condition1)
    {
        if (condition2)           // Noncompliant
        {
            // ...
        }
    }

Will be more readable as

    if (condition1 && condition2) // Compliant
    {
        // ...
    }

## How to fix it

If merging the conditions seems to result in a more complex code, extracting the condition or part of it in a named function or variable is a
better approach to fix readability.

### Code examples

#### Noncompliant code example

    if (file != null)
    {
      if (file.isFile() || file.isDirectory())    // Noncompliant
      {
        /* ... */
      }
    }

#### Compliant solution

    bool isFileOrDirectory(File file)
    {
      return file.isFile() || file.isDirectory();
    }
    
    /* ... */
    
    if (file != null && isFileOrDirectory(file))  // Compliant
    {
      /* ... */
    }