## Why is this an issue?

In software development, logs serve as a record of events within an application, providing crucial insights for debugging. When logging, it is
essential to ensure that the logs are:

- easily accessible
- uniformly formatted for readability
- properly recorded
- securely logged when dealing with sensitive data

Those requirements are not met if a program directly writes to the standard outputs (e.g., Console). That is why defining and using a dedicated
logger is highly recommended.

### Exceptions

The rule doesn’t raise an issue for:

- Console Applications
- Calls in methods decorated with `[Conditional ("DEBUG")]`
- Calls included in DEBUG preprocessor branches (`#if DEBUG`)

### Code examples

The following noncompliant code:

    public class MyClass
    {
        private void DoSomething()
        {
            // ...
            Console.WriteLine("My Message"); // Noncompliant
            // ...
        }
    }

Could be replaced by:

    public class MyClass
    {
        private readonly ILogger _logger;
    
        // ...
    
        private void DoSomething()
        {
            // ...
            _logger.LogInformation("My Message");
            // ...
        }
    }

## Resources

- OWASP - [Top 10 2021 Category A9 - Security Logging and
  Monitoring Failures](https://owasp.org/Top10/A09_2021-Security_Logging_and_Monitoring_Failures/)
- OWASP - [Top 10 2017 Category A3 - Sensitive Data
  Exposure](https://www.owasp.org/www-project-top-ten/2017/A3_2017-Sensitive_Data_Exposure)