## Why is this an issue?

Shared naming conventions allow teams to collaborate efficiently.

This rule raises an issue when a type name is not PascalCased.

For example, the classes

    class my_class {...}
    class SOMEName42 {...}

should be renamed to

    class MyClass {...}
    class SomeName42 {...}

### Exceptions

- The rule ignores types marked with `ComImportAttribute` or `InterfaceTypeAttribute`.
- To reduce noise, two consecutive upper case characters are allowed unless they form the full type name. So, `MyXClass` is compliant,
  but `XC` is not.
- The rule allows having `'_'` characters in class names inside test projects: in that case, each word separated by `'_'`
  should be PascalCased.

    class Some_Name___42 {...} // Compliant in tests
    class Some_name___42 {...} // Noncompliant
    class Some_Name_XC {...} // Noncompliant because of XC, should be Some_Name_Xc

## Resources

### Documentation

- [Microsoft Capitalization
  Conventions](https://docs.microsoft.com/en-us/dotnet/standard/design-guidelines/capitalization-conventions)