## Why is this an issue?

Shared naming conventions allow teams to collaborate efficiently.

This rule raises an issue when a method or a property name is not PascalCased.

For example, the method

    public int doSomething() {...} // Noncompliant

should be renamed to

    public int DoSomething() {...}

### Exceptions

- The rule ignores members in types marked with `ComImportAttribute` or `InterfaceTypeAttribute`.
- The rule ignores `extern` methods.
- To reduce noise, two consecutive upper-case characters are allowed unless they form the full name. So, `MyXMethod` is compliant, but
  `XM` is not.
- The camel casing is not enforced when a name contains the `'_'` character.

    void My_method_(){...} // Noncompliant, leading and trailing underscores are reported
    
    void My_method(){...} // Compliant by exception

## Resources

### Documentation

[Microsoft Capitalization
Conventions](https://docs.microsoft.com/en-us/dotnet/standard/design-guidelines/capitalization-conventions)