# libhoney Changelog

## 1.23.1 2024-06-13

### Fixes

- fix: Build the URL using url.JoinPath instead of path.Join (#249) | @MikeGoldsmith

## 1.23.0 2024-06-10

### ⚠️ Breaking Changes ⚠️

Minimum Go version required is 1.19

### Enhancements

- feat: URL encode dataset (#242) | @MikeGoldsmith

### Maintenance

- maint: add labels to release.yml for auto-generated grouping (#241) | @JamieDanielson
- maint: Update minimum go version to 1.19 | @MikeGoldsmith
- chore: Update dependabot reviewer to pipeline-team | @MikeGoldsmith
- maint(deps): bump github.com/klauspost/compress from 1.16.6 to 1.17.8 | @dependabot
- maint(deps): bump github.com/vmihailenco/msgpack/v5 from 5.3.5 to 5.4.1 (#248) | @dependabot
- maint(deps): bump github.com/stretchr/testify from 1.8.4 to 1.9.0 (#247) | @dependabot

## 1.22.0 2024-03-04

### Enhancements

- feat: introduce IsClassicKey helper function (#239) | @jharley

## 1.21.0 2024-02-28

### Enhancements

- feat: support classic-flavored ingest keys (#237) | @jharley

### Maintenance

- maint: update codeowners to pipeline (#233) | @JamieDanielson
- maint: update codeowners to pipeline-team (#234) | @JamieDanielson

## 1.20.0 2023-06-29

### Enhancements

- perf: allow pre-sizing the data map (#228) | @lizthegrey

### Maintenance

- maint(deps): bump github.com/klauspost/compress from 1.16.5 to 1.16.6 (#229) | @dependabot

## 1.19.0 2023-06-05

### ⚠️ Breaking Changes ⚠️

Minimum Go version required is 1.17

### Maintenance

- Drop go 14, 15, 16 (#225) | @vreynolds
- Bump github.com/stretchr/testify from 1.8.0 to 1.8.2 (#218) | @dependabot
- Bump github.com/stretchr/testify from 1.8.2 to 1.8.4 (#224) | @dependabot
- Bump github.com/klauspost/compress from 1.15.9 to 1.16.5 (#223) | @dependabot
- Bump github.com/DataDog/zstd from 1.5.2 to 1.5.5 (#222) | @dependabot

## 1.18.0 2022-10-28

### Enhancements

- Include Go version, GOOS, & GOARCH in user-agent (#207) | @robbkidd

### Maintenance

- Convert stray fmt.Printf into logger.Printf (#203) | @glenjamin

## 1.17.1 2022-10-19

### Fixed

- Pre-define field map capacities (#197) | [lizthegrey](https://github.com/lizthegrey)

### Maintenance

- Add release file (#199) | [@vreynolds](https://github.com/vreynolds)
- Add new project workflow (#196) | [@vreynolds](https://github.com/vreynolds)

## 1.17.0 2022-09-23

### Enhancements

- feat: adds a configurable event batch send timeout (#190) | [@robbkidd](https://github.com/robbkidd)

### Maintenance

- maint: add go 1.19 to CI (#189) | [@vreynolds](https://github.com/vreynolds)
- docs: add wiki manual tracing example (#188) | [@vreynolds](https://github.com/vreynolds)
- Bump github.com/klauspost/compress from 1.15.7 to 1.15.9 (#192) | [@robbkidd](https://github.com/robbkidd)

## 1.16.0 2022-07-13

There were several v2 releases that were unusable because they were incomplete according to Go's semantic versioning strategy.
Changes that appeared in those unusable v2 releases are consolidated into this minor release.

### ⚠️ Breaking Changes ⚠️

Minimum Go version required is 1.14

### Enhancements

- Update default dataset name for non-classic API keys (#170) | [@MikeGoldsmith](https://github.com/MikeGoldsmith)
- Add support to retrieve team and environment (#183) | [@MikeGoldsmith](https://github.com/MikeGoldsmith)

### Maintenance

- maint: drop support for go before 1.14 (#164) | [lizthegrey](https://github.com/lizthegrey)
- maint: add go 1.18 to CI (#172) | [@vreynolds](https://github.com/vreynolds)
- Fix race condition in test and other test bugs (#162) | [@kentquirk](https://github.com/kentquirk)
- Update examples (#184) | [@vreynolds](https://github.com/vreynolds)
- Build example app during CI test phase (#179) | [@MikeGoldsmith](https://github.com/MikeGoldsmith)
- Bump github.com/stretchr/testify from 1.6.1 to 1.8.0 (#111, #174, #181) | [dependabot](https://github.com/dependabot)
- Bump github.com/klauspost/compress from 1.13.6 to 1.15.7 (#175, #177, #180, #182) | [dependabot](https://github.com/dependabot)
- Bump github.com/DataDog/zstd from 1.5.0 to 1.5.2 (#178) | [dependabot](https://github.com/dependabot)

## 1.15.8 2022-01-05

### Fixed

- Pass bytes.Reader to http.Request, clean up pooledReader (#159) | | [lizthegrey](https://github.com/lizthegrey)

## 1.15.7 2022-01-04

### Fixed

- Don't crash on stream aborts, always add content length (#156) | [lizthegrey](https://github.com/lizthegrey)

### Maintenance

- Add re-triage workflow (#155) | [vreynolds](https://github.com/vreynolds)
- Bump github.com/vmihailenco/msgpack/v5 from 5.3.4 to 5.3.5 (#149)
- Bump github.com/DataDog/zstd from 1.4.8 to 1.5.0 (#153)
- Bump github.com/klauspost/compress from 1.13.5 to 1.13.6 (#145)

## 1.15.6 2021-11-03

### Fixed

- Ensure valid JSON even when individual events in a batch can't be marshalled (#151)

### Maintenance

- empower apply-labels action to apply labels (#150)
- add min go version to readme (#147)
- update certs in old CI image (#148)
- ci: remove buildevents from nightly (#144)
- ci: secrets management (#142)

## 1.15.5 2021-09-27

### Fixed

- fix race condition on Honeycomb.Flush() (#140) | [@bfreis](https://github.com/bfreis)

### Maintenance

- Change maintenance badge to maintained (#138)
- Adds Stalebot (#141)
- Add issue and PR templates (#136)
- Add OSS lifecycle badge (#135)
- Add community health files (#134)
- Bump github.com/klauspost/compress from 1.12.3 to 1.13.5 (#130, #137)
- Bump github.com/vmihailenco/msgpack/v5 from 5.2.0 to 5.3.4 (#133)

## 1.15.4 2021-07-21

### Maintenance

- Upgrade msgpack from v4 to v5. (#127)

## 1.15.3 2021-06-02

### Improvements

- Add more context to batch response parsing error (#116)

### Maintenance

- Add go 1.15 & 1.16 to the testing matrix (#114, #119)

## 1.15.2 2021-01-22

NOTE: v1.15.1 may cause update warnings due to checksum error, please use v1.15.2 instead.

### Maintenance

- Add Github action to manage project labels (#110)
- Automate the creation of draft releases when project is tagged (#109)

## 1.15.1 2021-01-14

### Improvements

- Fix data race on dynFields length in Builder.Clone (#72)

### Maintenance

- Update dependencies
- github.com/klauspost/compress from 1.11.2 to 1.11.4 (#105, #106)

## 1.15.0 2020-11-10

- Mask writekey when printing events (#103)

## 1.14.1 2020-9-24

- Add .editorconfig to help provide consistent IDE styling (#99)

## 1.14.0 2020-09-01

- Documentation - document potential failures if pendingWorkCapacity not specified
- Documentation - use Deprecated tags for deprecated fields
- Log when event batch is rejected with an invalid API key
- Dependency bump (compress)

## 1.13.0 2020-08-21

- This release includes a change by @apechimp that makes Flush thread-safe (#80)
- Update dependencies
- Have a more obvious default statsd prefix (libhoney)
