// Code generated by go-uaa/generator; DO NOT EDIT.

package uaa

import (
	"bytes"
	"encoding/json"
	"errors"
	"fmt"
	"net/http"
)

// GetMFAProvider with the given mfaproviderID.
func (a *API) GetMFAProvider(mfaproviderID string) (*MFAProvider, error) {
	u := urlWithPath(*a.TargetURL, fmt.Sprintf("%s/%s", MFAProvidersEndpoint, mfaproviderID))
	mfaprovider := &MFAProvider{}
	err := a.doJSON(http.MethodGet, &u, nil, mfaprovider, true)
	if err != nil {
		return nil, err
	}
	return mfaprovider, nil
}

// CreateMFAProvider creates the given mfaprovider.
func (a *API) CreateMFAProvider(mfaprovider MFAProvider) (*MFAProvider, error) {
	u := urlWithPath(*a.TargetURL, MFAProvidersEndpoint)
	created := &MFAProvider{}
	j, err := json.Marshal(mfaprovider)
	if err != nil {
		return nil, err
	}
	err = a.doJSON(http.MethodPost, &u, bytes.NewBuffer([]byte(j)), created, true)
	if err != nil {
		return nil, err
	}
	return created, nil
}

// UpdateMFAProvider updates the given mfaprovider.
func (a *API) UpdateMFAProvider(mfaprovider MFAProvider) (*MFAProvider, error) {
	u := urlWithPath(*a.TargetURL, fmt.Sprintf("%s/%s", MFAProvidersEndpoint, mfaprovider.Identifier()))

	created := &MFAProvider{}
	j, err := json.Marshal(mfaprovider)
	if err != nil {
		return nil, err
	}
	err = a.doJSON(http.MethodPut, &u, bytes.NewBuffer([]byte(j)), created, true)
	if err != nil {
		return nil, err
	}
	return created, nil
}

// DeleteMFAProvider deletes the mfaprovider with the given mfaprovider ID.
func (a *API) DeleteMFAProvider(mfaproviderID string) (*MFAProvider, error) {
	if mfaproviderID == "" {
		return nil, errors.New("mfaproviderID cannot be blank")
	}
	u := urlWithPath(*a.TargetURL, fmt.Sprintf("%s/%s", MFAProvidersEndpoint, mfaproviderID))
	deleted := &MFAProvider{}
	err := a.doJSON(http.MethodDelete, &u, nil, deleted, true)
	if err != nil {
		return nil, err
	}
	return deleted, nil
}

// ListMFAProviders fetches all of the MFAProvider records.
// If successful, ListMFAProviders returns the mfaproviders
// If unsuccessful, ListMFAProviders returns the error.
func (a *API) ListMFAProviders() ([]MFAProvider, error) {
	u := urlWithPath(*a.TargetURL, MFAProvidersEndpoint)
	var mfaproviders []MFAProvider
	err := a.doJSON(http.MethodGet, &u, nil, &mfaproviders, true)
	if err != nil {
		return nil, err
	}
	return mfaproviders, nil
}
