// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: security_group.proto

package models

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type PortRange struct {
	Start uint32 `protobuf:"varint,1,opt,name=start,proto3" json:"start"`
	End   uint32 `protobuf:"varint,2,opt,name=end,proto3" json:"end"`
}

func (m *PortRange) Reset()      { *m = PortRange{} }
func (*PortRange) ProtoMessage() {}
func (*PortRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_ff465b8f55f128fd, []int{0}
}
func (m *PortRange) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PortRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PortRange.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PortRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PortRange.Merge(m, src)
}
func (m *PortRange) XXX_Size() int {
	return m.Size()
}
func (m *PortRange) XXX_DiscardUnknown() {
	xxx_messageInfo_PortRange.DiscardUnknown(m)
}

var xxx_messageInfo_PortRange proto.InternalMessageInfo

func (m *PortRange) GetStart() uint32 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *PortRange) GetEnd() uint32 {
	if m != nil {
		return m.End
	}
	return 0
}

type ICMPInfo struct {
	Type int32 `protobuf:"varint,1,opt,name=type,proto3" json:"type"`
	Code int32 `protobuf:"varint,2,opt,name=code,proto3" json:"code"`
}

func (m *ICMPInfo) Reset()      { *m = ICMPInfo{} }
func (*ICMPInfo) ProtoMessage() {}
func (*ICMPInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ff465b8f55f128fd, []int{1}
}
func (m *ICMPInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ICMPInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ICMPInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ICMPInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ICMPInfo.Merge(m, src)
}
func (m *ICMPInfo) XXX_Size() int {
	return m.Size()
}
func (m *ICMPInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ICMPInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ICMPInfo proto.InternalMessageInfo

func (m *ICMPInfo) GetType() int32 {
	if m != nil {
		return m.Type
	}
	return 0
}

func (m *ICMPInfo) GetCode() int32 {
	if m != nil {
		return m.Code
	}
	return 0
}

type SecurityGroupRule struct {
	Protocol     string     `protobuf:"bytes,1,opt,name=protocol,proto3" json:"protocol,omitempty"`
	Destinations []string   `protobuf:"bytes,2,rep,name=destinations,proto3" json:"destinations,omitempty"`
	Ports        []uint32   `protobuf:"varint,3,rep,name=ports,proto3" json:"ports,omitempty"`
	PortRange    *PortRange `protobuf:"bytes,4,opt,name=port_range,json=portRange,proto3" json:"port_range,omitempty"`
	IcmpInfo     *ICMPInfo  `protobuf:"bytes,5,opt,name=icmp_info,json=icmpInfo,proto3" json:"icmp_info,omitempty"`
	Log          bool       `protobuf:"varint,6,opt,name=log,proto3" json:"log"`
	Annotations  []string   `protobuf:"bytes,7,rep,name=annotations,proto3" json:"annotations,omitempty"`
}

func (m *SecurityGroupRule) Reset()      { *m = SecurityGroupRule{} }
func (*SecurityGroupRule) ProtoMessage() {}
func (*SecurityGroupRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_ff465b8f55f128fd, []int{2}
}
func (m *SecurityGroupRule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SecurityGroupRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SecurityGroupRule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SecurityGroupRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecurityGroupRule.Merge(m, src)
}
func (m *SecurityGroupRule) XXX_Size() int {
	return m.Size()
}
func (m *SecurityGroupRule) XXX_DiscardUnknown() {
	xxx_messageInfo_SecurityGroupRule.DiscardUnknown(m)
}

var xxx_messageInfo_SecurityGroupRule proto.InternalMessageInfo

func (m *SecurityGroupRule) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *SecurityGroupRule) GetDestinations() []string {
	if m != nil {
		return m.Destinations
	}
	return nil
}

func (m *SecurityGroupRule) GetPorts() []uint32 {
	if m != nil {
		return m.Ports
	}
	return nil
}

func (m *SecurityGroupRule) GetPortRange() *PortRange {
	if m != nil {
		return m.PortRange
	}
	return nil
}

func (m *SecurityGroupRule) GetIcmpInfo() *ICMPInfo {
	if m != nil {
		return m.IcmpInfo
	}
	return nil
}

func (m *SecurityGroupRule) GetLog() bool {
	if m != nil {
		return m.Log
	}
	return false
}

func (m *SecurityGroupRule) GetAnnotations() []string {
	if m != nil {
		return m.Annotations
	}
	return nil
}

func init() {
	proto.RegisterType((*PortRange)(nil), "models.PortRange")
	proto.RegisterType((*ICMPInfo)(nil), "models.ICMPInfo")
	proto.RegisterType((*SecurityGroupRule)(nil), "models.SecurityGroupRule")
}

func init() { proto.RegisterFile("security_group.proto", fileDescriptor_ff465b8f55f128fd) }

var fileDescriptor_ff465b8f55f128fd = []byte{
	// 402 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x54, 0x90, 0xb1, 0x6e, 0xdb, 0x30,
	0x10, 0x86, 0x45, 0x2b, 0x76, 0x24, 0xa6, 0x01, 0x12, 0xa2, 0x03, 0x13, 0x14, 0x94, 0xa0, 0x49,
	0x4b, 0x94, 0xa2, 0xed, 0x13, 0xa8, 0x40, 0x83, 0x0c, 0x05, 0x02, 0xf6, 0x01, 0x0c, 0x59, 0xa2,
	0x55, 0x01, 0x32, 0x4f, 0x90, 0xa8, 0x21, 0x5b, 0xf7, 0x2e, 0x7d, 0x8c, 0x3e, 0x4a, 0x47, 0x8f,
	0x99, 0x8c, 0x5a, 0x5e, 0x0a, 0x4f, 0x79, 0x84, 0x82, 0x27, 0xc7, 0x68, 0x97, 0x13, 0xff, 0xff,
	0xd7, 0x1d, 0xee, 0x3e, 0xfa, 0xba, 0x53, 0x79, 0xdf, 0x56, 0xe6, 0x71, 0x5e, 0xb6, 0xd0, 0x37,
	0x49, 0xd3, 0x82, 0x01, 0x36, 0x5b, 0x41, 0xa1, 0xea, 0xee, 0xfa, 0xa6, 0xac, 0xcc, 0xd7, 0x7e,
	0x91, 0xe4, 0xb0, 0xba, 0x2d, 0xa1, 0x84, 0x5b, 0x8c, 0x17, 0xfd, 0x12, 0x15, 0x0a, 0x7c, 0x8d,
	0x6d, 0xd1, 0x1d, 0xf5, 0x1f, 0xa0, 0x35, 0x32, 0xd3, 0xa5, 0x62, 0x01, 0x9d, 0x76, 0x26, 0x6b,
	0x0d, 0x27, 0x21, 0x89, 0xcf, 0x53, 0x7f, 0xbf, 0x09, 0x46, 0x43, 0x8e, 0x1f, 0x76, 0x45, 0x5d,
	0xa5, 0x0b, 0x3e, 0xc1, 0xf8, 0x74, 0xbf, 0x09, 0xac, 0x94, 0xb6, 0x44, 0x9f, 0xa8, 0x77, 0xff,
	0xf1, 0xf3, 0xc3, 0xbd, 0x5e, 0x02, 0x7b, 0x43, 0x4f, 0xcc, 0x63, 0xa3, 0x70, 0xcc, 0x34, 0xf5,
	0xf6, 0x9b, 0x00, 0xb5, 0xc4, 0x6a, 0xd3, 0x1c, 0x0a, 0x85, 0x53, 0x0e, 0xa9, 0xd5, 0x12, 0x6b,
	0xf4, 0x7d, 0x42, 0x2f, 0xbf, 0x1c, 0x0e, 0xbc, 0xb3, 0xf7, 0xc9, 0xbe, 0x56, 0xec, 0x9a, 0x7a,
	0xb8, 0x6f, 0x0e, 0x35, 0x4e, 0xf5, 0xe5, 0x51, 0xb3, 0x88, 0xbe, 0x2a, 0x54, 0x67, 0x2a, 0x9d,
	0x99, 0x0a, 0x74, 0xc7, 0x27, 0xa1, 0x1b, 0xfb, 0xf2, 0x3f, 0x8f, 0x71, 0x3a, 0x6d, 0xa0, 0x35,
	0x1d, 0x77, 0x43, 0x37, 0x3e, 0x4f, 0x27, 0x17, 0x8e, 0x1c, 0x0d, 0xf6, 0x96, 0x52, 0xfb, 0x98,
	0xb7, 0x96, 0x00, 0x3f, 0x09, 0x49, 0x7c, 0xf6, 0xee, 0x32, 0x19, 0x61, 0x26, 0x47, 0x34, 0xd2,
	0x6f, 0x8e, 0x94, 0x6e, 0xa8, 0x5f, 0xe5, 0xab, 0x66, 0x5e, 0xe9, 0x25, 0xf0, 0x29, 0x36, 0x5c,
	0xbc, 0x34, 0xbc, 0x20, 0x90, 0x9e, 0xfd, 0x05, 0x61, 0x5c, 0x51, 0xb7, 0x86, 0x92, 0xcf, 0x42,
	0x12, 0x7b, 0x23, 0xb3, 0x1a, 0x4a, 0x69, 0x0b, 0x0b, 0xe9, 0x59, 0xa6, 0x35, 0x98, 0xc3, 0xe2,
	0xa7, 0xb8, 0xf8, 0xbf, 0x56, 0xfa, 0x61, 0xbd, 0x15, 0xce, 0xd3, 0x56, 0x38, 0xcf, 0x5b, 0x41,
	0xbe, 0x0d, 0x82, 0xfc, 0x1c, 0x04, 0xf9, 0x35, 0x08, 0xb2, 0x1e, 0x04, 0xf9, 0x3d, 0x08, 0xf2,
	0x67, 0x10, 0xce, 0xf3, 0x20, 0xc8, 0x8f, 0x9d, 0x70, 0xd6, 0x3b, 0xe1, 0x3c, 0xed, 0x84, 0xb3,
	0x98, 0x21, 0x9b, 0xf7, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0xfa, 0xd0, 0x92, 0x85, 0x2a, 0x02,
	0x00, 0x00,
}

func (this *PortRange) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*PortRange)
	if !ok {
		that2, ok := that.(PortRange)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Start != that1.Start {
		return false
	}
	if this.End != that1.End {
		return false
	}
	return true
}
func (this *ICMPInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ICMPInfo)
	if !ok {
		that2, ok := that.(ICMPInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Code != that1.Code {
		return false
	}
	return true
}
func (this *SecurityGroupRule) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SecurityGroupRule)
	if !ok {
		that2, ok := that.(SecurityGroupRule)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Protocol != that1.Protocol {
		return false
	}
	if len(this.Destinations) != len(that1.Destinations) {
		return false
	}
	for i := range this.Destinations {
		if this.Destinations[i] != that1.Destinations[i] {
			return false
		}
	}
	if len(this.Ports) != len(that1.Ports) {
		return false
	}
	for i := range this.Ports {
		if this.Ports[i] != that1.Ports[i] {
			return false
		}
	}
	if !this.PortRange.Equal(that1.PortRange) {
		return false
	}
	if !this.IcmpInfo.Equal(that1.IcmpInfo) {
		return false
	}
	if this.Log != that1.Log {
		return false
	}
	if len(this.Annotations) != len(that1.Annotations) {
		return false
	}
	for i := range this.Annotations {
		if this.Annotations[i] != that1.Annotations[i] {
			return false
		}
	}
	return true
}
func (this *PortRange) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&models.PortRange{")
	s = append(s, "Start: "+fmt.Sprintf("%#v", this.Start)+",\n")
	s = append(s, "End: "+fmt.Sprintf("%#v", this.End)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ICMPInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&models.ICMPInfo{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Code: "+fmt.Sprintf("%#v", this.Code)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SecurityGroupRule) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&models.SecurityGroupRule{")
	s = append(s, "Protocol: "+fmt.Sprintf("%#v", this.Protocol)+",\n")
	s = append(s, "Destinations: "+fmt.Sprintf("%#v", this.Destinations)+",\n")
	s = append(s, "Ports: "+fmt.Sprintf("%#v", this.Ports)+",\n")
	if this.PortRange != nil {
		s = append(s, "PortRange: "+fmt.Sprintf("%#v", this.PortRange)+",\n")
	}
	if this.IcmpInfo != nil {
		s = append(s, "IcmpInfo: "+fmt.Sprintf("%#v", this.IcmpInfo)+",\n")
	}
	s = append(s, "Log: "+fmt.Sprintf("%#v", this.Log)+",\n")
	s = append(s, "Annotations: "+fmt.Sprintf("%#v", this.Annotations)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringSecurityGroup(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *PortRange) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PortRange) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PortRange) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.End != 0 {
		i = encodeVarintSecurityGroup(dAtA, i, uint64(m.End))
		i--
		dAtA[i] = 0x10
	}
	if m.Start != 0 {
		i = encodeVarintSecurityGroup(dAtA, i, uint64(m.Start))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ICMPInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ICMPInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ICMPInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Code != 0 {
		i = encodeVarintSecurityGroup(dAtA, i, uint64(m.Code))
		i--
		dAtA[i] = 0x10
	}
	if m.Type != 0 {
		i = encodeVarintSecurityGroup(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SecurityGroupRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecurityGroupRule) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SecurityGroupRule) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Annotations) > 0 {
		for iNdEx := len(m.Annotations) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Annotations[iNdEx])
			copy(dAtA[i:], m.Annotations[iNdEx])
			i = encodeVarintSecurityGroup(dAtA, i, uint64(len(m.Annotations[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if m.Log {
		i--
		if m.Log {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if m.IcmpInfo != nil {
		{
			size, err := m.IcmpInfo.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecurityGroup(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if m.PortRange != nil {
		{
			size, err := m.PortRange.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintSecurityGroup(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Ports) > 0 {
		for iNdEx := len(m.Ports) - 1; iNdEx >= 0; iNdEx-- {
			i = encodeVarintSecurityGroup(dAtA, i, uint64(m.Ports[iNdEx]))
			i--
			dAtA[i] = 0x18
		}
	}
	if len(m.Destinations) > 0 {
		for iNdEx := len(m.Destinations) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Destinations[iNdEx])
			copy(dAtA[i:], m.Destinations[iNdEx])
			i = encodeVarintSecurityGroup(dAtA, i, uint64(len(m.Destinations[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Protocol) > 0 {
		i -= len(m.Protocol)
		copy(dAtA[i:], m.Protocol)
		i = encodeVarintSecurityGroup(dAtA, i, uint64(len(m.Protocol)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintSecurityGroup(dAtA []byte, offset int, v uint64) int {
	offset -= sovSecurityGroup(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *PortRange) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Start != 0 {
		n += 1 + sovSecurityGroup(uint64(m.Start))
	}
	if m.End != 0 {
		n += 1 + sovSecurityGroup(uint64(m.End))
	}
	return n
}

func (m *ICMPInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovSecurityGroup(uint64(m.Type))
	}
	if m.Code != 0 {
		n += 1 + sovSecurityGroup(uint64(m.Code))
	}
	return n
}

func (m *SecurityGroupRule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Protocol)
	if l > 0 {
		n += 1 + l + sovSecurityGroup(uint64(l))
	}
	if len(m.Destinations) > 0 {
		for _, s := range m.Destinations {
			l = len(s)
			n += 1 + l + sovSecurityGroup(uint64(l))
		}
	}
	if len(m.Ports) > 0 {
		for _, e := range m.Ports {
			n += 1 + sovSecurityGroup(uint64(e))
		}
	}
	if m.PortRange != nil {
		l = m.PortRange.Size()
		n += 1 + l + sovSecurityGroup(uint64(l))
	}
	if m.IcmpInfo != nil {
		l = m.IcmpInfo.Size()
		n += 1 + l + sovSecurityGroup(uint64(l))
	}
	if m.Log {
		n += 2
	}
	if len(m.Annotations) > 0 {
		for _, s := range m.Annotations {
			l = len(s)
			n += 1 + l + sovSecurityGroup(uint64(l))
		}
	}
	return n
}

func sovSecurityGroup(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozSecurityGroup(x uint64) (n int) {
	return sovSecurityGroup(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *PortRange) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&PortRange{`,
		`Start:` + fmt.Sprintf("%v", this.Start) + `,`,
		`End:` + fmt.Sprintf("%v", this.End) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ICMPInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ICMPInfo{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Code:` + fmt.Sprintf("%v", this.Code) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SecurityGroupRule) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SecurityGroupRule{`,
		`Protocol:` + fmt.Sprintf("%v", this.Protocol) + `,`,
		`Destinations:` + fmt.Sprintf("%v", this.Destinations) + `,`,
		`Ports:` + fmt.Sprintf("%v", this.Ports) + `,`,
		`PortRange:` + strings.Replace(this.PortRange.String(), "PortRange", "PortRange", 1) + `,`,
		`IcmpInfo:` + strings.Replace(this.IcmpInfo.String(), "ICMPInfo", "ICMPInfo", 1) + `,`,
		`Log:` + fmt.Sprintf("%v", this.Log) + `,`,
		`Annotations:` + fmt.Sprintf("%v", this.Annotations) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringSecurityGroup(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *PortRange) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecurityGroup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PortRange: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PortRange: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Start", wireType)
			}
			m.Start = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurityGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Start |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field End", wireType)
			}
			m.End = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurityGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.End |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSecurityGroup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSecurityGroup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ICMPInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecurityGroup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ICMPInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ICMPInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurityGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Code", wireType)
			}
			m.Code = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurityGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Code |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipSecurityGroup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSecurityGroup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SecurityGroupRule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowSecurityGroup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SecurityGroupRule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SecurityGroupRule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurityGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurityGroup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurityGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Protocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Destinations", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurityGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurityGroup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurityGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Destinations = append(m.Destinations, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSecurityGroup
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= uint32(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.Ports = append(m.Ports, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowSecurityGroup
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= int(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthSecurityGroup
				}
				postIndex := iNdEx + packedLen
				if postIndex < 0 {
					return ErrInvalidLengthSecurityGroup
				}
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				var elementCount int
				var count int
				for _, integer := range dAtA[iNdEx:postIndex] {
					if integer < 128 {
						count++
					}
				}
				elementCount = count
				if elementCount != 0 && len(m.Ports) == 0 {
					m.Ports = make([]uint32, 0, elementCount)
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowSecurityGroup
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= uint32(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.Ports = append(m.Ports, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field Ports", wireType)
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PortRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurityGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurityGroup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurityGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PortRange == nil {
				m.PortRange = &PortRange{}
			}
			if err := m.PortRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IcmpInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurityGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthSecurityGroup
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthSecurityGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.IcmpInfo == nil {
				m.IcmpInfo = &ICMPInfo{}
			}
			if err := m.IcmpInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Log", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurityGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Log = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Annotations", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowSecurityGroup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthSecurityGroup
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthSecurityGroup
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Annotations = append(m.Annotations, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipSecurityGroup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthSecurityGroup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipSecurityGroup(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowSecurityGroup
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSecurityGroup
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowSecurityGroup
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthSecurityGroup
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupSecurityGroup
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthSecurityGroup
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthSecurityGroup        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowSecurityGroup          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupSecurityGroup = fmt.Errorf("proto: unexpected end of group")
)
