// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: check_definition.proto

package models

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type CheckDefinition struct {
	Checks          []*Check `protobuf:"bytes,1,rep,name=checks,proto3" json:"checks,omitempty"`
	LogSource       string   `protobuf:"bytes,2,opt,name=log_source,json=logSource,proto3" json:"log_source"`
	ReadinessChecks []*Check `protobuf:"bytes,3,rep,name=readiness_checks,json=readinessChecks,proto3" json:"readiness_checks,omitempty"`
}

func (m *CheckDefinition) Reset()      { *m = CheckDefinition{} }
func (*CheckDefinition) ProtoMessage() {}
func (*CheckDefinition) Descriptor() ([]byte, []int) {
	return fileDescriptor_048a62b88ce7913d, []int{0}
}
func (m *CheckDefinition) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckDefinition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckDefinition.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckDefinition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckDefinition.Merge(m, src)
}
func (m *CheckDefinition) XXX_Size() int {
	return m.Size()
}
func (m *CheckDefinition) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckDefinition.DiscardUnknown(m)
}

var xxx_messageInfo_CheckDefinition proto.InternalMessageInfo

func (m *CheckDefinition) GetChecks() []*Check {
	if m != nil {
		return m.Checks
	}
	return nil
}

func (m *CheckDefinition) GetLogSource() string {
	if m != nil {
		return m.LogSource
	}
	return ""
}

func (m *CheckDefinition) GetReadinessChecks() []*Check {
	if m != nil {
		return m.ReadinessChecks
	}
	return nil
}

type Check struct {
	// oneof is hard to use right now, instead we can do this check in validation
	// oneof check {
	TcpCheck  *TCPCheck  `protobuf:"bytes,1,opt,name=tcp_check,json=tcpCheck,proto3" json:"tcp_check,omitempty"`
	HttpCheck *HTTPCheck `protobuf:"bytes,2,opt,name=http_check,json=httpCheck,proto3" json:"http_check,omitempty"`
}

func (m *Check) Reset()      { *m = Check{} }
func (*Check) ProtoMessage() {}
func (*Check) Descriptor() ([]byte, []int) {
	return fileDescriptor_048a62b88ce7913d, []int{1}
}
func (m *Check) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Check) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Check.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Check) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Check.Merge(m, src)
}
func (m *Check) XXX_Size() int {
	return m.Size()
}
func (m *Check) XXX_DiscardUnknown() {
	xxx_messageInfo_Check.DiscardUnknown(m)
}

var xxx_messageInfo_Check proto.InternalMessageInfo

func (m *Check) GetTcpCheck() *TCPCheck {
	if m != nil {
		return m.TcpCheck
	}
	return nil
}

func (m *Check) GetHttpCheck() *HTTPCheck {
	if m != nil {
		return m.HttpCheck
	}
	return nil
}

type TCPCheck struct {
	Port             uint32 `protobuf:"varint,1,opt,name=port,proto3" json:"port"`
	ConnectTimeoutMs uint64 `protobuf:"varint,2,opt,name=connect_timeout_ms,json=connectTimeoutMs,proto3" json:"connect_timeout_ms,omitempty"`
	IntervalMs       uint64 `protobuf:"varint,3,opt,name=interval_ms,json=intervalMs,proto3" json:"interval_ms,omitempty"`
}

func (m *TCPCheck) Reset()      { *m = TCPCheck{} }
func (*TCPCheck) ProtoMessage() {}
func (*TCPCheck) Descriptor() ([]byte, []int) {
	return fileDescriptor_048a62b88ce7913d, []int{2}
}
func (m *TCPCheck) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TCPCheck) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TCPCheck.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TCPCheck) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TCPCheck.Merge(m, src)
}
func (m *TCPCheck) XXX_Size() int {
	return m.Size()
}
func (m *TCPCheck) XXX_DiscardUnknown() {
	xxx_messageInfo_TCPCheck.DiscardUnknown(m)
}

var xxx_messageInfo_TCPCheck proto.InternalMessageInfo

func (m *TCPCheck) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *TCPCheck) GetConnectTimeoutMs() uint64 {
	if m != nil {
		return m.ConnectTimeoutMs
	}
	return 0
}

func (m *TCPCheck) GetIntervalMs() uint64 {
	if m != nil {
		return m.IntervalMs
	}
	return 0
}

type HTTPCheck struct {
	Port             uint32 `protobuf:"varint,1,opt,name=port,proto3" json:"port"`
	RequestTimeoutMs uint64 `protobuf:"varint,2,opt,name=request_timeout_ms,json=requestTimeoutMs,proto3" json:"request_timeout_ms,omitempty"`
	Path             string `protobuf:"bytes,3,opt,name=path,proto3" json:"path"`
	IntervalMs       uint64 `protobuf:"varint,4,opt,name=interval_ms,json=intervalMs,proto3" json:"interval_ms,omitempty"`
}

func (m *HTTPCheck) Reset()      { *m = HTTPCheck{} }
func (*HTTPCheck) ProtoMessage() {}
func (*HTTPCheck) Descriptor() ([]byte, []int) {
	return fileDescriptor_048a62b88ce7913d, []int{3}
}
func (m *HTTPCheck) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HTTPCheck) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HTTPCheck.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HTTPCheck) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HTTPCheck.Merge(m, src)
}
func (m *HTTPCheck) XXX_Size() int {
	return m.Size()
}
func (m *HTTPCheck) XXX_DiscardUnknown() {
	xxx_messageInfo_HTTPCheck.DiscardUnknown(m)
}

var xxx_messageInfo_HTTPCheck proto.InternalMessageInfo

func (m *HTTPCheck) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *HTTPCheck) GetRequestTimeoutMs() uint64 {
	if m != nil {
		return m.RequestTimeoutMs
	}
	return 0
}

func (m *HTTPCheck) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *HTTPCheck) GetIntervalMs() uint64 {
	if m != nil {
		return m.IntervalMs
	}
	return 0
}

func init() {
	proto.RegisterType((*CheckDefinition)(nil), "models.CheckDefinition")
	proto.RegisterType((*Check)(nil), "models.Check")
	proto.RegisterType((*TCPCheck)(nil), "models.TCPCheck")
	proto.RegisterType((*HTTPCheck)(nil), "models.HTTPCheck")
}

func init() { proto.RegisterFile("check_definition.proto", fileDescriptor_048a62b88ce7913d) }

var fileDescriptor_048a62b88ce7913d = []byte{
	// 414 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x92, 0x31, 0x8f, 0xd3, 0x40,
	0x10, 0x85, 0xbd, 0x97, 0x10, 0xc5, 0x13, 0x1d, 0x17, 0xb6, 0x40, 0x11, 0x42, 0x9b, 0xc8, 0x12,
	0x52, 0x0a, 0xe2, 0x43, 0x07, 0x05, 0x75, 0x8e, 0x82, 0xe6, 0x24, 0x64, 0xdc, 0x5b, 0xce, 0x66,
	0xcf, 0xb6, 0xb0, 0xbd, 0xc6, 0xbb, 0x86, 0x96, 0x9f, 0x40, 0x45, 0x4f, 0xc7, 0x4f, 0xa1, 0x4c,
	0x99, 0x2a, 0x22, 0x4e, 0x83, 0x52, 0xe5, 0x27, 0x20, 0x8f, 0xed, 0x80, 0xa2, 0x48, 0x34, 0xd6,
	0xcc, 0xbe, 0xef, 0xbd, 0x37, 0x85, 0xe1, 0x31, 0x0f, 0x05, 0xff, 0xe0, 0x2d, 0xc5, 0x7d, 0x94,
	0x46, 0x3a, 0x92, 0xa9, 0x9d, 0xe5, 0x52, 0x4b, 0xda, 0x4b, 0xe4, 0x52, 0xc4, 0xea, 0xc9, 0x2c,
	0x88, 0x74, 0x58, 0x2c, 0x6c, 0x2e, 0x93, 0xeb, 0x40, 0x06, 0xf2, 0x1a, 0xe5, 0x45, 0x71, 0x8f,
	0x1b, 0x2e, 0x38, 0xd5, 0x36, 0xeb, 0x3b, 0x81, 0xab, 0xdb, 0x2a, 0xf1, 0xcd, 0x31, 0x90, 0x3e,
	0x83, 0x1e, 0x96, 0xa8, 0x11, 0x99, 0x74, 0xa6, 0x83, 0x9b, 0x4b, 0xbb, 0xce, 0xb6, 0x11, 0x74,
	0x1a, 0x91, 0xce, 0x00, 0x62, 0x19, 0x78, 0x4a, 0x16, 0x39, 0x17, 0xa3, 0x8b, 0x09, 0x99, 0x9a,
	0xf3, 0x87, 0xfb, 0xcd, 0xf8, 0x9f, 0x57, 0xc7, 0x8c, 0x65, 0xf0, 0x1e, 0x47, 0xfa, 0x1a, 0x86,
	0xb9, 0xf0, 0x97, 0x51, 0x2a, 0x94, 0xf2, 0x9a, 0xfc, 0xce, 0xb9, 0xfc, 0xab, 0x23, 0x86, 0xbb,
	0xb2, 0x42, 0x78, 0x80, 0x13, 0x9d, 0x81, 0xa9, 0x79, 0x56, 0x9b, 0x47, 0x64, 0x42, 0xa6, 0x83,
	0x9b, 0x61, 0xeb, 0x75, 0x6f, 0xdf, 0xd5, 0xf6, 0xbe, 0xe6, 0x59, 0x8d, 0xbf, 0x00, 0x08, 0xb5,
	0x6e, 0xf9, 0x0b, 0xe4, 0x1f, 0xb5, 0xfc, 0x5b, 0xd7, 0x6d, 0x0c, 0x66, 0x05, 0xe1, 0x68, 0x7d,
	0x86, 0x7e, 0x9b, 0x43, 0x9f, 0x42, 0x37, 0x93, 0xb9, 0xc6, 0x9e, 0xcb, 0x79, 0x7f, 0xbf, 0x19,
	0xe3, 0xee, 0xe0, 0x97, 0x3e, 0x07, 0xca, 0x65, 0x9a, 0x0a, 0xae, 0x3d, 0x1d, 0x25, 0x42, 0x16,
	0xda, 0x4b, 0x14, 0x76, 0x74, 0x9d, 0x61, 0xa3, 0xb8, 0xb5, 0x70, 0xa7, 0xe8, 0x18, 0x06, 0x51,
	0xaa, 0x45, 0xfe, 0xc9, 0x8f, 0x2b, 0xac, 0x83, 0x18, 0xb4, 0x4f, 0x77, 0xca, 0xfa, 0x46, 0xc0,
	0x3c, 0x5e, 0xf4, 0xff, 0xea, 0x5c, 0x7c, 0x2c, 0x84, 0x3a, 0x57, 0xdd, 0x28, 0x7f, 0xab, 0xab,
	0x2c, 0x5f, 0x87, 0xd8, 0x69, 0x36, 0x59, 0xbe, 0x0e, 0x1d, 0xfc, 0x9e, 0x1e, 0xd6, 0x3d, 0x3d,
	0x6c, 0xfe, 0x6a, 0xb5, 0x65, 0xc6, 0x7a, 0xcb, 0x8c, 0xc3, 0x96, 0x91, 0x2f, 0x25, 0x23, 0x3f,
	0x4a, 0x46, 0x7e, 0x96, 0x8c, 0xac, 0x4a, 0x46, 0x7e, 0x95, 0x8c, 0xfc, 0x2e, 0x99, 0x71, 0x28,
	0x19, 0xf9, 0xba, 0x63, 0xc6, 0x6a, 0xc7, 0x8c, 0xf5, 0x8e, 0x19, 0x8b, 0x1e, 0xfe, 0x5c, 0x2f,
	0xff, 0x04, 0x00, 0x00, 0xff, 0xff, 0xdc, 0xc4, 0x3b, 0x86, 0xad, 0x02, 0x00, 0x00,
}

func (this *CheckDefinition) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CheckDefinition)
	if !ok {
		that2, ok := that.(CheckDefinition)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Checks) != len(that1.Checks) {
		return false
	}
	for i := range this.Checks {
		if !this.Checks[i].Equal(that1.Checks[i]) {
			return false
		}
	}
	if this.LogSource != that1.LogSource {
		return false
	}
	if len(this.ReadinessChecks) != len(that1.ReadinessChecks) {
		return false
	}
	for i := range this.ReadinessChecks {
		if !this.ReadinessChecks[i].Equal(that1.ReadinessChecks[i]) {
			return false
		}
	}
	return true
}
func (this *Check) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Check)
	if !ok {
		that2, ok := that.(Check)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.TcpCheck.Equal(that1.TcpCheck) {
		return false
	}
	if !this.HttpCheck.Equal(that1.HttpCheck) {
		return false
	}
	return true
}
func (this *TCPCheck) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*TCPCheck)
	if !ok {
		that2, ok := that.(TCPCheck)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Port != that1.Port {
		return false
	}
	if this.ConnectTimeoutMs != that1.ConnectTimeoutMs {
		return false
	}
	if this.IntervalMs != that1.IntervalMs {
		return false
	}
	return true
}
func (this *HTTPCheck) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*HTTPCheck)
	if !ok {
		that2, ok := that.(HTTPCheck)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Port != that1.Port {
		return false
	}
	if this.RequestTimeoutMs != that1.RequestTimeoutMs {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	if this.IntervalMs != that1.IntervalMs {
		return false
	}
	return true
}
func (this *CheckDefinition) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&models.CheckDefinition{")
	if this.Checks != nil {
		s = append(s, "Checks: "+fmt.Sprintf("%#v", this.Checks)+",\n")
	}
	s = append(s, "LogSource: "+fmt.Sprintf("%#v", this.LogSource)+",\n")
	if this.ReadinessChecks != nil {
		s = append(s, "ReadinessChecks: "+fmt.Sprintf("%#v", this.ReadinessChecks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Check) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&models.Check{")
	if this.TcpCheck != nil {
		s = append(s, "TcpCheck: "+fmt.Sprintf("%#v", this.TcpCheck)+",\n")
	}
	if this.HttpCheck != nil {
		s = append(s, "HttpCheck: "+fmt.Sprintf("%#v", this.HttpCheck)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TCPCheck) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&models.TCPCheck{")
	s = append(s, "Port: "+fmt.Sprintf("%#v", this.Port)+",\n")
	s = append(s, "ConnectTimeoutMs: "+fmt.Sprintf("%#v", this.ConnectTimeoutMs)+",\n")
	s = append(s, "IntervalMs: "+fmt.Sprintf("%#v", this.IntervalMs)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HTTPCheck) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&models.HTTPCheck{")
	s = append(s, "Port: "+fmt.Sprintf("%#v", this.Port)+",\n")
	s = append(s, "RequestTimeoutMs: "+fmt.Sprintf("%#v", this.RequestTimeoutMs)+",\n")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "IntervalMs: "+fmt.Sprintf("%#v", this.IntervalMs)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringCheckDefinition(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *CheckDefinition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckDefinition) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckDefinition) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ReadinessChecks) > 0 {
		for iNdEx := len(m.ReadinessChecks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.ReadinessChecks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCheckDefinition(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.LogSource) > 0 {
		i -= len(m.LogSource)
		copy(dAtA[i:], m.LogSource)
		i = encodeVarintCheckDefinition(dAtA, i, uint64(len(m.LogSource)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Checks) > 0 {
		for iNdEx := len(m.Checks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Checks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCheckDefinition(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *Check) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Check) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Check) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.HttpCheck != nil {
		{
			size, err := m.HttpCheck.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCheckDefinition(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.TcpCheck != nil {
		{
			size, err := m.TcpCheck.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCheckDefinition(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *TCPCheck) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TCPCheck) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *TCPCheck) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.IntervalMs != 0 {
		i = encodeVarintCheckDefinition(dAtA, i, uint64(m.IntervalMs))
		i--
		dAtA[i] = 0x18
	}
	if m.ConnectTimeoutMs != 0 {
		i = encodeVarintCheckDefinition(dAtA, i, uint64(m.ConnectTimeoutMs))
		i--
		dAtA[i] = 0x10
	}
	if m.Port != 0 {
		i = encodeVarintCheckDefinition(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *HTTPCheck) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HTTPCheck) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HTTPCheck) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.IntervalMs != 0 {
		i = encodeVarintCheckDefinition(dAtA, i, uint64(m.IntervalMs))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintCheckDefinition(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0x1a
	}
	if m.RequestTimeoutMs != 0 {
		i = encodeVarintCheckDefinition(dAtA, i, uint64(m.RequestTimeoutMs))
		i--
		dAtA[i] = 0x10
	}
	if m.Port != 0 {
		i = encodeVarintCheckDefinition(dAtA, i, uint64(m.Port))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintCheckDefinition(dAtA []byte, offset int, v uint64) int {
	offset -= sovCheckDefinition(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *CheckDefinition) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Checks) > 0 {
		for _, e := range m.Checks {
			l = e.Size()
			n += 1 + l + sovCheckDefinition(uint64(l))
		}
	}
	l = len(m.LogSource)
	if l > 0 {
		n += 1 + l + sovCheckDefinition(uint64(l))
	}
	if len(m.ReadinessChecks) > 0 {
		for _, e := range m.ReadinessChecks {
			l = e.Size()
			n += 1 + l + sovCheckDefinition(uint64(l))
		}
	}
	return n
}

func (m *Check) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TcpCheck != nil {
		l = m.TcpCheck.Size()
		n += 1 + l + sovCheckDefinition(uint64(l))
	}
	if m.HttpCheck != nil {
		l = m.HttpCheck.Size()
		n += 1 + l + sovCheckDefinition(uint64(l))
	}
	return n
}

func (m *TCPCheck) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Port != 0 {
		n += 1 + sovCheckDefinition(uint64(m.Port))
	}
	if m.ConnectTimeoutMs != 0 {
		n += 1 + sovCheckDefinition(uint64(m.ConnectTimeoutMs))
	}
	if m.IntervalMs != 0 {
		n += 1 + sovCheckDefinition(uint64(m.IntervalMs))
	}
	return n
}

func (m *HTTPCheck) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Port != 0 {
		n += 1 + sovCheckDefinition(uint64(m.Port))
	}
	if m.RequestTimeoutMs != 0 {
		n += 1 + sovCheckDefinition(uint64(m.RequestTimeoutMs))
	}
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovCheckDefinition(uint64(l))
	}
	if m.IntervalMs != 0 {
		n += 1 + sovCheckDefinition(uint64(m.IntervalMs))
	}
	return n
}

func sovCheckDefinition(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozCheckDefinition(x uint64) (n int) {
	return sovCheckDefinition(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *CheckDefinition) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForChecks := "[]*Check{"
	for _, f := range this.Checks {
		repeatedStringForChecks += strings.Replace(f.String(), "Check", "Check", 1) + ","
	}
	repeatedStringForChecks += "}"
	repeatedStringForReadinessChecks := "[]*Check{"
	for _, f := range this.ReadinessChecks {
		repeatedStringForReadinessChecks += strings.Replace(f.String(), "Check", "Check", 1) + ","
	}
	repeatedStringForReadinessChecks += "}"
	s := strings.Join([]string{`&CheckDefinition{`,
		`Checks:` + repeatedStringForChecks + `,`,
		`LogSource:` + fmt.Sprintf("%v", this.LogSource) + `,`,
		`ReadinessChecks:` + repeatedStringForReadinessChecks + `,`,
		`}`,
	}, "")
	return s
}
func (this *Check) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Check{`,
		`TcpCheck:` + strings.Replace(this.TcpCheck.String(), "TCPCheck", "TCPCheck", 1) + `,`,
		`HttpCheck:` + strings.Replace(this.HttpCheck.String(), "HTTPCheck", "HTTPCheck", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TCPCheck) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TCPCheck{`,
		`Port:` + fmt.Sprintf("%v", this.Port) + `,`,
		`ConnectTimeoutMs:` + fmt.Sprintf("%v", this.ConnectTimeoutMs) + `,`,
		`IntervalMs:` + fmt.Sprintf("%v", this.IntervalMs) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HTTPCheck) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HTTPCheck{`,
		`Port:` + fmt.Sprintf("%v", this.Port) + `,`,
		`RequestTimeoutMs:` + fmt.Sprintf("%v", this.RequestTimeoutMs) + `,`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`IntervalMs:` + fmt.Sprintf("%v", this.IntervalMs) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringCheckDefinition(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *CheckDefinition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheckDefinition
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckDefinition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckDefinition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheckDefinition
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheckDefinition
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheckDefinition
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Checks = append(m.Checks, &Check{})
			if err := m.Checks[len(m.Checks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LogSource", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheckDefinition
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheckDefinition
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheckDefinition
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LogSource = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadinessChecks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheckDefinition
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheckDefinition
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheckDefinition
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReadinessChecks = append(m.ReadinessChecks, &Check{})
			if err := m.ReadinessChecks[len(m.ReadinessChecks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCheckDefinition(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCheckDefinition
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Check) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheckDefinition
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Check: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Check: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TcpCheck", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheckDefinition
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheckDefinition
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheckDefinition
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TcpCheck == nil {
				m.TcpCheck = &TCPCheck{}
			}
			if err := m.TcpCheck.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpCheck", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheckDefinition
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheckDefinition
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheckDefinition
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HttpCheck == nil {
				m.HttpCheck = &HTTPCheck{}
			}
			if err := m.HttpCheck.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCheckDefinition(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCheckDefinition
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TCPCheck) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheckDefinition
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TCPCheck: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TCPCheck: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheckDefinition
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnectTimeoutMs", wireType)
			}
			m.ConnectTimeoutMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheckDefinition
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConnectTimeoutMs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntervalMs", wireType)
			}
			m.IntervalMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheckDefinition
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IntervalMs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCheckDefinition(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCheckDefinition
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HTTPCheck) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheckDefinition
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HTTPCheck: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HTTPCheck: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Port", wireType)
			}
			m.Port = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheckDefinition
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Port |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestTimeoutMs", wireType)
			}
			m.RequestTimeoutMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheckDefinition
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RequestTimeoutMs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheckDefinition
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheckDefinition
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheckDefinition
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntervalMs", wireType)
			}
			m.IntervalMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheckDefinition
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IntervalMs |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCheckDefinition(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCheckDefinition
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCheckDefinition(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCheckDefinition
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCheckDefinition
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCheckDefinition
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthCheckDefinition
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupCheckDefinition
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthCheckDefinition
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthCheckDefinition        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCheckDefinition          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupCheckDefinition = fmt.Errorf("proto: unexpected end of group")
)
