// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: cells.proto

package models

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type CellCapacity struct {
	MemoryMb   int32 `protobuf:"varint,1,opt,name=memory_mb,json=memoryMb,proto3" json:"memory_mb"`
	DiskMb     int32 `protobuf:"varint,2,opt,name=disk_mb,json=diskMb,proto3" json:"disk_mb"`
	Containers int32 `protobuf:"varint,3,opt,name=containers,proto3" json:"containers"`
}

func (m *CellCapacity) Reset()      { *m = CellCapacity{} }
func (*CellCapacity) ProtoMessage() {}
func (*CellCapacity) Descriptor() ([]byte, []int) {
	return fileDescriptor_842e821272d22ff7, []int{0}
}
func (m *CellCapacity) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CellCapacity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CellCapacity.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CellCapacity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CellCapacity.Merge(m, src)
}
func (m *CellCapacity) XXX_Size() int {
	return m.Size()
}
func (m *CellCapacity) XXX_DiscardUnknown() {
	xxx_messageInfo_CellCapacity.DiscardUnknown(m)
}

var xxx_messageInfo_CellCapacity proto.InternalMessageInfo

func (m *CellCapacity) GetMemoryMb() int32 {
	if m != nil {
		return m.MemoryMb
	}
	return 0
}

func (m *CellCapacity) GetDiskMb() int32 {
	if m != nil {
		return m.DiskMb
	}
	return 0
}

func (m *CellCapacity) GetContainers() int32 {
	if m != nil {
		return m.Containers
	}
	return 0
}

type CellPresence struct {
	CellId                string        `protobuf:"bytes,1,opt,name=cell_id,json=cellId,proto3" json:"cell_id"`
	RepAddress            string        `protobuf:"bytes,2,opt,name=rep_address,json=repAddress,proto3" json:"rep_address"`
	Zone                  string        `protobuf:"bytes,3,opt,name=zone,proto3" json:"zone"`
	Capacity              *CellCapacity `protobuf:"bytes,4,opt,name=capacity,proto3" json:"capacity,omitempty"`
	RootfsProviders       []*Provider   `protobuf:"bytes,5,rep,name=rootfs_providers,json=rootfsProviders,proto3" json:"rootfs_provider_list,omitempty"`
	PlacementTags         []string      `protobuf:"bytes,6,rep,name=placement_tags,json=placementTags,proto3" json:"placement_tags,omitempty"`
	OptionalPlacementTags []string      `protobuf:"bytes,7,rep,name=optional_placement_tags,json=optionalPlacementTags,proto3" json:"optional_placement_tags,omitempty"`
	RepUrl                string        `protobuf:"bytes,8,opt,name=rep_url,json=repUrl,proto3" json:"rep_url"`
}

func (m *CellPresence) Reset()      { *m = CellPresence{} }
func (*CellPresence) ProtoMessage() {}
func (*CellPresence) Descriptor() ([]byte, []int) {
	return fileDescriptor_842e821272d22ff7, []int{1}
}
func (m *CellPresence) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CellPresence) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CellPresence.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CellPresence) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CellPresence.Merge(m, src)
}
func (m *CellPresence) XXX_Size() int {
	return m.Size()
}
func (m *CellPresence) XXX_DiscardUnknown() {
	xxx_messageInfo_CellPresence.DiscardUnknown(m)
}

var xxx_messageInfo_CellPresence proto.InternalMessageInfo

func (m *CellPresence) GetCellId() string {
	if m != nil {
		return m.CellId
	}
	return ""
}

func (m *CellPresence) GetRepAddress() string {
	if m != nil {
		return m.RepAddress
	}
	return ""
}

func (m *CellPresence) GetZone() string {
	if m != nil {
		return m.Zone
	}
	return ""
}

func (m *CellPresence) GetCapacity() *CellCapacity {
	if m != nil {
		return m.Capacity
	}
	return nil
}

func (m *CellPresence) GetRootfsProviders() []*Provider {
	if m != nil {
		return m.RootfsProviders
	}
	return nil
}

func (m *CellPresence) GetPlacementTags() []string {
	if m != nil {
		return m.PlacementTags
	}
	return nil
}

func (m *CellPresence) GetOptionalPlacementTags() []string {
	if m != nil {
		return m.OptionalPlacementTags
	}
	return nil
}

func (m *CellPresence) GetRepUrl() string {
	if m != nil {
		return m.RepUrl
	}
	return ""
}

type Provider struct {
	Name       string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name"`
	Properties []string `protobuf:"bytes,2,rep,name=properties,proto3" json:"properties,omitempty"`
}

func (m *Provider) Reset()      { *m = Provider{} }
func (*Provider) ProtoMessage() {}
func (*Provider) Descriptor() ([]byte, []int) {
	return fileDescriptor_842e821272d22ff7, []int{2}
}
func (m *Provider) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Provider) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Provider.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Provider) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Provider.Merge(m, src)
}
func (m *Provider) XXX_Size() int {
	return m.Size()
}
func (m *Provider) XXX_DiscardUnknown() {
	xxx_messageInfo_Provider.DiscardUnknown(m)
}

var xxx_messageInfo_Provider proto.InternalMessageInfo

func (m *Provider) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Provider) GetProperties() []string {
	if m != nil {
		return m.Properties
	}
	return nil
}

type CellsResponse struct {
	Error *Error          `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	Cells []*CellPresence `protobuf:"bytes,2,rep,name=cells,proto3" json:"cells,omitempty"`
}

func (m *CellsResponse) Reset()      { *m = CellsResponse{} }
func (*CellsResponse) ProtoMessage() {}
func (*CellsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_842e821272d22ff7, []int{3}
}
func (m *CellsResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CellsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CellsResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CellsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CellsResponse.Merge(m, src)
}
func (m *CellsResponse) XXX_Size() int {
	return m.Size()
}
func (m *CellsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CellsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CellsResponse proto.InternalMessageInfo

func (m *CellsResponse) GetError() *Error {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *CellsResponse) GetCells() []*CellPresence {
	if m != nil {
		return m.Cells
	}
	return nil
}

func init() {
	proto.RegisterType((*CellCapacity)(nil), "models.CellCapacity")
	proto.RegisterType((*CellPresence)(nil), "models.CellPresence")
	proto.RegisterType((*Provider)(nil), "models.Provider")
	proto.RegisterType((*CellsResponse)(nil), "models.CellsResponse")
}

func init() { proto.RegisterFile("cells.proto", fileDescriptor_842e821272d22ff7) }

var fileDescriptor_842e821272d22ff7 = []byte{
	// 548 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x5c, 0x53, 0x4f, 0x6f, 0xd3, 0x30,
	0x14, 0x4f, 0xe8, 0x9a, 0xb5, 0x0e, 0xdd, 0x26, 0x0b, 0x44, 0x35, 0x21, 0xa7, 0x2a, 0x43, 0xaa,
	0x26, 0xe8, 0xa6, 0x81, 0xb8, 0xd3, 0x09, 0x09, 0x0e, 0x93, 0x26, 0x0b, 0xce, 0x21, 0x7f, 0xde,
	0x4a, 0x44, 0x12, 0x5b, 0xb6, 0x8b, 0x54, 0x4e, 0x7c, 0x84, 0x7d, 0x00, 0x3e, 0x00, 0x1f, 0x85,
	0x63, 0x8f, 0x3b, 0x45, 0x34, 0xbd, 0xa0, 0x9c, 0xf6, 0x11, 0x90, 0x9d, 0x66, 0x2b, 0xbd, 0x58,
	0xbf, 0xf7, 0x7b, 0xbf, 0x67, 0x3f, 0xff, 0x9e, 0x8d, 0xdc, 0x08, 0xd2, 0x54, 0x8e, 0xb9, 0x60,
	0x8a, 0x61, 0x27, 0x63, 0x31, 0xa4, 0xf2, 0xf0, 0xe5, 0x34, 0x51, 0x5f, 0x66, 0xe1, 0x38, 0x62,
	0xd9, 0xc9, 0x94, 0x4d, 0xd9, 0x89, 0x49, 0x87, 0xb3, 0x2b, 0x13, 0x99, 0xc0, 0xa0, 0xba, 0xec,
	0xd0, 0x05, 0x21, 0x98, 0xa8, 0x83, 0xe1, 0xb5, 0x8d, 0x1e, 0x9e, 0x43, 0x9a, 0x9e, 0x07, 0x3c,
	0x88, 0x12, 0x35, 0xc7, 0xc7, 0xa8, 0x9b, 0x41, 0xc6, 0xc4, 0xdc, 0xcf, 0xc2, 0xbe, 0x3d, 0xb0,
	0x47, 0xed, 0x49, 0xaf, 0x2a, 0xbc, 0x7b, 0x92, 0x76, 0x6a, 0x78, 0x11, 0xe2, 0x23, 0xb4, 0x1b,
	0x27, 0xf2, 0xab, 0x56, 0x3e, 0x30, 0x4a, 0xb7, 0x2a, 0xbc, 0x86, 0xa2, 0x8e, 0x06, 0x17, 0x21,
	0x1e, 0x23, 0x14, 0xb1, 0x5c, 0x05, 0x49, 0x0e, 0x42, 0xf6, 0x5b, 0x46, 0xb8, 0x57, 0x15, 0xde,
	0x06, 0x4b, 0x37, 0xf0, 0xf0, 0x67, 0xab, 0x6e, 0xe9, 0x52, 0x80, 0x84, 0x3c, 0x02, 0x7d, 0x8c,
	0xbe, 0xb6, 0x9f, 0xc4, 0xa6, 0xa1, 0x6e, 0x7d, 0xcc, 0x9a, 0xa2, 0x8e, 0x06, 0x1f, 0x62, 0x7c,
	0x8a, 0x5c, 0x01, 0xdc, 0x0f, 0xe2, 0x58, 0x80, 0x94, 0xa6, 0xa1, 0xee, 0x64, 0xbf, 0x2a, 0xbc,
	0x4d, 0x9a, 0x22, 0x01, 0xfc, 0x6d, 0x8d, 0xf1, 0x53, 0xb4, 0xf3, 0x9d, 0xe5, 0x60, 0x5a, 0xea,
	0x4e, 0x3a, 0x55, 0xe1, 0x99, 0x98, 0x9a, 0x15, 0x9f, 0xa2, 0x4e, 0xb4, 0x36, 0xa5, 0xbf, 0x33,
	0xb0, 0x47, 0xee, 0xd9, 0xa3, 0x71, 0x6d, 0xf8, 0x78, 0xd3, 0x30, 0x7a, 0xa7, 0xc2, 0x3e, 0x3a,
	0x10, 0x8c, 0xa9, 0x2b, 0xe9, 0x73, 0xc1, 0xbe, 0x25, 0xb1, 0xbe, 0x6e, 0x7b, 0xd0, 0x1a, 0xb9,
	0x67, 0x07, 0x4d, 0xe5, 0xe5, 0x3a, 0x31, 0x19, 0x56, 0x85, 0x47, 0xb6, 0xd4, 0x7e, 0x9a, 0x48,
	0xf5, 0x82, 0x65, 0x89, 0x82, 0x8c, 0xab, 0x39, 0xdd, 0xaf, 0xf3, 0x4d, 0x8d, 0xc4, 0xcf, 0xd1,
	0x1e, 0x4f, 0x83, 0x08, 0x32, 0xc8, 0x95, 0xaf, 0x82, 0xa9, 0xec, 0x3b, 0x83, 0xd6, 0xa8, 0x4b,
	0x7b, 0x77, 0xec, 0xc7, 0x60, 0x2a, 0xf1, 0x1b, 0xf4, 0x84, 0x71, 0x95, 0xb0, 0x3c, 0x48, 0xfd,
	0x2d, 0xfd, 0xae, 0xd1, 0x3f, 0x6e, 0xd2, 0x97, 0xff, 0xd5, 0x1d, 0xa1, 0x5d, 0x6d, 0xd5, 0x4c,
	0xa4, 0xfd, 0xce, 0xbd, 0xcf, 0x6b, 0x8a, 0x3a, 0x02, 0xf8, 0x27, 0x91, 0x0e, 0xdf, 0xa3, 0x4e,
	0xd3, 0x91, 0x76, 0x30, 0x0f, 0x32, 0x58, 0x8f, 0xc5, 0x38, 0xa8, 0x63, 0x6a, 0x56, 0x4c, 0x10,
	0xe2, 0x82, 0x71, 0x10, 0x2a, 0x01, 0x3d, 0x10, 0x7d, 0xf4, 0x06, 0x33, 0xfc, 0x8c, 0x7a, 0xda,
	0x49, 0x49, 0x41, 0x72, 0x96, 0x4b, 0xc0, 0xcf, 0x50, 0xdb, 0xbc, 0x4d, 0xb3, 0x9f, 0x7b, 0xd6,
	0x6b, 0x5c, 0x7b, 0xa7, 0x49, 0x5a, 0xe7, 0xf0, 0x31, 0x6a, 0x9b, 0x4f, 0x60, 0x36, 0xdc, 0x1a,
	0x4a, 0xf3, 0x64, 0x68, 0x2d, 0x99, 0xbc, 0x5e, 0x2c, 0x89, 0x75, 0xb3, 0x24, 0xd6, 0xed, 0x92,
	0xd8, 0x3f, 0x4a, 0x62, 0xff, 0x2a, 0x89, 0xfd, 0xbb, 0x24, 0xf6, 0xa2, 0x24, 0xf6, 0x9f, 0x92,
	0xd8, 0x7f, 0x4b, 0x62, 0xdd, 0x96, 0xc4, 0xbe, 0x5e, 0x11, 0x6b, 0xb1, 0x22, 0xd6, 0xcd, 0x8a,
	0x58, 0xa1, 0x63, 0xbe, 0xc6, 0xab, 0x7f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x12, 0x8c, 0x77, 0x8d,
	0x6d, 0x03, 0x00, 0x00,
}

func (this *CellCapacity) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CellCapacity)
	if !ok {
		that2, ok := that.(CellCapacity)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.MemoryMb != that1.MemoryMb {
		return false
	}
	if this.DiskMb != that1.DiskMb {
		return false
	}
	if this.Containers != that1.Containers {
		return false
	}
	return true
}
func (this *CellPresence) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CellPresence)
	if !ok {
		that2, ok := that.(CellPresence)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.CellId != that1.CellId {
		return false
	}
	if this.RepAddress != that1.RepAddress {
		return false
	}
	if this.Zone != that1.Zone {
		return false
	}
	if !this.Capacity.Equal(that1.Capacity) {
		return false
	}
	if len(this.RootfsProviders) != len(that1.RootfsProviders) {
		return false
	}
	for i := range this.RootfsProviders {
		if !this.RootfsProviders[i].Equal(that1.RootfsProviders[i]) {
			return false
		}
	}
	if len(this.PlacementTags) != len(that1.PlacementTags) {
		return false
	}
	for i := range this.PlacementTags {
		if this.PlacementTags[i] != that1.PlacementTags[i] {
			return false
		}
	}
	if len(this.OptionalPlacementTags) != len(that1.OptionalPlacementTags) {
		return false
	}
	for i := range this.OptionalPlacementTags {
		if this.OptionalPlacementTags[i] != that1.OptionalPlacementTags[i] {
			return false
		}
	}
	if this.RepUrl != that1.RepUrl {
		return false
	}
	return true
}
func (this *Provider) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Provider)
	if !ok {
		that2, ok := that.(Provider)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Name != that1.Name {
		return false
	}
	if len(this.Properties) != len(that1.Properties) {
		return false
	}
	for i := range this.Properties {
		if this.Properties[i] != that1.Properties[i] {
			return false
		}
	}
	return true
}
func (this *CellsResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CellsResponse)
	if !ok {
		that2, ok := that.(CellsResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Error.Equal(that1.Error) {
		return false
	}
	if len(this.Cells) != len(that1.Cells) {
		return false
	}
	for i := range this.Cells {
		if !this.Cells[i].Equal(that1.Cells[i]) {
			return false
		}
	}
	return true
}
func (this *CellCapacity) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&models.CellCapacity{")
	s = append(s, "MemoryMb: "+fmt.Sprintf("%#v", this.MemoryMb)+",\n")
	s = append(s, "DiskMb: "+fmt.Sprintf("%#v", this.DiskMb)+",\n")
	s = append(s, "Containers: "+fmt.Sprintf("%#v", this.Containers)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CellPresence) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&models.CellPresence{")
	s = append(s, "CellId: "+fmt.Sprintf("%#v", this.CellId)+",\n")
	s = append(s, "RepAddress: "+fmt.Sprintf("%#v", this.RepAddress)+",\n")
	s = append(s, "Zone: "+fmt.Sprintf("%#v", this.Zone)+",\n")
	if this.Capacity != nil {
		s = append(s, "Capacity: "+fmt.Sprintf("%#v", this.Capacity)+",\n")
	}
	if this.RootfsProviders != nil {
		s = append(s, "RootfsProviders: "+fmt.Sprintf("%#v", this.RootfsProviders)+",\n")
	}
	s = append(s, "PlacementTags: "+fmt.Sprintf("%#v", this.PlacementTags)+",\n")
	s = append(s, "OptionalPlacementTags: "+fmt.Sprintf("%#v", this.OptionalPlacementTags)+",\n")
	s = append(s, "RepUrl: "+fmt.Sprintf("%#v", this.RepUrl)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Provider) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&models.Provider{")
	s = append(s, "Name: "+fmt.Sprintf("%#v", this.Name)+",\n")
	s = append(s, "Properties: "+fmt.Sprintf("%#v", this.Properties)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *CellsResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&models.CellsResponse{")
	if this.Error != nil {
		s = append(s, "Error: "+fmt.Sprintf("%#v", this.Error)+",\n")
	}
	if this.Cells != nil {
		s = append(s, "Cells: "+fmt.Sprintf("%#v", this.Cells)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringCells(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *CellCapacity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CellCapacity) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CellCapacity) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Containers != 0 {
		i = encodeVarintCells(dAtA, i, uint64(m.Containers))
		i--
		dAtA[i] = 0x18
	}
	if m.DiskMb != 0 {
		i = encodeVarintCells(dAtA, i, uint64(m.DiskMb))
		i--
		dAtA[i] = 0x10
	}
	if m.MemoryMb != 0 {
		i = encodeVarintCells(dAtA, i, uint64(m.MemoryMb))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CellPresence) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CellPresence) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CellPresence) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.RepUrl) > 0 {
		i -= len(m.RepUrl)
		copy(dAtA[i:], m.RepUrl)
		i = encodeVarintCells(dAtA, i, uint64(len(m.RepUrl)))
		i--
		dAtA[i] = 0x42
	}
	if len(m.OptionalPlacementTags) > 0 {
		for iNdEx := len(m.OptionalPlacementTags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.OptionalPlacementTags[iNdEx])
			copy(dAtA[i:], m.OptionalPlacementTags[iNdEx])
			i = encodeVarintCells(dAtA, i, uint64(len(m.OptionalPlacementTags[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.PlacementTags) > 0 {
		for iNdEx := len(m.PlacementTags) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.PlacementTags[iNdEx])
			copy(dAtA[i:], m.PlacementTags[iNdEx])
			i = encodeVarintCells(dAtA, i, uint64(len(m.PlacementTags[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.RootfsProviders) > 0 {
		for iNdEx := len(m.RootfsProviders) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.RootfsProviders[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCells(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.Capacity != nil {
		{
			size, err := m.Capacity.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCells(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.Zone) > 0 {
		i -= len(m.Zone)
		copy(dAtA[i:], m.Zone)
		i = encodeVarintCells(dAtA, i, uint64(len(m.Zone)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.RepAddress) > 0 {
		i -= len(m.RepAddress)
		copy(dAtA[i:], m.RepAddress)
		i = encodeVarintCells(dAtA, i, uint64(len(m.RepAddress)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.CellId) > 0 {
		i -= len(m.CellId)
		copy(dAtA[i:], m.CellId)
		i = encodeVarintCells(dAtA, i, uint64(len(m.CellId)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Provider) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Provider) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Provider) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Properties) > 0 {
		for iNdEx := len(m.Properties) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Properties[iNdEx])
			copy(dAtA[i:], m.Properties[iNdEx])
			i = encodeVarintCells(dAtA, i, uint64(len(m.Properties[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintCells(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CellsResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CellsResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CellsResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Cells) > 0 {
		for iNdEx := len(m.Cells) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Cells[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCells(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCells(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintCells(dAtA []byte, offset int, v uint64) int {
	offset -= sovCells(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *CellCapacity) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MemoryMb != 0 {
		n += 1 + sovCells(uint64(m.MemoryMb))
	}
	if m.DiskMb != 0 {
		n += 1 + sovCells(uint64(m.DiskMb))
	}
	if m.Containers != 0 {
		n += 1 + sovCells(uint64(m.Containers))
	}
	return n
}

func (m *CellPresence) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.CellId)
	if l > 0 {
		n += 1 + l + sovCells(uint64(l))
	}
	l = len(m.RepAddress)
	if l > 0 {
		n += 1 + l + sovCells(uint64(l))
	}
	l = len(m.Zone)
	if l > 0 {
		n += 1 + l + sovCells(uint64(l))
	}
	if m.Capacity != nil {
		l = m.Capacity.Size()
		n += 1 + l + sovCells(uint64(l))
	}
	if len(m.RootfsProviders) > 0 {
		for _, e := range m.RootfsProviders {
			l = e.Size()
			n += 1 + l + sovCells(uint64(l))
		}
	}
	if len(m.PlacementTags) > 0 {
		for _, s := range m.PlacementTags {
			l = len(s)
			n += 1 + l + sovCells(uint64(l))
		}
	}
	if len(m.OptionalPlacementTags) > 0 {
		for _, s := range m.OptionalPlacementTags {
			l = len(s)
			n += 1 + l + sovCells(uint64(l))
		}
	}
	l = len(m.RepUrl)
	if l > 0 {
		n += 1 + l + sovCells(uint64(l))
	}
	return n
}

func (m *Provider) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovCells(uint64(l))
	}
	if len(m.Properties) > 0 {
		for _, s := range m.Properties {
			l = len(s)
			n += 1 + l + sovCells(uint64(l))
		}
	}
	return n
}

func (m *CellsResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovCells(uint64(l))
	}
	if len(m.Cells) > 0 {
		for _, e := range m.Cells {
			l = e.Size()
			n += 1 + l + sovCells(uint64(l))
		}
	}
	return n
}

func sovCells(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozCells(x uint64) (n int) {
	return sovCells(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *CellCapacity) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CellCapacity{`,
		`MemoryMb:` + fmt.Sprintf("%v", this.MemoryMb) + `,`,
		`DiskMb:` + fmt.Sprintf("%v", this.DiskMb) + `,`,
		`Containers:` + fmt.Sprintf("%v", this.Containers) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CellPresence) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForRootfsProviders := "[]*Provider{"
	for _, f := range this.RootfsProviders {
		repeatedStringForRootfsProviders += strings.Replace(f.String(), "Provider", "Provider", 1) + ","
	}
	repeatedStringForRootfsProviders += "}"
	s := strings.Join([]string{`&CellPresence{`,
		`CellId:` + fmt.Sprintf("%v", this.CellId) + `,`,
		`RepAddress:` + fmt.Sprintf("%v", this.RepAddress) + `,`,
		`Zone:` + fmt.Sprintf("%v", this.Zone) + `,`,
		`Capacity:` + strings.Replace(this.Capacity.String(), "CellCapacity", "CellCapacity", 1) + `,`,
		`RootfsProviders:` + repeatedStringForRootfsProviders + `,`,
		`PlacementTags:` + fmt.Sprintf("%v", this.PlacementTags) + `,`,
		`OptionalPlacementTags:` + fmt.Sprintf("%v", this.OptionalPlacementTags) + `,`,
		`RepUrl:` + fmt.Sprintf("%v", this.RepUrl) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Provider) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Provider{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Properties:` + fmt.Sprintf("%v", this.Properties) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CellsResponse) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForCells := "[]*CellPresence{"
	for _, f := range this.Cells {
		repeatedStringForCells += strings.Replace(f.String(), "CellPresence", "CellPresence", 1) + ","
	}
	repeatedStringForCells += "}"
	s := strings.Join([]string{`&CellsResponse{`,
		`Error:` + strings.Replace(fmt.Sprintf("%v", this.Error), "Error", "Error", 1) + `,`,
		`Cells:` + repeatedStringForCells + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringCells(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *CellCapacity) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCells
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CellCapacity: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CellCapacity: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryMb", wireType)
			}
			m.MemoryMb = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCells
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MemoryMb |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiskMb", wireType)
			}
			m.DiskMb = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCells
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DiskMb |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Containers", wireType)
			}
			m.Containers = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCells
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Containers |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCells(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCells
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CellPresence) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCells
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CellPresence: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CellPresence: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CellId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCells
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCells
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCells
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CellId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RepAddress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCells
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCells
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCells
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RepAddress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Zone", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCells
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCells
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCells
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Zone = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Capacity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCells
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCells
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCells
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Capacity == nil {
				m.Capacity = &CellCapacity{}
			}
			if err := m.Capacity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RootfsProviders", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCells
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCells
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCells
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RootfsProviders = append(m.RootfsProviders, &Provider{})
			if err := m.RootfsProviders[len(m.RootfsProviders)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PlacementTags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCells
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCells
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCells
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PlacementTags = append(m.PlacementTags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OptionalPlacementTags", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCells
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCells
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCells
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OptionalPlacementTags = append(m.OptionalPlacementTags, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RepUrl", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCells
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCells
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCells
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RepUrl = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCells(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCells
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Provider) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCells
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Provider: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Provider: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCells
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCells
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCells
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Properties", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCells
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCells
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCells
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Properties = append(m.Properties, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCells(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCells
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CellsResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCells
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CellsResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CellsResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCells
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCells
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCells
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &Error{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cells", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCells
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCells
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCells
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cells = append(m.Cells, &CellPresence{})
			if err := m.Cells[len(m.Cells)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCells(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthCells
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCells(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCells
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCells
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCells
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthCells
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupCells
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthCells
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthCells        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCells          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupCells = fmt.Errorf("proto: unexpected end of group")
)
