# Contributing

See the [Contributing.md](./.github/CONTRIBUTING.md) for more
information on how to contribute.

# Working Group Charter

This repository is maintained by [App Runtime
Platform](https://github.com/cloudfoundry/community/blob/main/toc/working-groups/app-runtime-platform.md)
under `Networking` area.

# Routing Release

This repository is a [BOSH](https://github.com/cloudfoundry/bosh)
release for deploying Gorouter, TCP Routing, and other associated tasks
that provide HTTP and TCP routing in Cloud Foundry foundations.

For information on getting started with Cloud Foundry look at the docs
for [CF Deployment](https://github.com/cloudfoundry/cf-deployment).

# Docs

-   [How To enable Quotas for TCP
    Routing](./docs/03-how-to-enable-quota-tcp-routing.md)
-   [How To Limit Trusted CAs for
    Gorouter](./docs/03-how-to-limit-trusted-cas-for-gorouter.md)
-   [How To Use NATS Client](./docs/03-how-to-use-nats-client.md)
-   [How To Use Session
    Affinity](./docs/03-how-to-use-session-affinity.md)
-   [How To Use X-CF Headers](./docs/03-how-to-use-x-cf-headers.md)
-   [(go1.15) Fixing Bad
    Transfer-Encoding](./docs/04-go1.15-fixing-bad-transfer-encoding.md)
-   [(go1.15) X.509 CommonName
    deprecation](./docs/04-go1.15-x509-commonname-deprecation.md)
-   [(go1.20) Multiple Expect 100-continue
    responses](./docs/04-go1.20-multiple-expect-100-continue.md)
-   [(routing-release-0.262.0) Healthy App Route
    Pruning](./docs/04-routing-0.262.0-healthy-app-route-pruning.md)
-   [(routing-release-0.277.0) TCP Router Port
    Conflict](./docs/04-routing-0.277.0-tcp-router-port-conflict.md)
-   [High Availability & Scaling](./docs/05-high-availbility-scaling.md)

> \[!IMPORTANT\]
>
> Content in this file is managed by the [CI task
> `sync-readme`](https://github.com/cloudfoundry/wg-app-platform-runtime-ci/blob/main/shared/tasks/sync-readme/metadata.yml)
> and is generated by CI following a convention.
