"use strict";
import classNames from "classnames";
import PropTypes from "prop-types";
import createReactClass from "create-react-class";

var PT = PropTypes;

var SearchResourceBox = createReactClass({
  //fixme! - class SearchResourceBox extends React.Component {
  propTypes: {
    search: PT.func.isRequired,
  },

  getInitialState: function () {
    return {
      query: ""
    };
  },

  handleChange: function (event) {
    var query = event.target.value;
    this.setState({ query: query });

    if (query.length === 0 || 2 <= query.length) {
      this.props.search(query);
    }
    event.stopPropagation();
  },

  handleKey: function (event) {
    if (event.keyCode == 13) {
      this.props.search(event.target.value);
    }
  },

  render: function () {
    return <div className="form-group">
      <input className="form-control search search-resource" type="text"
        value={this.state.query} placeholder="Search for resource"
        onChange={this.handleChange} />
    </div>;
  }
});

module.exports = SearchResourceBox;
