Contribution Guidelines
=======================

## How Can I Contribute?

### Bug Reports and Fixes

Raise an issue, and if you have a fix, make a pull request.

### Documentation Improvements

Raise an issue if it's complicated.

Make a pull request if it's simple.

### Feature Requests and Proposals

Raise an issue.

### Questions / Clarifications

Raise an issue.

### Feature Contributions

It is important to find out if you contribution will be accepted before
you spend time implementing it.

Feature contributions are likely be rejected if:

- They introduce significant complexity that must be maintained to support a niche usecase
- They conflict with something already in development in a local branch

## Code Style

Try your best to use the same style as the rest of your project. Contributions that
have a significantly different style will be nitpicked.

The following patterns are encouraged:

- one return per function (although this is not always possible)
- one break per loop (although this is not always possible)
- do not allow switch cases to fall-through
- always wrap blocks in braces (e.g. if, else, while)
- configure your editor to remove trailing whitespace
- goto is forbidden
- spaces not tabs
- four space indent
- don't break long lines if they are more readable unbroken

## Pull Requests

Pull requests should explain what the change is and why you've made it.

Commit comments should describe the change that is made.

In most cases multiple commits will be squashed prior to merging using
the Github squash feature.

## Licensing

All contributions shall be licensed the same as LDL (i.e. [MIT License](LICENSE)).

