# Getting Started

Getting started with open-source can be a difficult task, not only because we are being introduced to some new technologies, but also because most of us have never worked in a collaborative environment before. Being able to work in a collaborative environment is one of the most important skills anyone could acquire, not only in the coding and programming area, but in life.

It may appear a very challenging and overwhelming task at first, but it is, in fact, a fun and rewarding experience.

# Community Led Collaboration Projects
Providing the opportunity for you to flex your developer muscles, whilst working within a team of developers. Gaining valuable skills, employers are always seeking, such as:
- **Communication and collaboration** - Being able to work in a team and communicating effectively is a very important skill.
- **Github and source control** - In these projects you will have the opportunity to understand why branching is important along with other key github skills.
- **New stacks and technologies** - Each project is likely to use slightly varying stacks, providing the opportunity to jump into something new.

# How You Benefit
Along with learning new skills, you will also gain experience on projects you can start to list on your Resume/CV. In addition, you will build out your commit history on Github, which employers love! But most importantly, you will learn to work in teams which is one of the most important skills to be a top developer.

# You have 2 options: Join an existing project or Create a new project:

## Option 1: Join a project
Joining a project is pretty simple, checkout the [current projects](https://github.com/zero-to-mastery) and find one you would like to participate in. Check out the project README in its repo as it will have a guide on how to get started!

**Please note:** Whilst working on any project in the Zero To Mastery community, you must adhere to our code of conduct, which can be found [here](https://github.com/zero-to-mastery/CodeofConduct).

## Option 2: Create a project
We are always on the look out for new and exciting project to add to Zero to Mastery for you all to collaborate on! If you think you have a new and exciting project/idea the community would love to get involved in, here is the process for getting it listed:
- Reach out to a member of the Management Team on our Discord server, with a detailed project brief
- Management team will consider if the project is something that would work well with the community
- A Repository will be created and the project will be announced in #current-project channel in our Discord server and featured during an upcoming announcement by Andrei.
- If the project has enough demand, a dedicated channel will be created to accomodate discussions.

### **Rules**
In order to ensure that students hard work and time are not exploited, there are a couple of rules that will need to be followed for any project:
- The project repo and discussion channels, will be hosted under the Zero To Mastery Github organization/Discord Server.
- The project must use the [Creative Commons Attribution 4.0 International License](https://creativecommons.org/licenses/by/4.0/).
- The project must contain and adhere to the `code of conduct` guide found [here](https://github.com/zero-to-mastery/CodeofConduct).

## Current Projects
You can view all current projects [here](https://github.com/zero-to-mastery) or you can view the specific #current-projects channel in our Discord Community that gives you a little more detail on each project.

## What is open source?

Open source is the original way of creating software – in an open, transparent and collaborative manner. “[What is free software?](https://www.gnu.org/philosophy/free-sw.en.html)" and “[What is open source?](https://opensource.com/resources/what-open-source)" are good overviews of the subject.

Open source means that you get the final executable for a software project, and also have access to the source code from which it was produced. Having access to the source code means that you can better understand how the program functions and more importantly you can modify it to fix any problems you have with the software or add new features which you desire.

What might look like a chaotic way of creating software (everybody focusing on their own needs) works surprisingly well: for example the Linux kernel contains more than 4,000 man years worth of effort.

## Why would I want to contribute?

Here, practicing would be our primary objective but there are also many pragmatic reasons for contributing to open source projects:

   **1.** To add a new feature / improvement to a project; or to fix an issue with a project.

   **2.** To practice and learn about software development – contributing to a project is a great way to learn about the more hands on aspects of software development like using debuggers, version control systems, issue trackers, etc.

   **3.** To practice/learn a particular programming language or technology which you are interested in.

   **4.** To build your online presence – highlighting open source contributions relevant to the job makes your resume stand out from the rest.

## How can I contribute to projects?

**1.** **Test :**  Start with testing the code for any bugs, if found raise an issue about it. (Always check first if someone has already raised an issue for the same.)

**2.** **Suggest features:** Look for possible improvements and provide suggestions in the comment section.

**3.** **Design:** Considering the fact that practice is the main objective, try to make little changes on your forked repository and make a pull-request about it. *Commit often and provide appropriate messages to your commits.*

**4.** You can also help in providing proper documentation of the various projects.
