# Open-Source-4-Everyone

<a href="https://github.com/chryz-hub/opensource-4-everyone"><img src="https://img.shields.io/badge/PRs-welcome-green"></a> 
<a href="https://github.com/chryz-hub/opensource-4-everyone"><img src="https://img.shields.io/badge/Contributions-welcome-green"></a> 
<a href="https://github.com/chryz-hub/opensource-4-everyone/graphs/contributors"><img src="https://img.shields.io/github/contributors/chryz-Hub/opensource-4-everyone?style=plastic"></a>
<a href="https://github.com/chryz-hub/opensource-4-everyone/stargazers"><img src="https://img.shields.io/github/stars/chryz-Hub/opensource-4-everyone?style=plastic"></a>

#### This repo is for everything open source!

**Feel free to create an [issue](https://github.com/chryz-hub/opensource-4-everyone/issues) or make a Pull Request. Please see our [Contributing file](https://github.com/chryz-hub/opensource-4-everyone/blob/master/CONTRIBUTING.md)
first and our [Code of Conduct](https://github.com/chryz-hub/opensource-4-everyone/blob/master/CODE_OF_CONDUCT.md), before making new commits or opening a Pull Request, we appreciate it!
In order for us not to ignore your effort, please check well not to make a duplicate of a Pull Request (contribution)/issue!**

# Contributing

If you want to contribute to a project and make it better, your help is very welcome. Contributing is also a great way to learn more about social coding on GitHub, new technologies and their ecosystems and how to make constructive, helpful bug reports, feature requests and the noblest of all contributions: a good, clean Pull Request. To learn how to use Git or GitHub here is a [resource](Learn-Git-And-GitHub.md) allocated for that.

### How to make a clean Pull Request

Look for a project's contribution instructions. If you find any, then let's follow these steps.

- Create a personal fork of the project on GitHub.
- Clone the fork on your local machine. Your remote repo on GitHub is called `origin`.
- Add the original repository as a remote called `upstream`.
- If you created your fork a while ago be sure to pull upstream changes into your local repository.
- Create a new branch to work on! Branch from `develop` if it exists, else from `master`.
- Implement/ fix your feature, comment your code.
- Follow the code style of the project, including indentation.
- If the project has tests run them!
- Write or adapt tests as needed.
- Add or change the documentation as needed.
- Squash your commits into a single commit with the community [git tips](https://github.com/chryz-hub/opensource-4-everyone/blob/master/chryz-hub-resources/chryz-hub-docs/git.md). Create a new branch if necessary.
- Push your branch to your fork on GitHub, the remote `origin`.
- From your fork open a Pull Request in the correct branch. Target the project's `develop` branch if there is one, else go for `master`!
- If the maintainer requests further changes just push them to your branch. The Pull Request will be updated automatically.
- Once the Pull Request is approved and merged you can pull the changes from `upstream` to your local repo and delete
  your extra branch(es).

And last but not least: Always write your commit messages in the present tense. Your commit message should describe what the commit, when applied, does to the code – not what you did to the code.

**But wait before you start contibuting, you've got to know us better. This would really aid you to :**

- Fit more into the community.
- Understand our modes of operation.
- Know the community moderators and members as well.
- Know the goals and aim of the community.
- Including your presence as a member/ contributor, if you wish and many more!

## The Pull Request Practice!

Eager to make your first Pull Request or make out connections with lot of people or fishing out your choice[stack]-anyone, we've got you covered. Make a [Pull Request](https://github.com/chryz-hub/opensource-4-everyone/blob/master/My-PR-Contribution-Practice.md) but before that, check out our short tutorial on how to easily make a contribution 👇

**Note:**

- To be a member; Raise an [invitation issue here](https://github.com/chryz-hub/chryz-hub.github.io/issues/new?assignees=&labels=invite+me+to+the+organisation&template=invitation.md&title=Please+invite+me+to+the+GitHub+Community+Organization)!

## Simple Guide to Making a Pull Request or Contribution

### 1. Fork/ Edit

What is a fork?

This is cloning a repository to have a personal version of that same/ main repository.
So, this is advisable to first fork the repository you want to contribute to and then move to check for it in your personal GitHub repositories, there you would find the forked
repository. You can also click the edit(pencil) button, and this automatically forks the repo to your version. Make sure you are in the right repository before forking or editing it, can you see the name of the repository used as a sample!
<img align="center" src="https://github.com/chryz-hub/opensource-4-everyone/blob/master/chryz-hub-resources/chryz-hub-tut-pics/pr-tut-pics/fork1.jpg" />

### 2. Start Making contribution/ changes

Do you notice any change ~~ the naming of the repository, the first name there is your forked version while the other is that of the real repository. So, I already got my personal version of the repository because I forked or edited it. Then, you can start making your changes and add anything you feel neccesary/ right.
<img align="center" src="https://github.com/chryz-hub/opensource-4-everyone/blob/master/chryz-hub-resources/chryz-hub-tut-pics/pr-tut-pics/work2.jpg" />

### 3. Commit Changes

Just like using git, you have to put down a commit message, without putting down any message GitHub defaultly give you a commit message exactly as what I used as my commit message. There is a second space for more description, you can fill this up if you see it as dimmed fit or necessary and be precise. So, I would be committing this on the master(default) of my forked GitHub repository. There would be no much sense in commiting this in a new branch because I run this, there are no other contributors and you are sure on what you want but if it is a GitHub community it is advisable to create a new branch. Then commit changes!
<img align="center" src="https://github.com/chryz-hub/opensource-4-everyone/blob/master/chryz-hub-resources/chryz-hub-tut-pics/pr-tut-pics/worksave3jpg.jpg" />

### 4. Create Pull Request

After the commit, then click the Pull Request tab and make new Pull Request
<img align="center" src="https://github.com/chryz-hub/opensource-4-everyone/blob/master/chryz-hub-resources/chryz-hub-tut-pics/pr-tut-pics/pr-1-4.jpg" />

### 5. Comparing Changes

This is all about the comparism between your own forked version and the real repository to check if there was a change and if the change is mergeable. You can see the word `comparing across forks` and a transitional line with an arrow in the middle. You must set this well to avoid issue, now we are sending from mine to the main/real repository using the direction of the arrow, then you can make your Pull request. If it is not mergeable, you can still make the Pull Request and resolve it `resolve conflicts`, GitHub would point out the issue which makes it easier for you to resolve.
<img align="center" src="https://github.com/chryz-hub/opensource-4-everyone/blob/master/chryz-hub-resources/chryz-hub-tut-pics/pr-tut-pics/pr-2-5.jpg" />

### 6. Create Pull Request Message

Just same process as a commit message. Some community have a pull Request template which makes it easier to fill in important and appropriate details concerning a Pull Request,
which is shown on the image. I didn't add any description because there wasn't really a change,the change here was only a space, but yours could be way far than this. So fill
it up with neccessary details and concerning the Pull Request title, do not forget to make it precise. You can see a check button there, clicking it simply means that the Pull Request can be edited by the mainteners of the repository. I really advise you to always check this, although it's automatically checked by github by default, so the choice is left to you. Then click the `create Pull Request` button.

<img align="center" src="https://github.com/chryz-hub/opensource-4-everyone/blob/master/chryz-hub-resources/chryz-hub-tut-pics/pr-tut-pics/pr-3-6.jpg" />

### Congratulations🎉 You've made your first contribution

After your Pull Request has been reviewed by the Team of the community and everything there is appropriate. Then, your Pull Request would be merged and this makes your Pull Request a contribution!

## Chryz-hub Resources

<details>
<summary>
<strong> <a href="https://github.com/chryz-hub/opensource-4-everyone/tree/master/chryz-hub-resources/chryz-hub-docs"> Docs</a></strong>
</summary>
    <ul>
     <li><a href="https://chryzcodez.hashnode.dev/how-to-make-your-github-profile-readme"> How To Make Your GitHub Profile Readme</a></li>
     <li><a href="https://github.com/chryz-hub/opensource-4-everyone/blob/master/chryz-hub-resources/chryz-hub-docs/membership-visibility.md"> GitHub Membership Visibility Tutorials</a></li>
     <li><a href="https://github.com/chryz-hub/opensource-4-everyone/blob/master/chryz-hub-resources/chryz-hub-docs/anatomy-of-open-source-communities.md"> The Anatomy of Open-Source Projects</a></li>
     <li><a href="https://github.com/chryz-hub/opensource-4-everyone/blob/master/chryz-hub-resources/chryz-hub-docs/git.md"> Basic and Advance Git Tips</a></li>
     <li><a href="https://github.com/chryz-hub/opensource-4-everyone/blob/master/chryz-hub-resources/chryz-hub-docs/starting-open-source.md"> Getting Started With Open-Source</a></li>
     <li><a href="https://github.com/chryz-hub/opensource-4-everyone/blob/master/chryz-hub-resources/chryz-hub-docs/access-open-source-projects.md"> Getting an Open-Source Project to Start Contributing</a></li>
     <li><a href="https://github.com/chryz-hub/opensource-4-everyone/blob/master/chryz-hub-resources/chryz-hub-docs/git-cmd.md"> Git Commands</a></li>
    </ul>
</details>

<details>
<summary>
<strong> <a href="https://www.youtube.com/channel/UCxro6LYOp3pmmuWDPMg-p1Q"> YouTube Videos</a></strong>
</summary>
 <ul>
   <li><a href="https://www.youtube.com/watch?v=91x7KJ1lMHw"> Introduction to Opensource</a></li>
   <li><a href="https://www.youtube.com/watch?v=epPsQ3prWRw&t=6s"> Git and GitHub</a></li>
</ul>
</details>

#### We hope you found that, useful!

## Direct GitHub searches

Search links that point directly to suitable issues to contribute to on GitHub.

- [is:issue is:open label:beginner](https://github.com/issues?q=is%3Aissue+is%3Aopen+label%3Abeginner)
- [is:issue is:open label:easy](https://github.com/issues?q=is%3Aissue+is%3Aopen+label%3Aeasy)
- [is:issue is:open label:first-timers-only](https://github.com/issues?q=is%3Aissue+is%3Aopen+label%3Afirst-timers-only)
- [is:issue is:open label:good-first-bug](https://github.com/issues?q=is%3Aissue+is%3Aopen+label%3Agood-first-bug)
- [is:issue is:open label:"good first issue"](https://github.com/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22)
- [is:issue is:open label:starter](https://github.com/issues?q=is%3Aissue+is%3Aopen+label%3Astarter)
- [is:issue is:open label:up-for-grabs](https://github.com/issues?q=is%3Aissue+is%3Aopen+label%3Aup-for-grabs)

## Resources

<details><summary><strong> Websites </summary><blockquote></strong>
<ul>
    <li><a href="https://www.codetriage.com/">CodeTriage</a> - CodeTriage helps by picking a handful of open issues and delivering them directly to your inbox. After you sign up for CodeTriage, you pick the repos you want to help with, and we periodically send you issues.</li> 
    <li><a href="https://goodfirstissue.dev/"> goodfirstissue.dev</a> - Curates easy pickings from popular open-source projects, and helps you make your first contribution to open-source.</li>
    <li><a href="http://goodfirstissue.com/"> goodfirstissue.com</a> - A site made for new contributors to find great Open Source projects, discover issues and repositories with good first issue and help wanted labels.</li>
    <li><a href="https://up-for-grabs.net/"> Up For Grabs</a> - This is a list of projects which have curated tasks specifically for new contributors. These are a great way to get started with a project, or to help share the load of working on open source projects.</li>
    <li><a href="https://firstcontributions.github.io/"> First contributions</a> - A hands-on tutorial that walks you through contributions workflow on GitHub. It help beginners to contribute to open source projects.</li>
    <li><a href="https://contributor.ninja/"> Contributor Ninja</a> - A platform to find issues in several languages to fix on GitHub.</li>
    <li><a href="https://gauger.io/contrib"> Gauger</a> - With this site, you can find beginner friendly open source projects to work on.</li>
    <li><a href="https://opensauced.pizza/"> Open Sauced</a> - Open Sauced provides guidance for new contributors finding their next contribution. Our approach towards onboarding offers a way to track contributions through a GitHub powered dashboard.</li>
    <li><a href="https://24pullrequests.com/"> 24 Pull Requests</a> - 24 Pull Requests' goal is to encourage contribution to open source projects during December. The site suggests open projects, highlights tickets that are good for new contributors, provides guides for contributing and promotes good contributions submitted each day.</li>
    <li><a href="http://issuehub.pro/"> Issue Hub</a> - Contribute to open source by searching issue labels to find the right project for you!</li>
    <li><a href="http://www.pullrequestroulette.com/"> Pull Request Roulette</a> - On this site, there's a list of pull requests submitted for review, belonging to open source projects hosted on GitHub.</li>
</ul>
</blockquote></details>
</details>

<details><summary><strong> Repositories </summary><blockquote></strong>
<ul>
    <li><a href="https://github.com/MunGell/awesome-for-beginners"> Awesome First PR Opportunities</a></li>
    <li><a href="https://github.com/eddiejaoude/book-open-source-tips">Open Source Tips</a></li>
    <li><a href="https://github.com/github/opensource.guide">Open Source Guides</a></li>
    <li><a href="https://github.com/18F/open-source-guide">18F Open Source Style Guide</a></li>
    <li><a href="https://github.com/discord/discord-open-source">Open Source Communities on Discord</a></li>
    <li><a href="https://github.com/github/opensourcefriday">Open Source Friday</a></li>
    <li><a href="https://github.com/open-source-ideas/open-source-ideas">Open Source Ideas</a></li>
    <li><a href="https://github.com/mvillaloboz/open-source-cs-degree">The Open-Source Computer Science Degree</a></li>
    <li><a href="https://github.com/shainakrumme/open-source-handbook"> Open Source Handbook</a></li>
    <li><a href="https://github.com/tapaswenipathak/Getting-Started-With-Contributing-to-Open-Sources"> Getting Started With Contributing to Open Sources</a></li>
    <li><a href="https://github.com/open-sauced/open-sauced"> Open Sauced</a></li>
    <li><a href="https://github.com/firstcontributions/first-contributions"> First Contributions</a></li>
    <li><a href="https://github.com/explore/"> Explore Github</a></li>
    <li><a href="https://github.com/larymak/Python-project-Scripts"> Python Projects Script</a></li>
    <li><a href="https://github.com/mazipan/hello-open-source">Hello Open Source</a></li>
    <li><a href="https://github.com/pinax"> Pinax Project</a></li>
    <li><a href="https://github.com/open-source-ideas/open-source-ideas"> Open Source Ideas</a></li>
    <li> <a href ="https://github.com/freeCodeCamp/how-to-contribute-to-open-source">How to contribute to open source</a></li>
    <li> <a href ="https://github.com/danthareja/contribute-to-open-source">Contribute to Open Source</a></li>
</ul>
</blockquote></details>
</details>

<details><summary><strong> Books </summary><blockquote></strong>
<ul>
    <li><a href="https://www.amazon.com/dp/B086G6XDM1?tag=uuid10-20"> Open (Source) for Business: A Practical Guide to Open Source Software Licensing - Third Edition</a></li>
    <li><a href="https://www.amazon.com/Source-Static-Analysis-Complete-Guide/dp/0655942386?tag=uuid10-20"> Open Source Static Code Analysis Tool A Complete Guide</a></li>
    <li><a href="https://www.amazon.com/Open-Source-Licensing-Software-Intellectual/dp/0131487876/ref=pd_sbs_2/142-0255904-0756168?pd_rd_w=O2Jmx&pf_rd_p=3676f086-9496-4fd7-8490-77cf7f43f846&pf_rd_r=WFVCK53MGCMWXHP5TT0F&pd_rd_r=cba59fe4-8139-4165-b7e5-a37b50150f71&pd_rd_wg=Zlc9T&pd_rd_i=0131487876&psc=1">Open Source Licensing: Software Freedom and Intellectual Property Law</a></li>
    <li><a href="https://www.amazon.com/Producing-Open-Source-Software-Successful/dp/0596007590">Producing Open Source Software: How To Run A Successful Free Software Project</a></li>
    <li><a href="https://www.amazon.com/Forge-Your-Future-Open-Source/dp/1680503014"> Forge Your Future with Open Source: Build Your Skills. Build Your Network. Build the Future of Technology</a></li>
    <li><a href="https://www.amazon.com/Open-Source-Governance-Complete-Guide/dp/0655943102?tag=uuid10-20"> Open Source Governance A Complete Guide</a></li>
    <li><a href="https://www.amazon.com/Open-Source-Notebook-Sourcerer-Inches/dp/1700126016?tag=uuid10-20">Open Source Notebook: Open Sourcerer</a></li>
    <li><a href="https://www.amazon.com/dp/1565925823?tag=uuid10-20">Open Sources: Voices from the Open Source Revolution</a></li>
    <li><a href="https://www.amazon.com/Working-Public-Making-Maintenance-Software/dp/0578675862/ref=sr_1_2?dchild=1&keywords=open+source&qid=1627244642&s=books&sr=1-2">Working in Public: The Making and Maintenance of Open Source Software</a></li>
    <li><a href="https://www.amazon.com/Entreprenerd-Building-Multi-Million-Dollar-Business-Software-ebook/dp/B09516H7LY/ref=sr_1_3?dchild=1&keywords=open+source&qid=1627244690&s=books&sr=1-3">Entreprenerd: Building a Multi-Million-Dollar Business with Open Source Software</a></li>
    <li><a href="https://www.amazon.com/Intellectual-Property-Open-Source-Protecting/dp/0596517963/ref=sr_1_12?dchild=1&keywords=open+source&qid=1627244690&s=books&sr=1-12">Intellectual Property and Open Source: A Practical Guide to Protecting Code</a></li>
    <li><a href="https://www.amazon.com/Understanding-Open-Source-Software-Licensing/dp/0596005814/ref=pd_bxgy_img_1/142-0255904-0756168?pd_rd_w=2AAiV&pf_rd_p=c64372fa-c41c-422e-990d-9e034f73989b&pf_rd_r=B56H43PW2MBZGSZPDKRA&pd_rd_r=f8e98e8b-1fb6-4dee-a617-64adcc48343d&pd_rd_wg=OkEwO&pd_rd_i=0596005814&psc=1">Understanding Open Source and Free Software Licensing</a></li>
    <li><a href="https://www.amazon.com/Performance-Open-Source-Applications/dp/1304488780">The Performance of Open Source Applications</a></li>
    <li><a href="https://www.amazon.com/Open-Source-Alternative-Understanding-Opportunities/dp/0470194952/ref=pd_sim_5/142-0255904-0756168?pd_rd_w=NYlLz&pf_rd_p=6caf1c3a-a843-4189-8efc-81b67e85dc96&pf_rd_r=72BSPQAVZSVV5WAF481P&pd_rd_r=30cf2ab6-d784-4e41-a069-c492a0a8d918&pd_rd_wg=dE9El&pd_rd_i=0470194952&psc=1">The Open Source Alternative</a></li>
    <li><a href="https://www.amazon.com/Rebel-Code-Linux-Source-Revolution-ebook/dp/B005I57NZ2/ref=as_li_ss_tl?keywords=open+source&qid=1579289424&refinements=p_72:2661619011&rnid=2661617011&sr=8-57&linkCode=sl1&tag=solutionsre04-20&linkId=61398f18974ba77ed7bfc6ccf4972330&language=en_US">Rebel Code: Linux and the Open Source Revolution</a></li>
    <li><a href="https://www.amazon.com/Open-Source-Property-Jeremy-Sheff/dp/B08GG2DN9M/ref=sr_1_14?dchild=1&keywords=open+source&qid=1627244690&s=books&sr=1-14">Open Source Property: Volume 1</a></li>
    <li><a href="https://www.amazon.com/Open-Source-Property-Jeremy-Sheff/dp/B08GFYF69C/ref=pd_bxgy_img_1/142-0255904-0756168?pd_rd_w=MTuUy&pf_rd_p=c64372fa-c41c-422e-990d-9e034f73989b&pf_rd_r=0SGKXTNNH99N8P6WSB9K&pd_rd_r=b2f3385b-db10-4aec-bde8-24d5b5e3bec2&pd_rd_wg=LoMPm&pd_rd_i=B08GFYF69C&psc=1">Open Source Property: Volume 2</a></li>
    <li><a href="https://www.amazon.com/Success-Open-Source-Steven-Weber/dp/0674018583">The Success of Open Source</a></li>
    <li><a href="https://www.amazon.com/Architecture-Open-Source-Applications/dp/1257638017/ref=as_li_ss_tl?keywords=open+source&qid=1579288709&sr=8-12&linkCode=sl1&tag=solutionsre04-20&linkId=41cd4b50c76820c83cb477021a850822&language=en_US">The Architecture Of Open Source Applications</a></li>
    <li><a href="https://www.amazon.com/Architecture-Open-Source-Applications-Structure-ebook/dp/B008940UYK">The Architecture of Open Source Applications, Volume II: Structure, Scale, and a Few More Fearless Hacks</a></li>
    <li><a href="https://www.amazon.com/Open-Source-Enterprise-Managing-Reaping/dp/0596101198">Open Source for the Enterprise: Managing Risks, Reaping Rewards</a></li>
    <li><a href="https://www.amazon.com/Embracing-Insanity-Source-Software-Development/dp/0672319896/ref=sr_1_46?dchild=1&keywords=open+source&qid=1627245304&s=books&sr=1-46">Embracing Insanity: Open Source Software Development</a></li>
    <li><a href="https://www.amazon.com/Perspectives-Free-Source-Software-Press/dp/0262562278">Perspectives on Free and Open Source Software (The MIT Press)</a></li>
</ul>
</blockquote></details>
</details>

<details><summary><strong> Paid Open-Source Internship </summary><blockquote></strong>
<ul>
    <li> <a href ="https://summerofcode.withgoogle.com/"> Google Summer of Codes</a></li>
    <li> <a href ="https://www.outreachy.org/"> Outreachy</a></li>
    <li> <a href ="https://developers.google.com/season-of-docs"> Google Season of Docs</a></li>
    <li> <a href ="https://wikimediafoundation.org/news/tag/internship/"> Wikimedia Internship</a></li>
</ul>
</blockquote></details>
</details>

<details><summary><strong> YouTube Channels/Videos </summary><blockquote></strong>

<details><summary>Channels </summary><blockquote>
<ul>
    <li> <a href ="https://www.youtube.com/c/github">GitHub</a></li>
    <li> <a href ="https://youtube.com/c/eddiejaoude">Eddie Jaoude</a></li>
    <li> <a href ="https://youtube.com/c/opensourceway">Opensource.com</a></li>
    <li> <a href ="https://youtube.com/c/GoogleOpenSource">Google Open Source</a></li>
    <li> <a href ="https://www.youtube.com/c/AllThingsOpen">All Things Open</a></li>
</ul>
</blockquote></details>

<details><summary>Videos </summary><blockquote>
<ul>
    <li> <a href ="https://youtu.be/yzeVMecydCE">Complete Guide to Open Source - How to Contribute</a></li>
    <li> <a href ="https://youtu.be/kP-rEaamgHM">Tips for contributing to Open Source with Github</a></li>
    <li> <a href ="https://youtu.be/pASY8b8QWcs">Level Up as an Open Source Contributor</a></li>
    <li> <a href ="https://youtu.be/b_e-Uzag31w">Getting Into Open Source for Fun & Profit</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=6mtPPkKchcQ">How open source has made me and the stuff I make better</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=OGeoH-sqePE">Building The Open Source Community We Want</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=zCJyiBu12Jw">Managing an Open Source Project</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=jKI1Kj5VXqE">Managing an Open Source Project - UtahJS</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=Zlu3QvuwruY">Open Sourcing Your Stuff</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=k6KcaMffxac">Contributing to Open Source on GitHub for beginners</a></li>
    <li> <a href ="https://youtu.be/uzxcILudFWM">Pieter Hintjens - Building Open Source Communities</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=jTTf4oLkvaM">Contributing to Open-Source Projects as a New Python Developer: How to Do It</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=FYkBA9epUEk">A new way to contribute to open source</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=nKfl3EQ0twg">Starting an Open Source Project</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=W7AewHnxMig">How to find Github Repos to contribute to</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=Y6k_pW_7yLI">A Practical Guide to Open Source Contribution</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=9yx3XZq4JxM">Make Your First Open Source Contribution || Beginners Guide to Open Source</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=k17GqN9dT3Q">Jessica McKellar: Contribute with me! Getting started with open source development</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=hwdeUG_gySI">I want you to contribute to open source</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=b_aF5zk22cA">How to contribute to OPEN SOURCE projects on Github</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=OsOZpF6LFcw">The Open Source Contributor Funnel: Turning Users Into Maintainers</a></li>
    <li> <a href ="https://youtu.be/c6b6B9oN4Vg">Contributing to Open Source for the first time</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=vcLlsnH7r8k">Contributing to Open Source</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=figcsHHHT0o">Why Open Source Contribution is Essential to your Business </a></li>
    <li> <a href ="https://www.youtube.com/watch?v=qeuu_aSPlao">A Million Ways To Contribute To Open Source; It’s Not Just About Code</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=8QaezVWLydM">A Newcomer's Guide to Open Source Contribution</a></li>
    <li> <a href ="https://youtu.be/3HqN-YS8eso">Getting started with Open Source & GitHub</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=LvkRaIKX1L8">How to contribute to Open Source?</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=GAqfMNB-YBU">How I Started Contributing to Open Source and Why You Should Too</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=MT6M_sqAuZo">How to Open Source Like a Pro</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=GbqSvJs-6W4">How To Get Started With Open Source</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=DnvhWAx2I7A">How to Contribute to Open Source Projects</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=Tq4RZ-JH6aM">How to start with Open Source software contributions</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=RHETubkhjY8&list=PLR0CKdeR_FyscaxEksDVXc4UQvlOFLYS6&t=0s">Complete Guide to Open Source Contributions</a></li>
    <li> <a href ="https://www.youtube.com/watch?v=Y5HIJeR9hk0">Get started with Open Source</a></li>
</ul>
</blockquote></details>
</details>

<details><summary><strong> Open-Source Docs/Blogs </summary><blockquote></strong>
<ul>
    <li> <a href ="https://docs.github.com/en/github/getting-started-with-github/finding-ways-to-contribute-to-open-source-on-github"> GitHub docs for open source</a></li>
    <li> <a href ="https://opensource.guide/how-to-contribute/"> GitHub open souce guide</a></li>
    <li> <a href ="https://fasani.hashnode.dev/5-tips-for-getting-involved-in-open-source-projects-on-github-ckdrmibup00unfzs1e56ugo1q"> 5 tips for getting involved in open-source projects on GitHub</a></li>
    <li> <a href ="https://stackoverflow.blog/2020/08/03/getting-started-with-contributing-to-open-source/"> Getting started with contributing to open source</a></li>
    <li> <a href = "https://www.hanselman.com/blog/GetInvolvedInOpenSourceTodayHowToContributeAPatchToAGitHubHostedOpenSourceProjectLikeCode52.aspx"> Get Involved In Open Source Today</a></li>
    <li> <a href ="https://www.digitalocean.com/community/tutorials/how-to-contribute-to-open-source-getting-started-with-git"> How To Contribute To Open Source: Getting Started With Git</a></li>
    <li> <a href ="https://akrabat.com/the-beginners-guide-to-contributing-to-a-github-project/"> The beginner's guide to contributing to a GitHub project</a></li>
    <li> <a href ="https://www.works-hub.com/learn/the-beginners-guide-to-contributing-to-open-source-4a526"> The Beginner's Guide to Contributing to Open Source</a></li>
    <li> <a href ="https://www.digitalocean.com/community/tutorials/how-to-maintain-open-source-software-projects"> How To Maintain Open-Source Software Projects</a></li>
    <li> <a href ="https://opensource.guide/how-to-contribute/#a-checklist-before-you-contribute"> How to Contribute to Open Source</a></li>
    <li> <a href ="https://www.hackerearth.com/getstarted-opensource/"> How to get started with Open Source</a></li>
    <li> <a href ="https://yourfirstpr.github.io/"> Your First PR</a></li>
    <li> <a href ="https://edidiongasikpo.com/the-technical-writers-guide-to-contributing-to-open-source-projects">The Technical Writers Guide to Contributing to Open Source Projects</a></li>
    <li> <a href ="https://www.dataschool.io/how-to-contribute-on-github/"> Step-by-step guide to contributing on GitHub</a></li>
    <li> <a href ="https://www.codemotion.com/magazine/dev-hub/backend-dev/contributing-to-open-source-projects/"> Contributing To Open-Source Projects</a></li>
    <li> <a href ="https://edidiongasikpo.com/open-source-contributions-a-catalyst-for-growth">Open Source contributions: A catalyst for growth</a></li>
    <li> <a href ="https://pulkitsinghdev.hashnode.dev/how-to-contribute-to-open-source"> A guide to making open source contributions</a></li>
    <li> <a href ="https://ololade.hashnode.dev/series/beginners-guide-to-open-source-contribution"> Beginner's Guide to Open Source Contribution</a></li>
    <li> <a href ="https://dev.to/denicmarko/make-your-first-open-source-contribution-4b0n">Make your first open-source contribution</a></li>
    <li> <a href ="https://readwrite.com/2014/10/10/open-source-diversity-how-to-contribute/"> How To Get Started In Open Source</a></li>
    <li> <a href ="https://producingoss.com/en/evaluating-oss-projects.html"> Evaluating Open Source Projects</a></li>
    <li> <a href ="https://www.freecodecamp.org/news/a-beginners-very-bumpy-journey-through-the-world-of-open-source-4d108d540b39/"> A Beginner’s Very Bumpy Journey Through The World of Open Source</a></li>
    <li> <a href ="https://www.freecodecamp.org/news/how-to-contribute-to-open-source-projects-beginners-guide/"> How to Contribute to Open Source Projects – A Beginner's Guide</a></li>
    <li> <a href ="https://dev.to/sigje/contribute-beyond-code-open-source-for-everyone-593j"> Contribute Beyond Code: Open Source for Everyone</a></li>
    <li> <a href ="https://www.freecodecamp.org/news/ultimate-owners-guide-to-open-source/"> How to Be a Good Open Source Project Owner – The Ultimate Guide</a></li>
    <li> <a href ="https://www.freecodecamp.org/news/the-ultimate-guide-to-open-source/"> The Ultimate Guide to Open Source</a></li>
    <li> <a href ="https://www.freecodecamp.org/news/why-you-should-start-contributing-to-open-source-software-right-now/"> Why You Should Start Contributing to Open Source Software Right Now</a></li>
    <li> <a href ="https://www.freecodecamp.org/news/how-to-choose-and-care-for-a-secure-open-source-project/"> How to Choose and Care for a Secure Open Source Project</a></li>
    <li> <a href ="https://www.freecodecamp.org/news/what-is-great-about-developing-open-source-and-what-is-not/"> The Pros and Cons of Open Source Software Development</a></li>
    <li> <a href ="https://www.freecodecamp.org/news/the-definitive-guide-to-contributing-to-open-source-900d5f9f2282/"> The Definitive Guide to Contributing to Open Source</a></li>
    <li> <a href ="https://opensource.guide/starting-a-project/"> Starting an Open Source Project</a></li>
    <li> <a href ="https://kentcdodds.com/blog/how-getting-into-open-source-has-been-awesome-for-me"> How getting into Open Source has been awesome for me</a></li>
    <li> <a href ="https://kentcdodds.com/blog/open-source-stamina"> Open Source Stamina</a></li>
    <li> <a href ="https://kentcdodds.com/blog/building-the-open-source-community-we-want"> Building the Open Source Community We Want</a></li>
    <li> <a href ="https://kentcdodds.com/blog/how-i-learn-an-open-source-codebase"> How I learn an Open Source Codebase</a></li>
    <li> <a href ="https://livecodestream.dev/post/how-to-make-your-first-contribution-to-open-source/"> How to Make your First Contribution to Open Source</a></li>
    <li> <a href ="https://kentcdodds.com/blog/introducing-how-to-contribute-to-open-source"> Introducing: How to Contribute to Open Source</a></li>
    <li> <a href ="https://kentcdodds.com/blog/what-open-source-project-should-i-contribute-to"> What open source project should I contribute to?</a></li>
    <li> <a href ="https://egghead.io/courses/how-to-contribute-to-an-open-source-project-on-github"> How to Contribute to an Open Source Project on GitHub</a></li>
    <li> <a href ="https://kentcdodds.com/blog/first-timers-only"> First Timers Only</a></li>
    <li> <a href ="https://ben.balter.com/2015/11/23/why-open-source/"> Why open source?</a></li>
    <li> <a href ="https://ben.balter.com/2017/11/10/twelve-tips-for-growing-communities-around-your-open-source-project/"> Twelve tips for growing communities around your open source project</a></li>
    <li> <a href ="https://ben.balter.com/2015/03/08/open-source-best-practices-internal-collaboration/"> Best practices in Open Source: internal collaboration</a></li>
    <li> <a href ="https://ben.balter.com/2015/03/17/open-source-best-practices-external-engagement/"> Best practices in Open Source: external engagement</a></li>
    <li> <a href ="https://ben.balter.com/2017/11/28/everything-an-open-source-maintainer-might-need-to-know-about-open-source-licensing/"> Everything an open source maintainer might need to know about open source licensing</a></li>
    <li> <a href ="https://ben.balter.com/2016/08/01/why-you-shouldnt-write-your-own-open-source-license/"> Why you shouldn’t write your own open source license</a></li>
    <li> <a href ="https://medium.com/rocknnull/self-taught-software-engineers-why-open-source-is-important-to-us-fe2a3473a576"> Self-taught Software Developers: Why Open Source is important to us</a></li>
    <li> <a href ="https://dev.to/captainsafia/so-you-wanna-open-source-a-project-eh-5779"> So you wanna open source a project, eh?</a></li>
    <li> <a href ="https://www.saluki.tech/2021/06/16/making-a-game-with-open-source-tools/"> Making a game with Open-Source tools</a></li>
    <li> <a href ="https://www.errietta.me/blog/open-source/"> Why I love contributing to open source software</a></li>
    <li> <a href ="https://opensource.guide/best-practices/"> Best Practices for Maintainers
    </a></li>
    <li> <a href ="https://medium.com/@kenjagan/what-does-open-source-even-mean-p5-js-edition-98c02d354b39"> What Does “Open Source” Even Mean?</a></li>
    <li> <a href ="https://lord.io/oss-tips/"> TIPS FOR NEW OPEN SOURCE MAINTAINERS</a></li>
    <li> <a href ="https://krausefx.com/blog/scaling-open-source-communities"> Scaling Open Source Communities</a></li>
    <li> <a href ="https://github.blog/2016-03-15-kindly-closing-pull-requests/"> Kindly Closing Pull Requests</a></li>
    <li> <a href ="https://www.jeffgeerling.com/blog/2016/why-i-close-prs-oss-project-maintainer-notes"> Why I close PRs (OSS project maintainer notes)</a></li>
    <li> <a href ="https://danielbachhuber.com/2016/06/26/my-condolences-youre-now-the-maintainer-of-a-popular-open-source-project/"> My condolences, you’re now the maintainer of a popular open source project</a></li>
    <li> <a href ="https://medium.com/@nayafia/what-success-really-looks-like-in-open-source-2dd1facaf91c#.pbieg7stv"> What success really looks like in open source</a></li>
    <li> <a href ="https://taskwarrior.org/docs/advice.html"> Advice To Open Source Project Contributors</a></li>
    <li> <a href ="https://ayush-raj-blogs.hashnode.dev/making-clean-pr-for-open-source-contributors-pep-8-style">Making clean PR for Open Source Contributors (PEP 8 Style)</a></li>
    <li> <a href ="https://catalins.tech/getting-started-with-open-source-how-to-contribute">Getting Started With Open-Source: How To Contribute</a></li>
    <li> <a href ="https://movi.hashnode.dev/10-ways-you-can-contribute-to-open-source-ckfljitve00cspds1d0cmbzv2">Ways you can contribute to Open-source</a></li>
    <li> <a href ="https://taskwarrior.org/docs/first_time.html"> How to become an Open Source Contributor</a></li>
    <li> <a href ="https://opensource.guide/getting-paid/"> Getting Paid for Open Source Work</a></li>
    <li> <a href ="https://rubygarage.org/blog/how-contribute-to-open-source-projects"> How to Contribute to Open Source Project</a></li>
    <li> <a href ="https://www.upgrad.com/blog/tag/open-source-projects/"> Open Source Projects</a></li>
    <li> <a href ="https://www.upgrad.com/blog/tag/open-source-project-ideas/"> Open Source Project Ideas</a></li>
    <li> <a href ="https://daily.dev/blog/how-to-contribute-to-open-source-projects-as-a-beginner"> How To Contribute To Open-Source Projects As A Beginner</a></li>
    <li> <a href ="https://www.upgrad.com/blog/open-source-projects-for-beginners/">Top 8 Open Source Projects for Beginners To Try in 2021</a></li>
    <li> <a href ="https://www.upgrad.com/blog/open-source-repositories-github/">Top 12 Most Popular Open Source Repositories on GitHub[2021]</a></li>
    <li> <a href ="https://medium.com/@frankiefab100/first-timers-practical-guide-to-open-source-contribution-f1ad553ac79">First timers’ Practical Guide to Open Source Contribution</a></li>
    <li> <a href ="https://frankiefab.hashnode.dev/ten-10-reasons-you-should-contribute-to-free-and-open-source-projects-ckhj55rzq00ud7ys193oid5ia">Ten (10) Reasons You Should Contribute to Free and Open Source Projects</a></li>
</ul>
</blockquote></details>
</details>

<details><summary><strong>Podcasts </summary><blockquote></strong>
<ul>
    <li><a href="https://github.com/readme/podcast"> The ReadME Podcast</a> - On The ReadME Podcast, we take a look behind the scenes of the most impactful open source projects and the developers who make them happen.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9vcGVuc291cmNldW5kZXJkb2dzLmNvbS9mZWVkLw?ep=14"> Open Source Underdogs</a> - A podcast for entrepreneurs about open-source software. In each episode, we chat with a founder or leader to explore how they are building thriving businesses around open-source software. Our goal is to demystify how entrepreneurs can stay true to their open-source objectives while also building sustainable, profitable businesses that fuel innovation and ensure longevity.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9wb2RjYXN0Lm9wZW5zYXAuaW5mby9vcGVuLXNvdXJjZS13YXkvZmVlZC9tcDMv?ep=14"> The Open Source Way</a> - This podcast is about the difference, value or drop that open source can be. Each episode we talk with experts about open source related topics and why they do it the open source way.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9hbmNob3IuZm0vcy8xZjQ0NTg4MC9wb2RjYXN0L3Jzcw?ep=14"> FINOS Open Source in Finance Podcast</a> - The FINOS Open Source in Finance Podcast celebrates open source projects and interesting topics at the cross section of financial services and open source. </li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5wb2RldGl6ZS5jb20vcnNzLy1tUmxFdmJ6dQ?ep=14"> The Craft Of Open Source</a> - This bi-weekly show is focused on the ins and outs of the Open Source Software Community. Join Ben as he speaks with the brightest minds that have brought us some of the most adopted technologies on earth. Each episode is an interview with creators, maintainers, entrepreneurs, and key contributors to the open-source community.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkLnBvZGJlYW4uY29tL3BlcmNvbmEvZmVlZC54bWw?ep=14"> Percona's HOSS Talks FOSS: The Open Source Database Podcast</a> - Percona's head of open source strategy (The HOSS) Matt Yonkovit talks with developers, dba's, and engineers from around the open source community about the latest news and events in the FOSS space. </li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy50d2l0LnR2L2Zsb3NzLnhtbA"> FLOSS Weekly</a> - FLOSS all about Free Libre Open Source Software with talks with the most interesting and important people in the Open Source and Free Software community.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9jaGFuZ2Vsb2cuY29tL3BvZGNhc3QvZmVlZA"> The Changelog: Software Development, Open Source</a> - Conversations with the hackers, leaders, and innovators of the software world. This is a polyglot podcast. All programming languages, platforms, and communities are welcome. Open source moves fast. Keep up.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9saW51eHVucGx1Z2dlZC5jb20vcnNz">LINUX Unplugged</a> - An open show powered by community LINUX Unplugged takes the best attributes of open collaboration and turns it into a weekly show about Linux.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9saW51eGdhbWVjYXN0LmNvbS9mZWVkL2x3ZHdtcDMv">Linux Weekly Daily Wednesday</a> - A weekly dose of all thing Linux and open source with a slice of Pi for good measure.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9zb2Z0d2FyZWVuZ2luZWVyaW5nZGFpbHkuY29tL2NhdGVnb3J5L29wZW4tc291cmNlL2ZlZWQv?sa=X&ved=0CAMQ4aUDahcKEwig76j7qfzxAhUAAAAAHQAAAAAQDg">Open Source – Software Engineering Daily</a> - Open source technology episodes of Software Engineering Daily. At the gym or on your commute, you can listen to long-form interviews about software engineering. After every episode, you should feel like you are 1% better at understanding how the software works.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly93d3cucmVhbGl0eTJjYXN0LmNvbS9yc3M">Reality 2.0</a> - Join Linux and Open Source advocates, Doc Searls and Katherine Druckman, as they navigate the new digital world, covering topics related to Linux and Open Source, as well as digital privacy, security, and other current issues.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly93d3cub3BlbnNvdXJjZXZvaWNlcy5vcmcvcnNz">Open Source Voices</a> - Affter years of producing Linux, BSD, and Other Open Source Podcasts, I came to the realization that we almost always focus on technology. It makes sense, we all love tech, that's why we are who we are. But the community we are apart of is full of varied and fascinating people that make that tech. This is my attempt to highlight the people who are helping us dream up and build the future around us.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5wb2RldGl6ZS5jb20vcnNzLy1tUmxFdmJ6dQ"> The Craft Of Open Source</a> - This bi-weekly show is focused on the ins and outs of the Open Source Software Community. Join Ben as he speaks with the brightest minds that have brought us some of the most adopted technologies on earth. Each episode is an interview with creators, maintainers, entrepreneurs, and key contributors to the open-source community.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9hbmNob3IuZm0vcy8yZWI0ZTczMC9wb2RjYXN0L3Jzcw?sa=X&ved=0CBYQ27cFahcKEwjgis64qvzxAhUAAAAAHQAAAAAQFw"> Open source for business</a> - Your company uses open-source software but needs to better understand how to effectively manage it. In this podcast, Eunice Chendjou and Henry Badgery host interviews with some of the world's top experts that sit at the intersection of business and open source.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5maXJlc2lkZS5mbS9pbXBhY3RmdWxvcGVuc291cmNlL3Jzcw">Impactful Open Source</a> - We seek out stories of open source successes, moving from beyond source code and into the world at large. We focus on code that didn't just turn into a large enterprise business, but which passed through universities, cities, governments, and the world to make a real difference in people's lives. Our guests are open sorcerers, academics, open-source program officers, and everyone in between.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cDovL2ZhaWYudXMvZmVlZHMvY2FzdC1tcDMv">Free as in Freedom</a> - A bi-weekly discussion of legal, policy, and other issues in the open-source and software freedom community (including occasional interviews) from Brooklyn, New York, USA.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly93d3cub3BlbnNvdXJjZWNyZWF0aXZlLm9yZy9lcGlzb2RlL2luZGV4LnhtbA">Open Source Creative</a> - A weekly podcast where I ramble about creativity, process, and open-source software. The show features in-depth discussions about the nature of open-source software and how it relates to doing creative work. And interviews!</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9mbG9zc2ZvcnNjaWVuY2UuZ2l0aHViLmlvL2ZlZWQueG1s">FLOSS for Science</a> - Interviews with scientists who are using or developing free and libre open-source software.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9hbmNob3IuZm0vcy80MDU1MjRjOC9wb2RjYXN0L3Jzcw">Humans of Open Source</a> - A podcast where we explore the human side of working on open-source software. We talk to contributors about how, what, and why they contribute in order to uncover the human element behind the open-source communities that power our digital infrastructure.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly90aGViaW5hcnl0aW1lcy5uZXQvcnNzLW9nZy54bWw">The Binary Times Audiocast - ogg</a> - Linux and open-source tips, tricks, and discussion. Free software, hardware, and modern culture.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9icmVha2luZ29zLmxpYnN5bi5jb20vcnNz">Breaking Into Open Source</a> - Have you ever wondered what would it be to contribute to open-source software? Or is curious about how to get started? Well, wonder no more! In this podcast we let Bob and Josh take us through the tour of the wonderful world of open source, as seen through developers.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cDovL29wZW5zb3VyY2VzeXN0ZW1wb2RjYXN0LnZmLmlvL2ZlZWQv?sa=X&ved=0CCIQ27cFahcKEwjIjrfEqbjxAhUAAAAAHQAAAAAQAg"> Open Source System Podcast</a> - The Open Source System Podcast brings you the latest open source projects and news. We try to focus only on open source software and cover projects that are created in any programming language. If you have a goal to become more involved with open source software then this podcast is for you!</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9mZWVkcy5maXJlc2lkZS5mbS9zdXN0YWluL3Jzcw?sa=X&ved=0CDIQ27cFahcKEwjIjrfEqbjxAhUAAAAAHQAAAAAQAg"> Sustain</a> - Sustain brings together practitioners, sustainers, funders, researchers and maintainers of the open source ecosystem. We have conversations about the health and sustainability of the open source community. We learn about the ins and outs of what ‘open source’ entails in the real world.</li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly93d3cuc3ByZWFrZXIuY29tL3Nob3cvNDQyMTMyNC9lcGlzb2Rlcy9mZWVk?sa=X&ved=0CDMQ27cFahcKEwjIjrfEqbjxAhUAAAAAHQAAAAAQAg"> Scotland Open Source</a> - Scotland Open Source talks to maintainers, advocates and companies from Scotland’s vibrant open source community. </li>
    <li><a href="https://podcasts.google.com/feed/aHR0cHM6Ly9hbmNob3IuZm0vcy80ZjU1MzQ0MC9wb2RjYXN0L3Jzcw?sa=X&ved=0CD4Q27cFahcKEwjIjrfEqbjxAhUAAAAAHQAAAAAQAg"> Creators and Consumers of Open Source</a> - Team Aviyel is sitting together Maintainers on the Journey they took to reach here.</li>
</ul>
</blockquote></details>
</details>

## Find us on

<a href="https://discord.gg/c6RhGwcP5b"><img src="https://img.shields.io/badge/Discord-7289DA?style=for-the-badge&logo=discord&logoColor=white"><br>
<a href="https://github.com/chryz-hub"><img src="https://img.shields.io/badge/GitHub-100000?style=for-the-badge&logo=github&logoColor=white" width="102px"></a><br>
<a href="https://youtube.com/channel/UCxro6LYOp3pmmuWDPMg-p1Q"><img src="https://img.shields.io/badge/YouTube-FF0000?style=for-the-badge&logo=youtube&logoColor=white"></a><br>
<a href="https://twitter.com/ChryzHub"><img src="https://img.shields.io/badge/Twitter-blue?style=for-the-badge&logo=twitter&logoColor=white"></a><br>
<a href="https://www.linkedin.com/company/chryzhub/"><img src="https://img.shields.io/badge/LinkedIn-0077B5?style=for-the-badge&logo=linkedin&logoColor=white"></a>
