# Git/GitHub Resources

This file is allocated towards helping you understand the basics of Git and GitHub and how to get started.

## Index

* [Git/GitHub Blogs](#gitgithub-blogs) - Blogs explaining git/github fundamentals and concepts.
* [Git/GitHub Courses/Videos](#gitgithub-coursesvideos) - Videos explaining how to use git/github.
* [Git/GitHub Repositories](#gitgithub-repositories) - Repositories to learn git and github

# Git/GitHub Docs/Blogs 

- [GitHub Guides](https://guides.github.com/activities/hello-world/)
- [How To Use GitHub – Developers Collaboration Using GitHub](https://www.edureka.co/blog/how-to-use-github/)
- [The beginner’s guide to Git & GitHub](https://www.freecodecamp.org/news/the-beginners-guide-to-git-github/)
- [How To Contribute to Open Source: Getting Started with Git](https://www.digitalocean.com/community/tutorials/how-to-contribute-to-open-source-getting-started-with-git)
- [How Git Branches Work](https://www.freecodecamp.org/news/how-git-branches-work/)
- [What is Commit Signing in Git?](https://www.freecodecamp.org/news/what-is-commit-signing-in-git/)
- [How to Get Started with Version Control Using Git](https://www.freecodecamp.org/news/get-started-with-version-control-and-git/)
- [How To Use Git: A Reference Guide](https://www.digitalocean.com/community/cheatsheets/how-to-use-git-a-reference-guide)
- [How To Use Git Effectively](https://www.digitalocean.com/community/tutorials/how-to-use-git-effectively)
- [How To Use Git Branches](https://www.digitalocean.com/community/tutorials/how-to-use-git-branches)
- [How to Write a Git Commit Message](https://chris.beams.io/posts/git-commit/)
- [How To Use Git: A Reference Guide](https://www.digitalocean.com/community/cheatsheets/how-to-use-git-a-reference-guide)
- [Know how Git works: Behind the Scenes!](https://sohamsshah.hashnode.dev/know-how-git-works-behind-the-scenes-aa40567082ba)
- [5 Git Tips To Level Up Your Workflow](https://ygnys.hashnode.dev/5-git-tips-to-level-up-your-workflow)
- [Everything you need to know to get started with Git and GitHub on a Windows machine](https://chris.beams.io/posts/git-commit/)
- [How to Write a Git Commit Message](https://mihaiviisan.hashnode.dev/everything-you-need-to-know-to-get-started-with-git-and-github-on-a-windows-machine)
- [Git for beginners](https://sudoc.hashnode.dev/series/git-for-beginners)
- [How to Connect GitHub to your GitBash in 5 simple steps](https://unclebigbay.com/how-to-connect-github-to-your-gitbash-in-5-simple-steps)
- [Git & Github: All you need to know](https://nehasoni.hashnode.dev/git-and-github-all-you-need-to-know)
- [How to Use Branches in Git – the Ultimate Cheatsheet](https://www.freecodecamp.org/news/how-to-use-branches-in-git/)
- [Git Checkout Remote Branch Tutorial](https://www.freecodecamp.org/news/git-checkout-remote-branch-tutorial/)
- [A Really Useful Git Command For Quickly Searching Text](https://blog.yogeshchavan.dev/a-really-useful-git-command-for-quickly-searching-text)
- [Git Push to Remote Branch – How to Push a Local Branch to Origin](https://www.freecodecamp.org/news/git-push-to-remote-branch-how-to-push-a-local-branch-to-origin/)
- [Git Switch Branch – How to Change the Branch in Git](https://www.freecodecamp.org/news/git-switch-branch/)
- [How to Use Git and Git Workflows – a Practical Guide](https://www.freecodecamp.org/news/what-is-git-learn-git-version-control/)
- [What is Git? A Beginner's Guide to Git Version Control](https://www.freecodecamp.org/news/how-git-branches-work/)
- [How To Delete All Local Git Branches In One Go](https://catalins.tech/how-to-delete-all-local-git-branches-in-one-go)
- [How To Delete a Git Branch Locally and Remotely](https://hashnode.com/post/how-to-delete-a-git-branch-locally-and-remotely-cknk32nc2004qwes12ck4hn3m)
- [Renaming Your GitHub Projects](https://blog.benhammond.tech/renaming-your-github-projects)
- [A Beginner's Guide to Git and Github](https://efeakhigbe.hashnode.dev/a-beginners-guide-to-git-and-github)
- [Introduction to Git In 16 Minutes](https://vickyikechukwu.hashnode.dev/introduction-to-git-in-16-minutes)
- [How to Create GitHub Draft Pull Requests](https://blog.idrisolubisi.com/how-to-create-github-draft-pull-requests)
- [Start verifying your commits on GitHub in ~5 minutes](https://ozzie.sh/start-verifying-your-commits-on-github-in-5-minutes)
- [List of all Git Commands](https://blog.vimalverma.in/list-of-all-git-commands)
- [Git all-in-one cheat sheet: A collection of the most useful git commands](https://blog.learncodeonline.in/git-all-in-one-cheat-sheet-a-collection-of-the-most-useful-git-commands)
- [GitHub - A complete guide](https://devhankering.hashnode.dev/github-a-complete-guide)
- [A Git Cheatsheet Of Commands Every Developer Should Use](https://ravimengar.hashnode.dev/a-git-cheatsheet-of-commands-every-developer-should-use)
- [An Intro to Git and GitHub for Beginners (Tutorial)](https://product.hubspot.com/blog/git-and-github-tutorial-for-beginners)
- [Git and GitHub SSH Configuration](https://chrisdevcode.hashnode.dev/git-and-github-ssh-configuration)
- [Getting Started with GitHub CLI](https://onyxcode.net/gh-cli-getting-started)
- [How to use Git and GitHub inside of VS Code Editor](https://blog.thefierycoder.tech/how-to-use-git-and-github-inside-of-vs-code-editor)
- [Two Git commands you probably missed in your daily routine](https://thelinuxli.ch/two-git-commands-you-probably-missed-in-your-daily-routine)
- [How to setup GitHub Actions on your Github repository](https://blog.bhanuteja.dev/30-git-commands-that-i-frequently-use)
- [The most basic and essential GIT commands walkthrough](https://bearcub3.hashnode.dev/the-most-basic-and-essential-git-commands-walkthrough-ckgmw77b3012po9s188vag2ig)
- [Don't overcomplicate git](https://h.daily-dev-tips.com/dont-overcomplicate-git)
- [Learn the Basics of Git in Under 10 Minutes](https://nand.blog/git101)
- [The Ultimate Guide to Git Commands](https://ankits.hashnode.dev/the-ultimate-guide-to-git-commands)
- [13 Git Commands Every Developer Should Know](https://svikashk.hashnode.dev/13-git-commands-every-developer-should-know-ckftd1wrm03wtv6s1bqmrgul6)
- [GIT INIT (Part-1)](https://apoorvtyagi.tech/git-init-part-1)
- [GIT INIT (Part-2)](https://apoorvtyagi.tech/git-init-part-2)
- [GitHub CLI 1.0: All you need to know](https://ayushirawat.com/github-cli-10-all-you-need-to-know)
- [Introduction to Git-Adding an SSH Key](https://laasyasettyblog.hashnode.dev/introduction-to-git-adding-an-ssh-key)
- [Understanding Git Terminologies : The Fun Way](https://hafsah.hashnode.dev/understanding-git-terminologies-the-fun-way-ckdet27bd003c42s13lsm5ry5)
- [Baby Steps to Git and Version Control - Series 1](https://amarachiazubuike.com/baby-steps-to-git-and-version-control-series-1-ck36ciz5200eib1s1l5rscbdr)
- [How to Fix Git Always Asking for User Credentials](https://blog.bolajiayodeji.com/how-to-fix-git-always-asking-for-user-credentials)
- [How to Fork a Repo on GitHub using your Mobile Device](https://sudoc.hashnode.dev/series/git-for-beginners)
- [Git First Time Setup](https://blog.bolajiayodeji.com/git-first-time-setup)
- [Git Cheat Sheet for Beginners and Intermediates](https://blog.bolajiayodeji.com/git-cheat-sheet-for-beginners-and-intermediates)
- [Basics of Git](https://adarsh-thakur.hashnode.dev/series/basics-of-git)


# Git/GitHub Courses/Videos
- [Git In-depth](https://frontendmasters.com/courses/git-in-depth/)
- [Introduction to Git and GitHub - Offered By Google](https://www.coursera.org/learn/introduction-git-github?specialization=google-it-automation&utm_source=gg&utm_medium=sem&utm_campaign=11-GoogleITwithPython-ROW&utm_content=11-GoogleITwithPython-ROW&campaignid=9733806670&adgroupid=119184274733&device=c&keyword=&matchtype=b&network=g&devicemodel=&adpostion=&creativeid=507191775308&hide_mobile_promo&gclid=CjwKCAjwxo6IBhBKEiwAXSYBs8cqMR-9WYlilq7CrcFTkE7wQT1K7qv1XDpTa5HtjEJckeoyiU6cpRoCyCgQAvD_BwE)
- [Version Control with Git](https://www.coursera.org/learn/version-control-with-git)
- [Git for Developers Using Github](https://www.coursera.org/projects/git-for-developers-using-github)
- [Manage Your Versions with Git (Part I)](https://www.coursera.org/projects/git-1)
- [Manage Your Versions with Git (Part II)](https://www.coursera.org/projects/git-2)
- [Learn Gitpro-logo- Codecademy](https://www.codecademy.com/learn/learn-git)
- [Version Control with Git](https://www.udacity.com/course/version-control-with-git--ud123)
- [Git: Become an Expert in Git & GitHub in 4 Hours](https://www.udemy.com/course/git-expert-4-hours/)
- [Git Essentials: Mini Course](https://www.udemy.com/course/git-essentials-mini-course/)
- [How Git Works- Plurasight](https://www.pluralsight.com/courses/how-git-works)
- [Introduction to GitHub- The GitHub Training Team](https://lab.github.com/githubtraining/introduction-to-github)
- [Git and GitHub for Beginners - Crash Course](https://www.youtube.com/watch?v=RGOj5yH7evk&t=934s)
- [How to use GitHub | What is GitHub | Git and GitHub Tutorial | Edureka](https://www.youtube.com/watch?v=PQsJR8ci3J0)
- [Git & GitHub Tutorial for Beginners](https://www.youtube.com/watch?v=3RjQznt-8kE&list=PL4cUxeGkcC9goXbgTDQ0n_4TBzOO0ocPR)
- [Github Tutorial For Beginners - Github Basics for Mac or Windows & Source Control Basics](https://www.youtube.com/watch?v=0fKg7e37bQE)
- [Git and GitHub Tutorial For Beginners | Full Course](https://www.youtube.com/watch?v=3fUbBnN_H2c)
- [Git Tutorial for Beginners: Learn Git in 1 Hour](https://www.youtube.com/watch?v=8JJ101D3knE)
- [Git Tutorial - Telusko](https://www.youtube.com/watch?v=OdbBmvfThJY&list=PLsyeobzWxl7q2eaUkorLZExfd7qko9sZC)
- [Git & GitHub Crash Course For Beginners - Traversy Media](https://www.youtube.com/watch?v=SWYqp7iY_Tc)
- [Git Tutorial for Beginners - Git & GitHub Fundamentals In Depth](https://www.youtube.com/watch?v=DVRQoVRzMIY)
- [Git And GitHub in ~30 Minutes](https://www.youtube.com/watch?v=jG4Vs81kMlc)
- [Git Tutorial | Github Tutorial | Git Tutorial for Beginners | Intellipaat](https://www.youtube.com/watch?v=dnGeRjP8oxw)
- [GitHub Basics Tutorial - How to Use GitHub](https://www.youtube.com/watch?v=x0EYpi38Yp4)
- [Git Tutorial for Beginners: Command-Line Fundamentals](https://www.youtube.com/watch?v=HVsySz-h9r4)
- [Git and GitHub Crash Course By Google Coursera](https://www.youtube.com/watch?v=PtBr0fpKyFg)
- [Git And GitHub Full Course In 3 Hours | Git And GitHub Tutorial For Beginners ](https://www.youtube.com/watch?v=liwv7Hi68aI)
- [Git Tutorial For Dummies](https://www.youtube.com/watch?v=mJ-qvsxPHpY)
- [Git Tutorial for Beginners - The Basics](https://www.youtube.com/watch?v=ly4niPr9vUo)
- [Git Tutorial for Beginners](https://www.youtube.com/watch?v=XF99kTmS2gg)
- [Git & Github Tutorial for Absolute Beginners](https://www.youtube.com/watch?v=iCKAWxfVWUY)
- [Git Tutorial For Beginners - Kudvenkat](https://www.youtube.com/watch?v=WEmvT2YFlQw&list=PL6n9fhu94yhVwbuqXKuPzchWNjZ8GVcJa)
- [Git and GitHub Beginner Tutorials](https://www.youtube.com/watch?v=-U-eUHI6euM&list=PLhW3qG5bs-L8OlICbNX9u4MZ3rAt5c5GG)
- [Git and GitHub Tutorials](https://www.youtube.com/watch?v=r50BKIFGCI0&list=PLB5jA40tNf3v1wdyYfxQXgdjPgQvP7Xzg)
- [Git & GitHub Tutorials](https://www.youtube.com/watch?v=_bkT85B6n1U&list=PLzS3AYzXBoj8mX3WbzQDghYytnx2JqBrU)

# Git/GitHub Repositories

- [GitHub Actions Starter Pack](https://github.com/jasonbarry/github-actions-starter-pack) - Sample code project for automating various tasks via GitHub Actions.