![Banner about AI](./images/banner.jpg)

Guide and framework for creating ChatGPT Prompts

This repo was developed by [@christerjohansson](https://github.com/christerjohansson)
Follow or connect with me on [my LinkedIn](https://www.linkedin.com/in/christerjohansson/)

# Prompt engineering for developers

Jupyter code notebooks for Prompt engineering for developers

In prompt engineering for developers, you will learn how to use a large language model (LLM) to quickly build new and powerful applications.  Using the OpenAI API, you’ll be able to quickly build capabilities that learn to innovate and create value in ways that were cost-prohibitive, highly technical, or simply impossible before now.

This short course will describe how LLMs work, provide best practices for prompt engineering, and show how LLM APIs can be used in applications for a variety of tasks, including:

- Summarizing (e.g., summarizing user reviews for brevity)
- Inferring (e.g., sentiment classification, topic extraction)
- Transforming text (e.g., translation, spelling & grammar correction)
- Expanding (e.g., automatically writing emails)

In addition, you’ll learn two key principles for writing effective prompts, how to systematically engineer good prompts, and also learn to build a custom chatbot.

All concepts are illustrated with numerous examples, which you can play with directly in our Jupyter notebook environment to get hands-on experience with prompt engineering.

## Prompt Engineering: Explained

Prompt engineering refers to the practice of designing and implementing effective prompts for natural language generation models, such as ChatGPT-3 and ChatGPT-4. The goal of prompt engineering is to generate high-quality and coherent text that is relevant to a specific task or application.

Prompt engineering has a wide range of use cases, including but not limited to:

- Content generation: ChatGPT can be used to generate high-quality content, such as articles, blog posts, and product descriptions, which can save time and resources for businesses and organizations.
- Language understanding: ChatGPT can be used to generate natural language responses for chatbots, virtual assistants, and other language-based applications.
- Creative writing: ChatGPT can be used to generate short stories, poems, and other forms of creative writing, which can help writers tap into their imagination and generate new ideas.
- Business and finance: ChatGPT can be used for tasks such as summarizing financial reports, creating financial forecasts, and writing business proposals.

However, there are also some limitations to prompt engineering:

- Quality of generated text: While ChatGPT can generate high-quality text, the quality of the text generated by the model depends on the quality of the prompts. It's important to design effective prompts that can generate high-quality text.
- Relevance of generated text: The text generated by ChatGPT is based on the input provided by the prompt. If the prompt is not well-designed, the generated text may not be relevant to the task or application.
- Biases: ChatGPT has been trained on a large dataset of text from the internet, which may include biases. It's important to be aware of these biases and take steps to mitigate them when designing prompts.
- Size and cost: ChatGPT is a large model and requires significant computational resources, which can be costly. It's important to consider the cost and resources required when designing and implementing prompts.

Overall, prompt engineering is a powerful tool that can help organizations and individuals generate high-quality text quickly and efficiently. However, it's important to be aware of the limitations and best practices for designing and implementing effective prompts.

### Learn Prompt Engineering: What to Study

To learn about prompt engineering in ChatGPT, there are several key areas you may want to study. Here is a list of topics and resources that you can use to deepen your understanding of this field:

1. Understanding the basics of ChatGPT-3: Before diving into prompt engineering, it's important to understand the basics of ChatGPT-3 and how it works. You can start by reading the OpenAI documentation on ChatGPT-3, which provides an overview of the model's capabilities and limitations.

2. Designing effective prompts: One of the key aspects of prompt engineering is designing effective prompts that can generate high-quality text. There are several best practices and techniques you can use to design effective prompts. You can refer to the OpenAI's GPT-3 Playground for examples of prompts used to generate different types of text.

3. Understanding the use-cases: To be able to better understand the potential of GPT-3 and prompt engineering, you need to explore different use-cases that it can be applied to. The OpenAI website has a list of use cases that you can explore.

4. Evaluating the quality of generated text: To ensure that the prompts you design are generating high-quality text, you need to learn how to evaluate the quality of the generated text. You can refer to the OpenAI's GPT-3 Playground to see examples of evaluations of generated text.

5. Advanced topics: Once you have a good understanding of the basics, you can explore advanced topics such as fine-tuning the model, working with structured data, and using GPT-3 in specific applications or contexts. The OpenAI website has a list of articles that cover these advanced topics.

Here are some resources that you can use to study each of these topics in more depth:

- OpenAI documentation on ChatGPT-3: [https://beta.openai.com/docs/models/gpt-3](https://beta.openai.com/docs/models/gpt-3)
- OpenAI's GPT-3 Playground: [https://beta.openai.com/playground/gpt-3](https://beta.openai.com/playground/gpt-3)
- OpenAI's GPT-3 use cases: [https://openai.com/use-cases/gpt-3-use-cases/](https://openai.com/use-cases/gpt-3-use-cases/)
- OpenAI's GPT-3 fine-tuning: [https://beta.openai.com/docs/models/gpt-3/fine-tuning](https://beta.openai.com/docs/models/gpt-3/fine-tuning)
- OpenAI's GPT-3 with structured data: [https://beta.openai.com/docs/models/gpt-3/guides/structured-data](https://beta.openai.com/docs/models/gpt-3/guides/structured-data)
- OpenAI's GPT-3 in specific applications or contexts: [https://beta.openai.com/docs/models/gpt-3/guides](https://beta.openai.com/docs/models/gpt-3/guides)

### Tools to Improve Prompts

There are several tools that can help improve your chatgpt prompts:

1. Pre-training: You can use pre-training techniques to fine-tune your model on a specific task or domain, such as project management or software development.

2. Data augmentation: You can use techniques such as back-translation and synonym replacement to generate additional data to train your model.

3. Prompt optimization: Tools like Hugging Face's prompt-toolkit can help you optimize your prompts by suggesting modifications and providing metrics such as perplexity and coherence scores.

4. Auto-completion: Tools like OpenAI's GPT-3 Playground and Hugging Face's Write With Transformer can provide real-time auto-completion suggestions for your prompts.

5. Evaluating and Monitoring: Tools like Hugging Face's Model Hub allows you to evaluate and monitor the performance of your prompts over time, and make adjustments as necessary.

6. Human in the loop: Leveraging human feedback to improve the performance of your chatgpt prompts.

7. Templates: Creating a set of templates or examples that you can easily use and adapt to your specific use case.

8. Collaboration tools: Leveraging tools like Google Docs and GitHub to collaborate with others on your prompts, share knowledge, and get feedback.
