/*
 * Decompiled with CFR 0.152.
 */
package com.nhncorp.lucy.security.xss.markup.rule;

import com.nhncorp.lucy.security.xss.markup.rule.CharArraySegment;
import com.nhncorp.lucy.security.xss.markup.rule.CharCode;
import com.nhncorp.lucy.security.xss.markup.rule.Terminal;
import com.nhncorp.lucy.security.xss.markup.rule.Token;
import java.util.BitSet;

class CharCodeSet
extends Terminal {
    private BitSet bits = new BitSet(65535);

    public CharCodeSet() {
    }

    public CharCodeSet(char ... codes) {
        this();
        for (char code : codes) {
            this.bits.set(code);
        }
    }

    public CharCodeSet(CharArraySegment pattern) {
        this();
        this.setPattern(pattern);
    }

    public void setRange(int frcode, int tocode) {
        this.bits.set(frcode, tocode + 1);
    }

    public void set(int code) {
        this.bits.set(code);
    }

    public void flip(int code) {
        this.bits.flip(code);
    }

    public void setAll(CharCodeSet other) {
        if (other != null) {
            this.bits.or(other.bits);
        }
    }

    public void flipAll(CharCodeSet other) {
        if (other != null) {
            other.bits.flip(1, 65535);
            this.bits.and(other.bits);
        }
    }

    public void flipAll() {
        this.bits.flip(1, 65535);
    }

    private void setPattern(CharArraySegment pattern) {
        boolean reverse = false;
        boolean range = false;
        int tmp = -1;
        while (pattern != null && pattern.hasRemaining()) {
            char curr = pattern.getChar();
            if (tmp < 0 && curr == '^') {
                reverse = true;
                pattern.move();
                continue;
            }
            if (tmp >= 0 && curr == '-') {
                range = true;
                pattern.move();
                continue;
            }
            if (pattern.startWith("#x")) {
                char ch;
                int start;
                int end = start = pattern.move(2).pos();
                while (pattern.hasRemaining() && CharArraySegment.isHexChar(ch = pattern.getChar())) {
                    end = pattern.move().pos();
                }
                curr = CharCode.parse(pattern.subSegment(start, end).toString());
            } else {
                pattern.move(1);
            }
            if (range) {
                this.setRange(tmp, curr);
                range = false;
                continue;
            }
            this.set(curr);
            tmp = curr;
        }
        if (reverse) {
            this.flipAll();
        }
    }

    public boolean matches(char code) {
        return this.bits.get(code);
    }

    private boolean matches(CharArraySegment input) {
        char code = input.getChar();
        if (input.length() > input.pos() + 1) {
            char next = input.charAt(input.pos() + 1);
            if (code == '<' && (next == '\'' || next == '\"' || next == '<' || next == ' ' || next == '\t' || next == '\r' || next == '\n')) {
                return true;
            }
        }
        return this.matches(code);
    }

    public boolean sliceToken(Token parent, CharArraySegment input) {
        boolean isTokenized = false;
        int start = -1;
        int end = -1;
        while (input != null && input.hasRemaining() && (this.matches(input.getChar()) || "attValue".equals(parent.getName()) && this.matches(input))) {
            if (start < 0) {
                start = input.pos();
                end = input.move().pos();
            } else {
                end = input.move().pos();
            }
            if (this.isRepeat()) continue;
        }
        if (start >= 0 && end >= start) {
            parent.appendValue(input.subSegment(start, end));
            isTokenized = true;
        }
        return isTokenized;
    }

    public int matchPos(CharArraySegment input) {
        int pos = -1;
        for (int i = input.pos(); i < input.length(); ++i) {
            if (!this.matches(input.charAt(i))) continue;
            pos = i;
            break;
        }
        return pos;
    }
}

