/*
 * Decompiled with CFR 0.152.
 */
package com.nhncorp.lucy.security.xss.config;

import com.nhncorp.lucy.security.xss.event.AttributeListener;
import com.nhncorp.lucy.security.xss.markup.Attribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeRule {
    private String name;
    private boolean disabled;
    private List<Pattern> patterns;
    private List<Pattern> npatterns;
    private List<String> exceptionTagList = new ArrayList<String>();
    private boolean base64Decoding;
    private List<AttributeListener> listeners;

    AttributeRule(String name) {
        this.name = name;
    }

    AttributeRule(String name, boolean disabled) {
        this.name = name;
        this.disabled = disabled;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isBase64Decoding() {
        return this.base64Decoding;
    }

    public List<Pattern> getAllowedPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    public List<Pattern> getNotAllowedPatterns() {
        return Collections.unmodifiableList(this.npatterns);
    }

    public void checkDisabled(Attribute att) {
        if (this.disabled) {
            att.setEnabled(false);
        }
    }

    private String decodeWithBase64(String originalValue) {
        String[] value = originalValue.split(",");
        if (value[0].endsWith("base64")) {
            byte[] decodedValue = Base64.decodeBase64((String)value[1]);
            return new String(decodedValue);
        }
        return originalValue;
    }

    public void checkAttributeValue(Attribute att) {
        String value;
        boolean result;
        if (att != null && !att.isMinimized() && (result = this.checkAttributeValueCore(att, value = att.getValue())) && this.isBase64Decoding()) {
            value = this.decodeWithBase64(value);
            this.checkAttributeValueCore(att, value);
        }
    }

    private boolean checkAttributeValueCore(Attribute att, String value) {
        boolean result;
        block5: {
            boolean isNPatternsExist;
            block7: {
                boolean isPatternsExist;
                block6: {
                    result = true;
                    isPatternsExist = this.patterns != null && !this.patterns.isEmpty();
                    boolean bl = isNPatternsExist = this.npatterns != null && !this.npatterns.isEmpty();
                    if (!isPatternsExist || !isNPatternsExist) break block6;
                    for (Pattern pattern : this.npatterns) {
                        if (!pattern.matcher(value).find()) continue;
                        att.setEnabled(false);
                        result = false;
                        break;
                    }
                    for (Pattern pattern : this.patterns) {
                        if (!pattern.matcher(value).matches()) continue;
                        att.setEnabled(true);
                        result = true;
                        break block5;
                    }
                    break block5;
                }
                if (!isPatternsExist) break block7;
                boolean matched = false;
                for (Pattern pattern : this.patterns) {
                    if (!pattern.matcher(value).matches()) continue;
                    matched = true;
                    break;
                }
                if (matched) break block5;
                att.setEnabled(false);
                result = false;
                break block5;
            }
            if (isNPatternsExist) {
                for (Pattern pattern : this.npatterns) {
                    if (!pattern.matcher(value).find()) continue;
                    att.setEnabled(false);
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    void setBase64Decoding(boolean base64Decoding) {
        this.base64Decoding = base64Decoding;
    }

    void addAllowedPattern(String regex) {
        if (regex != null) {
            if (this.patterns == null) {
                this.patterns = new ArrayList<Pattern>();
            }
            this.patterns.add(Pattern.compile(regex));
        }
    }

    void addAllowedPatters(Collection<String> regexes) {
        if (regexes != null && !regexes.isEmpty()) {
            for (String regex : regexes) {
                this.addAllowedPattern(regex);
            }
        }
    }

    void addNotAllowedPattern(String regex) {
        if (regex != null) {
            if (this.npatterns == null) {
                this.npatterns = new ArrayList<Pattern>();
            }
            this.npatterns.add(Pattern.compile(regex));
        }
    }

    void addNotAllowedPatterns(Collection<String> regexes) {
        if (regexes != null && !regexes.isEmpty()) {
            for (String regex : regexes) {
                this.addNotAllowedPattern(regex);
            }
        }
    }

    public void executeListener(Attribute att) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (AttributeListener listener : this.listeners) {
                listener.handleAttribute(att);
            }
        }
    }

    void addListener(AttributeListener listener) {
        if (listener != null) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<AttributeListener>();
            }
            this.listeners.add(listener);
        }
    }

    public List<AttributeListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void addExceptionTag(String exceptionTag) {
        this.exceptionTagList.add(exceptionTag.toLowerCase());
    }

    public List<String> getExceptionTagList() {
        return this.exceptionTagList;
    }
}

