lat = 28
lon = 15
sinlat = sin lat
coslat = cos lat
numfmt 4 0
global a[] d[] m[] n$[] .
#
subr turn
   xd = -1
   yh = sin wx * x + cos wx * y
   if yh > -sinwa and yh < sinwa
      x = cos wx * x - sin wx * y
      xh = x * cos -wy + z * sin -wy
      if xh < 0
         z = -x * sin -wy + z * cos -wy
         if z > -sinwa and z < sinwa
            xd = (yh + sinwa) * 50 / sinwa
            yd = (z + sinwa) * 50 / sinwa
         .
      .
   .
.
subr turns
   xd = -9999
   yh = sin wx * x + cos wx * y
   if yh > -sinwa - 0.125 and yh < sinwa + 0.125
      x = cos wx * x - sin wx * y
      xh = x * cos -wy + z * sin -wy
      if xh < 0
         z = -x * sin -wy + z * cos -wy
         if z > -sinwa - 0.125 and z < sinwa + 0.125
            xd = (yh + sinwa) * 50 / sinwa
            yd = (z + sinwa) * 50 / sinwa
         .
      .
   .
.
global jd skycol st n_names disp .
#
proc xyz a0 d0 . .
   z = sinlat * sin d0 + coslat * cos d0 * cos a0
   if z > 0
      x = -coslat * sin d0 + sinlat * cos d0 * cos a0
      y = -cos d0 * sin a0
   .
.
n_stars = 300
#
proc draw_stars . .
   color 999
   for i = 1 to n_stars
      xyz st - a[i] d[i]
      if z > 0
         turn
         if xd > -1
            move xd yd
            circle m[i]
            if i <= n_names
               move xd + 0.2 yd - 2
               color 888
               text n$[i]
               color 999
            .
         .
      .
   .
.
global const[][] const$[] .
#
linewidth 0.125
#
proc draw_consts . .
   textsize 3
   color 987
   for i = 1 to len const[][]
      cnt = 0
      scnd = 0
      n = len const[i][]
      for j = 1 to n
         if const[i][j] > n_stars
            n = 0
            break 1
         .
      .
      for j = 1 to n
         ind = const[i][j]
         xyz st - a[ind] d[ind]
         if z < 0
            scnd = 0
         else
            turns
            cnt += 1
            if xd > -9999
               if scnd = 0
                  move xd yd
                  scnd = 1
               else
                  line xd yd
               .
               if cnt = len const[i][] div 2
                  move xd + 2 yd + 2
                  text const$[i]
                  move xd yd
               .
            .
         .
      .
   .
.
pla$[] = [ "Sun" "Mercury" "Venus" "Mars" "Jupiter" "Saturn" "Moon" ]
plac[] = [ 996 882 993 975 993 993 ]
plm[] = [ 3 0.5 0.75 0.6125 0.6125 0.375 2 ]
len pla[] len plm[]
len pld[] len plm[]
#
proc draw_moon . .
   ph = (jd - 2459316.5208) mod 29.530588853
   color 995
   move xd yd
   circle 2
   if ph < 1.84 or ph > 27.7
      color 555
      circle 2
   elif ph < 5.5
      move xd - 2.2 yd
      color skycol
      circle 3
   elif ph < 9.2
      color skycol
      circseg 2 90 270
   elif ph < 12.9
      color skycol
      circseg 2 100 260
      color 995
      move xd + 1.2 yd
      circseg 2.5 125 235
   elif ph < 16.6
      #
   elif ph < 20.3
      color skycol
      circseg 2 -80 80
      color 995
      move xd - 1.2 yd
      circseg 2.5 -55 55
   elif ph < 24
      color skycol
      circseg 2 270 90
   else
      move xd + 2.2 yd
      color skycol
      circle 3
   .
.
proc draw_planets . .
   for i = 1 to len pla[]
      xyz st - pla[i] pld[i]
      if z > 0
         turn
         if xd > -1
            move xd yd
            if i = 7
               draw_moon
            else
               color plac[i]
               circle plm[i]
            .
            if n_names > 0
               color 888
               text pla$[i]
            .
         .
      .
   .
.
el[][] &= [ 1.00000261 0.00000562 0.01671123 -0.00004392 -0.00001531 -0.01294668 100.46457166 35999.37244981 102.93768193 0.32327364 0 0 ]
el[][] &= [ 0.38709927 0.00000037 0.20563593 0.00001906 7.00497902 -0.00594749 252.25032350 149472.67411175 77.45779628 0.16047689 48.33076593 -0.12534081 ]
el[][] &= [ 0.72333566 0.00000390 0.00677672 -0.00004107 3.39467605 -0.00078890 181.97909950 58517.81538729 131.60246718 0.0026832 76.67984255 -0.27769418 ]
el[][] &= [ 1.52371034 0.00001847 0.09339410 0.00007882 1.84969142 -0.00813131 -4.55343205 19140.30268499 -23.94362959 0.44441088 49.55953891 -0.29257343 ]
el[][] &= [ 5.20288700 -0.00011607 0.04838624 -0.00013253 1.30439695 -0.00183714 34.39644051 3034.74612775 14.72847983 0.21252668 100.47390909 0.20469106 ]
el[][] &= [ 9.53667594 -0.00125060 0.05386179 -0.00050991 2.48599187 0.00193609 49.95424423 1222.49362201 92.59887831 -0.41897216 113.66242448 -0.28867794 ]
m1[] = [ 6.29 134.9 477198.85 (-1.27) 259.2 (-413335.38) 0.66 235.7 890534.23 0.21 269.9 954397.70 (-0.19) 357.5 35999.05 (-0.11) 186.6 966404.05 ]
m2[] = [ 5.13 93.3 483202.03 0.28 228.2 960400.87 (-0.28) 318.3 6003.18 (-0.17) 217.6 (-407332.20) ]
#
proc calc_planets . .
   T = (jd - 2451545) / 36525
   for pli = 1 to len el[][]
      swap el[] el[pli][]
      a = el[1] + el[2] * T
      e = el[3] + el[4] * T
      I = el[5] + el[6] * T
      L = el[7] + el[8] * T
      wi = el[9] + el[10] * T
      O = el[11] + el[12] * T
      swap el[] el[pli][]
      #
      w = wi - O
      M = (L - wi) mod 360
      h = 57.29578 * e
      E = M + h * sin M
      repeat
         dM = M - (E - h * sin E)
         dE = dM / (1 - e * cos E)
         E += dE
         until dE < 0.001
      .
      xi = a * (cos E - e)
      yi = a * sqrt (1 - e * e) * sin E
      cw = cos w
      sw = sin w
      co = cos O
      so = sin O
      si = sin I
      ci = cos I
      x = (cw * co - sw * so * ci) * xi + (-sw * co - cw * so * ci) * yi
      ye = (cw * so + sw * co * ci) * xi + (-sw * so + cw * co * ci) * yi
      ze = sw * si * xi + cw * si * yi
      ee = 23.43928
      y = cos ee * ye - sin ee * ze
      z = sin ee * ye + cos ee * ze
      #
      if pli = 1
         eax = x
         eay = y
         eaz = z
         x = 0
         y = 0
         z = 0
      .
      dx = eax - x
      dy = eay - y
      dz = eaz - z
      dist = sqrt (dx * dx + dy * dy + dz * dz)
      pld[pli] = asin ((z - eaz) / dist)
      pla[pli] = atan2 (y - eay) (x - eax)
      if pli = 1
         a0 = st - pla[pli]
         d0 = pld[pli]
         z = sinlat * sin d0 + coslat * cos d0 * cos a0
         skycol = 000
         if z > 0
            skycol = 004
         .
      .
   .
   # moon
   lam = 218.32 + 481267.883 * T
   for i = 1 step 3 to 18
      lam += m1[i] * sin (m1[i + 1] + m1[i + 2] * T)
   .
   beta = 0
   for i = 1 step 3 to 12
      beta += m2[i] * sin (m2[i + 1] + m2[i + 2] * T)
   .
   l = cos beta * cos lam
   m = 0.9175 * cos beta * sin lam - 0.3978 * sin beta
   n = 0.3978 * cos beta * sin lam + 0.9175 * sin beta
   pla[pli] = atan2 m l
   pld[pli] = asin n
.
dir$[] = [ "N" "E" "S" "W" ]
xdir[] = [ -1 0 1 0 ]
ydir[] = [ 0 1 0 -1 ]
global time$ .
#
proc draw_info . .
   color 666
   textsize 2.5
   move 71 1
   text time$
   move 1 1
   text lat & " " & lon
   for i = 1 to 4
      x = xdir[i]
      y = ydir[i]
      z = 0.001
      turn
      if xd > -1
         move xd yd + 0.5
         text dir$[i]
      .
   .
.
subr draw_sky
   clear
   textsize 2.2
   draw_stars
   draw_planets
   draw_info
   if disp = 2
      draw_consts
   .
.
subr update
   time$ = substr timestr sec 1 16
   jd = sec / 86400.0 + 2440587.5
   st = 280.46061837 + 360.98564736629 * (jd - 2451545.0)
   st = (st + lon) mod 360
   calc_planets
   background skycol
   draw_sky
.
on timer
   sec = systime
   if time$ <> substr timestr sec 1 16
      update
   .
   timer 1
.
on mouse_move
   if mdown = 1
      wx += mx - mouse_x
      wy += my - mouse_y
      if wy > 90
         wy = 90
      elif wy < 35
         wy = 35
      .
      draw_sky
      mx = mouse_x
      my = mouse_y
   .
.
on mouse_down
   mdown = 1
   mx = mouse_x
   my = mouse_y
.
on mouse_up
   mdown = 0
.
on key
   k$ = keybkey
   if k$ = "ArrowLeft"
      wx -= 1
      draw_sky
      timer 10
   elif k$ = "ArrowRight"
      wx += 1
      draw_sky
      timer 10
   elif k$ = "ArrowUp"
      if wy < 90
         wy += 1
         draw_sky
      .
      timer 10
   elif k$ = "ArrowDown"
      if wy > 35
         wy -= 1
         draw_sky
      .
      timer 10
   elif k$ = "m"
      sec += 60
      update
      timer 60
   elif k$ = "h"
      sec += 3600
      update
      timer 60
   elif k$ = "d"
      sec += 86400
      update
      timer 60
   elif k$ = "n"
      disp = (disp + 1) mod 3
      if disp > 0
         n_names = len n$[]
      else
         n_names = 0
      .
      draw_sky
   elif k$ = "v"
      if n_stars = 1000
         n_stars = len a[]
      elif n_stars = 300
         n_stars = 600
      elif n_stars = 600
         n_stars = 1000
      else
         n_stars = 300
      .
      draw_sky
   elif k$ = " "
      timer 0
   elif k$ = "z"
      dbg = 1 - dbg
      draw_sky
   elif k$ = "s"
      timer -1
   else
      if substr k$ 1 2 = "p:"
         time$ = ""
         s$[] = strsplit substr k$ 3 99 " "
         lat = number s$[1]
         lon = number s$[2]
         sinlat = sin lat
         coslat = cos lat
         timer 0
      .
   .
.
wy = 35
wx = 0
wa = 35
sinwa = sin wa
timer 0
#
repeat
   s$ = input
   until s$ = ""
   const$[] &= s$
   s$ = input
   a$[] = strsplit s$ " "
   len s[] len a$[]
   for i = 1 to len a$[]
      s[i] = number a$[i]
   .
   const[][] &= s[]
.
repeat
   s$ = input
   until s$ = "-"
   n$[] &= s$
.
repeat
   s$ = input
   until s$ = ""
   a$[] = strsplit s$ " "
   a[] &= number a$[1]
   d[] &= number a$[2]
   m[] &= number a$[3] / 100
.
#
input_data
Aries
49 104 457
Taurus
27 297 391 340 257 14 166
Gemini
43 287 17 23 186 148 234
Cancer
535 1079 489 683 489 298
Leo
50 278 21 243 62 97 50 269 167
Virgo
15 793 252 793 121 255 144 255 121 464 320 542
Libra
473 102 124 223
Scorpius
25 170 40 239 336 175 77 135 16 157 88 157 76 157 155
Big Dipper
38 69 33 238 36 80 85 238
Cassiopeia
245 108 63 71 74
Orion
31 56 7 73 31 10 26 73
Auriga
111 27 106 41 6 181 111
Bootes
109 4 81 275 283 183 4
Cepheus
288 256 90 218 288 214 218
Great Dog
178 22 37 89 37 179 1 47
Cygnus
213 92 70 20 70 147 70 184
Aquila
12 249 171 12 220 249 270
Perseus
140 156 177 34 159 34 60 237
Little Dipper
46 772 635 709 57 174 1523 709
Piscis Austrinus
624 18 632 872 712 918 775 624
Lyria
5 760 646 224 294 760

Sirius
Canopus
Rigil Kent
Arcturus
Vega
Capella
Rigel
Procyon
Achernar
Betelgeuse

Altair
Acrux
Aldebaran
Spica
Antares
Pollux
Fomalhaut

Deneb
Regulus
Adhara
Castor
Gacrux
Shaula
Bellatrix
Alnath
Miaplacidus
Alnilam
Alnair
Alnitak

Alioth
Mirphak
Kaus Australis
Dubhe

Alkaid
Avior

Menkalinan
Atria
Alhena

Peacock
Polaris
Mirzam
Alphard
-
101.3 -16.7 79
96.0 -52.7 71
219.9 -60.8 68
213.9 19.2 66
279.2 38.8 65
79.2 46.0 64
78.6 -8.2 63
114.8 5.2 61
24.4 -57.2 61
88.8 7.4 61
211.0 -60.4 59
297.7 8.9 57
186.6 -63.1 57
69.0 16.5 56
201.3 -11.2 55
247.4 -26.4 54
116.3 28.0 53
344.4 -29.6 53
191.9 -59.7 53
310.4 45.3 53
152.1 12.0 51
104.7 -29.0 50
113.6 31.9 49
187.8 -57.1 49
263.4 -37.1 49
81.3 6.3 49
81.6 28.6 49
138.3 -69.7 48
84.1 -1.2 48
332.1 -47.0 48
85.2 -1.9 48
122.4 -47.3 48
193.5 56.0 47
51.1 49.9 47
276.0 -34.4 47
165.9 61.8 47
107.1 -26.4 47
206.9 49.3 47
125.6 -59.5 46
264.3 -43.0 46
89.9 44.9 46
252.2 -69.0 46
99.4 16.4 46
131.2 -54.7 46
306.4 -56.7 46
38.0 89.3 45
95.7 -18.0 45
141.9 -8.7 45
31.8 23.5 45
155.0 19.8 45
10.9 -18.0 45
283.8 -26.3 45
211.7 -36.4 44
2.1 29.1 44
17.4 35.6 44
86.9 -9.7 44
222.7 74.2 44
340.7 -46.9 44
263.7 12.6 44
47.0 41.0 44
31.0 42.3 44
177.3 14.6 44
14.2 60.7 44
190.4 -49.0 43
120.9 -40.0 43
139.3 -59.3 43
233.7 26.7 43
137.0 -43.4 43
201.0 54.9 43
305.6 40.3 43
10.1 56.5 43
269.2 51.5 43
83.0 -0.3 43
2.3 59.1 42
205.0 -53.5 42
240.1 -22.6 42
252.5 -34.3 42
220.5 -47.4 42
218.9 -42.2 42
165.5 56.4 42
221.2 27.1 42
326.0 9.9 41
265.6 -39.0 41
6.6 -42.3 41
178.5 53.7 41
257.6 -15.7 41
345.9 28.1 41
241.4 -19.8 41
111.0 -29.3 41
319.6 62.6 41
140.5 -55.0 40
311.6 34.0 40
346.2 15.2 40
45.6 4.1 40
249.3 -10.6 40
208.9 -47.3 40
168.5 20.5 39
83.2 -17.8 39
182.1 -50.7 39
184.0 -17.5 39
285.7 -29.9 39
229.3 -9.4 39
236.1 6.4 39
28.7 20.8 39
84.9 -34.1 39
89.9 37.2 39
188.6 -23.4 39
21.5 60.2 38
208.7 18.4 38
224.6 -43.1 38
74.2 33.2 38
161.7 -49.4 38
189.3 -69.1 38
262.7 -37.3 38
109.3 -37.1 38
275.2 -29.8 38
296.6 10.6 38
243.6 -3.7 38
246.0 61.5 38
160.7 -64.4 38
190.4 -1.4 38
83.9 -5.9 38
200.1 -36.7 38
222.7 -16.0 38
265.9 4.6 37
77.0 -5.1 37
247.6 21.5 37
258.7 14.4 37
183.8 -58.7 37
262.6 52.3 37
233.8 -41.2 37
82.1 -20.8 37
250.3 31.6 37
6.4 -77.3 37
249.0 -28.2 37
277.0 -25.4 37
3.3 15.2 37
121.9 -24.3 37
238.8 -63.4 37
58.5 31.9 37
261.3 -55.5 37
263.0 -49.9 37
56.9 24.1 37
195.5 11.0 37
326.8 -16.1 37
29.7 -61.6 36
296.2 45.1 36
95.7 22.5 36
229.7 -68.7 36
334.6 -60.3 36
44.6 -40.3 36
287.4 -21.0 36
111.8 8.3 36
194.0 38.3 36
239.7 -26.1 36
59.5 40.0 36
245.3 -25.6 36
322.9 -5.6 36
46.2 53.5 36
146.8 -65.1 36
340.8 30.2 36
102.5 -50.6 36
187.5 -16.5 36
331.4 -0.3 36
59.5 -13.5 35
84.4 21.1 35
146.5 23.8 35
271.5 -30.4 35
199.7 -23.2 35
266.9 -40.1 35
286.4 13.9 35
32.4 35.0 35
167.4 44.5 35
230.2 71.8 35
253.0 -38.0 35
328.5 -37.4 35
55.7 47.8 35
95.1 -30.1 35
105.8 -23.8 35
182.5 -22.6 35
75.5 43.8 35
191.6 -68.1 35
218.0 38.3 35
292.7 28.0 35
305.3 -14.8 35
101.0 25.1 34
155.6 41.5 34
288.1 67.7 34
274.4 -36.8 34
133.8 5.9 34
162.4 -16.2 34
173.9 -63.0 34
309.4 -47.3 34
87.7 -35.8 34
134.8 48.0 34
254.7 -56.0 34
258.8 24.8 34
224.8 -42.1 34
140.3 34.4 34
142.8 -57.0 33
258.8 36.8 33
99.4 -43.2 33
143.2 51.7 33
257.2 65.7 33
281.4 -27.0 33
76.6 41.2 33
220.6 -65.0 33
72.5 7.0 33
76.4 -22.4 33
254.4 9.4 33
267.5 -37.0 33
0 0 33
318.2 30.2 33
354.8 77.6 33
230.3 -40.6 33
244.6 -4.7 33
275.3 -2.9 33
322.2 70.6 33
102.0 -61.9 33
302.8 -0.8 33
112.3 -43.3 33
211.6 -26.7 33
226.0 -25.3 33
284.7 32.7 33
56.8 -74.2 32
9.8 30.9 32
260.5 -25.0 32
343.7 -15.8 32
78.2 -16.2 32
153.4 -70.0 32
231.2 59.0 32
68.5 -55.0 32
158.0 -61.7 32
93.7 22.5 32
261.3 -56.4 32
16.5 -46.7 32
46.3 38.8 32
183.9 57.0 32
258.0 -43.2 32
269.8 -9.8 32
286.7 -27.7 32
63.6 -62.5 32
168.6 15.4 32
117.3 -24.9 32
28.6 63.7 32
81.1 -2.4 32
101.3 12.9 32
127.6 60.7 32
291.4 3.1 31
230.7 -44.7 31
131.7 6.4 31
203.7 -0.6 31
83.8 9.9 31
154.3 -61.3 31
193.9 3.4 31
332.7 58.2 31
67.2 15.9 31
22.1 -43.3 31
60.2 12.5 31
207.4 -41.7 31
228.1 -52.1 31
311.3 61.8 31
340.4 10.8 31
28.3 29.6 31
240.0 -38.4 31
266.6 27.7 31
311.2 -66.2 31
137.7 -59.0 31
154.2 23.4 31
286.6 -4.9 31
154.3 42.9 31
12.3 57.8 30
17.1 -10.2 30
119.2 -53.0 30
228.9 33.3 30
40.8 3.2 30
207.4 -42.5 30
151.8 16.8 30
250.7 38.9 30
26.0 -15.9 30
105.4 -27.9 30
169.6 33.1 30
225.5 40.4 30
276.7 -46.0 30
342.1 -51.3 30
102.5 -32.5 30
110.0 22.0 30
342.4 66.2 30
299.7 19.5 30
342.5 24.6 30
55.8 -9.8 30
145.3 9.9 30
149.2 -54.6 30
282.5 33.4 30
284.4 -21.1 30
332.5 6.2 30
67.2 19.2 30
124.1 9.2 30
173.3 -31.9 30
237.4 -3.4 30
264.4 -15.4 30
64.5 -33.8 30
86.7 -14.8 30
214.9 -46.1 30
275.3 72.7 30
302.2 -66.2 30
4.9 -8.8 29
34.1 -51.5 29
169.8 -14.8 29
253.1 -38.0 29
116.1 24.4 29
135.9 47.2 29
218.0 30.4 29
230.5 -36.3 29
109.5 16.5 29
304.5 -12.5 29
24.5 48.6 29
79.4 -6.8 29
86.1 -22.4 29
177.7 1.8 29
185.3 -60.4 29
21.0 -8.2 29
103.2 34.0 29
130.1 -52.9 29
142.7 -40.5 29
234.3 -28.1 29
262.8 -60.7 29
42.5 27.3 29
51.2 9.0 29
152.6 -12.4 29
195.6 -71.5 29
266.4 -64.7 29
22.9 15.3 29
57.3 24.1 29
116.3 -38.0 29
253.6 -42.4 29
345.5 42.3 29
176.4 -66.7 29
309.4 14.6 29
64.9 15.6 29
142.9 63.1 29
236.5 15.4 29
271.7 -50.1 29
337.2 -0.0 29
232.0 29.1 28
234.7 -29.8 28
211.1 64.4 28
313.7 -58.5 28
72.8 5.6 28
130.9 -33.2 28
296.8 18.5 28
347.4 -21.2 28
7.9 -63.0 28
9.2 53.9 28
29.0 -51.6 28
75.6 41.1 28
146.3 -62.5 28
176.5 47.8 28
325.0 -16.7 28
49.9 -21.8 28
269.4 29.2 28
349.3 3.3 28
73.6 2.4 28
89.1 -14.2 28
118.1 -40.6 28
237.7 4.5 28
271.8 9.6 28
298.8 6.4 28
53.2 -9.5 28
56.2 24.1 28
89.9 54.3 28
316.2 43.9 28
51.8 9.7 28
221.6 1.9 28
268.4 56.9 28
325.4 -77.4 28
343.2 -7.6 28
27.9 -10.3 28
245.5 19.2 28
318.7 38.0 28
136.0 -47.1 28
267.0 2.7 28
83.4 -62.5 27
87.8 -20.9 27
97.2 -7.0 27
286.2 -21.7 27
292.4 51.7 27
337.8 50.3 27
42.7 55.9 27
56.3 42.6 27
65.7 17.5 27
84.7 -2.6 27
126.4 -66.1 27
130.2 -46.6 27
252.4 -59.0 27
309.9 15.9 27
321.7 -22.4 27
331.8 25.3 27
107.2 -70.5 27
111.4 27.8 27
147.7 59.0 27
163.4 -58.9 27
220.3 13.7 27
311.9 -9.5 27
47.4 44.9 27
163.3 34.2 27
48.0 -29.0 27
114.7 -26.8 27
233.7 10.5 27
289.3 53.4 27
303.4 46.7 27
68.9 -30.6 27
157.0 -58.7 27
235.7 26.3 27
354.4 46.5 27
30.5 2.8 27
139.7 36.8 27
172.9 69.3 27
247.7 2.0 27
264.9 46.0 27
156.5 -16.8 27
209.6 -42.1 27
222.0 -79.0 27
56.0 -64.8 27
56.1 32.3 27
67.1 16.0 27
133.8 -60.6 27
158.2 9.3 27
159.3 -48.2 27
188.1 -72.1 27
271.9 28.8 27
273.4 -21.1 27
297.0 70.3 27
63.5 -42.3 27
86.8 -51.1 27
95.5 -33.4 27
153.7 -42.1 27
188.4 69.8 27
189.4 -48.5 27
239.1 15.7 27
275.9 21.8 27
278.8 -8.2 27
14.2 38.5 26
69.5 -14.3 26
82.8 -35.5 26
243.9 -63.7 26
248.4 -78.9 26
269.1 37.3 26
335.4 -1.4 26
56.5 24.4 26
131.5 -46.0 26
209.7 -44.8 26
220.8 -5.7 26
239.2 -29.2 26
298.1 1.0 26
2.4 -45.7 26
28.4 19.3 26
148.2 26.0 26
228.0 -48.7 26
347.6 -45.2 26
44.1 -8.9 26
103.5 -24.2 26
138.6 2.3 26
185.0 -0.7 26
299.1 35.1 26
145.0 -1.1 26
170.3 -54.5 26
202.8 -39.4 26
60.8 6.0 26
126.4 -3.9 26
187.0 -50.2 26
226.3 -47.1 26
233.9 -14.8 26
244.9 46.3 26
255.1 30.9 26
290.4 -17.8 26
319.0 5.2 26
6.6 -43.7 26
22.8 -49.1 26
43.6 52.8 26
69.1 -3.4 26
115.5 -72.6 26
167.1 -59.0 26
241.7 -20.7 26
270.2 2.9 26
17.1 -55.2 26
115.3 -9.6 26
116.0 -29.0 26
131.2 18.2 26
314.3 41.2 26
30.9 72.4 26
99.2 -19.3 26
62.2 47.7 25
89.8 -42.8 25
135.2 41.8 25
137.8 -62.3 25
290.7 -44.5 25
291.0 -40.6 25
303.9 47.7 25
350.7 -20.1 25
66.0 -34.0 25
87.9 39.1 25
109.2 -68.0 25
130.0 -35.3 25
182.9 -52.4 25
237.7 -33.6 25
300.1 -72.9 25
337.3 -43.5 25
341.6 23.6 25
59.7 35.8 25
323.5 45.6 25
30.0 -21.1 25
93.7 -6.3 25
156.1 -74.0 25
201.3 55.0 25
349.4 -58.2 25
135.6 -66.4 25
171.0 10.5 25
243.0 -19.5 25
25.9 50.7 25
71.4 -3.3 25
106.0 20.6 25
108.7 -26.8 25
220.5 -37.8 25
240.5 58.6 25
245.0 -50.2 25
280.8 -71.4 25
307.3 30.4 25
132.6 -27.7 25
182.1 -24.7 25
284.9 15.1 25
285.4 -5.7 25
34.3 33.8 25
75.9 60.4 25
131.7 28.8 25
193.6 -57.2 25
271.4 2.5 25
308.3 11.3 25
359.8 6.9 25
284.1 4.2 25
63.0 -6.8 25
176.5 6.5 25
216.3 51.9 25
338.8 -0.1 25
47.3 49.6 25
124.6 -76.9 25
131.1 -42.6 25
170.3 6.0 25
207.4 15.8 25
215.1 -37.9 25
219.5 -49.4 25
342.4 -13.6 25
74.1 13.5 24
114.0 26.9 24
171.2 -17.7 24
184.4 -68.0 24
184.6 -64.0 24
220.9 -35.2 24
254.9 -53.2 24
214.0 -6.0 24
227.2 -45.3 24
229.4 -58.8 24
337.3 58.4 24
11.8 24.3 24
35.4 -68.7 24
39.9 0.3 24
45.6 -23.6 24
103.5 -12.0 24
143.6 -59.2 24
164.9 -18.3 24
283.8 43.9 24
316.5 -17.2 24
320.5 19.8 24
84.2 9.3 24
237.2 18.1 24
24.2 41.4 24
41.0 49.2 24
117.3 -46.4 24
277.2 -49.1 24
287.5 -39.3 24
40.2 -39.9 24
105.9 -15.6 24
129.4 -43.0 24
147.9 -14.8 24
158.9 -78.6 24
176.6 -61.2 24
234.2 -66.3 24
287.4 -37.9 24
345.2 -52.8 24
39.9 -68.3 24
63.7 48.4 24
90.6 9.6 24
181.3 8.7 24
298.8 -41.9 24
313.0 -26.9 24
337.4 -43.7 24
81.0 -7.8 24
97.2 20.2 24
238.5 -16.7 24
311.5 -25.3 24
341.5 -81.4 24
355.0 5.6 24
52.7 12.9 24
56.6 23.9 24
129.4 5.7 24
181.7 -64.6 24
233.2 31.4 24
239.4 26.9 24
326.2 25.6 24
334.0 37.7 24
108.0 -0.5 24
260.9 37.1 24
355.1 44.3 24
91.0 23.3 23
112.3 31.8 23
261.6 -24.2 23
8.2 62.9 23
57.4 -36.2 23
334.2 -7.8 23
213.2 -10.3 23
214.1 46.1 23
249.1 -35.3 23
333.8 57.0 23
340.2 -27.0 23
207.4 -34.5 23
281.4 20.5 23
82.7 5.9 23
119.2 -22.9 23
157.0 36.7 23
248.5 42.4 23
341.7 12.2 23
344.0 -32.5 23
52.3 59.9 23
66.3 22.3 23
251.5 82.0 23
307.4 63.0 23
321.6 -65.4 23
42.6 38.3 23
56.7 -23.2 23
118.3 -48.1 23
241.6 -36.8 23
246.8 -18.5 23
275.2 71.3 23
281.8 -4.7 23
283.1 -62.2 23
283.6 36.9 23
311.4 30.7 23
319.4 39.4 23
348.6 -6.0 23
5.0 -64.9 23
115.8 28.9 23
198.0 27.9 23
206.4 -33.0 23
210.4 1.5 23
242.2 44.9 23
250.8 -77.5 23
286.6 -37.1 23
325.9 58.8 23
326.7 49.3 23
17.2 86.3 23
36.7 -47.7 23
41.0 -13.9 23
184.6 -79.3 23
188.4 41.4 23
247.8 -34.7 23
265.4 -12.9 23
349.0 -9.1 23
18.9 -68.9 23
61.6 50.4 23
68.9 10.2 23
69.2 41.3 23
77.3 -8.8 23
125.7 43.2 23
193.4 -40.2 23
216.9 75.7 23
326.4 61.1 23
17.4 47.2 22
26.3 9.2 22
50.0 -43.1 22
53.4 -21.6 22
64.0 -51.5 22
73.5 66.3 22
134.6 11.9 22
264.1 -38.6 22
270.4 21.6 22
330.9 64.6 22
15.7 7.9 22
41.2 10.1 22
63.9 8.9 22
69.5 12.5 22
70.6 23.0 22
196.7 -49.9 22
229.6 -47.9 22
290.8 -44.8 22
311.7 16.1 22
352.0 6.4 22
66.6 22.8 22
144.3 81.3 22
156.8 -31.1 22
261.8 -29.9 22
303.3 56.6 22
320.6 -16.8 22
332.5 33.2 22
346.7 -43.5 22
54.2 0.4 22
79.9 -13.2 22
159.8 -55.6 22
178.2 -33.9 22
236.0 77.8 22
247.8 -16.6 22
331.6 -13.9 22
337.9 -32.3 22
354.5 43.3 22
14.7 -29.4 22
37.0 8.5 22
56.3 24.5 22
57.1 -37.6 22
66.4 17.9 22
90.0 45.9 22
130.8 3.4 22
163.9 24.7 22
174.2 -0.8 22
177.4 -63.8 22
188.0 -16.2 22
215.1 -56.4 22
304.4 -12.5 22
130.2 -59.8 22
216.7 -83.7 22
231.1 37.4 22
241.9 -20.9 22
309.6 -1.1 22
54.1 48.2 22
70.1 -19.7 22
83.1 18.6 22
93.8 29.5 22
131.6 -13.5 22
142.9 23.0 22
180.8 -63.3 22
197.5 17.5 22
208.0 -33.0 22
222.9 -43.6 22
260.2 -12.8 22
112.0 8.9 22
193.3 -48.9 22
216.5 -45.4 22
258.8 -26.6 22
272.1 -63.7 22
275.0 36.1 22
9.2 33.7 22
9.6 29.3 22
17.8 55.1 22
86.2 -65.7 22
98.0 -23.4 22
125.2 -77.5 22
139.1 -57.5 22
144.2 -49.4 22
210.4 -45.6 22
234.5 -42.6 22
261.6 4.1 22
281.2 37.6 22
281.8 18.2 22
326.1 17.4 22
337.4 47.7 22
47.9 19.7 22
72.7 8.9 22
98.7 -53.0 22
104.3 58.4 22
122.0 -68.6 22
132.1 5.8 22
186.7 28.3 22
229.5 -30.1 22
263.1 86.6 22
275.8 -61.5 22
289.1 38.1 22
326.2 -33.0 22
10.8 -57.5 21
33.2 8.8 21
52.6 48.0 21
61.2 22.1 21
73.2 -5.5 21
78.3 -12.9 21
89.4 -35.3 21
104.0 -17.1 21
122.1 -3.0 21
211.5 -41.2 21
294.2 -1.3 21
0.5 -6.0 21
94.1 -35.1 21
109.7 -25.0 21
165.0 -42.2 21
272.2 20.8 21
299.9 -35.3 21
197.5 -5.5 21
302.2 77.7 21
351.5 -20.6 21
353.2 -37.8 21
28.4 -46.3 21
57.4 65.5 21
83.7 9.5 21
88.6 20.3 21
95.9 4.6 21
120.6 2.3 21
152.0 10.0 21
225.7 2.1 21
253.5 10.2 21
260.3 -21.1 21
295.0 18.0 21
295.3 17.5 21
320.0 -53.4 21
14.3 23.4 21
117.0 -25.9 21
122.3 -19.2 21
284.2 -67.2 21
329.5 -55.0 21
102.5 -53.6 21
107.8 30.2 21
215.8 -39.5 21
262.7 26.1 21
269.6 30.2 21
319.5 34.9 21
347.0 75.4 21
349.5 -9.2 21
349.7 -32.5 21
91.9 14.8 21
99.5 -18.2 21
108.4 -44.6 21
108.6 -26.4 21
123.5 -40.3 21
165.6 20.2 21
222.6 -28.0 21
236.6 7.4 21
270.4 1.3 21
335.9 52.2 21
351.3 23.4 21
56.5 -12.1 21
63.8 -7.7 21
74.3 53.8 21
288.4 39.1 21
300.7 -27.7 21
306.0 32.2 21
310.9 15.1 21
311.9 -5.0 21
3.7 -18.9 21
12.2 7.6 21
64.1 -59.3 21
70.1 -41.9 21
94.9 59.0 21
113.5 -22.3 21
122.8 -39.6 21
124.6 -36.7 21
218.2 -50.5 21
292.2 24.7 21
25.4 5.5 21
42.3 -32.4 21
78.1 -11.9 21
93.0 14.2 21
129.7 3.3 21
135.0 -41.3 21
158.9 -57.6 21
161.4 -80.5 21
169.2 -3.7 21
248.0 -21.5 21
288.9 73.4 21
293.5 7.4 21
37.3 67.4 20
58.6 -3.0 20
78.3 2.9 20
137.2 51.6 20
167.9 -22.8 20
182.0 -50.7 20
246.8 -47.6 20
343.1 -32.9 20
41.3 -18.6 20
50.1 29.0 20
74.6 1.7 20
97.0 -32.6 20
98.2 7.3 20
119.6 -49.2 20
136.3 -72.6 20
141.2 26.2 20
143.7 52.1 20
177.8 -45.2 20
218.7 29.7 20
224.3 -4.3 20
318.6 10.0 20
331.5 -39.5 20
11.2 48.3 20
60.2 -62.2 20
66.6 15.6 20
102.0 2.4 20
152.0 -0.4 20
230.8 -59.3 20
246.0 -20.0 20
346.0 3.8 20
346.7 -23.7 20
30.5 70.9 20
68.4 -29.8 20
101.0 13.2 20
108.1 -46.8 20
118.2 -38.9 20
151.9 35.2 20
220.2 16.4 20
294.1 50.2 20
316.8 -25.0 20
326.0 28.7 20
355.5 1.8 20
355.7 -14.5 20
360.0 -65.6 20
84.8 4.1 20
87.5 -56.2 20
131.7 -56.8 20
155.2 -56.0 20
177.0 20.2 20
206.8 17.5 20
303.9 27.8 20
317.4 -11.4 20
322.2 -21.8 20
332.1 -33.0 20
333.5 39.7 20
340.1 44.3 20
4.6 36.8 20
17.9 30.1 20
87.3 39.2 20
142.3 -36.0 20
144.8 -61.3 20
235.4 19.7 20
300.7 67.9 20
311.0 -51.9 20
324.3 -19.5 20
336.8 -65.0 20
358.6 57.5 20
42.0 29.2 20
200.7 -61.0 20
201.0 -64.5 20
214.8 -13.4 20
226.1 26.9 20
272.8 -46.0 20
290.4 -16.0 20
311.3 57.6 20
322.5 23.6 20
337.6 43.1 20
12.5 41.1 20
90.0 -3.1 20
114.3 -35.0 20
213.4 51.8 20
261.7 -5.1 20
266.9 -27.8 20
311.9 36.5 20
348.1 49.4 20
79.5 33.4 20
98.8 -23.0 20
143.0 -1.2 20
143.6 36.4 20
143.6 69.8 20
222.8 19.1 20
228.1 -19.8 20
230.8 -36.9 20
299.2 -27.2 20
346.8 9.4 20
352.3 12.8 20
0.9 -17.3 20
52.5 58.9 20
76.1 -35.5 20
105.0 77.0 20
112.4 12.0 20
148.0 54.1 20
234.0 -45.0 20
245.2 -24.2 20
272.0 -28.5 20
325.5 71.3 20
335.3 46.5 20
336.1 49.5 20
42.9 35.1 19
59.7 -61.4 19
88.3 27.6 19
136.6 38.5 19
168.8 23.1 19
216.5 -45.2 19
263.9 -46.5 19
313.0 27.1 19
316.7 47.6 19
54.3 -40.3 19
246.4 14.0 19
246.4 -23.4 19
265.5 72.1 19
283.7 22.6 19
287.1 -40.5 19
298.4 24.1 19
83.8 -4.8 19
147.9 -46.5 19
160.9 -60.6 19
198.1 -59.9 19
207.9 64.7 19
243.1 -27.9 19
264.5 -8.1 19
350.2 23.7 19
10.3 -46.1 19
55.7 -37.3 19
57.6 71.3 19
81.7 3.1 19
130.1 64.3 19
142.3 -2.8 19
154.9 -55.0 19
168.2 -60.3 19
237.4 26.1 19
238.4 -25.3 19
281.1 39.6 19
294.2 -24.9 19
357.2 -28.1 19
64.6 50.3 19
151.3 -13.1 19
164.2 -37.1 19
221.3 17.0 19
231.3 -38.7 19
238.2 42.5 19
290.2 65.7 19
1.3 -5.7 19
4.3 38.7 19
28.4 3.2 19
47.8 39.6 19
111.7 49.2 19
120.0 -18.4 19
233.5 -10.1 19
308.5 35.3 19
14.2 59.2 19
60.0 -24.0 19
75.8 21.6 19
83.0 -7.3 19
137.0 -25.9 19
166.3 7.3 19
166.6 -62.4 19
173.7 -54.3 19
191.6 -56.5 19
193.7 -59.1 19
247.0 -8.4 19
270.1 -3.7 19
278.4 -42.3 19
44.8 21.3 19
115.9 -28.4 19
118.3 -49.6 19
130.9 -7.2 19
138.9 -37.4 19
190.0 -40.0 19
205.2 54.7 19
224.4 65.9 19
237.7 -25.8 19
240.9 -57.8 19
277.8 -62.3 19
282.8 59.4 19
359.4 25.1 19
58.4 -24.6 19
73.7 10.2 19
91.0 20.1 19
206.7 -51.4 19
234.8 36.6 19
235.3 -44.7 19
252.5 -10.8 19
259.4 37.3 19
271.8 8.7 19
291.6 0.3 19
308.8 14.7 19
339.3 51.5 19
346.0 50.1 19
40.9 27.7 19
68.5 14.8 19
76.1 15.4 19
88.5 -63.1 19
109.6 -36.7 19
112.7 -31.0 19
113.8 -28.4 19
156.9 -57.6 19
180.2 6.6 19
240.8 -49.2 19
17.9 21.0 18
27.4 -10.7 18
100.2 9.9 18
103.9 -20.1 18
109.1 -27.9 18
130.8 21.5 18
136.4 -70.5 18
163.5 43.2 18
189.8 -8.0 18
190.6 -48.8 18
234.9 -34.4 18
271.3 -29.6 18
274.5 -27.0 18
275.9 -8.9 18
300.3 27.8 18
18.4 24.6 18
52.3 49.5 18
63.7 40.5 18
69.8 15.9 18
91.5 -14.9 18
123.1 17.6 18
137.7 63.5 18
270.0 16.8 18
277.3 -14.6 18
281.1 39.7 18
293.1 69.7 18
315.3 -32.3 18
23.5 59.2 18
28.7 -67.6 18
31.1 -29.3 18
44.7 39.7 18
134.1 -52.7 18
144.6 4.6 18
150.1 8.0 18
159.7 32.0 18
203.0 -6.3 18
203.6 49.0 18
245.1 -78.7 18
294.8 30.2 18
324.4 -7.9 18
340.9 -18.8 18
66.7 14.7 18
79.8 40.1 18
114.6 -25.4 18
117.1 -47.1 18
120.3 -1.4 18
159.7 -59.2 18
191.4 -61.0 18
325.5 51.2 18
330.8 -56.8 18
353.8 -42.6 18
80.1 -21.2 18
174.2 -9.8 18
175.1 -34.7 18
253.5 -42.4 18
280.6 -9.1 18
299.0 -26.3 18
317.6 10.1 18
343.6 84.3 18
353.3 -20.9 18
44.9 8.9 18
52.3 -62.9 18
73.1 14.3 18
76.4 -57.5 18
82.4 -1.1 18
83.2 32.2 18
140.4 -26.0 18
140.8 -28.8 18
176.2 -18.4 18
196.6 -48.5 18
209.4 -63.7 18
298.6 8.5 18
319.5 -32.2 18
347.5 -22.5 18
21.5 68.1 18
80.4 -0.4 18
87.8 37.3 18
92.6 -55.0 18
122.8 -12.9 18
141.8 -22.3 18
156.5 33.8 18
157.6 -72.0 18
158.3 40.4 18
181.1 -63.2 18
185.2 17.8 18
199.4 40.6 18
240.7 46.0 18
259.2 -0.4 18
325.7 -18.9 18
36.4 50.3 18
103.7 13.2 18
122.9 -43.0 18
165.5 -2.5 18
241.6 -45.2 18
242.2 36.5 18
313.2 -9.0 18
7.9 54.5 18
19.9 27.3 18
38.0 -15.2 18
39.9 -42.9 18
50.0 65.7 18
52.7 -5.1 18
122.3 -61.3 18
130.3 -47.3 18
135.6 67.6 18
199.6 -18.3 18
212.5 -53.4 18
237.8 21.0 18
269.9 -23.8 18
285.8 -42.1 18
292.9 34.5 18
315.0 47.5 18
330.8 -2.2 18
354.5 -45.5 18
108.7 -48.3 18
177.1 -66.8 18
208.3 -31.9 18
214.0 51.4 18
235.5 -19.7 18
235.7 -34.7 18
308.9 -60.6 18
349.7 68.1 18
7.9 -48.8 17
42.6 -75.1 17
42.8 -21.0 17
88.1 1.9 17
94.7 69.3 17
119.4 -30.3 17
145.3 -23.6 17
160.6 -64.5 17
169.8 38.2 17
186.0 51.6 17
194.7 17.4 17
201.9 -16.0 17
207.9 34.4 17
215.7 -58.5 17
260.5 -67.8 17
265.1 -49.4 17
289.1 21.4 17
324.5 62.1 17
346.8 25.5 17
11.0 -10.6 17
46.4 56.7 17
84.7 -7.2 17
101.8 8.0 17
139.9 -12.0 17
172.6 -3.0 17
193.6 -9.5 17
264.2 68.8 17
270.8 -8.2 17
278.1 57.0 17
300.9 -37.9 17
304.4 38.0 17
305.2 -12.8 17
307.2 -17.8 17
341.9 83.2 17
0.4 -77.1 17
13.3 -1.1 17
32.1 37.9 17
56.5 63.3 17
67.6 16.2 17
75.0 -12.5 17
83.8 -6.0 17
122.1 51.5 17
123.4 -35.9 17
146.1 -27.8 17
154.9 19.5 17
185.6 25.8 17
199.4 5.5 17
215.2 -45.2 17
215.8 -27.8 17
262.9 -24.0 17
267.5 -40.1 17
281.4 -64.9 17
335.3 28.3 17
337.0 4.7 17
3.7 20.2 17
29.5 23.6 17
73.2 36.7 17
125.6 -48.5 17
140.2 -62.4 17
198.8 -67.9 17
237.8 35.7 17
247.6 -25.1 17
267.3 -31.7 17
270.1 4.4 17
303.8 25.6 17
332.5 72.3 17
333.9 -41.3 17
10.5 50.5 17
13.3 61.1 17
49.0 -8.8 17
65.4 46.5 17
66.0 17.4 17
75.4 -7.2 17
99.8 42.5 17
137.6 67.1 17
139.0 54.0 17
140.1 -9.6 17
161.0 -64.0 17
188.7 22.6 17
196.8 27.6 17
212.2 77.5 17
214.5 35.5 17
220.9 26.5 17
225.5 25.0 17
244.6 -28.6 17
259.3 33.1 17
303.3 46.8 17
313.3 44.4 17
320.2 -40.8 17
336.3 1.4 17
340.4 29.3 17
77.4 15.6 17
78.4 -67.2 17
79.4 -34.9 17
89.5 26.0 17
120.1 -63.6 17
143.8 39.6 17
171.2 -10.9 17
217.1 -2.2 17
276.3 -20.5 17
309.6 21.2 17
312.2 46.1 17
29.3 -47.4 17
78.4 38.5 17
99.8 -14.1 17
103.4 -20.2 17
113.4 -14.5 17
155.6 -41.6 17
157.7 56.0 17
186.6 -51.5 17
204.4 36.3 17
212.6 25.1 17
240.6 22.8 17
245.5 1.0 17
252.3 46.0 17
255.3 -4.2 17
276.5 65.6 17
283.6 71.3 17
316.1 -19.9 17
335.4 12.2 17
337.7 -10.7 17
349.4 49.0 17
355.4 -17.8 17
13.8 59.0 17
21.9 45.4 17
39.9 -11.9 17
41.4 -67.6 17
107.2 -39.7 17
109.2 -23.3 17
125.3 -33.1 17
130.6 -53.1 17
195.9 -49.5 17
225.9 47.7 17
228.2 -44.5 17
247.2 41.9 17
256.2 -34.1 17
281.5 26.7 17
284.3 -5.8 17
284.7 -37.1 17
22.5 6.1 17
33.3 44.2 17
34.3 34.2 17
49.8 3.4 17
63.5 9.3 17
85.3 16.5 17
114.9 -38.3 17
128.8 -58.0 17
165.1 3.6 17
176.3 8.3 17
214.9 16.3 17
248.2 11.5 17
250.2 64.6 17
251.3 56.8 17
299.7 -26.2 17
340.9 -41.4 17
341.4 -53.5 17
346.7 59.4 17
48.0 74.4 17
49.7 34.2 17
112.5 -23.0 17
152.2 -51.8 17
198.0 -37.8 17
229.4 -63.6 17
269.2 -44.3 17
275.2 3.4 17
284.6 -52.9 17
7.0 -33.0 16
49.6 -22.5 16
101.6 59.4 16
129.9 -29.6 16
158.8 75.7 16
199.3 -66.8 16
215.8 8.4 16
220.4 8.2 16
245.5 30.9 16
248.5 -44.0 16
249.7 48.9 16
263.1 55.2 16
265.9 -21.7 16
281.1 -35.6 16
283.5 -22.7 16
288.9 -25.3 16
309.4 -61.5 16
331.4 5.1 16
20.6 45.5 16
39.0 5.6 16
48.7 21.0 16
63.6 -10.3 16
108.3 -45.2 16
130.4 -15.9 16
133.9 -27.7 16
148.6 -25.9 16
159.3 -27.4 16
161.7 -64.4 16
296.6 -19.8 16
323.7 38.5 16
36.5 -12.3 16
81.9 21.9 16
87.3 24.6 16
88.3 -33.8 16
109.7 -24.6 16
179.9 -78.2 16
190.5 10.2 16
195.1 30.8 16
254.0 65.1 16
269.4 -41.7 16
280.9 -8.3 16
289.4 -19.0 16
293.8 -48.1 16
356.8 58.7 16
359.7 -3.6 16
359.8 55.8 16
2.8 -15.5 16
72.5 37.5 16
81.2 1.8 16
87.4 12.7 16
114.8 34.6 16
116.5 18.5 16
157.8 -53.7 16
159.4 -13.4 16
176.6 -40.5 16
178.0 -65.2 16
193.3 21.2 16
214.6 -81.0 16
256.3 12.7 16
263.0 55.2 16
296.1 37.4 16
312.5 -33.8 16
339.8 39.1 16
352.5 58.5 16
12.2 51.0 16
21.4 -14.6 16
85.6 1.5 16
104.4 45.1 16
192.7 -34.0 16
198.6 -59.1 16
240.9 -38.6 16
247.1 -70.1 16
297.8 22.6 16
312.4 -46.2 16
40.6 40.2 16
68.0 -0.0 16
75.4 -20.1 16
76.9 18.6 16
95.0 -2.9 16
107.6 -4.2 16
107.9 39.3 16
159.6 -16.9 16
190.5 -59.7 16
203.7 37.2 16
225.2 -8.5 16
228.7 -31.5 16
250.4 -17.7 16
256.3 54.5 16
298.9 52.4 16
307.4 -2.9 16
309.2 -2.5 16
338.3 -62.0 16
343.8 8.8 16
29.2 -22.5 16
90.5 -10.6 16
91.2 -16.5 16
96.2 49.3 16
106.0 -49.6 16
112.8 82.4 16
138.9 -38.6 16
166.3 -27.3 16
186.6 27.3 16
203.5 3.7 16
207.4 21.3 16
221.2 -35.2 16
231.0 -10.3 16
271.7 -43.4 16
275.1 22.0 16
277.9 -45.9 16
283.3 50.7 16
311.2 25.3 16
62.7 -42.0 16
64.3 20.6 16
65.1 34.6 16
74.8 37.9 16
113.9 -52.5 16
115.8 58.7 16
119.9 -3.7 16
134.2 -59.2 16
145.6 -23.9 16
173.1 -29.3 16
175.2 -62.1 16
184.1 23.9 16
192.9 27.5 16
195.2 56.4 16
212.7 -16.3 16
222.8 -2.3 16
226.8 24.9 16
243.0 -10.1 16
294.2 -7.0 16
301.8 -52.9 16
302.4 36.8 16
303.6 36.8 16
311.8 34.4 16
349.2 -7.7 16
356.0 29.4 16
33.1 30.3 16
44.8 35.2 16
104.1 -48.7 16
110.6 -19.0 16
120.9 27.8 16
132.4 -45.3 16
148.7 -19.0 16
156.0 65.6 16
157.8 -73.2 16
197.3 -23.1 16
198.4 40.2 16
247.0 68.8 16
285.0 32.1 16
303.6 15.2 16
307.5 49.0 16
332.5 -32.5 16
10.9 47.0 16
20.0 58.2 16
59.4 63.1 16
85.2 -1.1 16
93.0 16.1 16
172.0 2.9 16
188.7 70.0 16
239.5 -14.3 16
243.4 -54.6 16
244.4 75.8 16
299.0 38.5 16
300.4 -59.4 16
343.0 43.3 16
351.7 1.3 16
356.6 3.5 16
25.1 40.6 15
25.4 42.6 15
38.5 -28.2 15
50.4 43.3 15
67.1 16.4 15
79.8 22.1 15
88.7 55.7 15
207.5 -18.1 15
239.4 54.7 15
240.8 -25.9 15
271.5 22.2 15
272.9 -23.7 15
273.0 31.4 15
351.2 62.3 15
18.8 -45.5 15
29.0 68.7 15
55.6 34.0 15
60.3 -61.1 15
65.1 27.4 15
88.9 -37.1 15
118.4 26.8 15
155.7 -66.9 15
185.1 3.3 15
202.1 13.8 15
217.0 -29.5 15
235.1 -23.8 15
244.3 -50.1 15
255.8 14.1 15
353.5 31.3 15
354.9 -14.2 15
356.5 46.4 15
25.7 -3.7 15
32.4 25.9 15
44.7 -64.1 15
76.7 51.6 15
83.8 -5.4 15
83.8 -5.4 15
115.1 -15.3 15
130.0 -12.5 15
165.2 6.1 15
177.5 -70.2 15
186.7 26.8 15
232.9 40.9 15
240.4 29.9 15
276.0 58.8 15
290.1 -5.4 15
299.0 58.8 15
1.1 -10.5 15
30.6 54.5 15
52.0 49.1 15
55.6 -31.9 15
59.3 61.1 15
69.7 -12.1 15
80.7 3.5 15
102.7 41.8 15
102.7 -34.4 15
105.7 -4.2 15
111.4 9.3 15
123.3 -15.8 15
136.5 5.1 15
137.8 -44.9 15
143.0 11.3 15
170.7 43.5 15
184.1 33.1 15
205.4 -54.6 15
213.1 2.4 15
230.5 -47.9 15
230.8 30.3 15
239.9 -41.7 15
273.5 64.4 15
291.0 29.6 15
301.1 -32.1 15
332.1 -34.0 15
344.1 49.7 15
349.7 -9.6 15

