seasons$[] = [ "Chaos" "Discord" "Confusion" "Bureaucracy" "The Aftermath" ]
weekday$[] = [ "Sweetmorn" "Boomtime" "Pungenday" "Prickle-Prickle" "Setting Orange" ]
apostle$[] = [ "Mungday" "Mojoday" "Syaday" "Zaraday" "Maladay" ]
holiday$[] = [ "Chaoflux" "Discoflux" "Confuflux" "Bureflux" "Afflux" ]
# 
func leap x .
   return if x mod 400 = 0 or x mod 4 = 0 and x mod 100 <> 0
.
func day_of_year y m d .
   days[] = [ 31 28 31 30 31 30 31 31 30 31 30 31 ]
   repeat
      m -= 1
      until m = 0
      d += days[m]
      if m = 2 and leap y = 1
         d += 1
      .
   .
   return d
.
func$ ddate y m d .
   doy = day_of_year y m d
   dyear = y + 1166
   if leap y = 1 and m = 2 and d = 29
      return "St. Tib's Day, in the YOLD " & dyear
   .
   if leap y = 1 and doy >= 60
      doy -= 1
   .
   dsday = doy mod1 73
   dseason = doy div1 73
   r$ = weekday$[doy mod1 5] & ", day " & dsday & " of " & seasons$[dseason]
   r$ &= " in the YOLD " & dyear & "."
   if dsday = 5
      r$ &= " Celebrate " & apostle$[dseason] & "!"
   elif dsday = 50
      r$ &= " Celebrate " & holiday$[dseason] & "!"
   .
   return r$
.
proc show d$ . .
   a[] = number strsplit d$ "-"
   write d$ & " --> "
   print ddate a[1] a[2] a[3]
.
show "2016-01-05"
show "2016-02-28"
show "2016-02-29"
show "2016-03-01"
show "2016-12-31"
show "2025-03-19"
show substr timestr systime 1 10
