// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.1
// 	protoc        v5.28.3
// source: integration/integration.proto

package integration

import (
	common "github.com/chirpstack/chirpstack/api/go/v4/common"
	gw "github.com/chirpstack/chirpstack/api/go/v4/gw"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type LogLevel int32

const (
	// Info.
	LogLevel_INFO LogLevel = 0
	// Warning.
	LogLevel_WARNING LogLevel = 1
	// Error.
	LogLevel_ERROR LogLevel = 2
)

// Enum value maps for LogLevel.
var (
	LogLevel_name = map[int32]string{
		0: "INFO",
		1: "WARNING",
		2: "ERROR",
	}
	LogLevel_value = map[string]int32{
		"INFO":    0,
		"WARNING": 1,
		"ERROR":   2,
	}
)

func (x LogLevel) Enum() *LogLevel {
	p := new(LogLevel)
	*p = x
	return p
}

func (x LogLevel) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogLevel) Descriptor() protoreflect.EnumDescriptor {
	return file_integration_integration_proto_enumTypes[0].Descriptor()
}

func (LogLevel) Type() protoreflect.EnumType {
	return &file_integration_integration_proto_enumTypes[0]
}

func (x LogLevel) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogLevel.Descriptor instead.
func (LogLevel) EnumDescriptor() ([]byte, []int) {
	return file_integration_integration_proto_rawDescGZIP(), []int{0}
}

type LogCode int32

const (
	// Unknown type.
	LogCode_UNKNOWN LogCode = 0
	// Error related to the downlink payload size.
	// Usually seen when the payload exceeded the maximum allowed payload size.
	LogCode_DOWNLINK_PAYLOAD_SIZE LogCode = 1
	// Uplink codec error.
	LogCode_UPLINK_CODEC LogCode = 2
	// Downlink codec error.
	LogCode_DOWNLINK_CODEC LogCode = 3
	// OTAA error.
	LogCode_OTAA LogCode = 4
	// Uplink frame-counter was reset.
	LogCode_UPLINK_F_CNT_RESET LogCode = 5
	// Uplink MIC error.
	LogCode_UPLINK_MIC LogCode = 6
	// Uplink frame-counter retransmission.
	LogCode_UPLINK_F_CNT_RETRANSMISSION LogCode = 7
	// Downlink gateway error.
	LogCode_DOWNLINK_GATEWAY LogCode = 8
	// Relay new end-device.
	LogCode_RELAY_NEW_END_DEVICE LogCode = 9
	// Downlink frame-counter.
	LogCode_F_CNT_DOWN LogCode = 10
	// Downlink has expired.
	LogCode_EXPIRED LogCode = 11
)

// Enum value maps for LogCode.
var (
	LogCode_name = map[int32]string{
		0:  "UNKNOWN",
		1:  "DOWNLINK_PAYLOAD_SIZE",
		2:  "UPLINK_CODEC",
		3:  "DOWNLINK_CODEC",
		4:  "OTAA",
		5:  "UPLINK_F_CNT_RESET",
		6:  "UPLINK_MIC",
		7:  "UPLINK_F_CNT_RETRANSMISSION",
		8:  "DOWNLINK_GATEWAY",
		9:  "RELAY_NEW_END_DEVICE",
		10: "F_CNT_DOWN",
		11: "EXPIRED",
	}
	LogCode_value = map[string]int32{
		"UNKNOWN":                     0,
		"DOWNLINK_PAYLOAD_SIZE":       1,
		"UPLINK_CODEC":                2,
		"DOWNLINK_CODEC":              3,
		"OTAA":                        4,
		"UPLINK_F_CNT_RESET":          5,
		"UPLINK_MIC":                  6,
		"UPLINK_F_CNT_RETRANSMISSION": 7,
		"DOWNLINK_GATEWAY":            8,
		"RELAY_NEW_END_DEVICE":        9,
		"F_CNT_DOWN":                  10,
		"EXPIRED":                     11,
	}
)

func (x LogCode) Enum() *LogCode {
	p := new(LogCode)
	*p = x
	return p
}

func (x LogCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LogCode) Descriptor() protoreflect.EnumDescriptor {
	return file_integration_integration_proto_enumTypes[1].Descriptor()
}

func (LogCode) Type() protoreflect.EnumType {
	return &file_integration_integration_proto_enumTypes[1]
}

func (x LogCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use LogCode.Descriptor instead.
func (LogCode) EnumDescriptor() ([]byte, []int) {
	return file_integration_integration_proto_rawDescGZIP(), []int{1}
}

// Device information.
type DeviceInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Tenant ID (UUID).
	TenantId string `protobuf:"bytes,1,opt,name=tenant_id,json=tenantId,proto3" json:"tenant_id,omitempty"`
	// Tenant name.
	TenantName string `protobuf:"bytes,2,opt,name=tenant_name,json=tenantName,proto3" json:"tenant_name,omitempty"`
	// Application ID (UUID).
	ApplicationId string `protobuf:"bytes,3,opt,name=application_id,json=applicationId,proto3" json:"application_id,omitempty"`
	// Application name.
	ApplicationName string `protobuf:"bytes,4,opt,name=application_name,json=applicationName,proto3" json:"application_name,omitempty"`
	// Device-profile ID (UUID).
	DeviceProfileId string `protobuf:"bytes,5,opt,name=device_profile_id,json=deviceProfileId,proto3" json:"device_profile_id,omitempty"`
	// Device-profile name.
	DeviceProfileName string `protobuf:"bytes,6,opt,name=device_profile_name,json=deviceProfileName,proto3" json:"device_profile_name,omitempty"`
	// Device name.
	DeviceName string `protobuf:"bytes,7,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
	// Device EUI.
	DevEui string `protobuf:"bytes,8,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Device class.
	DeviceClassEnabled common.DeviceClass `protobuf:"varint,10,opt,name=device_class_enabled,json=deviceClassEnabled,proto3,enum=common.DeviceClass" json:"device_class_enabled,omitempty"`
	// Device-profile and device tags.
	Tags map[string]string `protobuf:"bytes,9,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *DeviceInfo) Reset() {
	*x = DeviceInfo{}
	mi := &file_integration_integration_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeviceInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceInfo) ProtoMessage() {}

func (x *DeviceInfo) ProtoReflect() protoreflect.Message {
	mi := &file_integration_integration_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceInfo.ProtoReflect.Descriptor instead.
func (*DeviceInfo) Descriptor() ([]byte, []int) {
	return file_integration_integration_proto_rawDescGZIP(), []int{0}
}

func (x *DeviceInfo) GetTenantId() string {
	if x != nil {
		return x.TenantId
	}
	return ""
}

func (x *DeviceInfo) GetTenantName() string {
	if x != nil {
		return x.TenantName
	}
	return ""
}

func (x *DeviceInfo) GetApplicationId() string {
	if x != nil {
		return x.ApplicationId
	}
	return ""
}

func (x *DeviceInfo) GetApplicationName() string {
	if x != nil {
		return x.ApplicationName
	}
	return ""
}

func (x *DeviceInfo) GetDeviceProfileId() string {
	if x != nil {
		return x.DeviceProfileId
	}
	return ""
}

func (x *DeviceInfo) GetDeviceProfileName() string {
	if x != nil {
		return x.DeviceProfileName
	}
	return ""
}

func (x *DeviceInfo) GetDeviceName() string {
	if x != nil {
		return x.DeviceName
	}
	return ""
}

func (x *DeviceInfo) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

func (x *DeviceInfo) GetDeviceClassEnabled() common.DeviceClass {
	if x != nil {
		return x.DeviceClassEnabled
	}
	return common.DeviceClass(0)
}

func (x *DeviceInfo) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

// Uplink relay RX information.
type UplinkRelayRxInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Relay DevEUI.
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Frequency.
	Frequency uint32 `protobuf:"varint,2,opt,name=frequency,proto3" json:"frequency,omitempty"`
	// Data-rate.
	Dr uint32 `protobuf:"varint,3,opt,name=dr,proto3" json:"dr,omitempty"`
	// SNR.
	Snr int32 `protobuf:"varint,4,opt,name=snr,proto3" json:"snr,omitempty"`
	// RSSI.
	Rssi int32 `protobuf:"varint,5,opt,name=rssi,proto3" json:"rssi,omitempty"`
	// WOR channel.
	WorChannel uint32 `protobuf:"varint,6,opt,name=wor_channel,json=worChannel,proto3" json:"wor_channel,omitempty"`
}

func (x *UplinkRelayRxInfo) Reset() {
	*x = UplinkRelayRxInfo{}
	mi := &file_integration_integration_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UplinkRelayRxInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UplinkRelayRxInfo) ProtoMessage() {}

func (x *UplinkRelayRxInfo) ProtoReflect() protoreflect.Message {
	mi := &file_integration_integration_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UplinkRelayRxInfo.ProtoReflect.Descriptor instead.
func (*UplinkRelayRxInfo) Descriptor() ([]byte, []int) {
	return file_integration_integration_proto_rawDescGZIP(), []int{1}
}

func (x *UplinkRelayRxInfo) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

func (x *UplinkRelayRxInfo) GetFrequency() uint32 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *UplinkRelayRxInfo) GetDr() uint32 {
	if x != nil {
		return x.Dr
	}
	return 0
}

func (x *UplinkRelayRxInfo) GetSnr() int32 {
	if x != nil {
		return x.Snr
	}
	return 0
}

func (x *UplinkRelayRxInfo) GetRssi() int32 {
	if x != nil {
		return x.Rssi
	}
	return 0
}

func (x *UplinkRelayRxInfo) GetWorChannel() uint32 {
	if x != nil {
		return x.WorChannel
	}
	return 0
}

// UplinkEvent is the message sent when an uplink payload has been received.
type UplinkEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deduplication ID (UUID).
	DeduplicationId string `protobuf:"bytes,1,opt,name=deduplication_id,json=deduplicationId,proto3" json:"deduplication_id,omitempty"`
	// Timestamp.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Device information.
	DeviceInfo *DeviceInfo `protobuf:"bytes,3,opt,name=device_info,json=deviceInfo,proto3" json:"device_info,omitempty"`
	// Device address.
	DevAddr string `protobuf:"bytes,4,opt,name=dev_addr,json=devAddr,proto3" json:"dev_addr,omitempty"`
	// Device has ADR bit set.
	Adr bool `protobuf:"varint,5,opt,name=adr,proto3" json:"adr,omitempty"`
	// Data-rate.
	Dr uint32 `protobuf:"varint,6,opt,name=dr,proto3" json:"dr,omitempty"`
	// Frame counter.
	FCnt uint32 `protobuf:"varint,7,opt,name=f_cnt,json=fCnt,proto3" json:"f_cnt,omitempty"`
	// Frame port.
	FPort uint32 `protobuf:"varint,8,opt,name=f_port,json=fPort,proto3" json:"f_port,omitempty"`
	// Uplink was of type confirmed.
	Confirmed bool `protobuf:"varint,9,opt,name=confirmed,proto3" json:"confirmed,omitempty"`
	// FRMPayload data.
	Data []byte `protobuf:"bytes,10,opt,name=data,proto3" json:"data,omitempty"`
	// Note that this is only set when a codec is configured in the Device
	// Profile.
	Object *structpb.Struct `protobuf:"bytes,11,opt,name=object,proto3" json:"object,omitempty"`
	// Receiving gateway RX info.
	RxInfo []*gw.UplinkRxInfo `protobuf:"bytes,12,rep,name=rx_info,json=rxInfo,proto3" json:"rx_info,omitempty"`
	// TX info.
	TxInfo *gw.UplinkTxInfo `protobuf:"bytes,13,opt,name=tx_info,json=txInfo,proto3" json:"tx_info,omitempty"`
	// Relay info.
	RelayRxInfo *UplinkRelayRxInfo `protobuf:"bytes,14,opt,name=relay_rx_info,json=relayRxInfo,proto3" json:"relay_rx_info,omitempty"`
	// Join-Server context.
	// A non-empty value indicatest that ChirpStack does not have access to
	// the AppSKey and that the encryption / decryption of the payloads is
	// the responsibility of the end-application.
	JoinServerContext *common.JoinServerContext `protobuf:"bytes,15,opt,name=join_server_context,json=joinServerContext,proto3" json:"join_server_context,omitempty"`
	// Region config ID.
	// This contains the region config ID which reported the uplink.
	RegionConfigId string `protobuf:"bytes,16,opt,name=region_config_id,json=regionConfigId,proto3" json:"region_config_id,omitempty"`
}

func (x *UplinkEvent) Reset() {
	*x = UplinkEvent{}
	mi := &file_integration_integration_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UplinkEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UplinkEvent) ProtoMessage() {}

func (x *UplinkEvent) ProtoReflect() protoreflect.Message {
	mi := &file_integration_integration_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UplinkEvent.ProtoReflect.Descriptor instead.
func (*UplinkEvent) Descriptor() ([]byte, []int) {
	return file_integration_integration_proto_rawDescGZIP(), []int{2}
}

func (x *UplinkEvent) GetDeduplicationId() string {
	if x != nil {
		return x.DeduplicationId
	}
	return ""
}

func (x *UplinkEvent) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *UplinkEvent) GetDeviceInfo() *DeviceInfo {
	if x != nil {
		return x.DeviceInfo
	}
	return nil
}

func (x *UplinkEvent) GetDevAddr() string {
	if x != nil {
		return x.DevAddr
	}
	return ""
}

func (x *UplinkEvent) GetAdr() bool {
	if x != nil {
		return x.Adr
	}
	return false
}

func (x *UplinkEvent) GetDr() uint32 {
	if x != nil {
		return x.Dr
	}
	return 0
}

func (x *UplinkEvent) GetFCnt() uint32 {
	if x != nil {
		return x.FCnt
	}
	return 0
}

func (x *UplinkEvent) GetFPort() uint32 {
	if x != nil {
		return x.FPort
	}
	return 0
}

func (x *UplinkEvent) GetConfirmed() bool {
	if x != nil {
		return x.Confirmed
	}
	return false
}

func (x *UplinkEvent) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *UplinkEvent) GetObject() *structpb.Struct {
	if x != nil {
		return x.Object
	}
	return nil
}

func (x *UplinkEvent) GetRxInfo() []*gw.UplinkRxInfo {
	if x != nil {
		return x.RxInfo
	}
	return nil
}

func (x *UplinkEvent) GetTxInfo() *gw.UplinkTxInfo {
	if x != nil {
		return x.TxInfo
	}
	return nil
}

func (x *UplinkEvent) GetRelayRxInfo() *UplinkRelayRxInfo {
	if x != nil {
		return x.RelayRxInfo
	}
	return nil
}

func (x *UplinkEvent) GetJoinServerContext() *common.JoinServerContext {
	if x != nil {
		return x.JoinServerContext
	}
	return nil
}

func (x *UplinkEvent) GetRegionConfigId() string {
	if x != nil {
		return x.RegionConfigId
	}
	return ""
}

// JoinEvent is the message sent when a device joined the network.
// Note: this event is sent at the first uplink after OTAA.
type JoinEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deduplication ID (UUID).
	DeduplicationId string `protobuf:"bytes,1,opt,name=deduplication_id,json=deduplicationId,proto3" json:"deduplication_id,omitempty"`
	// Timestamp.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Device info.
	DeviceInfo *DeviceInfo `protobuf:"bytes,3,opt,name=device_info,json=deviceInfo,proto3" json:"device_info,omitempty"`
	// Device address.
	DevAddr string `protobuf:"bytes,4,opt,name=dev_addr,json=devAddr,proto3" json:"dev_addr,omitempty"`
	// Relay info.
	RelayRxInfo *UplinkRelayRxInfo `protobuf:"bytes,5,opt,name=relay_rx_info,json=relayRxInfo,proto3" json:"relay_rx_info,omitempty"`
	// Join-Server context.
	// A non-empty value indicatest that ChirpStack does not have access to
	// the AppSKey and that the encryption / decryption of the payloads is
	// the responsibility of the end-application.
	JoinServerContext *common.JoinServerContext `protobuf:"bytes,6,opt,name=join_server_context,json=joinServerContext,proto3" json:"join_server_context,omitempty"`
	// Region config ID.
	// This contains the region config ID which reported the uplink.
	RegionConfigId string `protobuf:"bytes,7,opt,name=region_config_id,json=regionConfigId,proto3" json:"region_config_id,omitempty"`
}

func (x *JoinEvent) Reset() {
	*x = JoinEvent{}
	mi := &file_integration_integration_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *JoinEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JoinEvent) ProtoMessage() {}

func (x *JoinEvent) ProtoReflect() protoreflect.Message {
	mi := &file_integration_integration_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JoinEvent.ProtoReflect.Descriptor instead.
func (*JoinEvent) Descriptor() ([]byte, []int) {
	return file_integration_integration_proto_rawDescGZIP(), []int{3}
}

func (x *JoinEvent) GetDeduplicationId() string {
	if x != nil {
		return x.DeduplicationId
	}
	return ""
}

func (x *JoinEvent) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *JoinEvent) GetDeviceInfo() *DeviceInfo {
	if x != nil {
		return x.DeviceInfo
	}
	return nil
}

func (x *JoinEvent) GetDevAddr() string {
	if x != nil {
		return x.DevAddr
	}
	return ""
}

func (x *JoinEvent) GetRelayRxInfo() *UplinkRelayRxInfo {
	if x != nil {
		return x.RelayRxInfo
	}
	return nil
}

func (x *JoinEvent) GetJoinServerContext() *common.JoinServerContext {
	if x != nil {
		return x.JoinServerContext
	}
	return nil
}

func (x *JoinEvent) GetRegionConfigId() string {
	if x != nil {
		return x.RegionConfigId
	}
	return ""
}

// AckEvent is the message sent when a confirmation on a confirmed downlink
// has been received -or- when the downlink timed out.
type AckEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deduplication ID (UUID).
	DeduplicationId string `protobuf:"bytes,1,opt,name=deduplication_id,json=deduplicationId,proto3" json:"deduplication_id,omitempty"`
	// Timestamp.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Device info.
	DeviceInfo *DeviceInfo `protobuf:"bytes,3,opt,name=device_info,json=deviceInfo,proto3" json:"device_info,omitempty"`
	// Downlink queue item ID (UUID).
	QueueItemId string `protobuf:"bytes,4,opt,name=queue_item_id,json=queueItemId,proto3" json:"queue_item_id,omitempty"`
	// Frame was acknowledged.
	Acknowledged bool `protobuf:"varint,5,opt,name=acknowledged,proto3" json:"acknowledged,omitempty"`
	// Downlink frame counter to which the acknowledgement relates.
	FCntDown uint32 `protobuf:"varint,6,opt,name=f_cnt_down,json=fCntDown,proto3" json:"f_cnt_down,omitempty"`
}

func (x *AckEvent) Reset() {
	*x = AckEvent{}
	mi := &file_integration_integration_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AckEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AckEvent) ProtoMessage() {}

func (x *AckEvent) ProtoReflect() protoreflect.Message {
	mi := &file_integration_integration_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AckEvent.ProtoReflect.Descriptor instead.
func (*AckEvent) Descriptor() ([]byte, []int) {
	return file_integration_integration_proto_rawDescGZIP(), []int{4}
}

func (x *AckEvent) GetDeduplicationId() string {
	if x != nil {
		return x.DeduplicationId
	}
	return ""
}

func (x *AckEvent) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *AckEvent) GetDeviceInfo() *DeviceInfo {
	if x != nil {
		return x.DeviceInfo
	}
	return nil
}

func (x *AckEvent) GetQueueItemId() string {
	if x != nil {
		return x.QueueItemId
	}
	return ""
}

func (x *AckEvent) GetAcknowledged() bool {
	if x != nil {
		return x.Acknowledged
	}
	return false
}

func (x *AckEvent) GetFCntDown() uint32 {
	if x != nil {
		return x.FCntDown
	}
	return 0
}

// TxAckEvent is the message sent when a downlink was acknowledged by the
// gateway for transmission. As a downlink can be scheduled in the future, this
// event does not confirm that the message has already been transmitted.
type TxAckEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Downlink ID.
	DownlinkId uint32 `protobuf:"varint,1,opt,name=downlink_id,json=downlinkId,proto3" json:"downlink_id,omitempty"`
	// Timestamp.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Device info.
	DeviceInfo *DeviceInfo `protobuf:"bytes,3,opt,name=device_info,json=deviceInfo,proto3" json:"device_info,omitempty"`
	// Downlink queue item ID (UUID).
	QueueItemId string `protobuf:"bytes,4,opt,name=queue_item_id,json=queueItemId,proto3" json:"queue_item_id,omitempty"`
	// Downlink frame-counter.
	FCntDown uint32 `protobuf:"varint,5,opt,name=f_cnt_down,json=fCntDown,proto3" json:"f_cnt_down,omitempty"`
	// Gateway ID.
	GatewayId string `protobuf:"bytes,6,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// TX info.
	TxInfo *gw.DownlinkTxInfo `protobuf:"bytes,7,opt,name=tx_info,json=txInfo,proto3" json:"tx_info,omitempty"`
}

func (x *TxAckEvent) Reset() {
	*x = TxAckEvent{}
	mi := &file_integration_integration_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TxAckEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TxAckEvent) ProtoMessage() {}

func (x *TxAckEvent) ProtoReflect() protoreflect.Message {
	mi := &file_integration_integration_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TxAckEvent.ProtoReflect.Descriptor instead.
func (*TxAckEvent) Descriptor() ([]byte, []int) {
	return file_integration_integration_proto_rawDescGZIP(), []int{5}
}

func (x *TxAckEvent) GetDownlinkId() uint32 {
	if x != nil {
		return x.DownlinkId
	}
	return 0
}

func (x *TxAckEvent) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *TxAckEvent) GetDeviceInfo() *DeviceInfo {
	if x != nil {
		return x.DeviceInfo
	}
	return nil
}

func (x *TxAckEvent) GetQueueItemId() string {
	if x != nil {
		return x.QueueItemId
	}
	return ""
}

func (x *TxAckEvent) GetFCntDown() uint32 {
	if x != nil {
		return x.FCntDown
	}
	return 0
}

func (x *TxAckEvent) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

func (x *TxAckEvent) GetTxInfo() *gw.DownlinkTxInfo {
	if x != nil {
		return x.TxInfo
	}
	return nil
}

// LogEvent is the message sent when a device-related log was sent.
type LogEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timestamp.
	Time *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
	// Device info.
	DeviceInfo *DeviceInfo `protobuf:"bytes,2,opt,name=device_info,json=deviceInfo,proto3" json:"device_info,omitempty"`
	// Log level.
	Level LogLevel `protobuf:"varint,3,opt,name=level,proto3,enum=integration.LogLevel" json:"level,omitempty"`
	// Log code.
	Code LogCode `protobuf:"varint,4,opt,name=code,proto3,enum=integration.LogCode" json:"code,omitempty"`
	// Description message.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Context map.
	Context map[string]string `protobuf:"bytes,6,rep,name=context,proto3" json:"context,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *LogEvent) Reset() {
	*x = LogEvent{}
	mi := &file_integration_integration_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogEvent) ProtoMessage() {}

func (x *LogEvent) ProtoReflect() protoreflect.Message {
	mi := &file_integration_integration_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogEvent.ProtoReflect.Descriptor instead.
func (*LogEvent) Descriptor() ([]byte, []int) {
	return file_integration_integration_proto_rawDescGZIP(), []int{6}
}

func (x *LogEvent) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *LogEvent) GetDeviceInfo() *DeviceInfo {
	if x != nil {
		return x.DeviceInfo
	}
	return nil
}

func (x *LogEvent) GetLevel() LogLevel {
	if x != nil {
		return x.Level
	}
	return LogLevel_INFO
}

func (x *LogEvent) GetCode() LogCode {
	if x != nil {
		return x.Code
	}
	return LogCode_UNKNOWN
}

func (x *LogEvent) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *LogEvent) GetContext() map[string]string {
	if x != nil {
		return x.Context
	}
	return nil
}

// StatusEvent is the message sent when a device-status mac-command was sent
// by the device.
type StatusEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deduplication ID (UUID).
	DeduplicationId string `protobuf:"bytes,1,opt,name=deduplication_id,json=deduplicationId,proto3" json:"deduplication_id,omitempty"`
	// Timestamp.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Device info.
	DeviceInfo *DeviceInfo `protobuf:"bytes,3,opt,name=device_info,json=deviceInfo,proto3" json:"device_info,omitempty"`
	// The demodulation signal-to-noise ratio in dB for the last successfully
	// received device-status request by the Network Server.
	Margin int32 `protobuf:"varint,5,opt,name=margin,proto3" json:"margin,omitempty"`
	// Device is connected to an external power source.
	ExternalPowerSource bool `protobuf:"varint,6,opt,name=external_power_source,json=externalPowerSource,proto3" json:"external_power_source,omitempty"`
	// Battery level is not available.
	BatteryLevelUnavailable bool `protobuf:"varint,7,opt,name=battery_level_unavailable,json=batteryLevelUnavailable,proto3" json:"battery_level_unavailable,omitempty"`
	// Battery level.
	BatteryLevel float32 `protobuf:"fixed32,8,opt,name=battery_level,json=batteryLevel,proto3" json:"battery_level,omitempty"`
}

func (x *StatusEvent) Reset() {
	*x = StatusEvent{}
	mi := &file_integration_integration_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StatusEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StatusEvent) ProtoMessage() {}

func (x *StatusEvent) ProtoReflect() protoreflect.Message {
	mi := &file_integration_integration_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StatusEvent.ProtoReflect.Descriptor instead.
func (*StatusEvent) Descriptor() ([]byte, []int) {
	return file_integration_integration_proto_rawDescGZIP(), []int{7}
}

func (x *StatusEvent) GetDeduplicationId() string {
	if x != nil {
		return x.DeduplicationId
	}
	return ""
}

func (x *StatusEvent) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *StatusEvent) GetDeviceInfo() *DeviceInfo {
	if x != nil {
		return x.DeviceInfo
	}
	return nil
}

func (x *StatusEvent) GetMargin() int32 {
	if x != nil {
		return x.Margin
	}
	return 0
}

func (x *StatusEvent) GetExternalPowerSource() bool {
	if x != nil {
		return x.ExternalPowerSource
	}
	return false
}

func (x *StatusEvent) GetBatteryLevelUnavailable() bool {
	if x != nil {
		return x.BatteryLevelUnavailable
	}
	return false
}

func (x *StatusEvent) GetBatteryLevel() float32 {
	if x != nil {
		return x.BatteryLevel
	}
	return 0
}

// LocationEvent is the message sent when a geolocation resolve was returned.
type LocationEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deduplication ID (UUID).
	DeduplicationId string `protobuf:"bytes,1,opt,name=deduplication_id,json=deduplicationId,proto3" json:"deduplication_id,omitempty"`
	// Timestamp.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Device info.
	DeviceInfo *DeviceInfo `protobuf:"bytes,3,opt,name=device_info,json=deviceInfo,proto3" json:"device_info,omitempty"`
	// Location.
	Location *common.Location `protobuf:"bytes,4,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *LocationEvent) Reset() {
	*x = LocationEvent{}
	mi := &file_integration_integration_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LocationEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationEvent) ProtoMessage() {}

func (x *LocationEvent) ProtoReflect() protoreflect.Message {
	mi := &file_integration_integration_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationEvent.ProtoReflect.Descriptor instead.
func (*LocationEvent) Descriptor() ([]byte, []int) {
	return file_integration_integration_proto_rawDescGZIP(), []int{8}
}

func (x *LocationEvent) GetDeduplicationId() string {
	if x != nil {
		return x.DeduplicationId
	}
	return ""
}

func (x *LocationEvent) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *LocationEvent) GetDeviceInfo() *DeviceInfo {
	if x != nil {
		return x.DeviceInfo
	}
	return nil
}

func (x *LocationEvent) GetLocation() *common.Location {
	if x != nil {
		return x.Location
	}
	return nil
}

// IntegrationEvent is the message that can be sent by an integration.
// It allows for sending events which are provided by an external integration
// which are "not native" to ChirpStack.
type IntegrationEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Deduplication ID (UUID).
	DeduplicationId string `protobuf:"bytes,1,opt,name=deduplication_id,json=deduplicationId,proto3" json:"deduplication_id,omitempty"`
	// Timestamp.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Device info.
	DeviceInfo *DeviceInfo `protobuf:"bytes,3,opt,name=device_info,json=deviceInfo,proto3" json:"device_info,omitempty"`
	// Integration name.
	IntegrationName string `protobuf:"bytes,4,opt,name=integration_name,json=integrationName,proto3" json:"integration_name,omitempty"`
	// Event type.
	EventType string `protobuf:"bytes,5,opt,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	// Struct containing the event object.
	Object *structpb.Struct `protobuf:"bytes,6,opt,name=object,proto3" json:"object,omitempty"`
}

func (x *IntegrationEvent) Reset() {
	*x = IntegrationEvent{}
	mi := &file_integration_integration_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IntegrationEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntegrationEvent) ProtoMessage() {}

func (x *IntegrationEvent) ProtoReflect() protoreflect.Message {
	mi := &file_integration_integration_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntegrationEvent.ProtoReflect.Descriptor instead.
func (*IntegrationEvent) Descriptor() ([]byte, []int) {
	return file_integration_integration_proto_rawDescGZIP(), []int{9}
}

func (x *IntegrationEvent) GetDeduplicationId() string {
	if x != nil {
		return x.DeduplicationId
	}
	return ""
}

func (x *IntegrationEvent) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *IntegrationEvent) GetDeviceInfo() *DeviceInfo {
	if x != nil {
		return x.DeviceInfo
	}
	return nil
}

func (x *IntegrationEvent) GetIntegrationName() string {
	if x != nil {
		return x.IntegrationName
	}
	return ""
}

func (x *IntegrationEvent) GetEventType() string {
	if x != nil {
		return x.EventType
	}
	return ""
}

func (x *IntegrationEvent) GetObject() *structpb.Struct {
	if x != nil {
		return x.Object
	}
	return nil
}

// DownlinkCommand is the command to enqueue a downlink payload for the given
// device.
type DownlinkCommand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID (UUID).
	// If left blank, a random UUID will be generated.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Device EUI (EUI64).
	DevEui string `protobuf:"bytes,2,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Confirmed.
	Confirmed bool `protobuf:"varint,3,opt,name=confirmed,proto3" json:"confirmed,omitempty"`
	// FPort (must be > 0).
	FPort uint32 `protobuf:"varint,4,opt,name=f_port,json=fPort,proto3" json:"f_port,omitempty"`
	// Data.
	// Or use the json_object field when a codec has been configured.
	Data []byte `protobuf:"bytes,5,opt,name=data,proto3" json:"data,omitempty"`
	// Only use this when a codec has been configured that can encode this
	// object to bytes.
	Object *structpb.Struct `protobuf:"bytes,6,opt,name=object,proto3" json:"object,omitempty"`
}

func (x *DownlinkCommand) Reset() {
	*x = DownlinkCommand{}
	mi := &file_integration_integration_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DownlinkCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownlinkCommand) ProtoMessage() {}

func (x *DownlinkCommand) ProtoReflect() protoreflect.Message {
	mi := &file_integration_integration_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownlinkCommand.ProtoReflect.Descriptor instead.
func (*DownlinkCommand) Descriptor() ([]byte, []int) {
	return file_integration_integration_proto_rawDescGZIP(), []int{10}
}

func (x *DownlinkCommand) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *DownlinkCommand) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

func (x *DownlinkCommand) GetConfirmed() bool {
	if x != nil {
		return x.Confirmed
	}
	return false
}

func (x *DownlinkCommand) GetFPort() uint32 {
	if x != nil {
		return x.FPort
	}
	return 0
}

func (x *DownlinkCommand) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *DownlinkCommand) GetObject() *structpb.Struct {
	if x != nil {
		return x.Object
	}
	return nil
}

var File_integration_integration_proto protoreflect.FileDescriptor

var file_integration_integration_proto_rawDesc = []byte{
	0x0a, 0x1d, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x69, 0x6e,
	0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x0b, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x13, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x0b, 0x67, 0x77, 0x2f, 0x67, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xe9, 0x03,
	0x0a, 0x0a, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1b, 0x0a, 0x09,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x08, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x65, 0x6e,
	0x61, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x11,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x13, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x65, 0x76,
	0x5f, 0x65, 0x75, 0x69, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45,
	0x75, 0x69, 0x12, 0x45, 0x0a, 0x14, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6c, 0x61,
	0x73, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x12, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c, 0x61,
	0x73, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x35, 0x0a, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x2e, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73,
	0x1a, 0x37, 0x0a, 0x09, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa1, 0x01, 0x0a, 0x11, 0x55, 0x70,
	0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x17, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x64, 0x65, 0x76, 0x45, 0x75, 0x69, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x66, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x0e, 0x0a, 0x02, 0x64, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x02, 0x64, 0x72, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x6e, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x03, 0x73, 0x6e, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x73, 0x73, 0x69,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x72, 0x73, 0x73, 0x69, 0x12, 0x1f, 0x0a, 0x0b,
	0x77, 0x6f, 0x72, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x22, 0xfd, 0x04,
	0x0a, 0x0b, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a,
	0x10, 0x64, 0x65, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x64, 0x75, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x0b, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x19, 0x0a, 0x08, 0x64, 0x65, 0x76, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72, 0x12, 0x10, 0x0a,
	0x03, 0x61, 0x64, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x03, 0x61, 0x64, 0x72, 0x12,
	0x0e, 0x0a, 0x02, 0x64, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x02, 0x64, 0x72, 0x12,
	0x13, 0x0a, 0x05, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04,
	0x66, 0x43, 0x6e, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x66, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x66, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2f, 0x0a,
	0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x29,
	0x0a, 0x07, 0x72, 0x78, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x10, 0x2e, 0x67, 0x77, 0x2e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x78, 0x49, 0x6e, 0x66,
	0x6f, 0x52, 0x06, 0x72, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x29, 0x0a, 0x07, 0x74, 0x78, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x77, 0x2e,
	0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x74, 0x78,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x42, 0x0a, 0x0d, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x72, 0x78,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b, 0x72, 0x65, 0x6c,
	0x61, 0x79, 0x52, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x49, 0x0a, 0x13, 0x6a, 0x6f, 0x69, 0x6e,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4a,
	0x6f, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x52, 0x11, 0x6a, 0x6f, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x22, 0xf4, 0x02,
	0x0a, 0x09, 0x4a, 0x6f, 0x69, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x64,
	0x65, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x19, 0x0a, 0x08, 0x64, 0x65, 0x76, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x64, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72, 0x12, 0x42, 0x0a, 0x0d, 0x72,
	0x65, 0x6c, 0x61, 0x79, 0x5f, 0x72, 0x78, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x78, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x0b, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x52, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x49, 0x0a, 0x13, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4a, 0x6f, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x11, 0x6a, 0x6f, 0x69, 0x6e, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x28, 0x0a, 0x10, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x49, 0x64, 0x22, 0x85, 0x02, 0x0a, 0x08, 0x41, 0x63, 0x6b, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x64,
	0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x04,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x0b,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x22, 0x0a, 0x0d, 0x71, 0x75, 0x65, 0x75, 0x65, 0x5f,
	0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x71,
	0x75, 0x65, 0x75, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0c, 0x61, 0x63,
	0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0c, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x64, 0x12, 0x1c,
	0x0a, 0x0a, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x08, 0x66, 0x43, 0x6e, 0x74, 0x44, 0x6f, 0x77, 0x6e, 0x22, 0xa5, 0x02, 0x0a,
	0x0a, 0x54, 0x78, 0x41, 0x63, 0x6b, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x64,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x0a, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x04,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x0b,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x22, 0x0a, 0x0d, 0x71, 0x75, 0x65, 0x75, 0x65, 0x5f,
	0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x71,
	0x75, 0x65, 0x75, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x0a, 0x66, 0x5f,
	0x63, 0x6e, 0x74, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08,
	0x66, 0x43, 0x6e, 0x74, 0x44, 0x6f, 0x77, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x12, 0x2b, 0x0a, 0x07, 0x74, 0x78, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x77, 0x2e, 0x44, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x74, 0x78,
	0x49, 0x6e, 0x66, 0x6f, 0x22, 0xe7, 0x02, 0x0a, 0x08, 0x4c, 0x6f, 0x67, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x12, 0x38, 0x0a, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2b, 0x0a, 0x05, 0x6c,
	0x65, 0x76, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65,
	0x6c, 0x52, 0x05, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x28, 0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x14, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x6f, 0x67, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f,
	0x64, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x4c, 0x6f, 0x67, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x1a, 0x3a, 0x0a, 0x0c, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xcf,
	0x02, 0x0a, 0x0b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x29,
	0x0a, 0x10, 0x64, 0x65, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x64, 0x75, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x0b, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x06, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x12, 0x32, 0x0a, 0x15, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x65, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x3a, 0x0a, 0x19, 0x62, 0x61, 0x74, 0x74, 0x65, 0x72, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c,
	0x5f, 0x75, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x17, 0x62, 0x61, 0x74, 0x74, 0x65, 0x72, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x55, 0x6e, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x62,
	0x61, 0x74, 0x74, 0x65, 0x72, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x0c, 0x62, 0x61, 0x74, 0x74, 0x65, 0x72, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x22, 0xd2, 0x01, 0x0a, 0x0d, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65,
	0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2e, 0x0a,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x38, 0x0a,
	0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2c, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa2, 0x02, 0x0a, 0x10, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x65,
	0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x64, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x38, 0x0a, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x29, 0x0a, 0x10, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x69, 0x6e, 0x74, 0x65, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x22, 0xb4, 0x01, 0x0a, 0x0f, 0x44,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x0e,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x17,
	0x0a, 0x07, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x64, 0x65, 0x76, 0x45, 0x75, 0x69, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x72, 0x6d, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x72, 0x6d, 0x65, 0x64, 0x12, 0x15, 0x0a, 0x06, 0x66, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x66, 0x50, 0x6f, 0x72, 0x74, 0x12, 0x12, 0x0a, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x2f, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x2a, 0x2c, 0x0a, 0x08, 0x4c, 0x6f, 0x67, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x08, 0x0a,
	0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x52, 0x4e, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x2a,
	0xf7, 0x01, 0x0a, 0x07, 0x4c, 0x6f, 0x67, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55,
	0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x4f, 0x57, 0x4e,
	0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x50, 0x41, 0x59, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x53, 0x49, 0x5a,
	0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x55, 0x50, 0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x43, 0x4f,
	0x44, 0x45, 0x43, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x4f, 0x57, 0x4e, 0x4c, 0x49, 0x4e,
	0x4b, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x43, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x4f, 0x54, 0x41,
	0x41, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12, 0x55, 0x50, 0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x46, 0x5f,
	0x43, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x53, 0x45, 0x54, 0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a, 0x55,
	0x50, 0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x4d, 0x49, 0x43, 0x10, 0x06, 0x12, 0x1f, 0x0a, 0x1b, 0x55,
	0x50, 0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x46, 0x5f, 0x43, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x54, 0x52,
	0x41, 0x4e, 0x53, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x07, 0x12, 0x14, 0x0a, 0x10,
	0x44, 0x4f, 0x57, 0x4e, 0x4c, 0x49, 0x4e, 0x4b, 0x5f, 0x47, 0x41, 0x54, 0x45, 0x57, 0x41, 0x59,
	0x10, 0x08, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x4c, 0x41, 0x59, 0x5f, 0x4e, 0x45, 0x57, 0x5f,
	0x45, 0x4e, 0x44, 0x5f, 0x44, 0x45, 0x56, 0x49, 0x43, 0x45, 0x10, 0x09, 0x12, 0x0e, 0x0a, 0x0a,
	0x46, 0x5f, 0x43, 0x4e, 0x54, 0x5f, 0x44, 0x4f, 0x57, 0x4e, 0x10, 0x0a, 0x12, 0x0b, 0x0a, 0x07,
	0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x44, 0x10, 0x0b, 0x42, 0xbf, 0x01, 0x0a, 0x1d, 0x69, 0x6f,
	0x2e, 0x63, 0x68, 0x69, 0x72, 0x70, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x10, 0x49, 0x6e, 0x74,
	0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x33, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x62, 0x72, 0x6f, 0x63,
	0x61, 0x61, 0x72, 0x2f, 0x63, 0x68, 0x69, 0x72, 0x70, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x34, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0xaa, 0x02, 0x16, 0x43, 0x68, 0x69, 0x72, 0x70, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0xca, 0x02, 0x16,
	0x43, 0x68, 0x69, 0x72, 0x70, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5c, 0x49, 0x6e, 0x74, 0x65, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0xe2, 0x02, 0x22, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x5c, 0x43, 0x68, 0x69, 0x72, 0x70, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5c,
	0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_integration_integration_proto_rawDescOnce sync.Once
	file_integration_integration_proto_rawDescData = file_integration_integration_proto_rawDesc
)

func file_integration_integration_proto_rawDescGZIP() []byte {
	file_integration_integration_proto_rawDescOnce.Do(func() {
		file_integration_integration_proto_rawDescData = protoimpl.X.CompressGZIP(file_integration_integration_proto_rawDescData)
	})
	return file_integration_integration_proto_rawDescData
}

var file_integration_integration_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_integration_integration_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_integration_integration_proto_goTypes = []any{
	(LogLevel)(0),                    // 0: integration.LogLevel
	(LogCode)(0),                     // 1: integration.LogCode
	(*DeviceInfo)(nil),               // 2: integration.DeviceInfo
	(*UplinkRelayRxInfo)(nil),        // 3: integration.UplinkRelayRxInfo
	(*UplinkEvent)(nil),              // 4: integration.UplinkEvent
	(*JoinEvent)(nil),                // 5: integration.JoinEvent
	(*AckEvent)(nil),                 // 6: integration.AckEvent
	(*TxAckEvent)(nil),               // 7: integration.TxAckEvent
	(*LogEvent)(nil),                 // 8: integration.LogEvent
	(*StatusEvent)(nil),              // 9: integration.StatusEvent
	(*LocationEvent)(nil),            // 10: integration.LocationEvent
	(*IntegrationEvent)(nil),         // 11: integration.IntegrationEvent
	(*DownlinkCommand)(nil),          // 12: integration.DownlinkCommand
	nil,                              // 13: integration.DeviceInfo.TagsEntry
	nil,                              // 14: integration.LogEvent.ContextEntry
	(common.DeviceClass)(0),          // 15: common.DeviceClass
	(*timestamppb.Timestamp)(nil),    // 16: google.protobuf.Timestamp
	(*structpb.Struct)(nil),          // 17: google.protobuf.Struct
	(*gw.UplinkRxInfo)(nil),          // 18: gw.UplinkRxInfo
	(*gw.UplinkTxInfo)(nil),          // 19: gw.UplinkTxInfo
	(*common.JoinServerContext)(nil), // 20: common.JoinServerContext
	(*gw.DownlinkTxInfo)(nil),        // 21: gw.DownlinkTxInfo
	(*common.Location)(nil),          // 22: common.Location
}
var file_integration_integration_proto_depIdxs = []int32{
	15, // 0: integration.DeviceInfo.device_class_enabled:type_name -> common.DeviceClass
	13, // 1: integration.DeviceInfo.tags:type_name -> integration.DeviceInfo.TagsEntry
	16, // 2: integration.UplinkEvent.time:type_name -> google.protobuf.Timestamp
	2,  // 3: integration.UplinkEvent.device_info:type_name -> integration.DeviceInfo
	17, // 4: integration.UplinkEvent.object:type_name -> google.protobuf.Struct
	18, // 5: integration.UplinkEvent.rx_info:type_name -> gw.UplinkRxInfo
	19, // 6: integration.UplinkEvent.tx_info:type_name -> gw.UplinkTxInfo
	3,  // 7: integration.UplinkEvent.relay_rx_info:type_name -> integration.UplinkRelayRxInfo
	20, // 8: integration.UplinkEvent.join_server_context:type_name -> common.JoinServerContext
	16, // 9: integration.JoinEvent.time:type_name -> google.protobuf.Timestamp
	2,  // 10: integration.JoinEvent.device_info:type_name -> integration.DeviceInfo
	3,  // 11: integration.JoinEvent.relay_rx_info:type_name -> integration.UplinkRelayRxInfo
	20, // 12: integration.JoinEvent.join_server_context:type_name -> common.JoinServerContext
	16, // 13: integration.AckEvent.time:type_name -> google.protobuf.Timestamp
	2,  // 14: integration.AckEvent.device_info:type_name -> integration.DeviceInfo
	16, // 15: integration.TxAckEvent.time:type_name -> google.protobuf.Timestamp
	2,  // 16: integration.TxAckEvent.device_info:type_name -> integration.DeviceInfo
	21, // 17: integration.TxAckEvent.tx_info:type_name -> gw.DownlinkTxInfo
	16, // 18: integration.LogEvent.time:type_name -> google.protobuf.Timestamp
	2,  // 19: integration.LogEvent.device_info:type_name -> integration.DeviceInfo
	0,  // 20: integration.LogEvent.level:type_name -> integration.LogLevel
	1,  // 21: integration.LogEvent.code:type_name -> integration.LogCode
	14, // 22: integration.LogEvent.context:type_name -> integration.LogEvent.ContextEntry
	16, // 23: integration.StatusEvent.time:type_name -> google.protobuf.Timestamp
	2,  // 24: integration.StatusEvent.device_info:type_name -> integration.DeviceInfo
	16, // 25: integration.LocationEvent.time:type_name -> google.protobuf.Timestamp
	2,  // 26: integration.LocationEvent.device_info:type_name -> integration.DeviceInfo
	22, // 27: integration.LocationEvent.location:type_name -> common.Location
	16, // 28: integration.IntegrationEvent.time:type_name -> google.protobuf.Timestamp
	2,  // 29: integration.IntegrationEvent.device_info:type_name -> integration.DeviceInfo
	17, // 30: integration.IntegrationEvent.object:type_name -> google.protobuf.Struct
	17, // 31: integration.DownlinkCommand.object:type_name -> google.protobuf.Struct
	32, // [32:32] is the sub-list for method output_type
	32, // [32:32] is the sub-list for method input_type
	32, // [32:32] is the sub-list for extension type_name
	32, // [32:32] is the sub-list for extension extendee
	0,  // [0:32] is the sub-list for field type_name
}

func init() { file_integration_integration_proto_init() }
func file_integration_integration_proto_init() {
	if File_integration_integration_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_integration_integration_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_integration_integration_proto_goTypes,
		DependencyIndexes: file_integration_integration_proto_depIdxs,
		EnumInfos:         file_integration_integration_proto_enumTypes,
		MessageInfos:      file_integration_integration_proto_msgTypes,
	}.Build()
	File_integration_integration_proto = out.File
	file_integration_integration_proto_rawDesc = nil
	file_integration_integration_proto_goTypes = nil
	file_integration_integration_proto_depIdxs = nil
}
