// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.1
// 	protoc        v5.28.3
// source: gw/gw.proto

package gw

import (
	common "github.com/chirpstack/chirpstack/api/go/v4/common"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	_ "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type CodeRate int32

const (
	CodeRate_CR_UNDEFINED CodeRate = 0
	CodeRate_CR_4_5       CodeRate = 1 // LoRa
	CodeRate_CR_4_6       CodeRate = 2
	CodeRate_CR_4_7       CodeRate = 3
	CodeRate_CR_4_8       CodeRate = 4
	CodeRate_CR_3_8       CodeRate = 5 // LR-FHSS
	CodeRate_CR_2_6       CodeRate = 6
	CodeRate_CR_1_4       CodeRate = 7
	CodeRate_CR_1_6       CodeRate = 8
	CodeRate_CR_5_6       CodeRate = 9
	CodeRate_CR_LI_4_5    CodeRate = 10 // LoRa 2.4 gHz
	CodeRate_CR_LI_4_6    CodeRate = 11
	CodeRate_CR_LI_4_8    CodeRate = 12
)

// Enum value maps for CodeRate.
var (
	CodeRate_name = map[int32]string{
		0:  "CR_UNDEFINED",
		1:  "CR_4_5",
		2:  "CR_4_6",
		3:  "CR_4_7",
		4:  "CR_4_8",
		5:  "CR_3_8",
		6:  "CR_2_6",
		7:  "CR_1_4",
		8:  "CR_1_6",
		9:  "CR_5_6",
		10: "CR_LI_4_5",
		11: "CR_LI_4_6",
		12: "CR_LI_4_8",
	}
	CodeRate_value = map[string]int32{
		"CR_UNDEFINED": 0,
		"CR_4_5":       1,
		"CR_4_6":       2,
		"CR_4_7":       3,
		"CR_4_8":       4,
		"CR_3_8":       5,
		"CR_2_6":       6,
		"CR_1_4":       7,
		"CR_1_6":       8,
		"CR_5_6":       9,
		"CR_LI_4_5":    10,
		"CR_LI_4_6":    11,
		"CR_LI_4_8":    12,
	}
)

func (x CodeRate) Enum() *CodeRate {
	p := new(CodeRate)
	*p = x
	return p
}

func (x CodeRate) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CodeRate) Descriptor() protoreflect.EnumDescriptor {
	return file_gw_gw_proto_enumTypes[0].Descriptor()
}

func (CodeRate) Type() protoreflect.EnumType {
	return &file_gw_gw_proto_enumTypes[0]
}

func (x CodeRate) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CodeRate.Descriptor instead.
func (CodeRate) EnumDescriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{0}
}

type DownlinkTiming int32

const (
	// Send the downlink immediately.
	DownlinkTiming_IMMEDIATELY DownlinkTiming = 0
	// Send downlink at the given delay (based on provided context).
	DownlinkTiming_DELAY DownlinkTiming = 1
	// Send at given GPS epoch value.
	DownlinkTiming_GPS_EPOCH DownlinkTiming = 2
)

// Enum value maps for DownlinkTiming.
var (
	DownlinkTiming_name = map[int32]string{
		0: "IMMEDIATELY",
		1: "DELAY",
		2: "GPS_EPOCH",
	}
	DownlinkTiming_value = map[string]int32{
		"IMMEDIATELY": 0,
		"DELAY":       1,
		"GPS_EPOCH":   2,
	}
)

func (x DownlinkTiming) Enum() *DownlinkTiming {
	p := new(DownlinkTiming)
	*p = x
	return p
}

func (x DownlinkTiming) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DownlinkTiming) Descriptor() protoreflect.EnumDescriptor {
	return file_gw_gw_proto_enumTypes[1].Descriptor()
}

func (DownlinkTiming) Type() protoreflect.EnumType {
	return &file_gw_gw_proto_enumTypes[1]
}

func (x DownlinkTiming) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DownlinkTiming.Descriptor instead.
func (DownlinkTiming) EnumDescriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{1}
}

type FineTimestampType int32

const (
	// No fine-timestamp available.
	FineTimestampType_NONE FineTimestampType = 0
	// Encrypted fine-timestamp.
	FineTimestampType_ENCRYPTED FineTimestampType = 1
	// Plain fine-timestamp.
	FineTimestampType_PLAIN FineTimestampType = 2
)

// Enum value maps for FineTimestampType.
var (
	FineTimestampType_name = map[int32]string{
		0: "NONE",
		1: "ENCRYPTED",
		2: "PLAIN",
	}
	FineTimestampType_value = map[string]int32{
		"NONE":      0,
		"ENCRYPTED": 1,
		"PLAIN":     2,
	}
)

func (x FineTimestampType) Enum() *FineTimestampType {
	p := new(FineTimestampType)
	*p = x
	return p
}

func (x FineTimestampType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FineTimestampType) Descriptor() protoreflect.EnumDescriptor {
	return file_gw_gw_proto_enumTypes[2].Descriptor()
}

func (FineTimestampType) Type() protoreflect.EnumType {
	return &file_gw_gw_proto_enumTypes[2]
}

func (x FineTimestampType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FineTimestampType.Descriptor instead.
func (FineTimestampType) EnumDescriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{2}
}

type CRCStatus int32

const (
	// No CRC.
	CRCStatus_NO_CRC CRCStatus = 0
	// Bad CRC.
	CRCStatus_BAD_CRC CRCStatus = 1
	// CRC OK.
	CRCStatus_CRC_OK CRCStatus = 2
)

// Enum value maps for CRCStatus.
var (
	CRCStatus_name = map[int32]string{
		0: "NO_CRC",
		1: "BAD_CRC",
		2: "CRC_OK",
	}
	CRCStatus_value = map[string]int32{
		"NO_CRC":  0,
		"BAD_CRC": 1,
		"CRC_OK":  2,
	}
)

func (x CRCStatus) Enum() *CRCStatus {
	p := new(CRCStatus)
	*p = x
	return p
}

func (x CRCStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CRCStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_gw_gw_proto_enumTypes[3].Descriptor()
}

func (CRCStatus) Type() protoreflect.EnumType {
	return &file_gw_gw_proto_enumTypes[3]
}

func (x CRCStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CRCStatus.Descriptor instead.
func (CRCStatus) EnumDescriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{3}
}

type TxAckStatus int32

const (
	// Ignored (when a previous item was already emitted).
	TxAckStatus_IGNORED TxAckStatus = 0
	// Packet has been programmed for downlink.
	TxAckStatus_OK TxAckStatus = 1
	// Rejected because it was already too late to program this packet for
	// downlink.
	TxAckStatus_TOO_LATE TxAckStatus = 2
	// Rejected because downlink packet timestamp is too much in advance.
	TxAckStatus_TOO_EARLY TxAckStatus = 3
	// Rejected because there was already a packet programmed in requested
	// timeframe.
	TxAckStatus_COLLISION_PACKET TxAckStatus = 4
	// Rejected because there was already a beacon planned in requested timeframe.
	TxAckStatus_COLLISION_BEACON TxAckStatus = 5
	// Rejected because requested frequency is not supported by TX RF chain.
	TxAckStatus_TX_FREQ TxAckStatus = 6
	// Rejected because requested power is not supported by gateway.
	TxAckStatus_TX_POWER TxAckStatus = 7
	// Rejected because GPS is unlocked, so GPS timestamp cannot be used.
	TxAckStatus_GPS_UNLOCKED TxAckStatus = 8
	// Downlink queue is full.
	TxAckStatus_QUEUE_FULL TxAckStatus = 9
	// Internal error.
	TxAckStatus_INTERNAL_ERROR TxAckStatus = 10
	// Duty-cycle overflow.
	TxAckStatus_DUTY_CYCLE_OVERFLOW TxAckStatus = 11
)

// Enum value maps for TxAckStatus.
var (
	TxAckStatus_name = map[int32]string{
		0:  "IGNORED",
		1:  "OK",
		2:  "TOO_LATE",
		3:  "TOO_EARLY",
		4:  "COLLISION_PACKET",
		5:  "COLLISION_BEACON",
		6:  "TX_FREQ",
		7:  "TX_POWER",
		8:  "GPS_UNLOCKED",
		9:  "QUEUE_FULL",
		10: "INTERNAL_ERROR",
		11: "DUTY_CYCLE_OVERFLOW",
	}
	TxAckStatus_value = map[string]int32{
		"IGNORED":             0,
		"OK":                  1,
		"TOO_LATE":            2,
		"TOO_EARLY":           3,
		"COLLISION_PACKET":    4,
		"COLLISION_BEACON":    5,
		"TX_FREQ":             6,
		"TX_POWER":            7,
		"GPS_UNLOCKED":        8,
		"QUEUE_FULL":          9,
		"INTERNAL_ERROR":      10,
		"DUTY_CYCLE_OVERFLOW": 11,
	}
)

func (x TxAckStatus) Enum() *TxAckStatus {
	p := new(TxAckStatus)
	*p = x
	return p
}

func (x TxAckStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TxAckStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_gw_gw_proto_enumTypes[4].Descriptor()
}

func (TxAckStatus) Type() protoreflect.EnumType {
	return &file_gw_gw_proto_enumTypes[4]
}

func (x TxAckStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TxAckStatus.Descriptor instead.
func (TxAckStatus) EnumDescriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{4}
}

type ConnState_State int32

const (
	ConnState_OFFLINE ConnState_State = 0
	ConnState_ONLINE  ConnState_State = 1
)

// Enum value maps for ConnState_State.
var (
	ConnState_State_name = map[int32]string{
		0: "OFFLINE",
		1: "ONLINE",
	}
	ConnState_State_value = map[string]int32{
		"OFFLINE": 0,
		"ONLINE":  1,
	}
)

func (x ConnState_State) Enum() *ConnState_State {
	p := new(ConnState_State)
	*p = x
	return p
}

func (x ConnState_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConnState_State) Descriptor() protoreflect.EnumDescriptor {
	return file_gw_gw_proto_enumTypes[5].Descriptor()
}

func (ConnState_State) Type() protoreflect.EnumType {
	return &file_gw_gw_proto_enumTypes[5]
}

func (x ConnState_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConnState_State.Descriptor instead.
func (ConnState_State) EnumDescriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{34, 0}
}

type Modulation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Parameters:
	//
	//	*Modulation_Lora
	//	*Modulation_Fsk
	//	*Modulation_LrFhss
	Parameters isModulation_Parameters `protobuf_oneof:"parameters"`
}

func (x *Modulation) Reset() {
	*x = Modulation{}
	mi := &file_gw_gw_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Modulation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Modulation) ProtoMessage() {}

func (x *Modulation) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Modulation.ProtoReflect.Descriptor instead.
func (*Modulation) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{0}
}

func (m *Modulation) GetParameters() isModulation_Parameters {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (x *Modulation) GetLora() *LoraModulationInfo {
	if x, ok := x.GetParameters().(*Modulation_Lora); ok {
		return x.Lora
	}
	return nil
}

func (x *Modulation) GetFsk() *FskModulationInfo {
	if x, ok := x.GetParameters().(*Modulation_Fsk); ok {
		return x.Fsk
	}
	return nil
}

func (x *Modulation) GetLrFhss() *LrFhssModulationInfo {
	if x, ok := x.GetParameters().(*Modulation_LrFhss); ok {
		return x.LrFhss
	}
	return nil
}

type isModulation_Parameters interface {
	isModulation_Parameters()
}

type Modulation_Lora struct {
	// LoRa modulation information.
	Lora *LoraModulationInfo `protobuf:"bytes,3,opt,name=lora,proto3,oneof"`
}

type Modulation_Fsk struct {
	// FSK modulation information.
	Fsk *FskModulationInfo `protobuf:"bytes,4,opt,name=fsk,proto3,oneof"`
}

type Modulation_LrFhss struct {
	// LR-FHSS modulation information.
	LrFhss *LrFhssModulationInfo `protobuf:"bytes,5,opt,name=lr_fhss,json=lrFhss,proto3,oneof"`
}

func (*Modulation_Lora) isModulation_Parameters() {}

func (*Modulation_Fsk) isModulation_Parameters() {}

func (*Modulation_LrFhss) isModulation_Parameters() {}

type UplinkTxInfoLegacy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Frequency (Hz).
	Frequency uint32 `protobuf:"varint,1,opt,name=frequency,proto3" json:"frequency,omitempty"`
	// Modulation.
	Modulation common.Modulation `protobuf:"varint,2,opt,name=modulation,proto3,enum=common.Modulation" json:"modulation,omitempty"`
	// Types that are assignable to ModulationInfo:
	//
	//	*UplinkTxInfoLegacy_LoraModulationInfo
	//	*UplinkTxInfoLegacy_FskModulationInfo
	//	*UplinkTxInfoLegacy_LrFhssModulationInfo
	ModulationInfo isUplinkTxInfoLegacy_ModulationInfo `protobuf_oneof:"modulation_info"`
}

func (x *UplinkTxInfoLegacy) Reset() {
	*x = UplinkTxInfoLegacy{}
	mi := &file_gw_gw_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UplinkTxInfoLegacy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UplinkTxInfoLegacy) ProtoMessage() {}

func (x *UplinkTxInfoLegacy) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UplinkTxInfoLegacy.ProtoReflect.Descriptor instead.
func (*UplinkTxInfoLegacy) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{1}
}

func (x *UplinkTxInfoLegacy) GetFrequency() uint32 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *UplinkTxInfoLegacy) GetModulation() common.Modulation {
	if x != nil {
		return x.Modulation
	}
	return common.Modulation(0)
}

func (m *UplinkTxInfoLegacy) GetModulationInfo() isUplinkTxInfoLegacy_ModulationInfo {
	if m != nil {
		return m.ModulationInfo
	}
	return nil
}

func (x *UplinkTxInfoLegacy) GetLoraModulationInfo() *LoraModulationInfo {
	if x, ok := x.GetModulationInfo().(*UplinkTxInfoLegacy_LoraModulationInfo); ok {
		return x.LoraModulationInfo
	}
	return nil
}

func (x *UplinkTxInfoLegacy) GetFskModulationInfo() *FskModulationInfo {
	if x, ok := x.GetModulationInfo().(*UplinkTxInfoLegacy_FskModulationInfo); ok {
		return x.FskModulationInfo
	}
	return nil
}

func (x *UplinkTxInfoLegacy) GetLrFhssModulationInfo() *LrFhssModulationInfo {
	if x, ok := x.GetModulationInfo().(*UplinkTxInfoLegacy_LrFhssModulationInfo); ok {
		return x.LrFhssModulationInfo
	}
	return nil
}

type isUplinkTxInfoLegacy_ModulationInfo interface {
	isUplinkTxInfoLegacy_ModulationInfo()
}

type UplinkTxInfoLegacy_LoraModulationInfo struct {
	// LoRa modulation information.
	LoraModulationInfo *LoraModulationInfo `protobuf:"bytes,3,opt,name=lora_modulation_info,json=loraModulationInfo,proto3,oneof"`
}

type UplinkTxInfoLegacy_FskModulationInfo struct {
	// FSK modulation information.
	FskModulationInfo *FskModulationInfo `protobuf:"bytes,4,opt,name=fsk_modulation_info,json=fskModulationInfo,proto3,oneof"`
}

type UplinkTxInfoLegacy_LrFhssModulationInfo struct {
	// LR-FHSS modulation information.
	LrFhssModulationInfo *LrFhssModulationInfo `protobuf:"bytes,5,opt,name=lr_fhss_modulation_info,json=lrFhssModulationInfo,proto3,oneof"`
}

func (*UplinkTxInfoLegacy_LoraModulationInfo) isUplinkTxInfoLegacy_ModulationInfo() {}

func (*UplinkTxInfoLegacy_FskModulationInfo) isUplinkTxInfoLegacy_ModulationInfo() {}

func (*UplinkTxInfoLegacy_LrFhssModulationInfo) isUplinkTxInfoLegacy_ModulationInfo() {}

type UplinkTxInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Frequency (Hz).
	Frequency uint32 `protobuf:"varint,1,opt,name=frequency,proto3" json:"frequency,omitempty"`
	// Modulation.
	Modulation *Modulation `protobuf:"bytes,2,opt,name=modulation,proto3" json:"modulation,omitempty"`
}

func (x *UplinkTxInfo) Reset() {
	*x = UplinkTxInfo{}
	mi := &file_gw_gw_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UplinkTxInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UplinkTxInfo) ProtoMessage() {}

func (x *UplinkTxInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UplinkTxInfo.ProtoReflect.Descriptor instead.
func (*UplinkTxInfo) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{2}
}

func (x *UplinkTxInfo) GetFrequency() uint32 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *UplinkTxInfo) GetModulation() *Modulation {
	if x != nil {
		return x.Modulation
	}
	return nil
}

type LoraModulationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bandwidth.
	Bandwidth uint32 `protobuf:"varint,1,opt,name=bandwidth,proto3" json:"bandwidth,omitempty"`
	// Speading-factor.
	SpreadingFactor uint32 `protobuf:"varint,2,opt,name=spreading_factor,json=spreadingFactor,proto3" json:"spreading_factor,omitempty"`
	// Code-rate.
	CodeRateLegacy string `protobuf:"bytes,3,opt,name=code_rate_legacy,json=codeRateLegacy,proto3" json:"code_rate_legacy,omitempty"`
	// Code-rate.
	CodeRate CodeRate `protobuf:"varint,5,opt,name=code_rate,json=codeRate,proto3,enum=gw.CodeRate" json:"code_rate,omitempty"`
	// Polarization inversion.
	PolarizationInversion bool `protobuf:"varint,4,opt,name=polarization_inversion,json=polarizationInversion,proto3" json:"polarization_inversion,omitempty"`
	// Preamble length (for TX).
	Preamble uint32 `protobuf:"varint,6,opt,name=preamble,proto3" json:"preamble,omitempty"`
	//	No CRC (for TX).
	//
	// If true, do not send a CRC in the packet.
	NoCrc bool `protobuf:"varint,7,opt,name=no_crc,json=noCrc,proto3" json:"no_crc,omitempty"`
}

func (x *LoraModulationInfo) Reset() {
	*x = LoraModulationInfo{}
	mi := &file_gw_gw_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoraModulationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoraModulationInfo) ProtoMessage() {}

func (x *LoraModulationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoraModulationInfo.ProtoReflect.Descriptor instead.
func (*LoraModulationInfo) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{3}
}

func (x *LoraModulationInfo) GetBandwidth() uint32 {
	if x != nil {
		return x.Bandwidth
	}
	return 0
}

func (x *LoraModulationInfo) GetSpreadingFactor() uint32 {
	if x != nil {
		return x.SpreadingFactor
	}
	return 0
}

func (x *LoraModulationInfo) GetCodeRateLegacy() string {
	if x != nil {
		return x.CodeRateLegacy
	}
	return ""
}

func (x *LoraModulationInfo) GetCodeRate() CodeRate {
	if x != nil {
		return x.CodeRate
	}
	return CodeRate_CR_UNDEFINED
}

func (x *LoraModulationInfo) GetPolarizationInversion() bool {
	if x != nil {
		return x.PolarizationInversion
	}
	return false
}

func (x *LoraModulationInfo) GetPreamble() uint32 {
	if x != nil {
		return x.Preamble
	}
	return 0
}

func (x *LoraModulationInfo) GetNoCrc() bool {
	if x != nil {
		return x.NoCrc
	}
	return false
}

type FskModulationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Frequency deviation.
	FrequencyDeviation uint32 `protobuf:"varint,1,opt,name=frequency_deviation,json=frequencyDeviation,proto3" json:"frequency_deviation,omitempty"`
	// FSK datarate (bits / sec).
	Datarate uint32 `protobuf:"varint,2,opt,name=datarate,proto3" json:"datarate,omitempty"`
}

func (x *FskModulationInfo) Reset() {
	*x = FskModulationInfo{}
	mi := &file_gw_gw_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FskModulationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FskModulationInfo) ProtoMessage() {}

func (x *FskModulationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FskModulationInfo.ProtoReflect.Descriptor instead.
func (*FskModulationInfo) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{4}
}

func (x *FskModulationInfo) GetFrequencyDeviation() uint32 {
	if x != nil {
		return x.FrequencyDeviation
	}
	return 0
}

func (x *FskModulationInfo) GetDatarate() uint32 {
	if x != nil {
		return x.Datarate
	}
	return 0
}

type LrFhssModulationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operating channel width (OCW) in Hz.
	OperatingChannelWidth uint32 `protobuf:"varint,1,opt,name=operating_channel_width,json=operatingChannelWidth,proto3" json:"operating_channel_width,omitempty"`
	// Code-rate.
	// Deprecated: use code_rate.
	CodeRateLegacy string `protobuf:"bytes,2,opt,name=code_rate_legacy,json=codeRateLegacy,proto3" json:"code_rate_legacy,omitempty"`
	// Code-rate.
	CodeRate CodeRate `protobuf:"varint,4,opt,name=code_rate,json=codeRate,proto3,enum=gw.CodeRate" json:"code_rate,omitempty"`
	// Hopping grid number of steps.
	GridSteps uint32 `protobuf:"varint,3,opt,name=grid_steps,json=gridSteps,proto3" json:"grid_steps,omitempty"`
}

func (x *LrFhssModulationInfo) Reset() {
	*x = LrFhssModulationInfo{}
	mi := &file_gw_gw_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LrFhssModulationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LrFhssModulationInfo) ProtoMessage() {}

func (x *LrFhssModulationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LrFhssModulationInfo.ProtoReflect.Descriptor instead.
func (*LrFhssModulationInfo) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{5}
}

func (x *LrFhssModulationInfo) GetOperatingChannelWidth() uint32 {
	if x != nil {
		return x.OperatingChannelWidth
	}
	return 0
}

func (x *LrFhssModulationInfo) GetCodeRateLegacy() string {
	if x != nil {
		return x.CodeRateLegacy
	}
	return ""
}

func (x *LrFhssModulationInfo) GetCodeRate() CodeRate {
	if x != nil {
		return x.CodeRate
	}
	return CodeRate_CR_UNDEFINED
}

func (x *LrFhssModulationInfo) GetGridSteps() uint32 {
	if x != nil {
		return x.GridSteps
	}
	return 0
}

type EncryptedFineTimestamp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// AES key index used for encrypting the fine timestamp.
	AesKeyIndex uint32 `protobuf:"varint,1,opt,name=aes_key_index,json=aesKeyIndex,proto3" json:"aes_key_index,omitempty"`
	// Encrypted 'main' fine-timestamp (ns precision part of the timestamp).
	EncryptedNs []byte `protobuf:"bytes,2,opt,name=encrypted_ns,json=encryptedNs,proto3" json:"encrypted_ns,omitempty"`
	// FPGA ID.
	FpgaId []byte `protobuf:"bytes,3,opt,name=fpga_id,json=fpgaId,proto3" json:"fpga_id,omitempty"`
}

func (x *EncryptedFineTimestamp) Reset() {
	*x = EncryptedFineTimestamp{}
	mi := &file_gw_gw_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EncryptedFineTimestamp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EncryptedFineTimestamp) ProtoMessage() {}

func (x *EncryptedFineTimestamp) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EncryptedFineTimestamp.ProtoReflect.Descriptor instead.
func (*EncryptedFineTimestamp) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{6}
}

func (x *EncryptedFineTimestamp) GetAesKeyIndex() uint32 {
	if x != nil {
		return x.AesKeyIndex
	}
	return 0
}

func (x *EncryptedFineTimestamp) GetEncryptedNs() []byte {
	if x != nil {
		return x.EncryptedNs
	}
	return nil
}

func (x *EncryptedFineTimestamp) GetFpgaId() []byte {
	if x != nil {
		return x.FpgaId
	}
	return nil
}

type PlainFineTimestamp struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Full timestamp.
	Time *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=time,proto3" json:"time,omitempty"`
}

func (x *PlainFineTimestamp) Reset() {
	*x = PlainFineTimestamp{}
	mi := &file_gw_gw_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlainFineTimestamp) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlainFineTimestamp) ProtoMessage() {}

func (x *PlainFineTimestamp) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlainFineTimestamp.ProtoReflect.Descriptor instead.
func (*PlainFineTimestamp) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{7}
}

func (x *PlainFineTimestamp) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

type GatewayStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gateway ID.
	// Deprecated: use gateway_id.
	GatewayIdLegacy []byte `protobuf:"bytes,1,opt,name=gateway_id_legacy,json=gatewayIdLegacy,proto3" json:"gateway_id_legacy,omitempty"`
	// Gateway ID.
	GatewayId string `protobuf:"bytes,17,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// Gateway time.
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// Gateway location.
	Location *common.Location `protobuf:"bytes,3,opt,name=location,proto3" json:"location,omitempty"`
	// Gateway configuration version (this maps to the config_version sent
	// by ChirpStack to the gateway).
	ConfigVersion string `protobuf:"bytes,4,opt,name=config_version,json=configVersion,proto3" json:"config_version,omitempty"`
	// Number of radio packets received.
	RxPacketsReceived uint32 `protobuf:"varint,5,opt,name=rx_packets_received,json=rxPacketsReceived,proto3" json:"rx_packets_received,omitempty"`
	// Number of radio packets received with valid PHY CRC.
	RxPacketsReceivedOk uint32 `protobuf:"varint,6,opt,name=rx_packets_received_ok,json=rxPacketsReceivedOk,proto3" json:"rx_packets_received_ok,omitempty"`
	// Number of downlink packets received for transmission.
	TxPacketsReceived uint32 `protobuf:"varint,7,opt,name=tx_packets_received,json=txPacketsReceived,proto3" json:"tx_packets_received,omitempty"`
	// Number of downlink packets emitted.
	TxPacketsEmitted uint32 `protobuf:"varint,8,opt,name=tx_packets_emitted,json=txPacketsEmitted,proto3" json:"tx_packets_emitted,omitempty"`
	// Additional gateway meta-data.
	Metadata map[string]string `protobuf:"bytes,10,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Tx packets per frequency.
	TxPacketsPerFrequency map[uint32]uint32 `protobuf:"bytes,12,rep,name=tx_packets_per_frequency,json=txPacketsPerFrequency,proto3" json:"tx_packets_per_frequency,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Rx packets per frequency.
	RxPacketsPerFrequency map[uint32]uint32 `protobuf:"bytes,13,rep,name=rx_packets_per_frequency,json=rxPacketsPerFrequency,proto3" json:"rx_packets_per_frequency,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Tx packets per modulation parameters.
	TxPacketsPerModulation []*PerModulationCount `protobuf:"bytes,14,rep,name=tx_packets_per_modulation,json=txPacketsPerModulation,proto3" json:"tx_packets_per_modulation,omitempty"`
	// Rx packets per modulation parameters.
	RxPacketsPerModulation []*PerModulationCount `protobuf:"bytes,15,rep,name=rx_packets_per_modulation,json=rxPacketsPerModulation,proto3" json:"rx_packets_per_modulation,omitempty"`
	// Tx packets per status.
	TxPacketsPerStatus map[string]uint32 `protobuf:"bytes,16,rep,name=tx_packets_per_status,json=txPacketsPerStatus,proto3" json:"tx_packets_per_status,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Duty-cycle statistics (Concentratord only).
	DutyCycleStats *DutyCycleStats `protobuf:"bytes,18,opt,name=duty_cycle_stats,json=dutyCycleStats,proto3" json:"duty_cycle_stats,omitempty"`
}

func (x *GatewayStats) Reset() {
	*x = GatewayStats{}
	mi := &file_gw_gw_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GatewayStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayStats) ProtoMessage() {}

func (x *GatewayStats) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayStats.ProtoReflect.Descriptor instead.
func (*GatewayStats) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{8}
}

func (x *GatewayStats) GetGatewayIdLegacy() []byte {
	if x != nil {
		return x.GatewayIdLegacy
	}
	return nil
}

func (x *GatewayStats) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

func (x *GatewayStats) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *GatewayStats) GetLocation() *common.Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *GatewayStats) GetConfigVersion() string {
	if x != nil {
		return x.ConfigVersion
	}
	return ""
}

func (x *GatewayStats) GetRxPacketsReceived() uint32 {
	if x != nil {
		return x.RxPacketsReceived
	}
	return 0
}

func (x *GatewayStats) GetRxPacketsReceivedOk() uint32 {
	if x != nil {
		return x.RxPacketsReceivedOk
	}
	return 0
}

func (x *GatewayStats) GetTxPacketsReceived() uint32 {
	if x != nil {
		return x.TxPacketsReceived
	}
	return 0
}

func (x *GatewayStats) GetTxPacketsEmitted() uint32 {
	if x != nil {
		return x.TxPacketsEmitted
	}
	return 0
}

func (x *GatewayStats) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *GatewayStats) GetTxPacketsPerFrequency() map[uint32]uint32 {
	if x != nil {
		return x.TxPacketsPerFrequency
	}
	return nil
}

func (x *GatewayStats) GetRxPacketsPerFrequency() map[uint32]uint32 {
	if x != nil {
		return x.RxPacketsPerFrequency
	}
	return nil
}

func (x *GatewayStats) GetTxPacketsPerModulation() []*PerModulationCount {
	if x != nil {
		return x.TxPacketsPerModulation
	}
	return nil
}

func (x *GatewayStats) GetRxPacketsPerModulation() []*PerModulationCount {
	if x != nil {
		return x.RxPacketsPerModulation
	}
	return nil
}

func (x *GatewayStats) GetTxPacketsPerStatus() map[string]uint32 {
	if x != nil {
		return x.TxPacketsPerStatus
	}
	return nil
}

func (x *GatewayStats) GetDutyCycleStats() *DutyCycleStats {
	if x != nil {
		return x.DutyCycleStats
	}
	return nil
}

type PerModulationCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Modulation.
	Modulation *Modulation `protobuf:"bytes,1,opt,name=modulation,proto3" json:"modulation,omitempty"`
	// Count.
	Count uint32 `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
}

func (x *PerModulationCount) Reset() {
	*x = PerModulationCount{}
	mi := &file_gw_gw_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PerModulationCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PerModulationCount) ProtoMessage() {}

func (x *PerModulationCount) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PerModulationCount.ProtoReflect.Descriptor instead.
func (*PerModulationCount) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{9}
}

func (x *PerModulationCount) GetModulation() *Modulation {
	if x != nil {
		return x.Modulation
	}
	return nil
}

func (x *PerModulationCount) GetCount() uint32 {
	if x != nil {
		return x.Count
	}
	return 0
}

type DutyCycleStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Implemented regulation.
	Regulation common.Regulation `protobuf:"varint,1,opt,name=regulation,proto3,enum=common.Regulation" json:"regulation,omitempty"`
	// Tracking window.
	Window *durationpb.Duration `protobuf:"bytes,2,opt,name=window,proto3" json:"window,omitempty"`
	// Bands.
	Bands []*DutyCycleBand `protobuf:"bytes,3,rep,name=bands,proto3" json:"bands,omitempty"`
}

func (x *DutyCycleStats) Reset() {
	*x = DutyCycleStats{}
	mi := &file_gw_gw_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DutyCycleStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DutyCycleStats) ProtoMessage() {}

func (x *DutyCycleStats) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DutyCycleStats.ProtoReflect.Descriptor instead.
func (*DutyCycleStats) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{10}
}

func (x *DutyCycleStats) GetRegulation() common.Regulation {
	if x != nil {
		return x.Regulation
	}
	return common.Regulation(0)
}

func (x *DutyCycleStats) GetWindow() *durationpb.Duration {
	if x != nil {
		return x.Window
	}
	return nil
}

func (x *DutyCycleStats) GetBands() []*DutyCycleBand {
	if x != nil {
		return x.Bands
	}
	return nil
}

type DutyCycleBand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Band name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Min frequency for this band.
	FrequencyMin uint32 `protobuf:"varint,2,opt,name=frequency_min,json=frequencyMin,proto3" json:"frequency_min,omitempty"`
	// Max frequency for this band.
	FrequencyMax uint32 `protobuf:"varint,3,opt,name=frequency_max,json=frequencyMax,proto3" json:"frequency_max,omitempty"`
	// Max. allowed load.
	LoadMax *durationpb.Duration `protobuf:"bytes,4,opt,name=load_max,json=loadMax,proto3" json:"load_max,omitempty"`
	// Tracked load (within the window of the regionlation).
	LoadTracked *durationpb.Duration `protobuf:"bytes,5,opt,name=load_tracked,json=loadTracked,proto3" json:"load_tracked,omitempty"`
}

func (x *DutyCycleBand) Reset() {
	*x = DutyCycleBand{}
	mi := &file_gw_gw_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DutyCycleBand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DutyCycleBand) ProtoMessage() {}

func (x *DutyCycleBand) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DutyCycleBand.ProtoReflect.Descriptor instead.
func (*DutyCycleBand) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{11}
}

func (x *DutyCycleBand) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DutyCycleBand) GetFrequencyMin() uint32 {
	if x != nil {
		return x.FrequencyMin
	}
	return 0
}

func (x *DutyCycleBand) GetFrequencyMax() uint32 {
	if x != nil {
		return x.FrequencyMax
	}
	return 0
}

func (x *DutyCycleBand) GetLoadMax() *durationpb.Duration {
	if x != nil {
		return x.LoadMax
	}
	return nil
}

func (x *DutyCycleBand) GetLoadTracked() *durationpb.Duration {
	if x != nil {
		return x.LoadTracked
	}
	return nil
}

type UplinkRxInfoLegacy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gateway ID.
	GatewayId []byte `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// RX time (only set when the gateway has a GPS module).
	Time *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=time,proto3" json:"time,omitempty"`
	// RX time since GPS epoch (only set when the gateway has a GPS module).
	TimeSinceGpsEpoch *durationpb.Duration `protobuf:"bytes,3,opt,name=time_since_gps_epoch,json=timeSinceGpsEpoch,proto3" json:"time_since_gps_epoch,omitempty"`
	// RSSI.
	Rssi int32 `protobuf:"varint,5,opt,name=rssi,proto3" json:"rssi,omitempty"`
	// LoRa SNR.
	LoraSnr float64 `protobuf:"fixed64,6,opt,name=lora_snr,json=loraSnr,proto3" json:"lora_snr,omitempty"`
	// Channel.
	Channel uint32 `protobuf:"varint,7,opt,name=channel,proto3" json:"channel,omitempty"`
	// RF Chain.
	RfChain uint32 `protobuf:"varint,8,opt,name=rf_chain,json=rfChain,proto3" json:"rf_chain,omitempty"`
	// Board.
	Board uint32 `protobuf:"varint,9,opt,name=board,proto3" json:"board,omitempty"`
	// Antenna.
	Antenna uint32 `protobuf:"varint,10,opt,name=antenna,proto3" json:"antenna,omitempty"`
	// Location.
	Location *common.Location `protobuf:"bytes,11,opt,name=location,proto3" json:"location,omitempty"`
	// Fine-timestamp type.
	FineTimestampType FineTimestampType `protobuf:"varint,12,opt,name=fine_timestamp_type,json=fineTimestampType,proto3,enum=gw.FineTimestampType" json:"fine_timestamp_type,omitempty"`
	// Fine-timestamp data.
	//
	// Types that are assignable to FineTimestamp:
	//
	//	*UplinkRxInfoLegacy_EncryptedFineTimestamp
	//	*UplinkRxInfoLegacy_PlainFineTimestamp
	FineTimestamp isUplinkRxInfoLegacy_FineTimestamp `protobuf_oneof:"fine_timestamp"`
	// Gateway specific context.
	Context []byte `protobuf:"bytes,15,opt,name=context,proto3" json:"context,omitempty"`
	// Uplink ID (UUID bytes).
	// Unique and random ID which can be used to correlate the uplink across
	// multiple logs.
	UplinkId []byte `protobuf:"bytes,16,opt,name=uplink_id,json=uplinkId,proto3" json:"uplink_id,omitempty"`
	// CRC status.
	CrcStatus CRCStatus `protobuf:"varint,17,opt,name=crc_status,json=crcStatus,proto3,enum=gw.CRCStatus" json:"crc_status,omitempty"`
	// Optional meta-data map.
	Metadata map[string]string `protobuf:"bytes,18,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *UplinkRxInfoLegacy) Reset() {
	*x = UplinkRxInfoLegacy{}
	mi := &file_gw_gw_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UplinkRxInfoLegacy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UplinkRxInfoLegacy) ProtoMessage() {}

func (x *UplinkRxInfoLegacy) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UplinkRxInfoLegacy.ProtoReflect.Descriptor instead.
func (*UplinkRxInfoLegacy) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{12}
}

func (x *UplinkRxInfoLegacy) GetGatewayId() []byte {
	if x != nil {
		return x.GatewayId
	}
	return nil
}

func (x *UplinkRxInfoLegacy) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *UplinkRxInfoLegacy) GetTimeSinceGpsEpoch() *durationpb.Duration {
	if x != nil {
		return x.TimeSinceGpsEpoch
	}
	return nil
}

func (x *UplinkRxInfoLegacy) GetRssi() int32 {
	if x != nil {
		return x.Rssi
	}
	return 0
}

func (x *UplinkRxInfoLegacy) GetLoraSnr() float64 {
	if x != nil {
		return x.LoraSnr
	}
	return 0
}

func (x *UplinkRxInfoLegacy) GetChannel() uint32 {
	if x != nil {
		return x.Channel
	}
	return 0
}

func (x *UplinkRxInfoLegacy) GetRfChain() uint32 {
	if x != nil {
		return x.RfChain
	}
	return 0
}

func (x *UplinkRxInfoLegacy) GetBoard() uint32 {
	if x != nil {
		return x.Board
	}
	return 0
}

func (x *UplinkRxInfoLegacy) GetAntenna() uint32 {
	if x != nil {
		return x.Antenna
	}
	return 0
}

func (x *UplinkRxInfoLegacy) GetLocation() *common.Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *UplinkRxInfoLegacy) GetFineTimestampType() FineTimestampType {
	if x != nil {
		return x.FineTimestampType
	}
	return FineTimestampType_NONE
}

func (m *UplinkRxInfoLegacy) GetFineTimestamp() isUplinkRxInfoLegacy_FineTimestamp {
	if m != nil {
		return m.FineTimestamp
	}
	return nil
}

func (x *UplinkRxInfoLegacy) GetEncryptedFineTimestamp() *EncryptedFineTimestamp {
	if x, ok := x.GetFineTimestamp().(*UplinkRxInfoLegacy_EncryptedFineTimestamp); ok {
		return x.EncryptedFineTimestamp
	}
	return nil
}

func (x *UplinkRxInfoLegacy) GetPlainFineTimestamp() *PlainFineTimestamp {
	if x, ok := x.GetFineTimestamp().(*UplinkRxInfoLegacy_PlainFineTimestamp); ok {
		return x.PlainFineTimestamp
	}
	return nil
}

func (x *UplinkRxInfoLegacy) GetContext() []byte {
	if x != nil {
		return x.Context
	}
	return nil
}

func (x *UplinkRxInfoLegacy) GetUplinkId() []byte {
	if x != nil {
		return x.UplinkId
	}
	return nil
}

func (x *UplinkRxInfoLegacy) GetCrcStatus() CRCStatus {
	if x != nil {
		return x.CrcStatus
	}
	return CRCStatus_NO_CRC
}

func (x *UplinkRxInfoLegacy) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

type isUplinkRxInfoLegacy_FineTimestamp interface {
	isUplinkRxInfoLegacy_FineTimestamp()
}

type UplinkRxInfoLegacy_EncryptedFineTimestamp struct {
	// Encrypted fine-timestamp data.
	EncryptedFineTimestamp *EncryptedFineTimestamp `protobuf:"bytes,13,opt,name=encrypted_fine_timestamp,json=encryptedFineTimestamp,proto3,oneof"`
}

type UplinkRxInfoLegacy_PlainFineTimestamp struct {
	// Plain fine-timestamp data.
	PlainFineTimestamp *PlainFineTimestamp `protobuf:"bytes,14,opt,name=plain_fine_timestamp,json=plainFineTimestamp,proto3,oneof"`
}

func (*UplinkRxInfoLegacy_EncryptedFineTimestamp) isUplinkRxInfoLegacy_FineTimestamp() {}

func (*UplinkRxInfoLegacy_PlainFineTimestamp) isUplinkRxInfoLegacy_FineTimestamp() {}

type UplinkRxInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gateway ID.
	GatewayId string `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// Uplink ID.
	UplinkId uint32 `protobuf:"varint,2,opt,name=uplink_id,json=uplinkId,proto3" json:"uplink_id,omitempty"`
	// Gateway RX time (set if the gateway has a GNSS module).
	GwTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=gw_time,json=gwTime,proto3" json:"gw_time,omitempty"`
	// Network Server RX time (set by the NS on receiving the uplink).
	NsTime *timestamppb.Timestamp `protobuf:"bytes,17,opt,name=ns_time,json=nsTime,proto3" json:"ns_time,omitempty"`
	// RX time as time since GPS epoch (set if the gateway has a GNSS module).
	TimeSinceGpsEpoch *durationpb.Duration `protobuf:"bytes,4,opt,name=time_since_gps_epoch,json=timeSinceGpsEpoch,proto3" json:"time_since_gps_epoch,omitempty"`
	// Fine-timestamp.
	// This timestamp can be used for TDOA based geolocation.
	FineTimeSinceGpsEpoch *durationpb.Duration `protobuf:"bytes,5,opt,name=fine_time_since_gps_epoch,json=fineTimeSinceGpsEpoch,proto3" json:"fine_time_since_gps_epoch,omitempty"`
	// RSSI.
	Rssi int32 `protobuf:"varint,6,opt,name=rssi,proto3" json:"rssi,omitempty"`
	// SNR.
	// Note: only available for LoRa modulation.
	Snr float32 `protobuf:"fixed32,7,opt,name=snr,proto3" json:"snr,omitempty"`
	// Channel.
	Channel uint32 `protobuf:"varint,8,opt,name=channel,proto3" json:"channel,omitempty"`
	// RF chain.
	RfChain uint32 `protobuf:"varint,9,opt,name=rf_chain,json=rfChain,proto3" json:"rf_chain,omitempty"`
	// Board.
	Board uint32 `protobuf:"varint,10,opt,name=board,proto3" json:"board,omitempty"`
	// Antenna.
	Antenna uint32 `protobuf:"varint,11,opt,name=antenna,proto3" json:"antenna,omitempty"`
	// Location.
	Location *common.Location `protobuf:"bytes,12,opt,name=location,proto3" json:"location,omitempty"`
	// Gateway specific context.
	// This value must be returned to the gateway on (Class-A) downlink.
	Context []byte `protobuf:"bytes,13,opt,name=context,proto3" json:"context,omitempty"`
	// Additional gateway meta-data.
	Metadata map[string]string `protobuf:"bytes,15,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// CRC status.
	CrcStatus CRCStatus `protobuf:"varint,16,opt,name=crc_status,json=crcStatus,proto3,enum=gw.CRCStatus" json:"crc_status,omitempty"`
}

func (x *UplinkRxInfo) Reset() {
	*x = UplinkRxInfo{}
	mi := &file_gw_gw_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UplinkRxInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UplinkRxInfo) ProtoMessage() {}

func (x *UplinkRxInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UplinkRxInfo.ProtoReflect.Descriptor instead.
func (*UplinkRxInfo) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{13}
}

func (x *UplinkRxInfo) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

func (x *UplinkRxInfo) GetUplinkId() uint32 {
	if x != nil {
		return x.UplinkId
	}
	return 0
}

func (x *UplinkRxInfo) GetGwTime() *timestamppb.Timestamp {
	if x != nil {
		return x.GwTime
	}
	return nil
}

func (x *UplinkRxInfo) GetNsTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NsTime
	}
	return nil
}

func (x *UplinkRxInfo) GetTimeSinceGpsEpoch() *durationpb.Duration {
	if x != nil {
		return x.TimeSinceGpsEpoch
	}
	return nil
}

func (x *UplinkRxInfo) GetFineTimeSinceGpsEpoch() *durationpb.Duration {
	if x != nil {
		return x.FineTimeSinceGpsEpoch
	}
	return nil
}

func (x *UplinkRxInfo) GetRssi() int32 {
	if x != nil {
		return x.Rssi
	}
	return 0
}

func (x *UplinkRxInfo) GetSnr() float32 {
	if x != nil {
		return x.Snr
	}
	return 0
}

func (x *UplinkRxInfo) GetChannel() uint32 {
	if x != nil {
		return x.Channel
	}
	return 0
}

func (x *UplinkRxInfo) GetRfChain() uint32 {
	if x != nil {
		return x.RfChain
	}
	return 0
}

func (x *UplinkRxInfo) GetBoard() uint32 {
	if x != nil {
		return x.Board
	}
	return 0
}

func (x *UplinkRxInfo) GetAntenna() uint32 {
	if x != nil {
		return x.Antenna
	}
	return 0
}

func (x *UplinkRxInfo) GetLocation() *common.Location {
	if x != nil {
		return x.Location
	}
	return nil
}

func (x *UplinkRxInfo) GetContext() []byte {
	if x != nil {
		return x.Context
	}
	return nil
}

func (x *UplinkRxInfo) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *UplinkRxInfo) GetCrcStatus() CRCStatus {
	if x != nil {
		return x.CrcStatus
	}
	return CRCStatus_NO_CRC
}

type DownlinkTxInfoLegacy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gateway ID.
	// Deprecated: replaced by gateway_id in DownlinkFrame.
	GatewayId []byte `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// TX frequency (in Hz).
	Frequency uint32 `protobuf:"varint,5,opt,name=frequency,proto3" json:"frequency,omitempty"`
	// TX power (in dBm EIRP).
	Power int32 `protobuf:"varint,6,opt,name=power,proto3" json:"power,omitempty"`
	// Modulation.
	Modulation common.Modulation `protobuf:"varint,7,opt,name=modulation,proto3,enum=common.Modulation" json:"modulation,omitempty"`
	// Types that are assignable to ModulationInfo:
	//
	//	*DownlinkTxInfoLegacy_LoraModulationInfo
	//	*DownlinkTxInfoLegacy_FskModulationInfo
	ModulationInfo isDownlinkTxInfoLegacy_ModulationInfo `protobuf_oneof:"modulation_info"`
	// The board identifier for emitting the frame.
	Board uint32 `protobuf:"varint,10,opt,name=board,proto3" json:"board,omitempty"`
	// The antenna identifier for emitting the frame.
	Antenna uint32 `protobuf:"varint,11,opt,name=antenna,proto3" json:"antenna,omitempty"`
	// Timing defines the downlink timing to use.
	Timing DownlinkTiming `protobuf:"varint,12,opt,name=timing,proto3,enum=gw.DownlinkTiming" json:"timing,omitempty"`
	// Types that are assignable to TimingInfo:
	//
	//	*DownlinkTxInfoLegacy_ImmediatelyTimingInfo
	//	*DownlinkTxInfoLegacy_DelayTimingInfo
	//	*DownlinkTxInfoLegacy_GpsEpochTimingInfo
	TimingInfo isDownlinkTxInfoLegacy_TimingInfo `protobuf_oneof:"timing_info"`
	// Gateway specific context.
	// In case of a Class-A downlink, this contains a copy of the uplink context.
	Context []byte `protobuf:"bytes,16,opt,name=context,proto3" json:"context,omitempty"`
}

func (x *DownlinkTxInfoLegacy) Reset() {
	*x = DownlinkTxInfoLegacy{}
	mi := &file_gw_gw_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DownlinkTxInfoLegacy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownlinkTxInfoLegacy) ProtoMessage() {}

func (x *DownlinkTxInfoLegacy) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownlinkTxInfoLegacy.ProtoReflect.Descriptor instead.
func (*DownlinkTxInfoLegacy) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{14}
}

func (x *DownlinkTxInfoLegacy) GetGatewayId() []byte {
	if x != nil {
		return x.GatewayId
	}
	return nil
}

func (x *DownlinkTxInfoLegacy) GetFrequency() uint32 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *DownlinkTxInfoLegacy) GetPower() int32 {
	if x != nil {
		return x.Power
	}
	return 0
}

func (x *DownlinkTxInfoLegacy) GetModulation() common.Modulation {
	if x != nil {
		return x.Modulation
	}
	return common.Modulation(0)
}

func (m *DownlinkTxInfoLegacy) GetModulationInfo() isDownlinkTxInfoLegacy_ModulationInfo {
	if m != nil {
		return m.ModulationInfo
	}
	return nil
}

func (x *DownlinkTxInfoLegacy) GetLoraModulationInfo() *LoraModulationInfo {
	if x, ok := x.GetModulationInfo().(*DownlinkTxInfoLegacy_LoraModulationInfo); ok {
		return x.LoraModulationInfo
	}
	return nil
}

func (x *DownlinkTxInfoLegacy) GetFskModulationInfo() *FskModulationInfo {
	if x, ok := x.GetModulationInfo().(*DownlinkTxInfoLegacy_FskModulationInfo); ok {
		return x.FskModulationInfo
	}
	return nil
}

func (x *DownlinkTxInfoLegacy) GetBoard() uint32 {
	if x != nil {
		return x.Board
	}
	return 0
}

func (x *DownlinkTxInfoLegacy) GetAntenna() uint32 {
	if x != nil {
		return x.Antenna
	}
	return 0
}

func (x *DownlinkTxInfoLegacy) GetTiming() DownlinkTiming {
	if x != nil {
		return x.Timing
	}
	return DownlinkTiming_IMMEDIATELY
}

func (m *DownlinkTxInfoLegacy) GetTimingInfo() isDownlinkTxInfoLegacy_TimingInfo {
	if m != nil {
		return m.TimingInfo
	}
	return nil
}

func (x *DownlinkTxInfoLegacy) GetImmediatelyTimingInfo() *ImmediatelyTimingInfo {
	if x, ok := x.GetTimingInfo().(*DownlinkTxInfoLegacy_ImmediatelyTimingInfo); ok {
		return x.ImmediatelyTimingInfo
	}
	return nil
}

func (x *DownlinkTxInfoLegacy) GetDelayTimingInfo() *DelayTimingInfo {
	if x, ok := x.GetTimingInfo().(*DownlinkTxInfoLegacy_DelayTimingInfo); ok {
		return x.DelayTimingInfo
	}
	return nil
}

func (x *DownlinkTxInfoLegacy) GetGpsEpochTimingInfo() *GPSEpochTimingInfo {
	if x, ok := x.GetTimingInfo().(*DownlinkTxInfoLegacy_GpsEpochTimingInfo); ok {
		return x.GpsEpochTimingInfo
	}
	return nil
}

func (x *DownlinkTxInfoLegacy) GetContext() []byte {
	if x != nil {
		return x.Context
	}
	return nil
}

type isDownlinkTxInfoLegacy_ModulationInfo interface {
	isDownlinkTxInfoLegacy_ModulationInfo()
}

type DownlinkTxInfoLegacy_LoraModulationInfo struct {
	// LoRa modulation information.
	LoraModulationInfo *LoraModulationInfo `protobuf:"bytes,8,opt,name=lora_modulation_info,json=loraModulationInfo,proto3,oneof"`
}

type DownlinkTxInfoLegacy_FskModulationInfo struct {
	// FSK modulation information.
	FskModulationInfo *FskModulationInfo `protobuf:"bytes,9,opt,name=fsk_modulation_info,json=fskModulationInfo,proto3,oneof"`
}

func (*DownlinkTxInfoLegacy_LoraModulationInfo) isDownlinkTxInfoLegacy_ModulationInfo() {}

func (*DownlinkTxInfoLegacy_FskModulationInfo) isDownlinkTxInfoLegacy_ModulationInfo() {}

type isDownlinkTxInfoLegacy_TimingInfo interface {
	isDownlinkTxInfoLegacy_TimingInfo()
}

type DownlinkTxInfoLegacy_ImmediatelyTimingInfo struct {
	// Immediately timing information.
	ImmediatelyTimingInfo *ImmediatelyTimingInfo `protobuf:"bytes,13,opt,name=immediately_timing_info,json=immediatelyTimingInfo,proto3,oneof"`
}

type DownlinkTxInfoLegacy_DelayTimingInfo struct {
	// Context based delay timing information.
	DelayTimingInfo *DelayTimingInfo `protobuf:"bytes,14,opt,name=delay_timing_info,json=delayTimingInfo,proto3,oneof"`
}

type DownlinkTxInfoLegacy_GpsEpochTimingInfo struct {
	// GPS Epoch timing information.
	GpsEpochTimingInfo *GPSEpochTimingInfo `protobuf:"bytes,15,opt,name=gps_epoch_timing_info,json=gpsEpochTimingInfo,proto3,oneof"`
}

func (*DownlinkTxInfoLegacy_ImmediatelyTimingInfo) isDownlinkTxInfoLegacy_TimingInfo() {}

func (*DownlinkTxInfoLegacy_DelayTimingInfo) isDownlinkTxInfoLegacy_TimingInfo() {}

func (*DownlinkTxInfoLegacy_GpsEpochTimingInfo) isDownlinkTxInfoLegacy_TimingInfo() {}

type DownlinkTxInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// TX frequency (in Hz).
	Frequency uint32 `protobuf:"varint,1,opt,name=frequency,proto3" json:"frequency,omitempty"`
	// TX power (in dBm EIRP).
	Power int32 `protobuf:"varint,2,opt,name=power,proto3" json:"power,omitempty"`
	// Modulation.
	Modulation *Modulation `protobuf:"bytes,3,opt,name=modulation,proto3" json:"modulation,omitempty"`
	// The board identifier for emitting the frame.
	Board uint32 `protobuf:"varint,4,opt,name=board,proto3" json:"board,omitempty"`
	// The antenna identifier for emitting the frame.
	Antenna uint32 `protobuf:"varint,5,opt,name=antenna,proto3" json:"antenna,omitempty"`
	// Timing.
	Timing *Timing `protobuf:"bytes,6,opt,name=timing,proto3" json:"timing,omitempty"`
	// Gateway specific context.
	// In case of a Class-A downlink, this contains a copy of the uplink context.
	Context []byte `protobuf:"bytes,7,opt,name=context,proto3" json:"context,omitempty"`
}

func (x *DownlinkTxInfo) Reset() {
	*x = DownlinkTxInfo{}
	mi := &file_gw_gw_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DownlinkTxInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownlinkTxInfo) ProtoMessage() {}

func (x *DownlinkTxInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownlinkTxInfo.ProtoReflect.Descriptor instead.
func (*DownlinkTxInfo) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{15}
}

func (x *DownlinkTxInfo) GetFrequency() uint32 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *DownlinkTxInfo) GetPower() int32 {
	if x != nil {
		return x.Power
	}
	return 0
}

func (x *DownlinkTxInfo) GetModulation() *Modulation {
	if x != nil {
		return x.Modulation
	}
	return nil
}

func (x *DownlinkTxInfo) GetBoard() uint32 {
	if x != nil {
		return x.Board
	}
	return 0
}

func (x *DownlinkTxInfo) GetAntenna() uint32 {
	if x != nil {
		return x.Antenna
	}
	return 0
}

func (x *DownlinkTxInfo) GetTiming() *Timing {
	if x != nil {
		return x.Timing
	}
	return nil
}

func (x *DownlinkTxInfo) GetContext() []byte {
	if x != nil {
		return x.Context
	}
	return nil
}

type Timing struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Parameters:
	//
	//	*Timing_Immediately
	//	*Timing_Delay
	//	*Timing_GpsEpoch
	Parameters isTiming_Parameters `protobuf_oneof:"parameters"`
}

func (x *Timing) Reset() {
	*x = Timing{}
	mi := &file_gw_gw_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Timing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Timing) ProtoMessage() {}

func (x *Timing) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Timing.ProtoReflect.Descriptor instead.
func (*Timing) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{16}
}

func (m *Timing) GetParameters() isTiming_Parameters {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (x *Timing) GetImmediately() *ImmediatelyTimingInfo {
	if x, ok := x.GetParameters().(*Timing_Immediately); ok {
		return x.Immediately
	}
	return nil
}

func (x *Timing) GetDelay() *DelayTimingInfo {
	if x, ok := x.GetParameters().(*Timing_Delay); ok {
		return x.Delay
	}
	return nil
}

func (x *Timing) GetGpsEpoch() *GPSEpochTimingInfo {
	if x, ok := x.GetParameters().(*Timing_GpsEpoch); ok {
		return x.GpsEpoch
	}
	return nil
}

type isTiming_Parameters interface {
	isTiming_Parameters()
}

type Timing_Immediately struct {
	// Immediately timing information.
	Immediately *ImmediatelyTimingInfo `protobuf:"bytes,1,opt,name=immediately,proto3,oneof"`
}

type Timing_Delay struct {
	// Context based delay timing information.
	Delay *DelayTimingInfo `protobuf:"bytes,2,opt,name=delay,proto3,oneof"`
}

type Timing_GpsEpoch struct {
	// GPS Epoch timing information.
	GpsEpoch *GPSEpochTimingInfo `protobuf:"bytes,3,opt,name=gps_epoch,json=gpsEpoch,proto3,oneof"`
}

func (*Timing_Immediately) isTiming_Parameters() {}

func (*Timing_Delay) isTiming_Parameters() {}

func (*Timing_GpsEpoch) isTiming_Parameters() {}

type ImmediatelyTimingInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ImmediatelyTimingInfo) Reset() {
	*x = ImmediatelyTimingInfo{}
	mi := &file_gw_gw_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImmediatelyTimingInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImmediatelyTimingInfo) ProtoMessage() {}

func (x *ImmediatelyTimingInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImmediatelyTimingInfo.ProtoReflect.Descriptor instead.
func (*ImmediatelyTimingInfo) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{17}
}

type DelayTimingInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Delay (duration).
	// The delay will be added to the gateway internal timing, provided by the
	// context object.
	Delay *durationpb.Duration `protobuf:"bytes,1,opt,name=delay,proto3" json:"delay,omitempty"`
}

func (x *DelayTimingInfo) Reset() {
	*x = DelayTimingInfo{}
	mi := &file_gw_gw_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DelayTimingInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DelayTimingInfo) ProtoMessage() {}

func (x *DelayTimingInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DelayTimingInfo.ProtoReflect.Descriptor instead.
func (*DelayTimingInfo) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{18}
}

func (x *DelayTimingInfo) GetDelay() *durationpb.Duration {
	if x != nil {
		return x.Delay
	}
	return nil
}

type GPSEpochTimingInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Duration since GPS Epoch.
	TimeSinceGpsEpoch *durationpb.Duration `protobuf:"bytes,1,opt,name=time_since_gps_epoch,json=timeSinceGpsEpoch,proto3" json:"time_since_gps_epoch,omitempty"`
}

func (x *GPSEpochTimingInfo) Reset() {
	*x = GPSEpochTimingInfo{}
	mi := &file_gw_gw_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GPSEpochTimingInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GPSEpochTimingInfo) ProtoMessage() {}

func (x *GPSEpochTimingInfo) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GPSEpochTimingInfo.ProtoReflect.Descriptor instead.
func (*GPSEpochTimingInfo) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{19}
}

func (x *GPSEpochTimingInfo) GetTimeSinceGpsEpoch() *durationpb.Duration {
	if x != nil {
		return x.TimeSinceGpsEpoch
	}
	return nil
}

type UplinkFrame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PHYPayload.
	PhyPayload []byte `protobuf:"bytes,1,opt,name=phy_payload,json=phyPayload,proto3" json:"phy_payload,omitempty"`
	// TX meta-data (deprecated).
	TxInfoLegacy *UplinkTxInfoLegacy `protobuf:"bytes,2,opt,name=tx_info_legacy,json=txInfoLegacy,proto3" json:"tx_info_legacy,omitempty"`
	// RX meta-data (deprecated).
	RxInfoLegacy *UplinkRxInfoLegacy `protobuf:"bytes,3,opt,name=rx_info_legacy,json=rxInfoLegacy,proto3" json:"rx_info_legacy,omitempty"`
	// Tx meta-data.
	TxInfo *UplinkTxInfo `protobuf:"bytes,4,opt,name=tx_info,json=txInfo,proto3" json:"tx_info,omitempty"`
	// Rx meta-data.
	RxInfo *UplinkRxInfo `protobuf:"bytes,5,opt,name=rx_info,json=rxInfo,proto3" json:"rx_info,omitempty"`
}

func (x *UplinkFrame) Reset() {
	*x = UplinkFrame{}
	mi := &file_gw_gw_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UplinkFrame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UplinkFrame) ProtoMessage() {}

func (x *UplinkFrame) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UplinkFrame.ProtoReflect.Descriptor instead.
func (*UplinkFrame) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{20}
}

func (x *UplinkFrame) GetPhyPayload() []byte {
	if x != nil {
		return x.PhyPayload
	}
	return nil
}

func (x *UplinkFrame) GetTxInfoLegacy() *UplinkTxInfoLegacy {
	if x != nil {
		return x.TxInfoLegacy
	}
	return nil
}

func (x *UplinkFrame) GetRxInfoLegacy() *UplinkRxInfoLegacy {
	if x != nil {
		return x.RxInfoLegacy
	}
	return nil
}

func (x *UplinkFrame) GetTxInfo() *UplinkTxInfo {
	if x != nil {
		return x.TxInfo
	}
	return nil
}

func (x *UplinkFrame) GetRxInfo() *UplinkRxInfo {
	if x != nil {
		return x.RxInfo
	}
	return nil
}

type UplinkFrameSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PHYPayload.
	PhyPayload []byte `protobuf:"bytes,1,opt,name=phy_payload,json=phyPayload,proto3" json:"phy_payload,omitempty"`
	// TX meta-data.
	TxInfo *UplinkTxInfo `protobuf:"bytes,2,opt,name=tx_info,json=txInfo,proto3" json:"tx_info,omitempty"`
	// RX meta-data set.
	RxInfo []*UplinkRxInfo `protobuf:"bytes,3,rep,name=rx_info,json=rxInfo,proto3" json:"rx_info,omitempty"`
}

func (x *UplinkFrameSet) Reset() {
	*x = UplinkFrameSet{}
	mi := &file_gw_gw_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UplinkFrameSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UplinkFrameSet) ProtoMessage() {}

func (x *UplinkFrameSet) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UplinkFrameSet.ProtoReflect.Descriptor instead.
func (*UplinkFrameSet) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{21}
}

func (x *UplinkFrameSet) GetPhyPayload() []byte {
	if x != nil {
		return x.PhyPayload
	}
	return nil
}

func (x *UplinkFrameSet) GetTxInfo() *UplinkTxInfo {
	if x != nil {
		return x.TxInfo
	}
	return nil
}

func (x *UplinkFrameSet) GetRxInfo() []*UplinkRxInfo {
	if x != nil {
		return x.RxInfo
	}
	return nil
}

type DownlinkFrame struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Downlink ID.
	DownlinkId uint32 `protobuf:"varint,3,opt,name=downlink_id,json=downlinkId,proto3" json:"downlink_id,omitempty"`
	// Downlink ID (UUID).
	// Deprecated: use downlink_id.
	DownlinkIdLegacy []byte `protobuf:"bytes,4,opt,name=downlink_id_legacy,json=downlinkIdLegacy,proto3" json:"downlink_id_legacy,omitempty"`
	// Downlink frame items.
	// This makes it possible to send multiple downlink opportunities to the
	// gateway at once (e.g. RX1 and RX2 in LoRaWAN). The first item has the
	// highest priority, the last the lowest. The gateway will emit at most
	// one item.
	Items []*DownlinkFrameItem `protobuf:"bytes,5,rep,name=items,proto3" json:"items,omitempty"`
	// Gateway ID.
	// Deprecated: use gateway_id
	GatewayIdLegacy []byte `protobuf:"bytes,6,opt,name=gateway_id_legacy,json=gatewayIdLegacy,proto3" json:"gateway_id_legacy,omitempty"`
	// Gateway ID.
	GatewayId string `protobuf:"bytes,7,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
}

func (x *DownlinkFrame) Reset() {
	*x = DownlinkFrame{}
	mi := &file_gw_gw_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DownlinkFrame) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownlinkFrame) ProtoMessage() {}

func (x *DownlinkFrame) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownlinkFrame.ProtoReflect.Descriptor instead.
func (*DownlinkFrame) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{22}
}

func (x *DownlinkFrame) GetDownlinkId() uint32 {
	if x != nil {
		return x.DownlinkId
	}
	return 0
}

func (x *DownlinkFrame) GetDownlinkIdLegacy() []byte {
	if x != nil {
		return x.DownlinkIdLegacy
	}
	return nil
}

func (x *DownlinkFrame) GetItems() []*DownlinkFrameItem {
	if x != nil {
		return x.Items
	}
	return nil
}

func (x *DownlinkFrame) GetGatewayIdLegacy() []byte {
	if x != nil {
		return x.GatewayIdLegacy
	}
	return nil
}

func (x *DownlinkFrame) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

type DownlinkFrameItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// PHYPayload.
	PhyPayload []byte `protobuf:"bytes,1,opt,name=phy_payload,json=phyPayload,proto3" json:"phy_payload,omitempty"`
	// TX meta-data (deprecated).
	TxInfoLegacy *DownlinkTxInfoLegacy `protobuf:"bytes,2,opt,name=tx_info_legacy,json=txInfoLegacy,proto3" json:"tx_info_legacy,omitempty"`
	// Tx meta-data.
	TxInfo *DownlinkTxInfo `protobuf:"bytes,3,opt,name=tx_info,json=txInfo,proto3" json:"tx_info,omitempty"`
}

func (x *DownlinkFrameItem) Reset() {
	*x = DownlinkFrameItem{}
	mi := &file_gw_gw_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DownlinkFrameItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownlinkFrameItem) ProtoMessage() {}

func (x *DownlinkFrameItem) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownlinkFrameItem.ProtoReflect.Descriptor instead.
func (*DownlinkFrameItem) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{23}
}

func (x *DownlinkFrameItem) GetPhyPayload() []byte {
	if x != nil {
		return x.PhyPayload
	}
	return nil
}

func (x *DownlinkFrameItem) GetTxInfoLegacy() *DownlinkTxInfoLegacy {
	if x != nil {
		return x.TxInfoLegacy
	}
	return nil
}

func (x *DownlinkFrameItem) GetTxInfo() *DownlinkTxInfo {
	if x != nil {
		return x.TxInfo
	}
	return nil
}

type DownlinkTxAck struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gateway ID (deprecated).
	GatewayIdLegacy []byte `protobuf:"bytes,1,opt,name=gateway_id_legacy,json=gatewayIdLegacy,proto3" json:"gateway_id_legacy,omitempty"`
	// Gateway ID.
	GatewayId string `protobuf:"bytes,6,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// Downlink ID.
	DownlinkId uint32 `protobuf:"varint,2,opt,name=downlink_id,json=downlinkId,proto3" json:"downlink_id,omitempty"`
	// Downlink ID (deprecated).
	DownlinkIdLegacy []byte `protobuf:"bytes,4,opt,name=downlink_id_legacy,json=downlinkIdLegacy,proto3" json:"downlink_id_legacy,omitempty"`
	// Downlink frame items.
	// This list has the same length as the request and indicates which
	// downlink frame has been emitted of the requested list (or why it failed).
	// Note that at most one item has a positive acknowledgement.
	Items []*DownlinkTxAckItem `protobuf:"bytes,5,rep,name=items,proto3" json:"items,omitempty"`
}

func (x *DownlinkTxAck) Reset() {
	*x = DownlinkTxAck{}
	mi := &file_gw_gw_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DownlinkTxAck) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownlinkTxAck) ProtoMessage() {}

func (x *DownlinkTxAck) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownlinkTxAck.ProtoReflect.Descriptor instead.
func (*DownlinkTxAck) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{24}
}

func (x *DownlinkTxAck) GetGatewayIdLegacy() []byte {
	if x != nil {
		return x.GatewayIdLegacy
	}
	return nil
}

func (x *DownlinkTxAck) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

func (x *DownlinkTxAck) GetDownlinkId() uint32 {
	if x != nil {
		return x.DownlinkId
	}
	return 0
}

func (x *DownlinkTxAck) GetDownlinkIdLegacy() []byte {
	if x != nil {
		return x.DownlinkIdLegacy
	}
	return nil
}

func (x *DownlinkTxAck) GetItems() []*DownlinkTxAckItem {
	if x != nil {
		return x.Items
	}
	return nil
}

type DownlinkTxAckItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Ack status of this item.
	Status TxAckStatus `protobuf:"varint,1,opt,name=status,proto3,enum=gw.TxAckStatus" json:"status,omitempty"`
}

func (x *DownlinkTxAckItem) Reset() {
	*x = DownlinkTxAckItem{}
	mi := &file_gw_gw_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DownlinkTxAckItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DownlinkTxAckItem) ProtoMessage() {}

func (x *DownlinkTxAckItem) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DownlinkTxAckItem.ProtoReflect.Descriptor instead.
func (*DownlinkTxAckItem) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{25}
}

func (x *DownlinkTxAckItem) GetStatus() TxAckStatus {
	if x != nil {
		return x.Status
	}
	return TxAckStatus_IGNORED
}

type GatewayConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gateway ID.
	// Deprecated: use gateway_id.
	GatewayIdLegacy []byte `protobuf:"bytes,1,opt,name=gateway_id_legacy,json=gatewayIdLegacy,proto3" json:"gateway_id_legacy,omitempty"`
	// Gateway ID.
	GatewayId string `protobuf:"bytes,5,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// Configuration version.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Channels.
	Channels []*ChannelConfiguration `protobuf:"bytes,3,rep,name=channels,proto3" json:"channels,omitempty"`
	// Stats interval.
	StatsInterval *durationpb.Duration `protobuf:"bytes,4,opt,name=stats_interval,json=statsInterval,proto3" json:"stats_interval,omitempty"`
}

func (x *GatewayConfiguration) Reset() {
	*x = GatewayConfiguration{}
	mi := &file_gw_gw_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GatewayConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayConfiguration) ProtoMessage() {}

func (x *GatewayConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayConfiguration.ProtoReflect.Descriptor instead.
func (*GatewayConfiguration) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{26}
}

func (x *GatewayConfiguration) GetGatewayIdLegacy() []byte {
	if x != nil {
		return x.GatewayIdLegacy
	}
	return nil
}

func (x *GatewayConfiguration) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

func (x *GatewayConfiguration) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *GatewayConfiguration) GetChannels() []*ChannelConfiguration {
	if x != nil {
		return x.Channels
	}
	return nil
}

func (x *GatewayConfiguration) GetStatsInterval() *durationpb.Duration {
	if x != nil {
		return x.StatsInterval
	}
	return nil
}

type ChannelConfiguration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Frequency (Hz).
	Frequency uint32 `protobuf:"varint,1,opt,name=frequency,proto3" json:"frequency,omitempty"`
	// Modulation (deprecated).
	ModulationLegacy common.Modulation `protobuf:"varint,2,opt,name=modulation_legacy,json=modulationLegacy,proto3,enum=common.Modulation" json:"modulation_legacy,omitempty"`
	// Types that are assignable to ModulationConfig:
	//
	//	*ChannelConfiguration_LoraModulationConfig
	//	*ChannelConfiguration_FskModulationConfig
	ModulationConfig isChannelConfiguration_ModulationConfig `protobuf_oneof:"modulation_config"`
	// Board index.
	Board uint32 `protobuf:"varint,5,opt,name=board,proto3" json:"board,omitempty"`
	// Demodulator index (of the given board).
	Demodulator uint32 `protobuf:"varint,6,opt,name=demodulator,proto3" json:"demodulator,omitempty"`
}

func (x *ChannelConfiguration) Reset() {
	*x = ChannelConfiguration{}
	mi := &file_gw_gw_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChannelConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChannelConfiguration) ProtoMessage() {}

func (x *ChannelConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChannelConfiguration.ProtoReflect.Descriptor instead.
func (*ChannelConfiguration) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{27}
}

func (x *ChannelConfiguration) GetFrequency() uint32 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

func (x *ChannelConfiguration) GetModulationLegacy() common.Modulation {
	if x != nil {
		return x.ModulationLegacy
	}
	return common.Modulation(0)
}

func (m *ChannelConfiguration) GetModulationConfig() isChannelConfiguration_ModulationConfig {
	if m != nil {
		return m.ModulationConfig
	}
	return nil
}

func (x *ChannelConfiguration) GetLoraModulationConfig() *LoraModulationConfig {
	if x, ok := x.GetModulationConfig().(*ChannelConfiguration_LoraModulationConfig); ok {
		return x.LoraModulationConfig
	}
	return nil
}

func (x *ChannelConfiguration) GetFskModulationConfig() *FskModulationConfig {
	if x, ok := x.GetModulationConfig().(*ChannelConfiguration_FskModulationConfig); ok {
		return x.FskModulationConfig
	}
	return nil
}

func (x *ChannelConfiguration) GetBoard() uint32 {
	if x != nil {
		return x.Board
	}
	return 0
}

func (x *ChannelConfiguration) GetDemodulator() uint32 {
	if x != nil {
		return x.Demodulator
	}
	return 0
}

type isChannelConfiguration_ModulationConfig interface {
	isChannelConfiguration_ModulationConfig()
}

type ChannelConfiguration_LoraModulationConfig struct {
	// LoRa modulation config.
	LoraModulationConfig *LoraModulationConfig `protobuf:"bytes,3,opt,name=lora_modulation_config,json=loraModulationConfig,proto3,oneof"`
}

type ChannelConfiguration_FskModulationConfig struct {
	// FSK modulation config.
	FskModulationConfig *FskModulationConfig `protobuf:"bytes,4,opt,name=fsk_modulation_config,json=fskModulationConfig,proto3,oneof"`
}

func (*ChannelConfiguration_LoraModulationConfig) isChannelConfiguration_ModulationConfig() {}

func (*ChannelConfiguration_FskModulationConfig) isChannelConfiguration_ModulationConfig() {}

type LoraModulationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bandwidth (kHz).
	// Deprecated: use bandwidth.
	BandwidthLegacy uint32 `protobuf:"varint,1,opt,name=bandwidth_legacy,json=bandwidthLegacy,proto3" json:"bandwidth_legacy,omitempty"`
	// Bandwidth (Hz).
	Bandwidth uint32 `protobuf:"varint,3,opt,name=bandwidth,proto3" json:"bandwidth,omitempty"`
	// Spreading-factors.
	SpreadingFactors []uint32 `protobuf:"varint,2,rep,packed,name=spreading_factors,json=spreadingFactors,proto3" json:"spreading_factors,omitempty"`
}

func (x *LoraModulationConfig) Reset() {
	*x = LoraModulationConfig{}
	mi := &file_gw_gw_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoraModulationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoraModulationConfig) ProtoMessage() {}

func (x *LoraModulationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoraModulationConfig.ProtoReflect.Descriptor instead.
func (*LoraModulationConfig) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{28}
}

func (x *LoraModulationConfig) GetBandwidthLegacy() uint32 {
	if x != nil {
		return x.BandwidthLegacy
	}
	return 0
}

func (x *LoraModulationConfig) GetBandwidth() uint32 {
	if x != nil {
		return x.Bandwidth
	}
	return 0
}

func (x *LoraModulationConfig) GetSpreadingFactors() []uint32 {
	if x != nil {
		return x.SpreadingFactors
	}
	return nil
}

type FskModulationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bandwidth (kHz).
	// Deprecated: use bandwidth.
	BandwidthLegacy uint32 `protobuf:"varint,1,opt,name=bandwidth_legacy,json=bandwidthLegacy,proto3" json:"bandwidth_legacy,omitempty"`
	// Bandwidth (Hz).
	Bandwidth uint32 `protobuf:"varint,3,opt,name=bandwidth,proto3" json:"bandwidth,omitempty"`
	// Bitrate.
	Bitrate uint32 `protobuf:"varint,2,opt,name=bitrate,proto3" json:"bitrate,omitempty"`
}

func (x *FskModulationConfig) Reset() {
	*x = FskModulationConfig{}
	mi := &file_gw_gw_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FskModulationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FskModulationConfig) ProtoMessage() {}

func (x *FskModulationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FskModulationConfig.ProtoReflect.Descriptor instead.
func (*FskModulationConfig) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{29}
}

func (x *FskModulationConfig) GetBandwidthLegacy() uint32 {
	if x != nil {
		return x.BandwidthLegacy
	}
	return 0
}

func (x *FskModulationConfig) GetBandwidth() uint32 {
	if x != nil {
		return x.Bandwidth
	}
	return 0
}

func (x *FskModulationConfig) GetBitrate() uint32 {
	if x != nil {
		return x.Bitrate
	}
	return 0
}

type GatewayCommandExecRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gateway ID.
	// Deprecated: use gateway_id.
	GatewayIdLegacy []byte `protobuf:"bytes,1,opt,name=gateway_id_legacy,json=gatewayIdLegacy,proto3" json:"gateway_id_legacy,omitempty"`
	// Gateway ID.
	GatewayId string `protobuf:"bytes,6,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// Command to execute.
	// This command must be pre-configured in the LoRa Gateway Bridge
	// configuration.
	Command string `protobuf:"bytes,2,opt,name=command,proto3" json:"command,omitempty"`
	// Execution request ID.
	// The same will be returned when the execution of the command has
	// completed.
	ExecId uint32 `protobuf:"varint,7,opt,name=exec_id,json=execId,proto3" json:"exec_id,omitempty"`
	// Standard input.
	Stdin []byte `protobuf:"bytes,4,opt,name=stdin,proto3" json:"stdin,omitempty"`
	// Environment variables.
	Environment map[string]string `protobuf:"bytes,5,rep,name=environment,proto3" json:"environment,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *GatewayCommandExecRequest) Reset() {
	*x = GatewayCommandExecRequest{}
	mi := &file_gw_gw_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GatewayCommandExecRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayCommandExecRequest) ProtoMessage() {}

func (x *GatewayCommandExecRequest) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayCommandExecRequest.ProtoReflect.Descriptor instead.
func (*GatewayCommandExecRequest) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{30}
}

func (x *GatewayCommandExecRequest) GetGatewayIdLegacy() []byte {
	if x != nil {
		return x.GatewayIdLegacy
	}
	return nil
}

func (x *GatewayCommandExecRequest) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

func (x *GatewayCommandExecRequest) GetCommand() string {
	if x != nil {
		return x.Command
	}
	return ""
}

func (x *GatewayCommandExecRequest) GetExecId() uint32 {
	if x != nil {
		return x.ExecId
	}
	return 0
}

func (x *GatewayCommandExecRequest) GetStdin() []byte {
	if x != nil {
		return x.Stdin
	}
	return nil
}

func (x *GatewayCommandExecRequest) GetEnvironment() map[string]string {
	if x != nil {
		return x.Environment
	}
	return nil
}

type GatewayCommandExecResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gateway ID.
	// Deprecated: use gateway_id.
	GatewayIdLegacy []byte `protobuf:"bytes,1,opt,name=gateway_id_legacy,json=gatewayIdLegacy,proto3" json:"gateway_id_legacy,omitempty"`
	// Gateway ID.
	GatewayId string `protobuf:"bytes,6,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// Execution request ID.
	ExecId uint32 `protobuf:"varint,7,opt,name=exec_id,json=execId,proto3" json:"exec_id,omitempty"`
	// Standard output.
	Stdout []byte `protobuf:"bytes,3,opt,name=stdout,proto3" json:"stdout,omitempty"`
	// Standard error.
	Stderr []byte `protobuf:"bytes,4,opt,name=stderr,proto3" json:"stderr,omitempty"`
	// Error message.
	Error string `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *GatewayCommandExecResponse) Reset() {
	*x = GatewayCommandExecResponse{}
	mi := &file_gw_gw_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GatewayCommandExecResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GatewayCommandExecResponse) ProtoMessage() {}

func (x *GatewayCommandExecResponse) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GatewayCommandExecResponse.ProtoReflect.Descriptor instead.
func (*GatewayCommandExecResponse) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{31}
}

func (x *GatewayCommandExecResponse) GetGatewayIdLegacy() []byte {
	if x != nil {
		return x.GatewayIdLegacy
	}
	return nil
}

func (x *GatewayCommandExecResponse) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

func (x *GatewayCommandExecResponse) GetExecId() uint32 {
	if x != nil {
		return x.ExecId
	}
	return 0
}

func (x *GatewayCommandExecResponse) GetStdout() []byte {
	if x != nil {
		return x.Stdout
	}
	return nil
}

func (x *GatewayCommandExecResponse) GetStderr() []byte {
	if x != nil {
		return x.Stderr
	}
	return nil
}

func (x *GatewayCommandExecResponse) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

// RawPacketForwarderEvent contains a raw packet-forwarder event.
// It can be used to access packet-forwarder features that are not (fully)
// integrated with the ChirpStack Gateway Bridge.
type RawPacketForwarderEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gateway ID.
	// Deprecated: use gateway_id.
	GatewayIdLegacy []byte `protobuf:"bytes,1,opt,name=gateway_id_legacy,json=gatewayIdLegacy,proto3" json:"gateway_id_legacy,omitempty"`
	// Gateway ID.
	GatewayId string `protobuf:"bytes,4,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// Payload contains the raw payload.
	Payload []byte `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *RawPacketForwarderEvent) Reset() {
	*x = RawPacketForwarderEvent{}
	mi := &file_gw_gw_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RawPacketForwarderEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RawPacketForwarderEvent) ProtoMessage() {}

func (x *RawPacketForwarderEvent) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RawPacketForwarderEvent.ProtoReflect.Descriptor instead.
func (*RawPacketForwarderEvent) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{32}
}

func (x *RawPacketForwarderEvent) GetGatewayIdLegacy() []byte {
	if x != nil {
		return x.GatewayIdLegacy
	}
	return nil
}

func (x *RawPacketForwarderEvent) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

func (x *RawPacketForwarderEvent) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

// RawPacketForwarderEvent contains a raw packet-forwarder command.
// It can be used to access packet-forwarder features that are not (fully)
// integrated with the ChirpStack Gateway Bridge.
type RawPacketForwarderCommand struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gateway ID.
	// Deprecated: use gateway_id.
	GatewayIdLegacy []byte `protobuf:"bytes,1,opt,name=gateway_id_legacy,json=gatewayIdLegacy,proto3" json:"gateway_id_legacy,omitempty"`
	// Gateway ID.
	GatewayId string `protobuf:"bytes,4,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// Payload contains the raw payload.
	Payload []byte `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (x *RawPacketForwarderCommand) Reset() {
	*x = RawPacketForwarderCommand{}
	mi := &file_gw_gw_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RawPacketForwarderCommand) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RawPacketForwarderCommand) ProtoMessage() {}

func (x *RawPacketForwarderCommand) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RawPacketForwarderCommand.ProtoReflect.Descriptor instead.
func (*RawPacketForwarderCommand) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{33}
}

func (x *RawPacketForwarderCommand) GetGatewayIdLegacy() []byte {
	if x != nil {
		return x.GatewayIdLegacy
	}
	return nil
}

func (x *RawPacketForwarderCommand) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

func (x *RawPacketForwarderCommand) GetPayload() []byte {
	if x != nil {
		return x.Payload
	}
	return nil
}

// ConnState contains the connection state of a gateway.
type ConnState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gateway ID.
	// Deprecated: use gateway_id.
	GatewayIdLegacy []byte `protobuf:"bytes,1,opt,name=gateway_id_legacy,json=gatewayIdLegacy,proto3" json:"gateway_id_legacy,omitempty"`
	// Gateway ID.
	GatewayId string          `protobuf:"bytes,3,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	State     ConnState_State `protobuf:"varint,2,opt,name=state,proto3,enum=gw.ConnState_State" json:"state,omitempty"`
}

func (x *ConnState) Reset() {
	*x = ConnState{}
	mi := &file_gw_gw_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConnState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnState) ProtoMessage() {}

func (x *ConnState) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnState.ProtoReflect.Descriptor instead.
func (*ConnState) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{34}
}

func (x *ConnState) GetGatewayIdLegacy() []byte {
	if x != nil {
		return x.GatewayIdLegacy
	}
	return nil
}

func (x *ConnState) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

func (x *ConnState) GetState() ConnState_State {
	if x != nil {
		return x.State
	}
	return ConnState_OFFLINE
}

// Gateway Mesh heartbeat (sent periodically by the Relay Gateways).
type MeshHeartbeat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Gateway ID (of the Border Gateway).
	GatewayId string `protobuf:"bytes,1,opt,name=gateway_id,json=gatewayId,proto3" json:"gateway_id,omitempty"`
	// Relay ID.
	RelayId string `protobuf:"bytes,2,opt,name=relay_id,json=relayId,proto3" json:"relay_id,omitempty"`
	// Timestamp (second precision).
	Time *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=time,proto3" json:"time,omitempty"`
	// Relay path.
	RelayPath []*MeshHeartbeatRelayPath `protobuf:"bytes,4,rep,name=relay_path,json=relayPath,proto3" json:"relay_path,omitempty"`
}

func (x *MeshHeartbeat) Reset() {
	*x = MeshHeartbeat{}
	mi := &file_gw_gw_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshHeartbeat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshHeartbeat) ProtoMessage() {}

func (x *MeshHeartbeat) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshHeartbeat.ProtoReflect.Descriptor instead.
func (*MeshHeartbeat) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{35}
}

func (x *MeshHeartbeat) GetGatewayId() string {
	if x != nil {
		return x.GatewayId
	}
	return ""
}

func (x *MeshHeartbeat) GetRelayId() string {
	if x != nil {
		return x.RelayId
	}
	return ""
}

func (x *MeshHeartbeat) GetTime() *timestamppb.Timestamp {
	if x != nil {
		return x.Time
	}
	return nil
}

func (x *MeshHeartbeat) GetRelayPath() []*MeshHeartbeatRelayPath {
	if x != nil {
		return x.RelayPath
	}
	return nil
}

type MeshHeartbeatRelayPath struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Relay ID.
	RelayId string `protobuf:"bytes,1,opt,name=relay_id,json=relayId,proto3" json:"relay_id,omitempty"`
	// RSSI.
	Rssi int32 `protobuf:"varint,2,opt,name=rssi,proto3" json:"rssi,omitempty"`
	// SNR.
	Snr int32 `protobuf:"varint,3,opt,name=snr,proto3" json:"snr,omitempty"`
}

func (x *MeshHeartbeatRelayPath) Reset() {
	*x = MeshHeartbeatRelayPath{}
	mi := &file_gw_gw_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MeshHeartbeatRelayPath) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MeshHeartbeatRelayPath) ProtoMessage() {}

func (x *MeshHeartbeatRelayPath) ProtoReflect() protoreflect.Message {
	mi := &file_gw_gw_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MeshHeartbeatRelayPath.ProtoReflect.Descriptor instead.
func (*MeshHeartbeatRelayPath) Descriptor() ([]byte, []int) {
	return file_gw_gw_proto_rawDescGZIP(), []int{36}
}

func (x *MeshHeartbeatRelayPath) GetRelayId() string {
	if x != nil {
		return x.RelayId
	}
	return ""
}

func (x *MeshHeartbeatRelayPath) GetRssi() int32 {
	if x != nil {
		return x.Rssi
	}
	return 0
}

func (x *MeshHeartbeatRelayPath) GetSnr() int32 {
	if x != nil {
		return x.Snr
	}
	return 0
}

var File_gw_gw_proto protoreflect.FileDescriptor

var file_gw_gw_proto_rawDesc = []byte{
	0x0a, 0x0b, 0x67, 0x77, 0x2f, 0x67, 0x77, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x02, 0x67,
	0x77, 0x1a, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa8, 0x01, 0x0a, 0x0a, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x04, 0x6c, 0x6f, 0x72, 0x61, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x77, 0x2e, 0x4c, 0x6f, 0x72, 0x61, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x04, 0x6c, 0x6f,
	0x72, 0x61, 0x12, 0x29, 0x0a, 0x03, 0x66, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x67, 0x77, 0x2e, 0x46, 0x73, 0x6b, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x03, 0x66, 0x73, 0x6b, 0x12, 0x33, 0x0a,
	0x07, 0x6c, 0x72, 0x5f, 0x66, 0x68, 0x73, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x67, 0x77, 0x2e, 0x4c, 0x72, 0x46, 0x68, 0x73, 0x73, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x06, 0x6c, 0x72, 0x46, 0x68,
	0x73, 0x73, 0x42, 0x0c, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x22, 0xe1, 0x02, 0x0a, 0x12, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x78, 0x49, 0x6e, 0x66,
	0x6f, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x66, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x32, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x14, 0x6c, 0x6f, 0x72,
	0x61, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x77, 0x2e, 0x4c, 0x6f, 0x72,
	0x61, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x48,
	0x00, 0x52, 0x12, 0x6c, 0x6f, 0x72, 0x61, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x47, 0x0a, 0x13, 0x66, 0x73, 0x6b, 0x5f, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x77, 0x2e, 0x46, 0x73, 0x6b, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x11, 0x66, 0x73, 0x6b,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x51,
	0x0a, 0x17, 0x6c, 0x72, 0x5f, 0x66, 0x68, 0x73, 0x73, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x18, 0x2e, 0x67, 0x77, 0x2e, 0x4c, 0x72, 0x46, 0x68, 0x73, 0x73, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x14, 0x6c, 0x72, 0x46,
	0x68, 0x73, 0x73, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x42, 0x11, 0x0a, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x22, 0x5c, 0x0a, 0x0c, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x78,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x12, 0x2e, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x67, 0x77, 0x2e, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x9c, 0x02, 0x0a, 0x12, 0x4c, 0x6f, 0x72, 0x61, 0x4d, 0x6f, 0x64, 0x75, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x62, 0x61, 0x6e,
	0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x62, 0x61,
	0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x29, 0x0a, 0x10, 0x73, 0x70, 0x72, 0x65, 0x61,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x0f, 0x73, 0x70, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x74,
	0x6f, 0x72, 0x12, 0x28, 0x0a, 0x10, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f,
	0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x6f,
	0x64, 0x65, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x29, 0x0a, 0x09,
	0x63, 0x6f, 0x64, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x0c, 0x2e, 0x67, 0x77, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x61, 0x74, 0x65, 0x52, 0x08, 0x63,
	0x6f, 0x64, 0x65, 0x52, 0x61, 0x74, 0x65, 0x12, 0x35, 0x0a, 0x16, 0x70, 0x6f, 0x6c, 0x61, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x15, 0x70, 0x6f, 0x6c, 0x61, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1a,
	0x0a, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x08, 0x70, 0x72, 0x65, 0x61, 0x6d, 0x62, 0x6c, 0x65, 0x12, 0x15, 0x0a, 0x06, 0x6e, 0x6f,
	0x5f, 0x63, 0x72, 0x63, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x6e, 0x6f, 0x43, 0x72,
	0x63, 0x22, 0x60, 0x0a, 0x11, 0x46, 0x73, 0x6b, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2f, 0x0a, 0x13, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x6e, 0x63, 0x79, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x12, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x44, 0x65,
	0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x72,
	0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x72,
	0x61, 0x74, 0x65, 0x22, 0xc2, 0x01, 0x0a, 0x14, 0x4c, 0x72, 0x46, 0x68, 0x73, 0x73, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x36, 0x0a, 0x17,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x5f, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x15, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x57,
	0x69, 0x64, 0x74, 0x68, 0x12, 0x28, 0x0a, 0x10, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x72, 0x61, 0x74,
	0x65, 0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e,
	0x63, 0x6f, 0x64, 0x65, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x29,
	0x0a, 0x09, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x0c, 0x2e, 0x67, 0x77, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x61, 0x74, 0x65, 0x52,
	0x08, 0x63, 0x6f, 0x64, 0x65, 0x52, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x72, 0x69,
	0x64, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x67,
	0x72, 0x69, 0x64, 0x53, 0x74, 0x65, 0x70, 0x73, 0x22, 0x78, 0x0a, 0x16, 0x45, 0x6e, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6e, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x12, 0x22, 0x0a, 0x0d, 0x61, 0x65, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x61, 0x65, 0x73, 0x4b, 0x65,
	0x79, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x21, 0x0a, 0x0c, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x65, 0x64, 0x5f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0b, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x4e, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x66, 0x70, 0x67,
	0x61, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x66, 0x70, 0x67, 0x61,
	0x49, 0x64, 0x22, 0x44, 0x0a, 0x12, 0x50, 0x6c, 0x61, 0x69, 0x6e, 0x46, 0x69, 0x6e, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x82, 0x0a, 0x0a, 0x0c, 0x47, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x0f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x4c,
	0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x5f, 0x69, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04,
	0x74, 0x69, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2e, 0x0a, 0x13, 0x72, 0x78, 0x5f,
	0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x72, 0x78, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74,
	0x73, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x12, 0x33, 0x0a, 0x16, 0x72, 0x78, 0x5f,
	0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64,
	0x5f, 0x6f, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x13, 0x72, 0x78, 0x50, 0x61, 0x63,
	0x6b, 0x65, 0x74, 0x73, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x4f, 0x6b, 0x12, 0x2e,
	0x0a, 0x13, 0x74, 0x78, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x63,
	0x65, 0x69, 0x76, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x11, 0x74, 0x78, 0x50,
	0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x12, 0x2c,
	0x0a, 0x12, 0x74, 0x78, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x65, 0x6d, 0x69,
	0x74, 0x74, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x10, 0x74, 0x78, 0x50, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x73, 0x45, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x12, 0x3a, 0x0a, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e,
	0x2e, 0x67, 0x77, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x18, 0x74, 0x78, 0x5f, 0x70,
	0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x66, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x77, 0x2e,
	0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x54, 0x78, 0x50,
	0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x50, 0x65, 0x72, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e,
	0x63, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x15, 0x74, 0x78, 0x50, 0x61, 0x63, 0x6b, 0x65,
	0x74, 0x73, 0x50, 0x65, 0x72, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x64,
	0x0a, 0x18, 0x72, 0x78, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x77, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x2e, 0x52, 0x78, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x50, 0x65, 0x72, 0x46,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x15, 0x72,
	0x78, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x50, 0x65, 0x72, 0x46, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x12, 0x51, 0x0a, 0x19, 0x74, 0x78, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65,
	0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x77, 0x2e, 0x50, 0x65, 0x72,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52,
	0x16, 0x74, 0x78, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x50, 0x65, 0x72, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x19, 0x72, 0x78, 0x5f, 0x70, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x77, 0x2e,
	0x50, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x52, 0x16, 0x72, 0x78, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x50, 0x65, 0x72,
	0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5b, 0x0a, 0x15, 0x74, 0x78,
	0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x77, 0x2e, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x53, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x54, 0x78, 0x50, 0x61,
	0x63, 0x6b, 0x65, 0x74, 0x73, 0x50, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x12, 0x74, 0x78, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x50, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x3c, 0x0a, 0x10, 0x64, 0x75, 0x74, 0x79, 0x5f,
	0x63, 0x79, 0x63, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x77, 0x2e, 0x44, 0x75, 0x74, 0x79, 0x43, 0x79, 0x63, 0x6c, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x0e, 0x64, 0x75, 0x74, 0x79, 0x43, 0x79, 0x63, 0x6c, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x48, 0x0a, 0x1a, 0x54, 0x78, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x50,
	0x65, 0x72, 0x46, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x48, 0x0a, 0x1a,
	0x52, 0x78, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x50, 0x65, 0x72, 0x46, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x79, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x45, 0x0a, 0x17, 0x54, 0x78, 0x50, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x50, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x5a, 0x0a,
	0x12, 0x50, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x67, 0x77, 0x2e, 0x4d, 0x6f, 0x64,
	0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xa0, 0x01, 0x0a, 0x0e, 0x44, 0x75,
	0x74, 0x79, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x32, 0x0a, 0x0a,
	0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x12, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x52, 0x65, 0x67, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x31, 0x0a, 0x06, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x77, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x12, 0x27, 0x0a, 0x05, 0x62, 0x61, 0x6e, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x77, 0x2e, 0x44, 0x75, 0x74, 0x79, 0x43, 0x79, 0x63, 0x6c,
	0x65, 0x42, 0x61, 0x6e, 0x64, 0x52, 0x05, 0x62, 0x61, 0x6e, 0x64, 0x73, 0x22, 0xe1, 0x01, 0x0a,
	0x0d, 0x44, 0x75, 0x74, 0x79, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x42, 0x61, 0x6e, 0x64, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f,
	0x6d, 0x69, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c, 0x66, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x4d, 0x69, 0x6e, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0c,
	0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x4d, 0x61, 0x78, 0x12, 0x34, 0x0a, 0x08,
	0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x78, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x07, 0x6c, 0x6f, 0x61, 0x64, 0x4d,
	0x61, 0x78, 0x12, 0x3c, 0x0a, 0x0c, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b,
	0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x6c, 0x6f, 0x61, 0x64, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x65, 0x64,
	0x22, 0xd2, 0x06, 0x0a, 0x12, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x78, 0x49, 0x6e, 0x66,
	0x6f, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x14, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73,
	0x69, 0x6e, 0x63, 0x65, 0x5f, 0x67, 0x70, 0x73, 0x5f, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x11, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x69, 0x6e, 0x63, 0x65, 0x47, 0x70, 0x73, 0x45, 0x70, 0x6f,
	0x63, 0x68, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x73, 0x73, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x04, 0x72, 0x73, 0x73, 0x69, 0x12, 0x19, 0x0a, 0x08, 0x6c, 0x6f, 0x72, 0x61, 0x5f, 0x73,
	0x6e, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x52, 0x07, 0x6c, 0x6f, 0x72, 0x61, 0x53, 0x6e,
	0x72, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x19, 0x0a, 0x08, 0x72,
	0x66, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x72,
	0x66, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x12, 0x18, 0x0a, 0x07,
	0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x61,
	0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x12, 0x2c, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x13, 0x66, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x15, 0x2e, 0x67, 0x77, 0x2e, 0x46, 0x69, 0x6e, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x54, 0x79, 0x70, 0x65, 0x52, 0x11, 0x66, 0x69, 0x6e, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x56, 0x0a, 0x18, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x77, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6e, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x16, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x65, 0x64, 0x46, 0x69, 0x6e, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x12, 0x4a, 0x0a, 0x14, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x5f, 0x66, 0x69, 0x6e,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x67, 0x77, 0x2e, 0x50, 0x6c, 0x61, 0x69, 0x6e, 0x46, 0x69, 0x6e, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x12, 0x70, 0x6c, 0x61,
	0x69, 0x6e, 0x46, 0x69, 0x6e, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x12,
	0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x75, 0x70,
	0x6c, 0x69, 0x6e, 0x6b, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x0a, 0x63, 0x72, 0x63, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x0d, 0x2e, 0x67, 0x77, 0x2e,
	0x43, 0x52, 0x43, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x09, 0x63, 0x72, 0x63, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x40, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x12, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x77, 0x2e, 0x55, 0x70, 0x6c, 0x69,
	0x6e, 0x6b, 0x52, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x2e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x66, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0xcf, 0x05, 0x0a, 0x0c, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x52, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x75, 0x70, 0x6c, 0x69, 0x6e, 0x6b,
	0x49, 0x64, 0x12, 0x33, 0x0a, 0x07, 0x67, 0x77, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x06, 0x67, 0x77, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x07, 0x6e, 0x73, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x06, 0x6e, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x14,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x5f, 0x67, 0x70, 0x73, 0x5f, 0x65,
	0x70, 0x6f, 0x63, 0x68, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x69, 0x6e, 0x63, 0x65,
	0x47, 0x70, 0x73, 0x45, 0x70, 0x6f, 0x63, 0x68, 0x12, 0x53, 0x0a, 0x19, 0x66, 0x69, 0x6e, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x5f, 0x67, 0x70, 0x73, 0x5f,
	0x65, 0x70, 0x6f, 0x63, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x66, 0x69, 0x6e, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x53, 0x69, 0x6e, 0x63, 0x65, 0x47, 0x70, 0x73, 0x45, 0x70, 0x6f, 0x63, 0x68, 0x12, 0x12, 0x0a,
	0x04, 0x72, 0x73, 0x73, 0x69, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x72, 0x73, 0x73,
	0x69, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x6e, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x02, 0x52, 0x03,
	0x73, 0x6e, 0x72, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x19, 0x0a,
	0x08, 0x72, 0x66, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x07, 0x72, 0x66, 0x43, 0x68, 0x61, 0x69, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x6f, 0x61, 0x72,
	0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x12, 0x18,
	0x0a, 0x07, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x07, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x12, 0x2c, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x3a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0f, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x77, 0x2e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x78,
	0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2c, 0x0a, 0x0a,
	0x63, 0x72, 0x63, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x0d, 0x2e, 0x67, 0x77, 0x2e, 0x43, 0x52, 0x43, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x09, 0x63, 0x72, 0x63, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xaf, 0x05, 0x0a, 0x14, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79,
	0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x09, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x12,
	0x1c, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0d, 0x52, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x14, 0x0a,
	0x05, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x70, 0x6f,
	0x77, 0x65, 0x72, 0x12, 0x32, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4a, 0x0a, 0x14, 0x6c, 0x6f, 0x72, 0x61, 0x5f,
	0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x77, 0x2e, 0x4c, 0x6f, 0x72, 0x61, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52,
	0x12, 0x6c, 0x6f, 0x72, 0x61, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x47, 0x0a, 0x13, 0x66, 0x73, 0x6b, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x67, 0x77, 0x2e, 0x46, 0x73, 0x6b, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x11, 0x66, 0x73, 0x6b, 0x4d, 0x6f,
	0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x14, 0x0a, 0x05,
	0x62, 0x6f, 0x61, 0x72, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x07, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61, 0x12, 0x2a, 0x0a, 0x06,
	0x74, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x12, 0x2e, 0x67,
	0x77, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67,
	0x52, 0x06, 0x74, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x12, 0x53, 0x0a, 0x17, 0x69, 0x6d, 0x6d, 0x65,
	0x64, 0x69, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x77, 0x2e, 0x49,
	0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67,
	0x49, 0x6e, 0x66, 0x6f, 0x48, 0x01, 0x52, 0x15, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74,
	0x65, 0x6c, 0x79, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x41, 0x0a,
	0x11, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x74, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x77, 0x2e, 0x44, 0x65,
	0x6c, 0x61, 0x79, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x01, 0x52,
	0x0f, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x4b, 0x0a, 0x15, 0x67, 0x70, 0x73, 0x5f, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x5f, 0x74, 0x69,
	0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x67, 0x77, 0x2e, 0x47, 0x50, 0x53, 0x45, 0x70, 0x6f, 0x63, 0x68, 0x54, 0x69, 0x6d,
	0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x01, 0x52, 0x12, 0x67, 0x70, 0x73, 0x45, 0x70,
	0x6f, 0x63, 0x68, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x18, 0x0a,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42, 0x11, 0x0a, 0x0f, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x42, 0x0d, 0x0a, 0x0b, 0x74, 0x69,
	0x6d, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0xe2, 0x01, 0x0a, 0x0e, 0x44, 0x6f,
	0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1c, 0x0a, 0x09,
	0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x70, 0x6f,
	0x77, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x70, 0x6f, 0x77, 0x65, 0x72,
	0x12, 0x2e, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x67, 0x77, 0x2e, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x14, 0x0a, 0x05, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x05, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e,
	0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x61, 0x6e, 0x74, 0x65, 0x6e, 0x6e, 0x61,
	0x12, 0x22, 0x0a, 0x06, 0x74, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x0a, 0x2e, 0x67, 0x77, 0x2e, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x06, 0x74, 0x69,
	0x6d, 0x69, 0x6e, 0x67, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0xb9,
	0x01, 0x0a, 0x06, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x12, 0x3d, 0x0a, 0x0b, 0x69, 0x6d, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x77, 0x2e, 0x49, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x54,
	0x69, 0x6d, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0b, 0x69, 0x6d, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x12, 0x2b, 0x0a, 0x05, 0x64, 0x65, 0x6c, 0x61,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x77, 0x2e, 0x44, 0x65, 0x6c,
	0x61, 0x79, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x05,
	0x64, 0x65, 0x6c, 0x61, 0x79, 0x12, 0x35, 0x0a, 0x09, 0x67, 0x70, 0x73, 0x5f, 0x65, 0x70, 0x6f,
	0x63, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x77, 0x2e, 0x47, 0x50,
	0x53, 0x45, 0x70, 0x6f, 0x63, 0x68, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f,
	0x48, 0x00, 0x52, 0x08, 0x67, 0x70, 0x73, 0x45, 0x70, 0x6f, 0x63, 0x68, 0x42, 0x0c, 0x0a, 0x0a,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x17, 0x0a, 0x15, 0x49, 0x6d,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x49,
	0x6e, 0x66, 0x6f, 0x22, 0x42, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x61, 0x79, 0x54, 0x69, 0x6d, 0x69,
	0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2f, 0x0a, 0x05, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x05, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x22, 0x60, 0x0a, 0x12, 0x47, 0x50, 0x53, 0x45, 0x70,
	0x6f, 0x63, 0x68, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4a, 0x0a,
	0x14, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x5f, 0x67, 0x70, 0x73, 0x5f,
	0x65, 0x70, 0x6f, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x74, 0x69, 0x6d, 0x65, 0x53, 0x69, 0x6e, 0x63,
	0x65, 0x47, 0x70, 0x73, 0x45, 0x70, 0x6f, 0x63, 0x68, 0x22, 0x80, 0x02, 0x0a, 0x0b, 0x55, 0x70,
	0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x68, 0x79,
	0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a,
	0x70, 0x68, 0x79, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x3c, 0x0a, 0x0e, 0x74, 0x78,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x77, 0x2e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x78,
	0x49, 0x6e, 0x66, 0x6f, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x52, 0x0c, 0x74, 0x78, 0x49, 0x6e,
	0x66, 0x6f, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x3c, 0x0a, 0x0e, 0x72, 0x78, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x77, 0x2e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x78, 0x49, 0x6e,
	0x66, 0x6f, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x52, 0x0c, 0x72, 0x78, 0x49, 0x6e, 0x66, 0x6f,
	0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x29, 0x0a, 0x07, 0x74, 0x78, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x77, 0x2e, 0x55, 0x70, 0x6c,
	0x69, 0x6e, 0x6b, 0x54, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x74, 0x78, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x29, 0x0a, 0x07, 0x72, 0x78, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x77, 0x2e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x78,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x72, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x87, 0x01, 0x0a,
	0x0e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x53, 0x65, 0x74, 0x12,
	0x1f, 0x0a, 0x0b, 0x70, 0x68, 0x79, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x70, 0x68, 0x79, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x12, 0x29, 0x0a, 0x07, 0x74, 0x78, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x10, 0x2e, 0x67, 0x77, 0x2e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x78, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x06, 0x74, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x29, 0x0a, 0x07, 0x72,
	0x78, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67,
	0x77, 0x2e, 0x55, 0x70, 0x6c, 0x69, 0x6e, 0x6b, 0x52, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06,
	0x72, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xd6, 0x01, 0x0a, 0x0d, 0x44, 0x6f, 0x77, 0x6e, 0x6c,
	0x69, 0x6e, 0x6b, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x64,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x49, 0x64, 0x12, 0x2c, 0x0a, 0x12, 0x64, 0x6f, 0x77,
	0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x10, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x49,
	0x64, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x2b, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x77, 0x2e, 0x44, 0x6f, 0x77, 0x6e,
	0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x05, 0x69,
	0x74, 0x65, 0x6d, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f,
	0x69, 0x64, 0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0c, 0x52,
	0x0f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79,
	0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x22,
	0xa1, 0x01, 0x0a, 0x11, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x72, 0x61, 0x6d,
	0x65, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x1f, 0x0a, 0x0b, 0x70, 0x68, 0x79, 0x5f, 0x70, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0a, 0x70, 0x68, 0x79, 0x50,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x3e, 0x0a, 0x0e, 0x74, 0x78, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18,
	0x2e, 0x67, 0x77, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x78, 0x49, 0x6e,
	0x66, 0x6f, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x52, 0x0c, 0x74, 0x78, 0x49, 0x6e, 0x66, 0x6f,
	0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x2b, 0x0a, 0x07, 0x74, 0x78, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x77, 0x2e, 0x44, 0x6f, 0x77,
	0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x78, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x06, 0x74, 0x78, 0x49,
	0x6e, 0x66, 0x6f, 0x22, 0xd6, 0x01, 0x0a, 0x0d, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b,
	0x54, 0x78, 0x41, 0x63, 0x6b, 0x12, 0x2a, 0x0a, 0x11, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x5f, 0x69, 0x64, 0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x0f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x4c, 0x65, 0x67, 0x61, 0x63,
	0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64,
	0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x49,
	0x64, 0x12, 0x2c, 0x0a, 0x12, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x69, 0x64,
	0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x10, 0x64,
	0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x49, 0x64, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12,
	0x2b, 0x0a, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x67, 0x77, 0x2e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x78, 0x41, 0x63,
	0x6b, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x05, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x22, 0x3c, 0x0a, 0x11,
	0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x78, 0x41, 0x63, 0x6b, 0x49, 0x74, 0x65,
	0x6d, 0x12, 0x27, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x0f, 0x2e, 0x67, 0x77, 0x2e, 0x54, 0x78, 0x41, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xf3, 0x01, 0x0a, 0x14, 0x47,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x11, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69,
	0x64, 0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0f,
	0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12,
	0x1d, 0x0a, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x12, 0x18,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x34, 0x0a, 0x08, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x77, 0x2e,
	0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x12, 0x40,
	0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x73, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c,
	0x22, 0xe3, 0x02, 0x0a, 0x14, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x0a, 0x09, 0x66, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x66, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x3f, 0x0a, 0x11, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x12, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x50, 0x0a, 0x16, 0x6c, 0x6f, 0x72, 0x61,
	0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x77, 0x2e, 0x4c, 0x6f,
	0x72, 0x61, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x00, 0x52, 0x14, 0x6c, 0x6f, 0x72, 0x61, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4d, 0x0a, 0x15, 0x66, 0x73,
	0x6b, 0x5f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x77, 0x2e, 0x46,
	0x73, 0x6b, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x00, 0x52, 0x13, 0x66, 0x73, 0x6b, 0x4d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0d, 0x52, 0x0b, 0x64, 0x65, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x6f,
	0x72, 0x42, 0x13, 0x0a, 0x11, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x8c, 0x01, 0x0a, 0x14, 0x4c, 0x6f, 0x72, 0x61, 0x4d,
	0x6f, 0x64, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x29, 0x0a, 0x10, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x6c, 0x65, 0x67,
	0x61, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x62, 0x61, 0x6e, 0x64, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x62, 0x61,
	0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x62,
	0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x70, 0x72, 0x65,
	0x61, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0d, 0x52, 0x10, 0x73, 0x70, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x46, 0x61,
	0x63, 0x74, 0x6f, 0x72, 0x73, 0x22, 0x78, 0x0a, 0x13, 0x46, 0x73, 0x6b, 0x4d, 0x6f, 0x64, 0x75,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x29, 0x0a, 0x10,
	0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74, 0x68, 0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0f, 0x62, 0x61, 0x6e, 0x64, 0x77, 0x69, 0x64, 0x74,
	0x68, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x1c, 0x0a, 0x09, 0x62, 0x61, 0x6e, 0x64, 0x77,
	0x69, 0x64, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x62, 0x61, 0x6e, 0x64,
	0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x22,
	0xc1, 0x02, 0x0a, 0x19, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x45, 0x78, 0x65, 0x63, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2a, 0x0a,
	0x11, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x5f, 0x6c, 0x65, 0x67, 0x61,
	0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x49, 0x64, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6d, 0x6d,
	0x61, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6d, 0x6d, 0x61,
	0x6e, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x06, 0x65, 0x78, 0x65, 0x63, 0x49, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x73,
	0x74, 0x64, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x73, 0x74, 0x64, 0x69,
	0x6e, 0x12, 0x50, 0x0a, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x77, 0x2e, 0x47, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x45, 0x78, 0x65, 0x63, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e,
	0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x1a, 0x3e, 0x0a, 0x10, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0xc6, 0x01, 0x0a, 0x1a, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x43,
	0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x45, 0x78, 0x65, 0x63, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64,
	0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0f, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x1d,
	0x0a, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x12, 0x17, 0x0a,
	0x07, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06,
	0x65, 0x78, 0x65, 0x63, 0x49, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x73, 0x74, 0x64, 0x6f, 0x75, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06,
	0x73, 0x74, 0x64, 0x65, 0x72, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x7e, 0x0a, 0x17,
	0x52, 0x61, 0x77, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72, 0x64,
	0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x11, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x5f, 0x69, 0x64, 0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x0f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x4c, 0x65, 0x67,
	0x61, 0x63, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79,
	0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22, 0x80, 0x01, 0x0a,
	0x19, 0x52, 0x61, 0x77, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x46, 0x6f, 0x72, 0x77, 0x61, 0x72,
	0x64, 0x65, 0x72, 0x43, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x12, 0x2a, 0x0a, 0x11, 0x67, 0x61,
	0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x5f, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64,
	0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x61, 0x74, 0x65,
	0x77, 0x61, 0x79, 0x49, 0x64, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x22,
	0xa3, 0x01, 0x0a, 0x09, 0x43, 0x6f, 0x6e, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2a, 0x0a,
	0x11, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x5f, 0x6c, 0x65, 0x67, 0x61,
	0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0f, 0x67, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x49, 0x64, 0x4c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67,
	0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x67, 0x77, 0x2e, 0x43, 0x6f, 0x6e,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x22, 0x20, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0b, 0x0a, 0x07,
	0x4f, 0x46, 0x46, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4f, 0x4e, 0x4c,
	0x49, 0x4e, 0x45, 0x10, 0x01, 0x22, 0xb4, 0x01, 0x0a, 0x0d, 0x4d, 0x65, 0x73, 0x68, 0x48, 0x65,
	0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x67, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x49,
	0x64, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x04, 0x74, 0x69, 0x6d,
	0x65, 0x12, 0x39, 0x0a, 0x0a, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x77, 0x2e, 0x4d, 0x65, 0x73, 0x68, 0x48,
	0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65, 0x6c, 0x61, 0x79, 0x50, 0x61, 0x74,
	0x68, 0x52, 0x09, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x50, 0x61, 0x74, 0x68, 0x22, 0x59, 0x0a, 0x16,
	0x4d, 0x65, 0x73, 0x68, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x52, 0x65, 0x6c,
	0x61, 0x79, 0x50, 0x61, 0x74, 0x68, 0x12, 0x19, 0x0a, 0x08, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x72, 0x65, 0x6c, 0x61, 0x79, 0x49,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x73, 0x73, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x04, 0x72, 0x73, 0x73, 0x69, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x6e, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x03, 0x73, 0x6e, 0x72, 0x2a, 0xb5, 0x01, 0x0a, 0x08, 0x43, 0x6f, 0x64, 0x65,
	0x52, 0x61, 0x74, 0x65, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x52, 0x5f, 0x55, 0x4e, 0x44, 0x45, 0x46,
	0x49, 0x4e, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x5f, 0x34, 0x5f, 0x35,
	0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x5f, 0x34, 0x5f, 0x36, 0x10, 0x02, 0x12, 0x0a,
	0x0a, 0x06, 0x43, 0x52, 0x5f, 0x34, 0x5f, 0x37, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52,
	0x5f, 0x34, 0x5f, 0x38, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x5f, 0x33, 0x5f, 0x38,
	0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x5f, 0x32, 0x5f, 0x36, 0x10, 0x06, 0x12, 0x0a,
	0x0a, 0x06, 0x43, 0x52, 0x5f, 0x31, 0x5f, 0x34, 0x10, 0x07, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52,
	0x5f, 0x31, 0x5f, 0x36, 0x10, 0x08, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x5f, 0x35, 0x5f, 0x36,
	0x10, 0x09, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x52, 0x5f, 0x4c, 0x49, 0x5f, 0x34, 0x5f, 0x35, 0x10,
	0x0a, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x52, 0x5f, 0x4c, 0x49, 0x5f, 0x34, 0x5f, 0x36, 0x10, 0x0b,
	0x12, 0x0d, 0x0a, 0x09, 0x43, 0x52, 0x5f, 0x4c, 0x49, 0x5f, 0x34, 0x5f, 0x38, 0x10, 0x0c, 0x2a,
	0x3b, 0x0a, 0x0e, 0x44, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x54, 0x69, 0x6d, 0x69, 0x6e,
	0x67, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4d, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x54, 0x45, 0x4c, 0x59,
	0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x45, 0x4c, 0x41, 0x59, 0x10, 0x01, 0x12, 0x0d, 0x0a,
	0x09, 0x47, 0x50, 0x53, 0x5f, 0x45, 0x50, 0x4f, 0x43, 0x48, 0x10, 0x02, 0x2a, 0x37, 0x0a, 0x11,
	0x46, 0x69, 0x6e, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x45,
	0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x4c,
	0x41, 0x49, 0x4e, 0x10, 0x02, 0x2a, 0x30, 0x0a, 0x09, 0x43, 0x52, 0x43, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x0a, 0x0a, 0x06, 0x4e, 0x4f, 0x5f, 0x43, 0x52, 0x43, 0x10, 0x00, 0x12, 0x0b,
	0x0a, 0x07, 0x42, 0x41, 0x44, 0x5f, 0x43, 0x52, 0x43, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x43,
	0x52, 0x43, 0x5f, 0x4f, 0x4b, 0x10, 0x02, 0x2a, 0xd5, 0x01, 0x0a, 0x0b, 0x54, 0x78, 0x41, 0x63,
	0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x47, 0x4e, 0x4f, 0x52,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x4f, 0x4b, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x54, 0x4f, 0x4f, 0x5f, 0x4c, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x4f,
	0x4f, 0x5f, 0x45, 0x41, 0x52, 0x4c, 0x59, 0x10, 0x03, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x4c,
	0x4c, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x41, 0x43, 0x4b, 0x45, 0x54, 0x10, 0x04, 0x12,
	0x14, 0x0a, 0x10, 0x43, 0x4f, 0x4c, 0x4c, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x42, 0x45, 0x41,
	0x43, 0x4f, 0x4e, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x54, 0x58, 0x5f, 0x46, 0x52, 0x45, 0x51,
	0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x54, 0x58, 0x5f, 0x50, 0x4f, 0x57, 0x45, 0x52, 0x10, 0x07,
	0x12, 0x10, 0x0a, 0x0c, 0x47, 0x50, 0x53, 0x5f, 0x55, 0x4e, 0x4c, 0x4f, 0x43, 0x4b, 0x45, 0x44,
	0x10, 0x08, 0x12, 0x0e, 0x0a, 0x0a, 0x51, 0x55, 0x45, 0x55, 0x45, 0x5f, 0x46, 0x55, 0x4c, 0x4c,
	0x10, 0x09, 0x12, 0x12, 0x0a, 0x0e, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x0a, 0x12, 0x17, 0x0a, 0x13, 0x44, 0x55, 0x54, 0x59, 0x5f, 0x43,
	0x59, 0x43, 0x4c, 0x45, 0x5f, 0x4f, 0x56, 0x45, 0x52, 0x46, 0x4c, 0x4f, 0x57, 0x10, 0x0b, 0x42,
	0xa0, 0x01, 0x0a, 0x14, 0x69, 0x6f, 0x2e, 0x63, 0x68, 0x69, 0x72, 0x70, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x77, 0x42, 0x0c, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x2d, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x68, 0x69, 0x72, 0x70, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f,
	0x63, 0x68, 0x69, 0x72, 0x70, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x67,
	0x6f, 0x2f, 0x76, 0x34, 0x2f, 0x67, 0x77, 0xaa, 0x02, 0x12, 0x43, 0x68, 0x69, 0x72, 0x70, 0x73,
	0x74, 0x61, 0x63, 0x6b, 0x2e, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0xca, 0x02, 0x12, 0x43,
	0x68, 0x69, 0x72, 0x70, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5c, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61,
	0x79, 0xe2, 0x02, 0x1e, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5c,
	0x43, 0x68, 0x69, 0x72, 0x70, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5c, 0x47, 0x61, 0x74, 0x65, 0x77,
	0x61, 0x79, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_gw_gw_proto_rawDescOnce sync.Once
	file_gw_gw_proto_rawDescData = file_gw_gw_proto_rawDesc
)

func file_gw_gw_proto_rawDescGZIP() []byte {
	file_gw_gw_proto_rawDescOnce.Do(func() {
		file_gw_gw_proto_rawDescData = protoimpl.X.CompressGZIP(file_gw_gw_proto_rawDescData)
	})
	return file_gw_gw_proto_rawDescData
}

var file_gw_gw_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_gw_gw_proto_msgTypes = make([]protoimpl.MessageInfo, 44)
var file_gw_gw_proto_goTypes = []any{
	(CodeRate)(0),                      // 0: gw.CodeRate
	(DownlinkTiming)(0),                // 1: gw.DownlinkTiming
	(FineTimestampType)(0),             // 2: gw.FineTimestampType
	(CRCStatus)(0),                     // 3: gw.CRCStatus
	(TxAckStatus)(0),                   // 4: gw.TxAckStatus
	(ConnState_State)(0),               // 5: gw.ConnState.State
	(*Modulation)(nil),                 // 6: gw.Modulation
	(*UplinkTxInfoLegacy)(nil),         // 7: gw.UplinkTxInfoLegacy
	(*UplinkTxInfo)(nil),               // 8: gw.UplinkTxInfo
	(*LoraModulationInfo)(nil),         // 9: gw.LoraModulationInfo
	(*FskModulationInfo)(nil),          // 10: gw.FskModulationInfo
	(*LrFhssModulationInfo)(nil),       // 11: gw.LrFhssModulationInfo
	(*EncryptedFineTimestamp)(nil),     // 12: gw.EncryptedFineTimestamp
	(*PlainFineTimestamp)(nil),         // 13: gw.PlainFineTimestamp
	(*GatewayStats)(nil),               // 14: gw.GatewayStats
	(*PerModulationCount)(nil),         // 15: gw.PerModulationCount
	(*DutyCycleStats)(nil),             // 16: gw.DutyCycleStats
	(*DutyCycleBand)(nil),              // 17: gw.DutyCycleBand
	(*UplinkRxInfoLegacy)(nil),         // 18: gw.UplinkRxInfoLegacy
	(*UplinkRxInfo)(nil),               // 19: gw.UplinkRxInfo
	(*DownlinkTxInfoLegacy)(nil),       // 20: gw.DownlinkTxInfoLegacy
	(*DownlinkTxInfo)(nil),             // 21: gw.DownlinkTxInfo
	(*Timing)(nil),                     // 22: gw.Timing
	(*ImmediatelyTimingInfo)(nil),      // 23: gw.ImmediatelyTimingInfo
	(*DelayTimingInfo)(nil),            // 24: gw.DelayTimingInfo
	(*GPSEpochTimingInfo)(nil),         // 25: gw.GPSEpochTimingInfo
	(*UplinkFrame)(nil),                // 26: gw.UplinkFrame
	(*UplinkFrameSet)(nil),             // 27: gw.UplinkFrameSet
	(*DownlinkFrame)(nil),              // 28: gw.DownlinkFrame
	(*DownlinkFrameItem)(nil),          // 29: gw.DownlinkFrameItem
	(*DownlinkTxAck)(nil),              // 30: gw.DownlinkTxAck
	(*DownlinkTxAckItem)(nil),          // 31: gw.DownlinkTxAckItem
	(*GatewayConfiguration)(nil),       // 32: gw.GatewayConfiguration
	(*ChannelConfiguration)(nil),       // 33: gw.ChannelConfiguration
	(*LoraModulationConfig)(nil),       // 34: gw.LoraModulationConfig
	(*FskModulationConfig)(nil),        // 35: gw.FskModulationConfig
	(*GatewayCommandExecRequest)(nil),  // 36: gw.GatewayCommandExecRequest
	(*GatewayCommandExecResponse)(nil), // 37: gw.GatewayCommandExecResponse
	(*RawPacketForwarderEvent)(nil),    // 38: gw.RawPacketForwarderEvent
	(*RawPacketForwarderCommand)(nil),  // 39: gw.RawPacketForwarderCommand
	(*ConnState)(nil),                  // 40: gw.ConnState
	(*MeshHeartbeat)(nil),              // 41: gw.MeshHeartbeat
	(*MeshHeartbeatRelayPath)(nil),     // 42: gw.MeshHeartbeatRelayPath
	nil,                                // 43: gw.GatewayStats.MetadataEntry
	nil,                                // 44: gw.GatewayStats.TxPacketsPerFrequencyEntry
	nil,                                // 45: gw.GatewayStats.RxPacketsPerFrequencyEntry
	nil,                                // 46: gw.GatewayStats.TxPacketsPerStatusEntry
	nil,                                // 47: gw.UplinkRxInfoLegacy.MetadataEntry
	nil,                                // 48: gw.UplinkRxInfo.MetadataEntry
	nil,                                // 49: gw.GatewayCommandExecRequest.EnvironmentEntry
	(common.Modulation)(0),             // 50: common.Modulation
	(*timestamppb.Timestamp)(nil),      // 51: google.protobuf.Timestamp
	(*common.Location)(nil),            // 52: common.Location
	(common.Regulation)(0),             // 53: common.Regulation
	(*durationpb.Duration)(nil),        // 54: google.protobuf.Duration
}
var file_gw_gw_proto_depIdxs = []int32{
	9,  // 0: gw.Modulation.lora:type_name -> gw.LoraModulationInfo
	10, // 1: gw.Modulation.fsk:type_name -> gw.FskModulationInfo
	11, // 2: gw.Modulation.lr_fhss:type_name -> gw.LrFhssModulationInfo
	50, // 3: gw.UplinkTxInfoLegacy.modulation:type_name -> common.Modulation
	9,  // 4: gw.UplinkTxInfoLegacy.lora_modulation_info:type_name -> gw.LoraModulationInfo
	10, // 5: gw.UplinkTxInfoLegacy.fsk_modulation_info:type_name -> gw.FskModulationInfo
	11, // 6: gw.UplinkTxInfoLegacy.lr_fhss_modulation_info:type_name -> gw.LrFhssModulationInfo
	6,  // 7: gw.UplinkTxInfo.modulation:type_name -> gw.Modulation
	0,  // 8: gw.LoraModulationInfo.code_rate:type_name -> gw.CodeRate
	0,  // 9: gw.LrFhssModulationInfo.code_rate:type_name -> gw.CodeRate
	51, // 10: gw.PlainFineTimestamp.time:type_name -> google.protobuf.Timestamp
	51, // 11: gw.GatewayStats.time:type_name -> google.protobuf.Timestamp
	52, // 12: gw.GatewayStats.location:type_name -> common.Location
	43, // 13: gw.GatewayStats.metadata:type_name -> gw.GatewayStats.MetadataEntry
	44, // 14: gw.GatewayStats.tx_packets_per_frequency:type_name -> gw.GatewayStats.TxPacketsPerFrequencyEntry
	45, // 15: gw.GatewayStats.rx_packets_per_frequency:type_name -> gw.GatewayStats.RxPacketsPerFrequencyEntry
	15, // 16: gw.GatewayStats.tx_packets_per_modulation:type_name -> gw.PerModulationCount
	15, // 17: gw.GatewayStats.rx_packets_per_modulation:type_name -> gw.PerModulationCount
	46, // 18: gw.GatewayStats.tx_packets_per_status:type_name -> gw.GatewayStats.TxPacketsPerStatusEntry
	16, // 19: gw.GatewayStats.duty_cycle_stats:type_name -> gw.DutyCycleStats
	6,  // 20: gw.PerModulationCount.modulation:type_name -> gw.Modulation
	53, // 21: gw.DutyCycleStats.regulation:type_name -> common.Regulation
	54, // 22: gw.DutyCycleStats.window:type_name -> google.protobuf.Duration
	17, // 23: gw.DutyCycleStats.bands:type_name -> gw.DutyCycleBand
	54, // 24: gw.DutyCycleBand.load_max:type_name -> google.protobuf.Duration
	54, // 25: gw.DutyCycleBand.load_tracked:type_name -> google.protobuf.Duration
	51, // 26: gw.UplinkRxInfoLegacy.time:type_name -> google.protobuf.Timestamp
	54, // 27: gw.UplinkRxInfoLegacy.time_since_gps_epoch:type_name -> google.protobuf.Duration
	52, // 28: gw.UplinkRxInfoLegacy.location:type_name -> common.Location
	2,  // 29: gw.UplinkRxInfoLegacy.fine_timestamp_type:type_name -> gw.FineTimestampType
	12, // 30: gw.UplinkRxInfoLegacy.encrypted_fine_timestamp:type_name -> gw.EncryptedFineTimestamp
	13, // 31: gw.UplinkRxInfoLegacy.plain_fine_timestamp:type_name -> gw.PlainFineTimestamp
	3,  // 32: gw.UplinkRxInfoLegacy.crc_status:type_name -> gw.CRCStatus
	47, // 33: gw.UplinkRxInfoLegacy.metadata:type_name -> gw.UplinkRxInfoLegacy.MetadataEntry
	51, // 34: gw.UplinkRxInfo.gw_time:type_name -> google.protobuf.Timestamp
	51, // 35: gw.UplinkRxInfo.ns_time:type_name -> google.protobuf.Timestamp
	54, // 36: gw.UplinkRxInfo.time_since_gps_epoch:type_name -> google.protobuf.Duration
	54, // 37: gw.UplinkRxInfo.fine_time_since_gps_epoch:type_name -> google.protobuf.Duration
	52, // 38: gw.UplinkRxInfo.location:type_name -> common.Location
	48, // 39: gw.UplinkRxInfo.metadata:type_name -> gw.UplinkRxInfo.MetadataEntry
	3,  // 40: gw.UplinkRxInfo.crc_status:type_name -> gw.CRCStatus
	50, // 41: gw.DownlinkTxInfoLegacy.modulation:type_name -> common.Modulation
	9,  // 42: gw.DownlinkTxInfoLegacy.lora_modulation_info:type_name -> gw.LoraModulationInfo
	10, // 43: gw.DownlinkTxInfoLegacy.fsk_modulation_info:type_name -> gw.FskModulationInfo
	1,  // 44: gw.DownlinkTxInfoLegacy.timing:type_name -> gw.DownlinkTiming
	23, // 45: gw.DownlinkTxInfoLegacy.immediately_timing_info:type_name -> gw.ImmediatelyTimingInfo
	24, // 46: gw.DownlinkTxInfoLegacy.delay_timing_info:type_name -> gw.DelayTimingInfo
	25, // 47: gw.DownlinkTxInfoLegacy.gps_epoch_timing_info:type_name -> gw.GPSEpochTimingInfo
	6,  // 48: gw.DownlinkTxInfo.modulation:type_name -> gw.Modulation
	22, // 49: gw.DownlinkTxInfo.timing:type_name -> gw.Timing
	23, // 50: gw.Timing.immediately:type_name -> gw.ImmediatelyTimingInfo
	24, // 51: gw.Timing.delay:type_name -> gw.DelayTimingInfo
	25, // 52: gw.Timing.gps_epoch:type_name -> gw.GPSEpochTimingInfo
	54, // 53: gw.DelayTimingInfo.delay:type_name -> google.protobuf.Duration
	54, // 54: gw.GPSEpochTimingInfo.time_since_gps_epoch:type_name -> google.protobuf.Duration
	7,  // 55: gw.UplinkFrame.tx_info_legacy:type_name -> gw.UplinkTxInfoLegacy
	18, // 56: gw.UplinkFrame.rx_info_legacy:type_name -> gw.UplinkRxInfoLegacy
	8,  // 57: gw.UplinkFrame.tx_info:type_name -> gw.UplinkTxInfo
	19, // 58: gw.UplinkFrame.rx_info:type_name -> gw.UplinkRxInfo
	8,  // 59: gw.UplinkFrameSet.tx_info:type_name -> gw.UplinkTxInfo
	19, // 60: gw.UplinkFrameSet.rx_info:type_name -> gw.UplinkRxInfo
	29, // 61: gw.DownlinkFrame.items:type_name -> gw.DownlinkFrameItem
	20, // 62: gw.DownlinkFrameItem.tx_info_legacy:type_name -> gw.DownlinkTxInfoLegacy
	21, // 63: gw.DownlinkFrameItem.tx_info:type_name -> gw.DownlinkTxInfo
	31, // 64: gw.DownlinkTxAck.items:type_name -> gw.DownlinkTxAckItem
	4,  // 65: gw.DownlinkTxAckItem.status:type_name -> gw.TxAckStatus
	33, // 66: gw.GatewayConfiguration.channels:type_name -> gw.ChannelConfiguration
	54, // 67: gw.GatewayConfiguration.stats_interval:type_name -> google.protobuf.Duration
	50, // 68: gw.ChannelConfiguration.modulation_legacy:type_name -> common.Modulation
	34, // 69: gw.ChannelConfiguration.lora_modulation_config:type_name -> gw.LoraModulationConfig
	35, // 70: gw.ChannelConfiguration.fsk_modulation_config:type_name -> gw.FskModulationConfig
	49, // 71: gw.GatewayCommandExecRequest.environment:type_name -> gw.GatewayCommandExecRequest.EnvironmentEntry
	5,  // 72: gw.ConnState.state:type_name -> gw.ConnState.State
	51, // 73: gw.MeshHeartbeat.time:type_name -> google.protobuf.Timestamp
	42, // 74: gw.MeshHeartbeat.relay_path:type_name -> gw.MeshHeartbeatRelayPath
	75, // [75:75] is the sub-list for method output_type
	75, // [75:75] is the sub-list for method input_type
	75, // [75:75] is the sub-list for extension type_name
	75, // [75:75] is the sub-list for extension extendee
	0,  // [0:75] is the sub-list for field type_name
}

func init() { file_gw_gw_proto_init() }
func file_gw_gw_proto_init() {
	if File_gw_gw_proto != nil {
		return
	}
	file_gw_gw_proto_msgTypes[0].OneofWrappers = []any{
		(*Modulation_Lora)(nil),
		(*Modulation_Fsk)(nil),
		(*Modulation_LrFhss)(nil),
	}
	file_gw_gw_proto_msgTypes[1].OneofWrappers = []any{
		(*UplinkTxInfoLegacy_LoraModulationInfo)(nil),
		(*UplinkTxInfoLegacy_FskModulationInfo)(nil),
		(*UplinkTxInfoLegacy_LrFhssModulationInfo)(nil),
	}
	file_gw_gw_proto_msgTypes[12].OneofWrappers = []any{
		(*UplinkRxInfoLegacy_EncryptedFineTimestamp)(nil),
		(*UplinkRxInfoLegacy_PlainFineTimestamp)(nil),
	}
	file_gw_gw_proto_msgTypes[14].OneofWrappers = []any{
		(*DownlinkTxInfoLegacy_LoraModulationInfo)(nil),
		(*DownlinkTxInfoLegacy_FskModulationInfo)(nil),
		(*DownlinkTxInfoLegacy_ImmediatelyTimingInfo)(nil),
		(*DownlinkTxInfoLegacy_DelayTimingInfo)(nil),
		(*DownlinkTxInfoLegacy_GpsEpochTimingInfo)(nil),
	}
	file_gw_gw_proto_msgTypes[16].OneofWrappers = []any{
		(*Timing_Immediately)(nil),
		(*Timing_Delay)(nil),
		(*Timing_GpsEpoch)(nil),
	}
	file_gw_gw_proto_msgTypes[27].OneofWrappers = []any{
		(*ChannelConfiguration_LoraModulationConfig)(nil),
		(*ChannelConfiguration_FskModulationConfig)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_gw_gw_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   44,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_gw_gw_proto_goTypes,
		DependencyIndexes: file_gw_gw_proto_depIdxs,
		EnumInfos:         file_gw_gw_proto_enumTypes,
		MessageInfos:      file_gw_gw_proto_msgTypes,
	}.Build()
	File_gw_gw_proto = out.File
	file_gw_gw_proto_rawDesc = nil
	file_gw_gw_proto_goTypes = nil
	file_gw_gw_proto_depIdxs = nil
}
