// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.1
// 	protoc        v5.28.3
// source: api/device.proto

package api

import (
	common "github.com/chirpstack/chirpstack/api/go/v4/common"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Device struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DevEUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Application ID (UUID).
	ApplicationId string `protobuf:"bytes,4,opt,name=application_id,json=applicationId,proto3" json:"application_id,omitempty"`
	// Device-profile ID (UUID).
	DeviceProfileId string `protobuf:"bytes,5,opt,name=device_profile_id,json=deviceProfileId,proto3" json:"device_profile_id,omitempty"`
	// Skip frame-counter checks (this is insecure, but could be helpful for
	// debugging).
	SkipFcntCheck bool `protobuf:"varint,6,opt,name=skip_fcnt_check,json=skipFcntCheck,proto3" json:"skip_fcnt_check,omitempty"`
	// Device is disabled.
	IsDisabled bool `protobuf:"varint,7,opt,name=is_disabled,json=isDisabled,proto3" json:"is_disabled,omitempty"`
	// Variables (user defined).
	// These variables can be used together with integrations to store tokens /
	// secrets that must be configured per device. These variables are not
	// exposed in the event payloads.
	Variables map[string]string `protobuf:"bytes,8,rep,name=variables,proto3" json:"variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Tags (user defined).
	// These tags can be used to add additional information to the device.
	// These tags are exposed in all the integration events.
	Tags map[string]string `protobuf:"bytes,9,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// JoinEUI (optional, EUI64).
	// This field will be automatically set / updated on OTAA. However, in some
	// cases it must be pre-configured. For example to allow OTAA using a Relay.
	// In this case the Relay needs to know the JoinEUI + DevEUI combinations
	// of the devices for which it needs to forward uplinks.
	JoinEui string `protobuf:"bytes,10,opt,name=join_eui,json=joinEui,proto3" json:"join_eui,omitempty"`
}

func (x *Device) Reset() {
	*x = Device{}
	mi := &file_api_device_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Device) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Device) ProtoMessage() {}

func (x *Device) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Device.ProtoReflect.Descriptor instead.
func (*Device) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{0}
}

func (x *Device) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

func (x *Device) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Device) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Device) GetApplicationId() string {
	if x != nil {
		return x.ApplicationId
	}
	return ""
}

func (x *Device) GetDeviceProfileId() string {
	if x != nil {
		return x.DeviceProfileId
	}
	return ""
}

func (x *Device) GetSkipFcntCheck() bool {
	if x != nil {
		return x.SkipFcntCheck
	}
	return false
}

func (x *Device) GetIsDisabled() bool {
	if x != nil {
		return x.IsDisabled
	}
	return false
}

func (x *Device) GetVariables() map[string]string {
	if x != nil {
		return x.Variables
	}
	return nil
}

func (x *Device) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *Device) GetJoinEui() string {
	if x != nil {
		return x.JoinEui
	}
	return ""
}

type DeviceStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The device margin status
	// -32..32: The demodulation SNR ration in dB
	Margin int32 `protobuf:"varint,1,opt,name=margin,proto3" json:"margin,omitempty"`
	// Device is connected to an external power source.
	ExternalPowerSource bool `protobuf:"varint,2,opt,name=external_power_source,json=externalPowerSource,proto3" json:"external_power_source,omitempty"`
	// Device battery level as a percentage.
	// -1 when the battery level is not available.
	BatteryLevel float32 `protobuf:"fixed32,3,opt,name=battery_level,json=batteryLevel,proto3" json:"battery_level,omitempty"`
}

func (x *DeviceStatus) Reset() {
	*x = DeviceStatus{}
	mi := &file_api_device_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeviceStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceStatus) ProtoMessage() {}

func (x *DeviceStatus) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceStatus.ProtoReflect.Descriptor instead.
func (*DeviceStatus) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{1}
}

func (x *DeviceStatus) GetMargin() int32 {
	if x != nil {
		return x.Margin
	}
	return 0
}

func (x *DeviceStatus) GetExternalPowerSource() bool {
	if x != nil {
		return x.ExternalPowerSource
	}
	return false
}

func (x *DeviceStatus) GetBatteryLevel() float32 {
	if x != nil {
		return x.BatteryLevel
	}
	return 0
}

type DeviceListItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DevEUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Created at timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Last update timestamp.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Last seen at timestamp.
	LastSeenAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=last_seen_at,json=lastSeenAt,proto3" json:"last_seen_at,omitempty"`
	// Name.
	Name string `protobuf:"bytes,5,opt,name=name,proto3" json:"name,omitempty"`
	// Description.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Device-profile ID (UUID).
	DeviceProfileId string `protobuf:"bytes,7,opt,name=device_profile_id,json=deviceProfileId,proto3" json:"device_profile_id,omitempty"`
	// Device-profile name.
	DeviceProfileName string `protobuf:"bytes,8,opt,name=device_profile_name,json=deviceProfileName,proto3" json:"device_profile_name,omitempty"`
	// Device status.
	DeviceStatus *DeviceStatus `protobuf:"bytes,9,opt,name=device_status,json=deviceStatus,proto3" json:"device_status,omitempty"`
}

func (x *DeviceListItem) Reset() {
	*x = DeviceListItem{}
	mi := &file_api_device_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeviceListItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceListItem) ProtoMessage() {}

func (x *DeviceListItem) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceListItem.ProtoReflect.Descriptor instead.
func (*DeviceListItem) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{2}
}

func (x *DeviceListItem) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

func (x *DeviceListItem) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *DeviceListItem) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *DeviceListItem) GetLastSeenAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LastSeenAt
	}
	return nil
}

func (x *DeviceListItem) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeviceListItem) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DeviceListItem) GetDeviceProfileId() string {
	if x != nil {
		return x.DeviceProfileId
	}
	return ""
}

func (x *DeviceListItem) GetDeviceProfileName() string {
	if x != nil {
		return x.DeviceProfileName
	}
	return ""
}

func (x *DeviceListItem) GetDeviceStatus() *DeviceStatus {
	if x != nil {
		return x.DeviceStatus
	}
	return nil
}

type DeviceKeys struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DevEUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Network root key (128 bit).
	// Note: For LoRaWAN 1.0.x, use this field for the LoRaWAN 1.0.x 'AppKey`!
	NwkKey string `protobuf:"bytes,2,opt,name=nwk_key,json=nwkKey,proto3" json:"nwk_key,omitempty"`
	// Application root key (128 bit).
	// Note: This field only needs to be set for LoRaWAN 1.1.x devices!
	AppKey string `protobuf:"bytes,3,opt,name=app_key,json=appKey,proto3" json:"app_key,omitempty"`
}

func (x *DeviceKeys) Reset() {
	*x = DeviceKeys{}
	mi := &file_api_device_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeviceKeys) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceKeys) ProtoMessage() {}

func (x *DeviceKeys) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceKeys.ProtoReflect.Descriptor instead.
func (*DeviceKeys) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{3}
}

func (x *DeviceKeys) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

func (x *DeviceKeys) GetNwkKey() string {
	if x != nil {
		return x.NwkKey
	}
	return ""
}

func (x *DeviceKeys) GetAppKey() string {
	if x != nil {
		return x.AppKey
	}
	return ""
}

type CreateDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device object.
	Device *Device `protobuf:"bytes,1,opt,name=device,proto3" json:"device,omitempty"`
}

func (x *CreateDeviceRequest) Reset() {
	*x = CreateDeviceRequest{}
	mi := &file_api_device_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDeviceRequest) ProtoMessage() {}

func (x *CreateDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDeviceRequest.ProtoReflect.Descriptor instead.
func (*CreateDeviceRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{4}
}

func (x *CreateDeviceRequest) GetDevice() *Device {
	if x != nil {
		return x.Device
	}
	return nil
}

type GetDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DevEUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
}

func (x *GetDeviceRequest) Reset() {
	*x = GetDeviceRequest{}
	mi := &file_api_device_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceRequest) ProtoMessage() {}

func (x *GetDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceRequest.ProtoReflect.Descriptor instead.
func (*GetDeviceRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{5}
}

func (x *GetDeviceRequest) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

type GetDeviceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device object.
	Device *Device `protobuf:"bytes,1,opt,name=device,proto3" json:"device,omitempty"`
	// Created at timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Last update timestamp.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
	// Last seen at timestamp.
	LastSeenAt *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=last_seen_at,json=lastSeenAt,proto3" json:"last_seen_at,omitempty"`
	// Device status.
	DeviceStatus *DeviceStatus `protobuf:"bytes,5,opt,name=device_status,json=deviceStatus,proto3" json:"device_status,omitempty"`
	// Enabled device class.
	ClassEnabled common.DeviceClass `protobuf:"varint,6,opt,name=class_enabled,json=classEnabled,proto3,enum=common.DeviceClass" json:"class_enabled,omitempty"`
}

func (x *GetDeviceResponse) Reset() {
	*x = GetDeviceResponse{}
	mi := &file_api_device_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDeviceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceResponse) ProtoMessage() {}

func (x *GetDeviceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceResponse.ProtoReflect.Descriptor instead.
func (*GetDeviceResponse) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{6}
}

func (x *GetDeviceResponse) GetDevice() *Device {
	if x != nil {
		return x.Device
	}
	return nil
}

func (x *GetDeviceResponse) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *GetDeviceResponse) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

func (x *GetDeviceResponse) GetLastSeenAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LastSeenAt
	}
	return nil
}

func (x *GetDeviceResponse) GetDeviceStatus() *DeviceStatus {
	if x != nil {
		return x.DeviceStatus
	}
	return nil
}

func (x *GetDeviceResponse) GetClassEnabled() common.DeviceClass {
	if x != nil {
		return x.ClassEnabled
	}
	return common.DeviceClass(0)
}

type UpdateDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device object.
	Device *Device `protobuf:"bytes,1,opt,name=device,proto3" json:"device,omitempty"`
}

func (x *UpdateDeviceRequest) Reset() {
	*x = UpdateDeviceRequest{}
	mi := &file_api_device_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDeviceRequest) ProtoMessage() {}

func (x *UpdateDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDeviceRequest.ProtoReflect.Descriptor instead.
func (*UpdateDeviceRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{7}
}

func (x *UpdateDeviceRequest) GetDevice() *Device {
	if x != nil {
		return x.Device
	}
	return nil
}

type DeleteDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DevEUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
}

func (x *DeleteDeviceRequest) Reset() {
	*x = DeleteDeviceRequest{}
	mi := &file_api_device_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDeviceRequest) ProtoMessage() {}

func (x *DeleteDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDeviceRequest.ProtoReflect.Descriptor instead.
func (*DeleteDeviceRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteDeviceRequest) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

type ListDevicesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Max number of devices to return in the result-set.
	Limit uint32 `protobuf:"varint,1,opt,name=limit,proto3" json:"limit,omitempty"`
	// Offset in the result-set (for pagination).
	Offset uint32 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// If set, the given string will be used to search on name (optional).
	Search string `protobuf:"bytes,3,opt,name=search,proto3" json:"search,omitempty"`
	// Application ID (UUID) to filter devices on.
	ApplicationId string `protobuf:"bytes,4,opt,name=application_id,json=applicationId,proto3" json:"application_id,omitempty"`
	// Multicst-group ID (UUID) to filter devices on.
	MulticastGroupId string `protobuf:"bytes,5,opt,name=multicast_group_id,json=multicastGroupId,proto3" json:"multicast_group_id,omitempty"`
}

func (x *ListDevicesRequest) Reset() {
	*x = ListDevicesRequest{}
	mi := &file_api_device_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDevicesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDevicesRequest) ProtoMessage() {}

func (x *ListDevicesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDevicesRequest.ProtoReflect.Descriptor instead.
func (*ListDevicesRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{9}
}

func (x *ListDevicesRequest) GetLimit() uint32 {
	if x != nil {
		return x.Limit
	}
	return 0
}

func (x *ListDevicesRequest) GetOffset() uint32 {
	if x != nil {
		return x.Offset
	}
	return 0
}

func (x *ListDevicesRequest) GetSearch() string {
	if x != nil {
		return x.Search
	}
	return ""
}

func (x *ListDevicesRequest) GetApplicationId() string {
	if x != nil {
		return x.ApplicationId
	}
	return ""
}

func (x *ListDevicesRequest) GetMulticastGroupId() string {
	if x != nil {
		return x.MulticastGroupId
	}
	return ""
}

type ListDevicesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total number of devices.
	TotalCount uint32 `protobuf:"varint,1,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
	// Result-set.
	Result []*DeviceListItem `protobuf:"bytes,2,rep,name=result,proto3" json:"result,omitempty"`
}

func (x *ListDevicesResponse) Reset() {
	*x = ListDevicesResponse{}
	mi := &file_api_device_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDevicesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDevicesResponse) ProtoMessage() {}

func (x *ListDevicesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDevicesResponse.ProtoReflect.Descriptor instead.
func (*ListDevicesResponse) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{10}
}

func (x *ListDevicesResponse) GetTotalCount() uint32 {
	if x != nil {
		return x.TotalCount
	}
	return 0
}

func (x *ListDevicesResponse) GetResult() []*DeviceListItem {
	if x != nil {
		return x.Result
	}
	return nil
}

type CreateDeviceKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device-keys object.
	DeviceKeys *DeviceKeys `protobuf:"bytes,1,opt,name=device_keys,json=deviceKeys,proto3" json:"device_keys,omitempty"`
}

func (x *CreateDeviceKeysRequest) Reset() {
	*x = CreateDeviceKeysRequest{}
	mi := &file_api_device_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDeviceKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDeviceKeysRequest) ProtoMessage() {}

func (x *CreateDeviceKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDeviceKeysRequest.ProtoReflect.Descriptor instead.
func (*CreateDeviceKeysRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{11}
}

func (x *CreateDeviceKeysRequest) GetDeviceKeys() *DeviceKeys {
	if x != nil {
		return x.DeviceKeys
	}
	return nil
}

type GetDeviceKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DevEUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
}

func (x *GetDeviceKeysRequest) Reset() {
	*x = GetDeviceKeysRequest{}
	mi := &file_api_device_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDeviceKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceKeysRequest) ProtoMessage() {}

func (x *GetDeviceKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceKeysRequest.ProtoReflect.Descriptor instead.
func (*GetDeviceKeysRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{12}
}

func (x *GetDeviceKeysRequest) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

type GetDeviceKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device-keys object.
	DeviceKeys *DeviceKeys `protobuf:"bytes,1,opt,name=device_keys,json=deviceKeys,proto3" json:"device_keys,omitempty"`
	// Created at timestamp.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Last update timestamp.
	UpdatedAt *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=updated_at,json=updatedAt,proto3" json:"updated_at,omitempty"`
}

func (x *GetDeviceKeysResponse) Reset() {
	*x = GetDeviceKeysResponse{}
	mi := &file_api_device_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDeviceKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceKeysResponse) ProtoMessage() {}

func (x *GetDeviceKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceKeysResponse.ProtoReflect.Descriptor instead.
func (*GetDeviceKeysResponse) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{13}
}

func (x *GetDeviceKeysResponse) GetDeviceKeys() *DeviceKeys {
	if x != nil {
		return x.DeviceKeys
	}
	return nil
}

func (x *GetDeviceKeysResponse) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *GetDeviceKeysResponse) GetUpdatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdatedAt
	}
	return nil
}

type UpdateDeviceKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device-keys object.
	DeviceKeys *DeviceKeys `protobuf:"bytes,1,opt,name=device_keys,json=deviceKeys,proto3" json:"device_keys,omitempty"`
}

func (x *UpdateDeviceKeysRequest) Reset() {
	*x = UpdateDeviceKeysRequest{}
	mi := &file_api_device_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDeviceKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDeviceKeysRequest) ProtoMessage() {}

func (x *UpdateDeviceKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDeviceKeysRequest.ProtoReflect.Descriptor instead.
func (*UpdateDeviceKeysRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateDeviceKeysRequest) GetDeviceKeys() *DeviceKeys {
	if x != nil {
		return x.DeviceKeys
	}
	return nil
}

type DeleteDeviceKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DevEUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
}

func (x *DeleteDeviceKeysRequest) Reset() {
	*x = DeleteDeviceKeysRequest{}
	mi := &file_api_device_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteDeviceKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDeviceKeysRequest) ProtoMessage() {}

func (x *DeleteDeviceKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDeviceKeysRequest.ProtoReflect.Descriptor instead.
func (*DeleteDeviceKeysRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteDeviceKeysRequest) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

type DeviceActivation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device EUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Device address (HEX encoded).
	DevAddr string `protobuf:"bytes,2,opt,name=dev_addr,json=devAddr,proto3" json:"dev_addr,omitempty"`
	// Application session key (HEX encoded).
	AppSKey string `protobuf:"bytes,3,opt,name=app_s_key,json=appSKey,proto3" json:"app_s_key,omitempty"`
	// Network session encryption key (HEX encoded).
	// Note: For ABP in LoRaWAN 1.0.x, use this, the serving and the forwarding
	// network session integrity key fields with the LoRaWAN 1.0.x 'NwkSKey`!
	NwkSEncKey string `protobuf:"bytes,4,opt,name=nwk_s_enc_key,json=nwkSEncKey,proto3" json:"nwk_s_enc_key,omitempty"`
	// Serving network session integrity key (HEX encoded).
	SNwkSIntKey string `protobuf:"bytes,8,opt,name=s_nwk_s_int_key,json=sNwkSIntKey,proto3" json:"s_nwk_s_int_key,omitempty"`
	// Forwarding network session integrity key (HEX encoded).
	FNwkSIntKey string `protobuf:"bytes,9,opt,name=f_nwk_s_int_key,json=fNwkSIntKey,proto3" json:"f_nwk_s_int_key,omitempty"`
	// Uplink frame-counter.
	FCntUp uint32 `protobuf:"varint,5,opt,name=f_cnt_up,json=fCntUp,proto3" json:"f_cnt_up,omitempty"`
	// Downlink network frame-counter.
	NFCntDown uint32 `protobuf:"varint,6,opt,name=n_f_cnt_down,json=nFCntDown,proto3" json:"n_f_cnt_down,omitempty"`
	// Downlink application frame-counter.
	AFCntDown uint32 `protobuf:"varint,10,opt,name=a_f_cnt_down,json=aFCntDown,proto3" json:"a_f_cnt_down,omitempty"`
}

func (x *DeviceActivation) Reset() {
	*x = DeviceActivation{}
	mi := &file_api_device_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeviceActivation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceActivation) ProtoMessage() {}

func (x *DeviceActivation) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceActivation.ProtoReflect.Descriptor instead.
func (*DeviceActivation) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{16}
}

func (x *DeviceActivation) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

func (x *DeviceActivation) GetDevAddr() string {
	if x != nil {
		return x.DevAddr
	}
	return ""
}

func (x *DeviceActivation) GetAppSKey() string {
	if x != nil {
		return x.AppSKey
	}
	return ""
}

func (x *DeviceActivation) GetNwkSEncKey() string {
	if x != nil {
		return x.NwkSEncKey
	}
	return ""
}

func (x *DeviceActivation) GetSNwkSIntKey() string {
	if x != nil {
		return x.SNwkSIntKey
	}
	return ""
}

func (x *DeviceActivation) GetFNwkSIntKey() string {
	if x != nil {
		return x.FNwkSIntKey
	}
	return ""
}

func (x *DeviceActivation) GetFCntUp() uint32 {
	if x != nil {
		return x.FCntUp
	}
	return 0
}

func (x *DeviceActivation) GetNFCntDown() uint32 {
	if x != nil {
		return x.NFCntDown
	}
	return 0
}

func (x *DeviceActivation) GetAFCntDown() uint32 {
	if x != nil {
		return x.AFCntDown
	}
	return 0
}

type ActivateDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device activation object.
	DeviceActivation *DeviceActivation `protobuf:"bytes,1,opt,name=device_activation,json=deviceActivation,proto3" json:"device_activation,omitempty"`
}

func (x *ActivateDeviceRequest) Reset() {
	*x = ActivateDeviceRequest{}
	mi := &file_api_device_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ActivateDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActivateDeviceRequest) ProtoMessage() {}

func (x *ActivateDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActivateDeviceRequest.ProtoReflect.Descriptor instead.
func (*ActivateDeviceRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{17}
}

func (x *ActivateDeviceRequest) GetDeviceActivation() *DeviceActivation {
	if x != nil {
		return x.DeviceActivation
	}
	return nil
}

type DeactivateDeviceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DevEUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
}

func (x *DeactivateDeviceRequest) Reset() {
	*x = DeactivateDeviceRequest{}
	mi := &file_api_device_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeactivateDeviceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeactivateDeviceRequest) ProtoMessage() {}

func (x *DeactivateDeviceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeactivateDeviceRequest.ProtoReflect.Descriptor instead.
func (*DeactivateDeviceRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{18}
}

func (x *DeactivateDeviceRequest) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

type GetDeviceActivationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DevEUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
}

func (x *GetDeviceActivationRequest) Reset() {
	*x = GetDeviceActivationRequest{}
	mi := &file_api_device_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDeviceActivationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceActivationRequest) ProtoMessage() {}

func (x *GetDeviceActivationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceActivationRequest.ProtoReflect.Descriptor instead.
func (*GetDeviceActivationRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{19}
}

func (x *GetDeviceActivationRequest) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

type GetDeviceActivationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device activation object.
	DeviceActivation *DeviceActivation `protobuf:"bytes,1,opt,name=device_activation,json=deviceActivation,proto3" json:"device_activation,omitempty"`
	// Join-Server context.
	// A non-empty value indicatest that ChirpStack does not have access to
	// the AppSKey and that the encryption / decryption of the payloads is
	// the responsibility of the end-application.
	JoinServerContext *common.JoinServerContext `protobuf:"bytes,2,opt,name=join_server_context,json=joinServerContext,proto3" json:"join_server_context,omitempty"`
}

func (x *GetDeviceActivationResponse) Reset() {
	*x = GetDeviceActivationResponse{}
	mi := &file_api_device_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDeviceActivationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceActivationResponse) ProtoMessage() {}

func (x *GetDeviceActivationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceActivationResponse.ProtoReflect.Descriptor instead.
func (*GetDeviceActivationResponse) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{20}
}

func (x *GetDeviceActivationResponse) GetDeviceActivation() *DeviceActivation {
	if x != nil {
		return x.DeviceActivation
	}
	return nil
}

func (x *GetDeviceActivationResponse) GetJoinServerContext() *common.JoinServerContext {
	if x != nil {
		return x.JoinServerContext
	}
	return nil
}

type GetRandomDevAddrRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DevEUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
}

func (x *GetRandomDevAddrRequest) Reset() {
	*x = GetRandomDevAddrRequest{}
	mi := &file_api_device_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRandomDevAddrRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRandomDevAddrRequest) ProtoMessage() {}

func (x *GetRandomDevAddrRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRandomDevAddrRequest.ProtoReflect.Descriptor instead.
func (*GetRandomDevAddrRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{21}
}

func (x *GetRandomDevAddrRequest) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

type GetRandomDevAddrResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DevAddr.
	DevAddr string `protobuf:"bytes,1,opt,name=dev_addr,json=devAddr,proto3" json:"dev_addr,omitempty"`
}

func (x *GetRandomDevAddrResponse) Reset() {
	*x = GetRandomDevAddrResponse{}
	mi := &file_api_device_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetRandomDevAddrResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRandomDevAddrResponse) ProtoMessage() {}

func (x *GetRandomDevAddrResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRandomDevAddrResponse.ProtoReflect.Descriptor instead.
func (*GetRandomDevAddrResponse) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{22}
}

func (x *GetRandomDevAddrResponse) GetDevAddr() string {
	if x != nil {
		return x.DevAddr
	}
	return ""
}

type GetDeviceMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DevEUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Interval start timestamp.
	Start *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start,proto3" json:"start,omitempty"`
	// Interval end timestamp.
	End *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end,proto3" json:"end,omitempty"`
	// Aggregation.
	Aggregation common.Aggregation `protobuf:"varint,4,opt,name=aggregation,proto3,enum=common.Aggregation" json:"aggregation,omitempty"`
}

func (x *GetDeviceMetricsRequest) Reset() {
	*x = GetDeviceMetricsRequest{}
	mi := &file_api_device_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDeviceMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceMetricsRequest) ProtoMessage() {}

func (x *GetDeviceMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceMetricsRequest.ProtoReflect.Descriptor instead.
func (*GetDeviceMetricsRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{23}
}

func (x *GetDeviceMetricsRequest) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

func (x *GetDeviceMetricsRequest) GetStart() *timestamppb.Timestamp {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *GetDeviceMetricsRequest) GetEnd() *timestamppb.Timestamp {
	if x != nil {
		return x.End
	}
	return nil
}

func (x *GetDeviceMetricsRequest) GetAggregation() common.Aggregation {
	if x != nil {
		return x.Aggregation
	}
	return common.Aggregation(0)
}

type GetDeviceMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Metrics map[string]*common.Metric `protobuf:"bytes,1,rep,name=metrics,proto3" json:"metrics,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	States  map[string]*DeviceState   `protobuf:"bytes,2,rep,name=states,proto3" json:"states,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *GetDeviceMetricsResponse) Reset() {
	*x = GetDeviceMetricsResponse{}
	mi := &file_api_device_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDeviceMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceMetricsResponse) ProtoMessage() {}

func (x *GetDeviceMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceMetricsResponse.ProtoReflect.Descriptor instead.
func (*GetDeviceMetricsResponse) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{24}
}

func (x *GetDeviceMetricsResponse) GetMetrics() map[string]*common.Metric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *GetDeviceMetricsResponse) GetStates() map[string]*DeviceState {
	if x != nil {
		return x.States
	}
	return nil
}

type DeviceState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Value.
	Value string `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *DeviceState) Reset() {
	*x = DeviceState{}
	mi := &file_api_device_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeviceState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceState) ProtoMessage() {}

func (x *DeviceState) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceState.ProtoReflect.Descriptor instead.
func (*DeviceState) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{25}
}

func (x *DeviceState) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeviceState) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type GetDeviceLinkMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DevEUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Interval start timestamp.
	Start *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start,proto3" json:"start,omitempty"`
	// Interval end timestamp.
	End *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=end,proto3" json:"end,omitempty"`
	// Aggregation.
	Aggregation common.Aggregation `protobuf:"varint,4,opt,name=aggregation,proto3,enum=common.Aggregation" json:"aggregation,omitempty"`
}

func (x *GetDeviceLinkMetricsRequest) Reset() {
	*x = GetDeviceLinkMetricsRequest{}
	mi := &file_api_device_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDeviceLinkMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceLinkMetricsRequest) ProtoMessage() {}

func (x *GetDeviceLinkMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceLinkMetricsRequest.ProtoReflect.Descriptor instead.
func (*GetDeviceLinkMetricsRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{26}
}

func (x *GetDeviceLinkMetricsRequest) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

func (x *GetDeviceLinkMetricsRequest) GetStart() *timestamppb.Timestamp {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *GetDeviceLinkMetricsRequest) GetEnd() *timestamppb.Timestamp {
	if x != nil {
		return x.End
	}
	return nil
}

func (x *GetDeviceLinkMetricsRequest) GetAggregation() common.Aggregation {
	if x != nil {
		return x.Aggregation
	}
	return common.Aggregation(0)
}

type GetDeviceLinkMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Packets received from the device.
	RxPackets *common.Metric `protobuf:"bytes,1,opt,name=rx_packets,json=rxPackets,proto3" json:"rx_packets,omitempty"`
	// RSSI (as reported by the gateway(s)).
	GwRssi *common.Metric `protobuf:"bytes,2,opt,name=gw_rssi,json=gwRssi,proto3" json:"gw_rssi,omitempty"`
	// SNR (as reported by the gateway(s)).
	GwSnr *common.Metric `protobuf:"bytes,3,opt,name=gw_snr,json=gwSnr,proto3" json:"gw_snr,omitempty"`
	// Packets received by frequency.
	RxPacketsPerFreq *common.Metric `protobuf:"bytes,4,opt,name=rx_packets_per_freq,json=rxPacketsPerFreq,proto3" json:"rx_packets_per_freq,omitempty"`
	// Packets received by DR.
	RxPacketsPerDr *common.Metric `protobuf:"bytes,5,opt,name=rx_packets_per_dr,json=rxPacketsPerDr,proto3" json:"rx_packets_per_dr,omitempty"`
	// Errors.
	Errors *common.Metric `protobuf:"bytes,6,opt,name=errors,proto3" json:"errors,omitempty"`
}

func (x *GetDeviceLinkMetricsResponse) Reset() {
	*x = GetDeviceLinkMetricsResponse{}
	mi := &file_api_device_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDeviceLinkMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceLinkMetricsResponse) ProtoMessage() {}

func (x *GetDeviceLinkMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceLinkMetricsResponse.ProtoReflect.Descriptor instead.
func (*GetDeviceLinkMetricsResponse) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{27}
}

func (x *GetDeviceLinkMetricsResponse) GetRxPackets() *common.Metric {
	if x != nil {
		return x.RxPackets
	}
	return nil
}

func (x *GetDeviceLinkMetricsResponse) GetGwRssi() *common.Metric {
	if x != nil {
		return x.GwRssi
	}
	return nil
}

func (x *GetDeviceLinkMetricsResponse) GetGwSnr() *common.Metric {
	if x != nil {
		return x.GwSnr
	}
	return nil
}

func (x *GetDeviceLinkMetricsResponse) GetRxPacketsPerFreq() *common.Metric {
	if x != nil {
		return x.RxPacketsPerFreq
	}
	return nil
}

func (x *GetDeviceLinkMetricsResponse) GetRxPacketsPerDr() *common.Metric {
	if x != nil {
		return x.RxPacketsPerDr
	}
	return nil
}

func (x *GetDeviceLinkMetricsResponse) GetErrors() *common.Metric {
	if x != nil {
		return x.Errors
	}
	return nil
}

type DeviceQueueItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID (UUID).
	// This is automatically generated on enqueue.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Device EUI (EUI64).
	DevEui string `protobuf:"bytes,2,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Confirmed.
	Confirmed bool `protobuf:"varint,3,opt,name=confirmed,proto3" json:"confirmed,omitempty"`
	// FPort (must be > 0).
	FPort uint32 `protobuf:"varint,4,opt,name=f_port,json=fPort,proto3" json:"f_port,omitempty"`
	// Data.
	// Or use the json_object field when a codec has been configured.
	Data []byte `protobuf:"bytes,5,opt,name=data,proto3" json:"data,omitempty"`
	// Only use this when a codec has been configured that can encode this
	// object to bytes.
	Object *structpb.Struct `protobuf:"bytes,6,opt,name=object,proto3" json:"object,omitempty"`
	// Is pending.
	// This is set by ChirpStack to true when the downlink is pending (e.g. it
	// has been sent, but a confirmation is still pending).
	IsPending bool `protobuf:"varint,7,opt,name=is_pending,json=isPending,proto3" json:"is_pending,omitempty"`
	// Downlink frame-counter.
	// Do not set this for plain-text data payloads. It will be automatically set
	// by ChirpStack when the payload has been sent as downlink.
	FCntDown uint32 `protobuf:"varint,8,opt,name=f_cnt_down,json=fCntDown,proto3" json:"f_cnt_down,omitempty"`
	// Is encrypted.
	// This must be set to true if the end-application has already encrypted
	// the data payload. In this case, the f_cnt_down field must be set to
	// the corresponding frame-counter which has been used during the encryption.
	IsEncrypted bool `protobuf:"varint,9,opt,name=is_encrypted,json=isEncrypted,proto3" json:"is_encrypted,omitempty"`
	// Expires at (optional).
	// Expired queue-items will be automatically removed from the queue.
	ExpiresAt *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=expires_at,json=expiresAt,proto3" json:"expires_at,omitempty"`
}

func (x *DeviceQueueItem) Reset() {
	*x = DeviceQueueItem{}
	mi := &file_api_device_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeviceQueueItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceQueueItem) ProtoMessage() {}

func (x *DeviceQueueItem) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceQueueItem.ProtoReflect.Descriptor instead.
func (*DeviceQueueItem) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{28}
}

func (x *DeviceQueueItem) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *DeviceQueueItem) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

func (x *DeviceQueueItem) GetConfirmed() bool {
	if x != nil {
		return x.Confirmed
	}
	return false
}

func (x *DeviceQueueItem) GetFPort() uint32 {
	if x != nil {
		return x.FPort
	}
	return 0
}

func (x *DeviceQueueItem) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *DeviceQueueItem) GetObject() *structpb.Struct {
	if x != nil {
		return x.Object
	}
	return nil
}

func (x *DeviceQueueItem) GetIsPending() bool {
	if x != nil {
		return x.IsPending
	}
	return false
}

func (x *DeviceQueueItem) GetFCntDown() uint32 {
	if x != nil {
		return x.FCntDown
	}
	return 0
}

func (x *DeviceQueueItem) GetIsEncrypted() bool {
	if x != nil {
		return x.IsEncrypted
	}
	return false
}

func (x *DeviceQueueItem) GetExpiresAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpiresAt
	}
	return nil
}

type EnqueueDeviceQueueItemRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	QueueItem *DeviceQueueItem `protobuf:"bytes,1,opt,name=queue_item,json=queueItem,proto3" json:"queue_item,omitempty"`
}

func (x *EnqueueDeviceQueueItemRequest) Reset() {
	*x = EnqueueDeviceQueueItemRequest{}
	mi := &file_api_device_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnqueueDeviceQueueItemRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnqueueDeviceQueueItemRequest) ProtoMessage() {}

func (x *EnqueueDeviceQueueItemRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnqueueDeviceQueueItemRequest.ProtoReflect.Descriptor instead.
func (*EnqueueDeviceQueueItemRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{29}
}

func (x *EnqueueDeviceQueueItemRequest) GetQueueItem() *DeviceQueueItem {
	if x != nil {
		return x.QueueItem
	}
	return nil
}

type EnqueueDeviceQueueItemResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// ID (UUID).
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *EnqueueDeviceQueueItemResponse) Reset() {
	*x = EnqueueDeviceQueueItemResponse{}
	mi := &file_api_device_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnqueueDeviceQueueItemResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnqueueDeviceQueueItemResponse) ProtoMessage() {}

func (x *EnqueueDeviceQueueItemResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnqueueDeviceQueueItemResponse.ProtoReflect.Descriptor instead.
func (*EnqueueDeviceQueueItemResponse) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{30}
}

func (x *EnqueueDeviceQueueItemResponse) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type FlushDeviceQueueRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device EUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
}

func (x *FlushDeviceQueueRequest) Reset() {
	*x = FlushDeviceQueueRequest{}
	mi := &file_api_device_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlushDeviceQueueRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlushDeviceQueueRequest) ProtoMessage() {}

func (x *FlushDeviceQueueRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlushDeviceQueueRequest.ProtoReflect.Descriptor instead.
func (*FlushDeviceQueueRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{31}
}

func (x *FlushDeviceQueueRequest) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

type GetDeviceQueueItemsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device EUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
	// Return only the count, not the result-set.
	CountOnly bool `protobuf:"varint,2,opt,name=count_only,json=countOnly,proto3" json:"count_only,omitempty"`
}

func (x *GetDeviceQueueItemsRequest) Reset() {
	*x = GetDeviceQueueItemsRequest{}
	mi := &file_api_device_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDeviceQueueItemsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceQueueItemsRequest) ProtoMessage() {}

func (x *GetDeviceQueueItemsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceQueueItemsRequest.ProtoReflect.Descriptor instead.
func (*GetDeviceQueueItemsRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{32}
}

func (x *GetDeviceQueueItemsRequest) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

func (x *GetDeviceQueueItemsRequest) GetCountOnly() bool {
	if x != nil {
		return x.CountOnly
	}
	return false
}

type GetDeviceQueueItemsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total number of queue items.
	TotalCount uint32 `protobuf:"varint,1,opt,name=total_count,json=totalCount,proto3" json:"total_count,omitempty"`
	// Result-set.
	Result []*DeviceQueueItem `protobuf:"bytes,2,rep,name=result,proto3" json:"result,omitempty"`
}

func (x *GetDeviceQueueItemsResponse) Reset() {
	*x = GetDeviceQueueItemsResponse{}
	mi := &file_api_device_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDeviceQueueItemsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceQueueItemsResponse) ProtoMessage() {}

func (x *GetDeviceQueueItemsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceQueueItemsResponse.ProtoReflect.Descriptor instead.
func (*GetDeviceQueueItemsResponse) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{33}
}

func (x *GetDeviceQueueItemsResponse) GetTotalCount() uint32 {
	if x != nil {
		return x.TotalCount
	}
	return 0
}

func (x *GetDeviceQueueItemsResponse) GetResult() []*DeviceQueueItem {
	if x != nil {
		return x.Result
	}
	return nil
}

type FlushDevNoncesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device EUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
}

func (x *FlushDevNoncesRequest) Reset() {
	*x = FlushDevNoncesRequest{}
	mi := &file_api_device_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlushDevNoncesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlushDevNoncesRequest) ProtoMessage() {}

func (x *FlushDevNoncesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlushDevNoncesRequest.ProtoReflect.Descriptor instead.
func (*FlushDevNoncesRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{34}
}

func (x *FlushDevNoncesRequest) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

type GetDeviceNextFCntDownRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Device EUI (EUI64).
	DevEui string `protobuf:"bytes,1,opt,name=dev_eui,json=devEui,proto3" json:"dev_eui,omitempty"`
}

func (x *GetDeviceNextFCntDownRequest) Reset() {
	*x = GetDeviceNextFCntDownRequest{}
	mi := &file_api_device_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDeviceNextFCntDownRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceNextFCntDownRequest) ProtoMessage() {}

func (x *GetDeviceNextFCntDownRequest) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceNextFCntDownRequest.ProtoReflect.Descriptor instead.
func (*GetDeviceNextFCntDownRequest) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{35}
}

func (x *GetDeviceNextFCntDownRequest) GetDevEui() string {
	if x != nil {
		return x.DevEui
	}
	return ""
}

type GetDeviceNextFCntDownResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// FCntDown.
	FCntDown uint32 `protobuf:"varint,1,opt,name=f_cnt_down,json=fCntDown,proto3" json:"f_cnt_down,omitempty"`
}

func (x *GetDeviceNextFCntDownResponse) Reset() {
	*x = GetDeviceNextFCntDownResponse{}
	mi := &file_api_device_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDeviceNextFCntDownResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeviceNextFCntDownResponse) ProtoMessage() {}

func (x *GetDeviceNextFCntDownResponse) ProtoReflect() protoreflect.Message {
	mi := &file_api_device_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeviceNextFCntDownResponse.ProtoReflect.Descriptor instead.
func (*GetDeviceNextFCntDownResponse) Descriptor() ([]byte, []int) {
	return file_api_device_proto_rawDescGZIP(), []int{36}
}

func (x *GetDeviceNextFCntDownResponse) GetFCntDown() uint32 {
	if x != nil {
		return x.FCntDown
	}
	return 0
}

var File_api_device_proto protoreflect.FileDescriptor

var file_api_device_proto_rawDesc = []byte{
	0x0a, 0x10, 0x61, 0x70, 0x69, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x03, 0x61, 0x70, 0x69, 0x1a, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xea, 0x03, 0x0a, 0x06, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45, 0x75, 0x69, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x25, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x11, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0f, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x66, 0x63, 0x6e, 0x74,
	0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x73, 0x6b,
	0x69, 0x70, 0x46, 0x63, 0x6e, 0x74, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x12, 0x1f, 0x0a, 0x0b, 0x69,
	0x73, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0a, 0x69, 0x73, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x38, 0x0a, 0x09,
	0x76, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x56, 0x61, 0x72,
	0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x09, 0x76, 0x61, 0x72,
	0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x12, 0x19, 0x0a, 0x08, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6a, 0x6f, 0x69, 0x6e, 0x45, 0x75, 0x69, 0x1a, 0x3c, 0x0a, 0x0e,
	0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x37, 0x0a, 0x09, 0x54, 0x61,
	0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0x7f, 0x0a, 0x0c, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x06, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x12, 0x32, 0x0a, 0x15, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x65, 0x78, 0x74, 0x65,
	0x72, 0x6e, 0x61, 0x6c, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x23, 0x0a, 0x0d, 0x62, 0x61, 0x74, 0x74, 0x65, 0x72, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0c, 0x62, 0x61, 0x74, 0x74, 0x65, 0x72, 0x79, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x22, 0xa7, 0x03, 0x0a, 0x0e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x5f, 0x65,
	0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45, 0x75, 0x69,
	0x12, 0x39, 0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x09, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x3c, 0x0a, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73,
	0x65, 0x65, 0x6e, 0x5f, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x65,
	0x65, 0x6e, 0x41, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x11, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x2e, 0x0a, 0x13, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x11, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x36, 0x0a, 0x0d, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x52, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x57,
	0x0a, 0x0a, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x17, 0x0a, 0x07,
	0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64,
	0x65, 0x76, 0x45, 0x75, 0x69, 0x12, 0x17, 0x0a, 0x07, 0x6e, 0x77, 0x6b, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6e, 0x77, 0x6b, 0x4b, 0x65, 0x79, 0x12, 0x17,
	0x0a, 0x07, 0x61, 0x70, 0x70, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x61, 0x70, 0x70, 0x4b, 0x65, 0x79, 0x22, 0x3a, 0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23,
	0x0a, 0x06, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x06, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x22, 0x2b, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x5f, 0x65,
	0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45, 0x75, 0x69,
	0x22, 0xde, 0x02, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a, 0x06, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x52, 0x06, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x41,
	0x74, 0x12, 0x3c, 0x0a, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x65, 0x65, 0x6e, 0x5f, 0x61,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0a, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x65, 0x65, 0x6e, 0x41, 0x74, 0x12,
	0x36, 0x0a, 0x0d, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x38, 0x0a, 0x0d, 0x63, 0x6c, 0x61, 0x73, 0x73,
	0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x13,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6c,
	0x61, 0x73, 0x73, 0x52, 0x0c, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x64, 0x22, 0x3a, 0x0a, 0x13, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x23, 0x0a, 0x06, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0b, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x06, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x22, 0x2e, 0x0a,
	0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45, 0x75, 0x69, 0x22, 0xaf, 0x01,
	0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0d, 0x52, 0x05, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x70,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x64, 0x12, 0x2c, 0x0a, 0x12, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x63, 0x61, 0x73, 0x74, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6d,
	0x75, 0x6c, 0x74, 0x69, 0x63, 0x61, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x22,
	0x63, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x74, 0x6f, 0x74,
	0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x06, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x22, 0x4b, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x30, 0x0a, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4b, 0x65, 0x79,
	0x73, 0x22, 0x2f, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4b, 0x65,
	0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x65, 0x76,
	0x5f, 0x65, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45,
	0x75, 0x69, 0x22, 0xbf, 0x01, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x0b,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x0f, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4b, 0x65,
	0x79, 0x73, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x39,
	0x0a, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x39, 0x0a, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x64, 0x41, 0x74, 0x22, 0x4b, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x30, 0x0a, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6b, 0x65, 0x79, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0f, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4b, 0x65, 0x79,
	0x73, 0x22, 0x32, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07,
	0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64,
	0x65, 0x76, 0x45, 0x75, 0x69, 0x22, 0xad, 0x02, 0x0a, 0x10, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x65,
	0x76, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x76,
	0x45, 0x75, 0x69, 0x12, 0x19, 0x0a, 0x08, 0x64, 0x65, 0x76, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72, 0x12, 0x1a,
	0x0a, 0x09, 0x61, 0x70, 0x70, 0x5f, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x61, 0x70, 0x70, 0x53, 0x4b, 0x65, 0x79, 0x12, 0x21, 0x0a, 0x0d, 0x6e, 0x77,
	0x6b, 0x5f, 0x73, 0x5f, 0x65, 0x6e, 0x63, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x6e, 0x77, 0x6b, 0x53, 0x45, 0x6e, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x24, 0x0a,
	0x0f, 0x73, 0x5f, 0x6e, 0x77, 0x6b, 0x5f, 0x73, 0x5f, 0x69, 0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x4e, 0x77, 0x6b, 0x53, 0x49, 0x6e, 0x74,
	0x4b, 0x65, 0x79, 0x12, 0x24, 0x0a, 0x0f, 0x66, 0x5f, 0x6e, 0x77, 0x6b, 0x5f, 0x73, 0x5f, 0x69,
	0x6e, 0x74, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x66, 0x4e,
	0x77, 0x6b, 0x53, 0x49, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x18, 0x0a, 0x08, 0x66, 0x5f, 0x63,
	0x6e, 0x74, 0x5f, 0x75, 0x70, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x06, 0x66, 0x43, 0x6e,
	0x74, 0x55, 0x70, 0x12, 0x1f, 0x0a, 0x0c, 0x6e, 0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x5f, 0x64,
	0x6f, 0x77, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x6e, 0x46, 0x43, 0x6e, 0x74,
	0x44, 0x6f, 0x77, 0x6e, 0x12, 0x1f, 0x0a, 0x0c, 0x61, 0x5f, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x5f,
	0x64, 0x6f, 0x77, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x09, 0x61, 0x46, 0x43, 0x6e,
	0x74, 0x44, 0x6f, 0x77, 0x6e, 0x22, 0x5b, 0x0a, 0x15, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42,
	0x0a, 0x11, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x10, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x32, 0x0a, 0x17, 0x44, 0x65, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a,
	0x07, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x64, 0x65, 0x76, 0x45, 0x75, 0x69, 0x22, 0x35, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45, 0x75, 0x69, 0x22, 0xac, 0x01,
	0x0a, 0x1b, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a,
	0x11, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x10, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x49, 0x0a, 0x13, 0x6a, 0x6f, 0x69, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4a, 0x6f, 0x69, 0x6e, 0x53, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x11, 0x6a, 0x6f, 0x69, 0x6e, 0x53,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x32, 0x0a, 0x17,
	0x47, 0x65, 0x74, 0x52, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x44, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x5f, 0x65,
	0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45, 0x75, 0x69,
	0x22, 0x35, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x52, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x44, 0x65, 0x76,
	0x41, 0x64, 0x64, 0x72, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x19, 0x0a, 0x08,
	0x64, 0x65, 0x76, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x64, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72, 0x22, 0xc9, 0x01, 0x0a, 0x17, 0x47, 0x65, 0x74, 0x44,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45, 0x75, 0x69, 0x12, 0x30, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x2c,
	0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x12, 0x35, 0x0a, 0x0b,
	0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65,
	0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xbc, 0x02, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x44, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x41, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x47, 0x65, 0x74,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x1a, 0x4a, 0x0a, 0x0c, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x24, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x4b, 0x0a, 0x0b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x26, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0x37, 0x0a, 0x0b, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xcd, 0x01, 0x0a, 0x1b,
	0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x64,
	0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65,
	0x76, 0x45, 0x75, 0x69, 0x12, 0x30, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x2c, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x03, 0x65, 0x6e, 0x64, 0x12, 0x35, 0x0a, 0x0b, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x13, 0x2e, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b,
	0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xbf, 0x02, 0x0a, 0x1c,
	0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x2d, 0x0a, 0x0a,
	0x72, 0x78, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x0e, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x52, 0x09, 0x72, 0x78, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x12, 0x27, 0x0a, 0x07, 0x67,
	0x77, 0x5f, 0x72, 0x73, 0x73, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x63,
	0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x06, 0x67, 0x77,
	0x52, 0x73, 0x73, 0x69, 0x12, 0x25, 0x0a, 0x06, 0x67, 0x77, 0x5f, 0x73, 0x6e, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x52, 0x05, 0x67, 0x77, 0x53, 0x6e, 0x72, 0x12, 0x3d, 0x0a, 0x13, 0x72,
	0x78, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x66, 0x72,
	0x65, 0x71, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x10, 0x72, 0x78, 0x50, 0x61, 0x63, 0x6b,
	0x65, 0x74, 0x73, 0x50, 0x65, 0x72, 0x46, 0x72, 0x65, 0x71, 0x12, 0x39, 0x0a, 0x11, 0x72, 0x78,
	0x5f, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x64, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x0e, 0x72, 0x78, 0x50, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73,
	0x50, 0x65, 0x72, 0x44, 0x72, 0x12, 0x26, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0xcf, 0x02,
	0x0a, 0x0f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x49, 0x74, 0x65,
	0x6d, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45, 0x75, 0x69, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x12, 0x15, 0x0a, 0x06, 0x66, 0x5f, 0x70, 0x6f,
	0x72, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x05, 0x66, 0x50, 0x6f, 0x72, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x2f, 0x0a, 0x06, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x06, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x69, 0x73, 0x5f, 0x70, 0x65, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x69, 0x73, 0x50, 0x65, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x12, 0x1c, 0x0a, 0x0a, 0x66, 0x5f, 0x63, 0x6e, 0x74, 0x5f, 0x64, 0x6f, 0x77,
	0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x08, 0x66, 0x43, 0x6e, 0x74, 0x44, 0x6f, 0x77,
	0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x69, 0x73, 0x5f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x65,
	0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x69, 0x73, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x65, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x5f,
	0x61, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x41, 0x74, 0x22,
	0x54, 0x0a, 0x1d, 0x45, 0x6e, 0x71, 0x75, 0x65, 0x75, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x51, 0x75, 0x65, 0x75, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x33, 0x0a, 0x0a, 0x71, 0x75, 0x65, 0x75, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x09, 0x71, 0x75, 0x65, 0x75,
	0x65, 0x49, 0x74, 0x65, 0x6d, 0x22, 0x30, 0x0a, 0x1e, 0x45, 0x6e, 0x71, 0x75, 0x65, 0x75, 0x65,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x32, 0x0a, 0x17, 0x46, 0x6c, 0x75, 0x73, 0x68,
	0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45, 0x75, 0x69, 0x22, 0x54, 0x0a, 0x1a, 0x47,
	0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x49, 0x74, 0x65,
	0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x65, 0x76,
	0x5f, 0x65, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45,
	0x75, 0x69, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6f, 0x6e, 0x6c, 0x79,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4f, 0x6e, 0x6c,
	0x79, 0x22, 0x6c, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x51, 0x75,
	0x65, 0x75, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x2c, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x14, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x51, 0x75,
	0x65, 0x75, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22,
	0x30, 0x0a, 0x15, 0x46, 0x6c, 0x75, 0x73, 0x68, 0x44, 0x65, 0x76, 0x4e, 0x6f, 0x6e, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x5f,
	0x65, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45, 0x75,
	0x69, 0x22, 0x37, 0x0a, 0x1c, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x65,
	0x78, 0x74, 0x46, 0x43, 0x6e, 0x74, 0x44, 0x6f, 0x77, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x76, 0x45, 0x75, 0x69, 0x22, 0x3d, 0x0a, 0x1d, 0x47, 0x65,
	0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x65, 0x78, 0x74, 0x46, 0x43, 0x6e, 0x74, 0x44,
	0x6f, 0x77, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1c, 0x0a, 0x0a, 0x66,
	0x5f, 0x63, 0x6e, 0x74, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52,
	0x08, 0x66, 0x43, 0x6e, 0x74, 0x44, 0x6f, 0x77, 0x6e, 0x32, 0xe2, 0x11, 0x0a, 0x0d, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x53, 0x0a, 0x06, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x12, 0x18, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x17, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x11, 0x3a,
	0x01, 0x2a, 0x22, 0x0c, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x12, 0x54, 0x0a, 0x03, 0x47, 0x65, 0x74, 0x12, 0x15, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x47, 0x65,
	0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x12, 0x16,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65,
	0x76, 0x5f, 0x65, 0x75, 0x69, 0x7d, 0x12, 0x64, 0x0a, 0x06, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x12, 0x18, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70,
	0x74, 0x79, 0x22, 0x28, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x22, 0x3a, 0x01, 0x2a, 0x1a, 0x1d, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x7d, 0x12, 0x5a, 0x0a, 0x06,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x12, 0x18, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x1e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18,
	0x2a, 0x16, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b,
	0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x7d, 0x12, 0x4f, 0x0a, 0x04, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x17, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x18, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x14, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x0e, 0x12, 0x0c, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x76, 0x0a, 0x0a, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x1c, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x32, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x3a, 0x01, 0x2a, 0x22, 0x27, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6b,
	0x65, 0x79, 0x73, 0x2e, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x7d, 0x2f, 0x6b, 0x65, 0x79,
	0x73, 0x12, 0x65, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x19, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1a, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x47, 0x65,
	0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x23, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1d, 0x12, 0x1b, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x5f, 0x65,
	0x75, 0x69, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x76, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x1c, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x32, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2c, 0x3a, 0x01, 0x2a, 0x1a, 0x27, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6b, 0x65,
	0x79, 0x73, 0x2e, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x73,
	0x12, 0x67, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4b, 0x65, 0x79, 0x73, 0x12, 0x1c,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x23, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1d, 0x2a, 0x1b, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x5f,
	0x65, 0x75, 0x69, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x73, 0x12, 0x6f, 0x0a, 0x0e, 0x46, 0x6c, 0x75,
	0x73, 0x68, 0x44, 0x65, 0x76, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x1a, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x46, 0x6c, 0x75, 0x73, 0x68, 0x44, 0x65, 0x76, 0x4e, 0x6f, 0x6e, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x29, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x2a, 0x21, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x7d, 0x2f,
	0x64, 0x65, 0x76, 0x2d, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x7c, 0x0a, 0x08, 0x41, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x41, 0x63, 0x74,
	0x69, 0x76, 0x61, 0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3c, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x36, 0x3a, 0x01, 0x2a, 0x22, 0x31, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x7d, 0x2f,
	0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x12, 0x6d, 0x0a, 0x0a, 0x44, 0x65, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x65, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x29, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x23, 0x2a, 0x21, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x7d, 0x2f, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7d, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x41, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x47,
	0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x29, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x23, 0x12, 0x21, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x7d, 0x2f, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x83, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x52, 0x61,
	0x6e, 0x64, 0x6f, 0x6d, 0x44, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72, 0x12, 0x1c, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x44, 0x65, 0x76, 0x41, 0x64,
	0x64, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x47, 0x65, 0x74, 0x52, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x44, 0x65, 0x76, 0x41, 0x64, 0x64, 0x72,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c,
	0x22, 0x2a, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b,
	0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x7d, 0x2f, 0x67, 0x65, 0x74, 0x2d, 0x72, 0x61, 0x6e,
	0x64, 0x6f, 0x6d, 0x2d, 0x64, 0x65, 0x76, 0x2d, 0x61, 0x64, 0x64, 0x72, 0x12, 0x71, 0x0a, 0x0a,
	0x47, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x1c, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x47,
	0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x26, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x20, 0x12,
	0x1e, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64,
	0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x7d, 0x2f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12,
	0x82, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x4c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x12, 0x20, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x12,
	0x23, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64,
	0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x7d, 0x2f, 0x6c, 0x69, 0x6e, 0x6b, 0x2d, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x12, 0x86, 0x01, 0x0a, 0x07, 0x45, 0x6e, 0x71, 0x75, 0x65, 0x75, 0x65,
	0x12, 0x22, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x45, 0x6e, 0x71, 0x75, 0x65, 0x75, 0x65, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x45, 0x6e, 0x71, 0x75, 0x65,
	0x75, 0x65, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x49, 0x74, 0x65,
	0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2c, 0x3a, 0x01, 0x2a, 0x22, 0x27, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2f, 0x7b, 0x71, 0x75, 0x65, 0x75, 0x65, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x2e, 0x64,
	0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x7d, 0x2f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x12, 0x68, 0x0a,
	0x0a, 0x46, 0x6c, 0x75, 0x73, 0x68, 0x51, 0x75, 0x65, 0x75, 0x65, 0x12, 0x1c, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x46, 0x6c, 0x75, 0x73, 0x68, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x51, 0x75, 0x65,
	0x75, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x24, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x2a, 0x1c, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69,
	0x7d, 0x2f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x12, 0x73, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x51, 0x75,
	0x65, 0x75, 0x65, 0x12, 0x1f, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x51, 0x75, 0x65, 0x75, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x24, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x12, 0x1c,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x64, 0x65,
	0x76, 0x5f, 0x65, 0x75, 0x69, 0x7d, 0x2f, 0x71, 0x75, 0x65, 0x75, 0x65, 0x12, 0x8f, 0x01, 0x0a,
	0x0f, 0x47, 0x65, 0x74, 0x4e, 0x65, 0x78, 0x74, 0x46, 0x43, 0x6e, 0x74, 0x44, 0x6f, 0x77, 0x6e,
	0x12, 0x21, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x4e, 0x65, 0x78, 0x74, 0x46, 0x43, 0x6e, 0x74, 0x44, 0x6f, 0x77, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x4e, 0x65, 0x78, 0x74, 0x46, 0x43, 0x6e, 0x74, 0x44, 0x6f, 0x77, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x3a,
	0x01, 0x2a, 0x22, 0x2a, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2f, 0x7b, 0x64, 0x65, 0x76, 0x5f, 0x65, 0x75, 0x69, 0x7d, 0x2f, 0x67, 0x65, 0x74, 0x2d, 0x6e,
	0x65, 0x78, 0x74, 0x2d, 0x66, 0x2d, 0x63, 0x6e, 0x74, 0x2d, 0x64, 0x6f, 0x77, 0x6e, 0x42, 0x91,
	0x01, 0x0a, 0x11, 0x69, 0x6f, 0x2e, 0x63, 0x68, 0x69, 0x72, 0x70, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x2e, 0x61, 0x70, 0x69, 0x42, 0x0b, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x2e, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x63, 0x68, 0x69, 0x72, 0x70, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x63, 0x68, 0x69, 0x72, 0x70,
	0x73, 0x74, 0x61, 0x63, 0x6b, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x34, 0x2f,
	0x61, 0x70, 0x69, 0xaa, 0x02, 0x0e, 0x43, 0x68, 0x69, 0x72, 0x70, 0x73, 0x74, 0x61, 0x63, 0x6b,
	0x2e, 0x41, 0x70, 0x69, 0xca, 0x02, 0x0e, 0x43, 0x68, 0x69, 0x72, 0x70, 0x73, 0x74, 0x61, 0x63,
	0x6b, 0x5c, 0x41, 0x70, 0x69, 0xe2, 0x02, 0x1a, 0x47, 0x50, 0x42, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x5c, 0x43, 0x68, 0x69, 0x72, 0x70, 0x73, 0x74, 0x61, 0x63, 0x6b, 0x5c, 0x41,
	0x70, 0x69, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_api_device_proto_rawDescOnce sync.Once
	file_api_device_proto_rawDescData = file_api_device_proto_rawDesc
)

func file_api_device_proto_rawDescGZIP() []byte {
	file_api_device_proto_rawDescOnce.Do(func() {
		file_api_device_proto_rawDescData = protoimpl.X.CompressGZIP(file_api_device_proto_rawDescData)
	})
	return file_api_device_proto_rawDescData
}

var file_api_device_proto_msgTypes = make([]protoimpl.MessageInfo, 41)
var file_api_device_proto_goTypes = []any{
	(*Device)(nil),                         // 0: api.Device
	(*DeviceStatus)(nil),                   // 1: api.DeviceStatus
	(*DeviceListItem)(nil),                 // 2: api.DeviceListItem
	(*DeviceKeys)(nil),                     // 3: api.DeviceKeys
	(*CreateDeviceRequest)(nil),            // 4: api.CreateDeviceRequest
	(*GetDeviceRequest)(nil),               // 5: api.GetDeviceRequest
	(*GetDeviceResponse)(nil),              // 6: api.GetDeviceResponse
	(*UpdateDeviceRequest)(nil),            // 7: api.UpdateDeviceRequest
	(*DeleteDeviceRequest)(nil),            // 8: api.DeleteDeviceRequest
	(*ListDevicesRequest)(nil),             // 9: api.ListDevicesRequest
	(*ListDevicesResponse)(nil),            // 10: api.ListDevicesResponse
	(*CreateDeviceKeysRequest)(nil),        // 11: api.CreateDeviceKeysRequest
	(*GetDeviceKeysRequest)(nil),           // 12: api.GetDeviceKeysRequest
	(*GetDeviceKeysResponse)(nil),          // 13: api.GetDeviceKeysResponse
	(*UpdateDeviceKeysRequest)(nil),        // 14: api.UpdateDeviceKeysRequest
	(*DeleteDeviceKeysRequest)(nil),        // 15: api.DeleteDeviceKeysRequest
	(*DeviceActivation)(nil),               // 16: api.DeviceActivation
	(*ActivateDeviceRequest)(nil),          // 17: api.ActivateDeviceRequest
	(*DeactivateDeviceRequest)(nil),        // 18: api.DeactivateDeviceRequest
	(*GetDeviceActivationRequest)(nil),     // 19: api.GetDeviceActivationRequest
	(*GetDeviceActivationResponse)(nil),    // 20: api.GetDeviceActivationResponse
	(*GetRandomDevAddrRequest)(nil),        // 21: api.GetRandomDevAddrRequest
	(*GetRandomDevAddrResponse)(nil),       // 22: api.GetRandomDevAddrResponse
	(*GetDeviceMetricsRequest)(nil),        // 23: api.GetDeviceMetricsRequest
	(*GetDeviceMetricsResponse)(nil),       // 24: api.GetDeviceMetricsResponse
	(*DeviceState)(nil),                    // 25: api.DeviceState
	(*GetDeviceLinkMetricsRequest)(nil),    // 26: api.GetDeviceLinkMetricsRequest
	(*GetDeviceLinkMetricsResponse)(nil),   // 27: api.GetDeviceLinkMetricsResponse
	(*DeviceQueueItem)(nil),                // 28: api.DeviceQueueItem
	(*EnqueueDeviceQueueItemRequest)(nil),  // 29: api.EnqueueDeviceQueueItemRequest
	(*EnqueueDeviceQueueItemResponse)(nil), // 30: api.EnqueueDeviceQueueItemResponse
	(*FlushDeviceQueueRequest)(nil),        // 31: api.FlushDeviceQueueRequest
	(*GetDeviceQueueItemsRequest)(nil),     // 32: api.GetDeviceQueueItemsRequest
	(*GetDeviceQueueItemsResponse)(nil),    // 33: api.GetDeviceQueueItemsResponse
	(*FlushDevNoncesRequest)(nil),          // 34: api.FlushDevNoncesRequest
	(*GetDeviceNextFCntDownRequest)(nil),   // 35: api.GetDeviceNextFCntDownRequest
	(*GetDeviceNextFCntDownResponse)(nil),  // 36: api.GetDeviceNextFCntDownResponse
	nil,                                    // 37: api.Device.VariablesEntry
	nil,                                    // 38: api.Device.TagsEntry
	nil,                                    // 39: api.GetDeviceMetricsResponse.MetricsEntry
	nil,                                    // 40: api.GetDeviceMetricsResponse.StatesEntry
	(*timestamppb.Timestamp)(nil),          // 41: google.protobuf.Timestamp
	(common.DeviceClass)(0),                // 42: common.DeviceClass
	(*common.JoinServerContext)(nil),       // 43: common.JoinServerContext
	(common.Aggregation)(0),                // 44: common.Aggregation
	(*common.Metric)(nil),                  // 45: common.Metric
	(*structpb.Struct)(nil),                // 46: google.protobuf.Struct
	(*emptypb.Empty)(nil),                  // 47: google.protobuf.Empty
}
var file_api_device_proto_depIdxs = []int32{
	37, // 0: api.Device.variables:type_name -> api.Device.VariablesEntry
	38, // 1: api.Device.tags:type_name -> api.Device.TagsEntry
	41, // 2: api.DeviceListItem.created_at:type_name -> google.protobuf.Timestamp
	41, // 3: api.DeviceListItem.updated_at:type_name -> google.protobuf.Timestamp
	41, // 4: api.DeviceListItem.last_seen_at:type_name -> google.protobuf.Timestamp
	1,  // 5: api.DeviceListItem.device_status:type_name -> api.DeviceStatus
	0,  // 6: api.CreateDeviceRequest.device:type_name -> api.Device
	0,  // 7: api.GetDeviceResponse.device:type_name -> api.Device
	41, // 8: api.GetDeviceResponse.created_at:type_name -> google.protobuf.Timestamp
	41, // 9: api.GetDeviceResponse.updated_at:type_name -> google.protobuf.Timestamp
	41, // 10: api.GetDeviceResponse.last_seen_at:type_name -> google.protobuf.Timestamp
	1,  // 11: api.GetDeviceResponse.device_status:type_name -> api.DeviceStatus
	42, // 12: api.GetDeviceResponse.class_enabled:type_name -> common.DeviceClass
	0,  // 13: api.UpdateDeviceRequest.device:type_name -> api.Device
	2,  // 14: api.ListDevicesResponse.result:type_name -> api.DeviceListItem
	3,  // 15: api.CreateDeviceKeysRequest.device_keys:type_name -> api.DeviceKeys
	3,  // 16: api.GetDeviceKeysResponse.device_keys:type_name -> api.DeviceKeys
	41, // 17: api.GetDeviceKeysResponse.created_at:type_name -> google.protobuf.Timestamp
	41, // 18: api.GetDeviceKeysResponse.updated_at:type_name -> google.protobuf.Timestamp
	3,  // 19: api.UpdateDeviceKeysRequest.device_keys:type_name -> api.DeviceKeys
	16, // 20: api.ActivateDeviceRequest.device_activation:type_name -> api.DeviceActivation
	16, // 21: api.GetDeviceActivationResponse.device_activation:type_name -> api.DeviceActivation
	43, // 22: api.GetDeviceActivationResponse.join_server_context:type_name -> common.JoinServerContext
	41, // 23: api.GetDeviceMetricsRequest.start:type_name -> google.protobuf.Timestamp
	41, // 24: api.GetDeviceMetricsRequest.end:type_name -> google.protobuf.Timestamp
	44, // 25: api.GetDeviceMetricsRequest.aggregation:type_name -> common.Aggregation
	39, // 26: api.GetDeviceMetricsResponse.metrics:type_name -> api.GetDeviceMetricsResponse.MetricsEntry
	40, // 27: api.GetDeviceMetricsResponse.states:type_name -> api.GetDeviceMetricsResponse.StatesEntry
	41, // 28: api.GetDeviceLinkMetricsRequest.start:type_name -> google.protobuf.Timestamp
	41, // 29: api.GetDeviceLinkMetricsRequest.end:type_name -> google.protobuf.Timestamp
	44, // 30: api.GetDeviceLinkMetricsRequest.aggregation:type_name -> common.Aggregation
	45, // 31: api.GetDeviceLinkMetricsResponse.rx_packets:type_name -> common.Metric
	45, // 32: api.GetDeviceLinkMetricsResponse.gw_rssi:type_name -> common.Metric
	45, // 33: api.GetDeviceLinkMetricsResponse.gw_snr:type_name -> common.Metric
	45, // 34: api.GetDeviceLinkMetricsResponse.rx_packets_per_freq:type_name -> common.Metric
	45, // 35: api.GetDeviceLinkMetricsResponse.rx_packets_per_dr:type_name -> common.Metric
	45, // 36: api.GetDeviceLinkMetricsResponse.errors:type_name -> common.Metric
	46, // 37: api.DeviceQueueItem.object:type_name -> google.protobuf.Struct
	41, // 38: api.DeviceQueueItem.expires_at:type_name -> google.protobuf.Timestamp
	28, // 39: api.EnqueueDeviceQueueItemRequest.queue_item:type_name -> api.DeviceQueueItem
	28, // 40: api.GetDeviceQueueItemsResponse.result:type_name -> api.DeviceQueueItem
	45, // 41: api.GetDeviceMetricsResponse.MetricsEntry.value:type_name -> common.Metric
	25, // 42: api.GetDeviceMetricsResponse.StatesEntry.value:type_name -> api.DeviceState
	4,  // 43: api.DeviceService.Create:input_type -> api.CreateDeviceRequest
	5,  // 44: api.DeviceService.Get:input_type -> api.GetDeviceRequest
	7,  // 45: api.DeviceService.Update:input_type -> api.UpdateDeviceRequest
	8,  // 46: api.DeviceService.Delete:input_type -> api.DeleteDeviceRequest
	9,  // 47: api.DeviceService.List:input_type -> api.ListDevicesRequest
	11, // 48: api.DeviceService.CreateKeys:input_type -> api.CreateDeviceKeysRequest
	12, // 49: api.DeviceService.GetKeys:input_type -> api.GetDeviceKeysRequest
	14, // 50: api.DeviceService.UpdateKeys:input_type -> api.UpdateDeviceKeysRequest
	15, // 51: api.DeviceService.DeleteKeys:input_type -> api.DeleteDeviceKeysRequest
	34, // 52: api.DeviceService.FlushDevNonces:input_type -> api.FlushDevNoncesRequest
	17, // 53: api.DeviceService.Activate:input_type -> api.ActivateDeviceRequest
	18, // 54: api.DeviceService.Deactivate:input_type -> api.DeactivateDeviceRequest
	19, // 55: api.DeviceService.GetActivation:input_type -> api.GetDeviceActivationRequest
	21, // 56: api.DeviceService.GetRandomDevAddr:input_type -> api.GetRandomDevAddrRequest
	23, // 57: api.DeviceService.GetMetrics:input_type -> api.GetDeviceMetricsRequest
	26, // 58: api.DeviceService.GetLinkMetrics:input_type -> api.GetDeviceLinkMetricsRequest
	29, // 59: api.DeviceService.Enqueue:input_type -> api.EnqueueDeviceQueueItemRequest
	31, // 60: api.DeviceService.FlushQueue:input_type -> api.FlushDeviceQueueRequest
	32, // 61: api.DeviceService.GetQueue:input_type -> api.GetDeviceQueueItemsRequest
	35, // 62: api.DeviceService.GetNextFCntDown:input_type -> api.GetDeviceNextFCntDownRequest
	47, // 63: api.DeviceService.Create:output_type -> google.protobuf.Empty
	6,  // 64: api.DeviceService.Get:output_type -> api.GetDeviceResponse
	47, // 65: api.DeviceService.Update:output_type -> google.protobuf.Empty
	47, // 66: api.DeviceService.Delete:output_type -> google.protobuf.Empty
	10, // 67: api.DeviceService.List:output_type -> api.ListDevicesResponse
	47, // 68: api.DeviceService.CreateKeys:output_type -> google.protobuf.Empty
	13, // 69: api.DeviceService.GetKeys:output_type -> api.GetDeviceKeysResponse
	47, // 70: api.DeviceService.UpdateKeys:output_type -> google.protobuf.Empty
	47, // 71: api.DeviceService.DeleteKeys:output_type -> google.protobuf.Empty
	47, // 72: api.DeviceService.FlushDevNonces:output_type -> google.protobuf.Empty
	47, // 73: api.DeviceService.Activate:output_type -> google.protobuf.Empty
	47, // 74: api.DeviceService.Deactivate:output_type -> google.protobuf.Empty
	20, // 75: api.DeviceService.GetActivation:output_type -> api.GetDeviceActivationResponse
	22, // 76: api.DeviceService.GetRandomDevAddr:output_type -> api.GetRandomDevAddrResponse
	24, // 77: api.DeviceService.GetMetrics:output_type -> api.GetDeviceMetricsResponse
	27, // 78: api.DeviceService.GetLinkMetrics:output_type -> api.GetDeviceLinkMetricsResponse
	30, // 79: api.DeviceService.Enqueue:output_type -> api.EnqueueDeviceQueueItemResponse
	47, // 80: api.DeviceService.FlushQueue:output_type -> google.protobuf.Empty
	33, // 81: api.DeviceService.GetQueue:output_type -> api.GetDeviceQueueItemsResponse
	36, // 82: api.DeviceService.GetNextFCntDown:output_type -> api.GetDeviceNextFCntDownResponse
	63, // [63:83] is the sub-list for method output_type
	43, // [43:63] is the sub-list for method input_type
	43, // [43:43] is the sub-list for extension type_name
	43, // [43:43] is the sub-list for extension extendee
	0,  // [0:43] is the sub-list for field type_name
}

func init() { file_api_device_proto_init() }
func file_api_device_proto_init() {
	if File_api_device_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_api_device_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   41,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_api_device_proto_goTypes,
		DependencyIndexes: file_api_device_proto_depIdxs,
		MessageInfos:      file_api_device_proto_msgTypes,
	}.Build()
	File_api_device_proto = out.File
	file_api_device_proto_rawDesc = nil
	file_api_device_proto_goTypes = nil
	file_api_device_proto_depIdxs = nil
}
