# Python 潮流周刊的辅助脚本

在创作周刊时，我经常遇到一些重复性的工作，有些是工序比较繁琐的，有些是频繁需要做的。作为一名程序员，这些事怎么能忍？

我决定要使用技术来释放双手，提升个人的效能。

这里将收录我为方便周刊的创作与推广而写的脚本。

- [周刊信息摘要，自动发送给 Telegram 机器人](./weekly_summary.py) ：提取 Python 潮流周刊的摘要内容，用于在各平台发布

- [聚合社区里最新发布的 Python 周刊，自动发送给 Telegram 机器人](./weekly_collection.py) ：Python 社区里有很多技术周刊，每周日将最新信息采集起来，发布到我们周刊的 Telegram 频道中

- [自动给已发布文章添加超链接](./weekly_season_link.py) ：在发布第一季周刊的汇总文后，我发现它里面缺少指向每期周刊的链接，这个脚本的目的是补充相应的链接

- [分拆中英文混合标题的原始文件](./split_weekly_file.py) ：在写周刊的初稿时，若分享内容是英文的，我会在中文标题后保留原始的英文标题。等完成初稿后，我用这个脚本分拆成中文标题版+英文标题版。这样可以保留原始分享内容的标题，避免后续作二次翻译

- [周刊中译英脚本](./weekly_translation.py) ：获取待译的文件，解析正文后调用 LLM 实现翻译，再写入到模板文件中，归档在“docs/en”目录下

- [记录每期周刊中条目的数量](./weekly_save_count.py) ：获取每一期的文章、项目等条目的数量，记录到数据库中

- [生成周刊词云脚本](./weekly_wordcloud.py) ：获取每一季周刊的主要内容，生成词云，并保存为图片文件

- [生成周刊统计看板页面](./weekly_kanban.py) ：统计每一季周刊的柱状图、饼图和词云等数据，使用pyecharts库生成页面

- todo：Telegram 机器人接收投稿，自动创建 Github issue

- 待续