# Python Trending Weekly #42 (2024-03-16)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2024-03-16-weekly) of the weekly was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Why Our Company Still Uses Python for Project Development?](https://mp.weixin.qq.com/s/OU38bK4q-KNymXAtx8gZJA)

This article gave me a sense of "industry secrets you don't know." Small companies are still sticking with Python 2.7 + Django 1.8, and they are supporting hundreds of millions of dollars in transactions each year. The author also shared several projects, and my feeling is: Maybe you don't need to consider "which language is better" too much. Just choose the one you are familiar with and focus on business implementation.

2. [Should Python Strings Use Single or Double Quotes?](https://mp.weixin.qq.com/s/9uIYtQEc-RuNhMY7Ck9IAA)

Python strings allow both single and double quotes, and even triple quotes. This flexibility is great, but it's also a source of conflict for standards pedants. This article shares an interesting story about it, recommended reading!

3. [Understanding Context Manager and Its Syntactic Sugar](https://bjoernricks.github.io/posts/python/context-manager)

Why do we need context managers? What problems do they solve? The article also introduces the context manager protocol, the `with` syntax sugar, implementing context managers with `contextlib`, and four practical use cases.

4. [Python deque tutorial](https://mathspp.com/blog/python-deque-tutorial)

A `deque` is a double-ended queue data structure in the `collections` module, similar to a `list` but optimized for fast addition and removal from either end. This tutorial covers its basic usage and some advanced use cases.

5. [Python Generic function and class types](https://guicommits.com/python-generic-type-function-class/)

Python performs type checking at runtime and emphasizes the behavior of objects rather than their types, so it doesn't put much emphasis on "generics" that focus on type safety. However, Python does support generics, and this article introduces how to implement generic functions and generic classes using the `typing` module.

6. [Gevent in practice: Common pitfalls to keep in mind](https://upsun.com/blog/python-gevent-best-practices/)

Gevent is a high-performance networking library built on top of greenlet, a lightweight coroutine implementation. This article introduces common pitfalls of Gevent and provides solutions.

7. [Insecurity and Python pickles](https://lwn.net/SubscriberLink/964392/498a12fe44f51139/)

`pickle` is Python's standard library for serialization, but it has a major security risk when deserializing! The article introduces how it works, the root of the security risk, and how the machine learning community collaborated to design a safer alternative format called `safetensors`.

8. [Building An Open Source Decentralized E-Book Search Engine](https://github.com/j2qk3b/ebook-demo/blob/main/tutorial.md)

This tutorial uses JavaScript and Python to develop an e-book search engine that relies on Glitter (a decentralized database service built with Tendermint) and uses React to develop the page that displays the search results.

9. [What's the Difference Between Python import and Java import?](https://juejin.cn/post/7345423755948572726)

Many programming languages have the `import` keyword, and their functions are similar, but what are the differences in their underlying mechanisms? This article analyzes the similarities and differences between import in Java and Python, which can deepen your understanding of this topic.

10. [PDM's Internal Implementation (1)](https://frostming.com/2024/pdm-lockfile/)

`pdm` is an excellent dependency management tool in Python, created by the Chinese developer @frostming. The author plans to write a series of articles about its internal implementation. This is the first article, which introduces what Lockfile is and how Lockfile is generated.

11. [Does Python have pointers?](https://nedbatchelder.com/blog/202403/does_python_have_pointers.html)

Does Python have pointers? The answer depends on how you understand "pointers". The author gives a brief but insightful answer. Python does not have the classic pointer operations of the C language, but every variable in Python is a pointer, i.e., everything is an implicit pointer. (In addition: [A project](https://github.com/ZeroIntensity/pointers.py) "brings the pointer hell to Python", which is as superfluous as the Python version with curly braces below.)

12. [When Python can’t thread: a deep-dive into the GIL’s impact](https://pythonspeed.com/articles/python-gil/)

The GIL-less feature was finally [merged into Python's main branch](https://github.com/python/cpython/pull/116338) this week! Here is a long article that provides an in-depth introduction to the GIL, helping to understand how the GIL works and predict where concurrency bottlenecks are located. The article uses many thread timing analysis graphs for easy understanding.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [Flet enables developers to easily build realtime web, mobile and desktop apps in Python](https://github.com/flet-dev/flet)

No front-end experience required, quickly build cross-platform, multi-user, real-time single-page applications (SPAs); no SDK needed, development can be done with an IDE or text editor, front-end uses Flutter UI, back-end currently supports Python, with plans to support Go and C#. (8.7K stars) (Contributed by @bear)

2. [ss-python: A Python project template covering the entire development lifecycle](https://github.com/serious-scaffold/ss-python)

A Python project template with various integrations, configurations, and modules, featuring: project setup and template updates with `copier`, dependency and virtual environment management with `pdm`, containerization with dev container, mypy, ruff, and other commonly used tech stacks. (Contributed by @huxuan\_org)

3. [dukpy: Simple JavaScript interpreter for Python](https://github.com/amol-/dukpy)

A JS interpreter built on the `duktape` engine, used to execute JS code in Python. It has no other external dependencies, and has built-in common transpilers (TypeScript, JSX, LESS, CoffeeScript). It also supports passing parameters, running multiple scripts, global interpreters, loading modules using `require`, and installing packages from npmjs.org.

```Python
>>> import dukpy
>>> dukpy.evaljs("var o = {'value': 5}; o['value'] += 3; o")
{'value': 8}
```

4. [PyKidos: A Python Programming Practice Website](https://pykidos.github.io/)

An online Python programming website that makes it easy to teach kids how to code through games.

![](https://img.pythoncat.top/2024-03-15_pykidos.png)

5. [hatchet: A distributed, fault-tolerant task queue](https://github.com/hatchet-dev/hatchet)

Replaces hard-to-manage traditional queues and pub/sub systems, supports fault recovery, and solves concurrency, fairness, and rate limiting issues. Features low latency and high throughput, supports strategies like FIFO, LIFO, round-robin, and priority queues, allows for customizable retry policies, and supports integrated error handling. (2.4K stars)

6. [full-stack-fastapi-template: Full stack, modern web application template](https://github.com/tiangolo/full-stack-fastapi-template)

Supports JWT authentication, email-based password recovery, and uses Traefik as a reverse proxy/load balancer, with FastAPI, React, SQLModel, PostgreSQL, Docker, GitHub Actions, automatic HTTPS, etc. (17.5K stars)

7. [bython: Python with braces](https://github.com/mathialo/bython)

I think Python's use of whitespace for indentation is its most beautiful design feature! But some people prefer curly braces. This project adds curly braces to Python, with a basic example:

```python
def print_message(num_of_times) {
    for i in range(num_of_times) {
        print("Bython is awesome!");
    }
}

if __name__ == "__main__" {
    print_message(10);
}
```

8. [treq: Python requests-like API built on top of Twisted's HTTP client](https://github.com/twisted/treq)

A simple, requests-like HTTP client built on top of Twisted.

9. [JavSP: Video Metadata Scraper Aggregating Data from Multiple Sites](https://github.com/Yuukiy/JavSP)

Automatically fetches, aggregates, and categorizes video files based on specified rules, creating metadata files for use with software like Emby, Jellyfin, Kodi, etc. (1.6K stars)

10. [botasaurus: The All in One Framework to build Awesome Scrapers](https://github.com/omkarcloud/botasaurus)

Access Cloudflare protected pages with simple HTTP requests, the only scraper framework with SSL support for authenticated proxies, integrate any Chrome extension with just one line of code, sitemap support, data cleaning support, caching support, provides Selenium shortcuts, and more.

11. [pywebview: Build GUI for your Python program with JavaScript, HTML, and CSS](https://github.com/r0x0r/pywebview)

A lightweight cross-platform wrapper around the WebView component, displaying HTML content in a GUI window. Can be used with web frameworks or standalone to bridge Python with the DOM. The latest 5.0 release introduces Android support. (4.2K stars)

12. [Paper-Piano: Piano like no other, Piano on Paper](https://github.com/Mayuresh1611/Paper-Piano)

Allows you to practice playing the piano directly on a sheet of paper! Currently supports up to two fingers, primarily intended for those who cannot afford a piano.

![Image of Paper-Piano](https://img.pythoncat.top/2024-03-15_paper-piano.png)

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.