# Python Trending Weekly #41 (2024-03-09)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2024-03-09-weekly) of the weekly was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Implementing RSA in Python from Scratch](https://coderoasis.com/implementing-rsa-from-scratch-in-python/)

In a series of articles (4 in total), the author implements the RSA encryption algorithm in Python, covering the basic steps and mathematical principles of the algorithm, implementing it in Python and optimizing it step by step, implementing security attacks on it, and finally exploring future directions for RSA encryption.

2. [Python IAQ: Infrequently Answered Questions](https://norvig.com/python-iaq.html)

A question is infrequently answered either because few people know the answer or because it involves an obscure or subtle point. This article lists many such questions and provides answers. Since it was written 20 years ago, some of the questions have been addressed in later versions of Python, while others remain as relevant as ever.

3. [Why I Like Nox](https://hynek.me/articles/why-i-like-nox/)

Tox and Nox are two similar Python tools, one of their main purposes is to test your project against different Python versions. The author explains why he prefers to use Nox in some cases. (Note: I wrote a [tox tutorial](https://pythoncat.top/posts/2020-01-06-tox) 4 years ago, and also translated the Nox documentation. Time flies...)

4. [My favorite data structure: The trie](https://jamesg.blog/2024/01/16/trie/)

A trie (prefix tree or dictionary tree) is a tree-like data structure commonly used to store and retrieve information from a collection of strings. This article introduces the data structure and demonstrates basic operations using the `pygtrie` library.

5. [How fast can we process a CSV file](https://datapythonista.me/blog/how-fast-can-we-process-a-csv-file)

What are the options for processing CSV files in Python? How do they compare in terms of execution speed, code readability, and hardware implications? The author benchmarks the performance of Pandas with different engines and compares implementations using Numpy/DuckDB/DataFusion/Polars.

6. [Multilingual Support In Django](https://medium.com/@sakhawy/multilingual-support-in-django-5706e1e144a8)

How to add multilingual support to a Django project? How to detect the current language? How to translate message files, template files, and JS files? How is the translated content served to the frontend?

7. [Python Upgrade Playbook. How Lyft upgrades Python at scale—1500+…](https://eng.lyft.com/python-upgrade-playbook-1479145d52f4)

Lyft upgraded 1500+ codebases across 150+ teams from Python 2 to Python 3.10, and summarized a version upgrade manual.

8. [The simplest way to add Tailwind CSS to Django](https://www.photondesigner.com/articles/tailwind-with-django)

This tutorial provides step-by-step instructions, including a video, on how to integrate the popular Tailwind CSS framework into your Django project.

9. [Unexpected Python Traps for Beginners](https://www.bitecode.dev/p/unexpected-python-traps-for-beginners)

This article lists several common Python "traps" that can easily trip up beginners. These include: sneaky string concatenation, functions returning None, invisible tuples, the dreaded `is`, and list multiplication.

10. [Better PC Cooling with Python and Grafana](https://calbryant.uk/blog/better-pc-cooling-with-python/#)

An article about Python in the real world: the author uses Python to read CPU and water cooler temperatures, control fan and pump speeds, and monitor performance with Grafana, effectively improving PC cooling and reducing fan noise!

11. [Run Large AI Models on Android Phones with Snapdragon 8 Gen 3](https://soulteary.com/2024/02/29/run-large-ai-models-on-android-phones-with-snapdragon-8-gen-3.html)

The article introduces a simple method to run large AI models on Android phones, allowing you to experience English language models (Llama2 7B, Mistral 7B, RedPajama 3B, Google Gemma 2B, Microsoft PHI 2B); Chinese language models (Mianbi MiniCPM, multimodal models); and Stable Diffusion.

12. [14 Years in the Industry, and I Still Find Programming Difficult](https://www.piglei.com/articles/programming-is-still-hard-after-14-years/)

@piglei, the author of "Python Craftsman," shares his thoughts on programming. I read it last year and still find it insightful. The article compiles eight programming experiences, one of the core ideas being "writing good code," which echoes the original intention of the "Python Craftsman" series: writing elegant and efficient code like a craftsman creating a perfect handicraft.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [umami-python: Umami Analytics Client for Python](https://github.com/mikeckennedy/umami-python)

Many personal websites (including mine) have moved away from using Google Analytics for website traffic analysis in favor of the open-source umami. This project provides a client built on `httpx` and `pydantic` that allows you to authenticate, add custom data to umami, and view analytics data from umami.

2. [returns: Make your functions return something meaningful, typed, and safe](https://github.com/dry-python/returns)

It brings functional programming to Python, providing primitives for writing declarative business logic, fully typed, supporting functions and coroutines, and is framework agnostic. (3.2k stars)

3. [pyquest: Python everything Cheatsheet and a Journey to the land of Python programming](https://github.com/ivnvxd/pyquest)

This project collects a series of Python programming learning materials, covering all aspects of Python programming, for a systematic study of Python.

4. [flect: a Python framework for building full-stack web applications](https://github.com/Chaoyingz/flect)

Build user interfaces quickly with interactive and beautiful UIs by building your UI with Pydantic models that correspond to your frontend React component props on the backend.

5. [docker-android: Android in docker solution with noVNC supported and video recording](https://github.com/budtmo/docker-android)

A docker image for Android development and testing, with simulators for different devices, support for vnc to view inside the container, support for sharing logs via a web UI, ability to control from outside using adb, and support for various testing frameworks such as Appnium and Espresso. (7K stars)

6. [anthropic-sdk-python](https://github.com/anthropics/anthropic-sdk-python)

Last week's Claude 3 was a hot topic, with performance benchmarks that comprehensively surpassed GPT-4! This project is an officially released Python SDK that supports asynchronous, streaming responses, streaming assistants, usage viewing, returns in Pydantic models, retries, and timeout handling.

7. [PhotoMaker: PhotoMaker](https://github.com/TencentARC/PhotoMaker)

Quickly customize in seconds without additional LoRA training; ensure impressive ID fidelity, provide diversity, and generate high quality; can collaborate with other foundation models and LoRA modules as an adapter. (star 7.8K)

![](https://img.pythoncat.top/2024-03-09_photomaker.png)

8. [metube: Self-hosted YouTube downloader (web UI for youtube-dl / yt-dlp)](https://github.com/alexta69/metube)

A web GUI for youtube-dl (using a fork of yt-dlp) with playlist support. Download videos from YouTube and dozens of other sites. (3.1k stars)

9. [cachetools: Extensible memoizing collections and decorators](https://github.com/tkem/cachetools)

Provides various in-memory collections and decorators, including a variant of the Python standard library's @lru_cache function decorator. (2K stars)

10. [speedtest-cli: Command line interface for testing internet bandwidth using speedtest.net](https://github.com/sivel/speedtest-cli)

A network performance diagnostic tool that allows users to measure download and upload speeds and network latency to a specific server from a terminal or command-line environment. Cross-platform and easy to integrate into scripts for automated testing. (13.2K stars)

11. [Open-Sora-Plan: This project aims to reproduce Sora (Open AI T2V model)](https://github.com/PKU-YuanGroup/Open-Sora-Plan)

Sora is a text-to-video model released by OpenAI, representing a significant leap forward in video generation technology. This project aims to reproduce Sora through the power of the open-source community, and has set up the infrastructure but has not yet trained the full model. (5.2K stars)

12. [minisora: aims to explore the implementation path and future development direction of Sora](https://github.com/mini-sora/minisora)

Also aims to reproduce Sora, with a focus on being GPU-friendly and improving training and inference efficiency. Regularly holds roundtable discussions and paper reading sessions to delve deeper into the current state of video generation technology.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.