# Python Trending Weekly #39 (2024-02-24)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2024-02-24-weekly) of the weekly was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [uv: Python packaging in Rust](https://astral.sh/blog/uv)

`Ruff` team developed a powerful tool in Rust: `uv`, a package resolver and installer for Python! It's designed as a drop-in replacement for `pip` and `pip-tools`, and it's 8-10x faster than them when not using a cache. It can also be used as a virtual environment manager via `uv venv`, which is 80x faster than `python -m venv` and 7x faster than `virtualenv`.

![Performance comparison for resolving and installing the Trio library](https://img.pythoncat.top/2024-02-23_uv.png)

2. [Rye: A Vision Continued](https://lucumr.pocoo.org/2024/2/4/rye-a-vision/)

Rye is a Python packaging and project management tool released by the author of Flask in April last year. In the article, the author summarized its implemented functions (downloading Python, managing virtual environments, building and releasing packages, linting and formatting, dependency management, etc.), and introduced his design ideas. (Appendix 1: The author's 16-minute tutorial video [Rye: a Hassle-Free Python Experience](https://www.youtube.com/watch?v=q99TYA7LnuA)) (Appendix 2: The uv team that shared last time has taken over Rye, and it will be integrated into one in the future. [Rye Grows With UV](https://lucumr.pocoo.org/2024/2/15/rye-grows-with-uv/))

3. [The Python Rust-aissance](https://baincapitalventures.com/insight/why-more-python-developers-are-using-rust-for-building-libraries/)

Rust is progressively replacing C as the high-performance backend for Python. The article introduces the advantages of Rust over C and presents some well-known Python libraries developed with Rust.

4. [A search engine in 80 lines of Python](https://www.alexmolas.com/2024/02/05/a-search-engine-in-80-lines.html)

This article is a bit clickbaity, but the content it introduces is very comprehensive: asynchronous crawlers based on RSS, inverted indexes, search rankings, and web pages based on FastAPI. You can learn how search engines work and learn the project development process from data acquisition, data parsing, open interfaces, to web page presentation.

5. [Counting CPU Instructions in Python](https://blog.mattstuchlik.com/2024/02/08/counting-cpu-instructions-in-python.html)

Do you know how many CPU instructions it takes to execute `print("Hello")` in Python? The answer is 17,000. Importing `seaborn` takes about 2 billion. The author developed the [Cirron](https://github.com/s7nfo/Cirron) library to count CPU instructions, branch misses, and time spent in code.

6. [Python Reusable Decorator Code](https://www.kawabangga.com/posts/5757)

You have multiple decorators to add to different functions, and the same decorator may have different parameters. How do you reuse these decorators? The problem may be difficult to understand at first glance, but the article contains intuitive examples and solutions that can deepen your understanding of decorators and help you master advanced applications.

7. [Handling Tasks in Asyncio Like a Pro](https://jacobpadilla.com/articles/handling-asyncio-tasks)

What is a Task object in Asyncio? How do Asyncio coroutines work? How do you await a task, and how do you await multiple or a group of tasks? This article explains how Asyncio works and the functions you can use to work with tasks.

8. [Everything You Can Do with Python's textwrap Module](https://martinheinz.dev/blog/108)

This article introduces several major functions of the `textwrap` library, such as `shorten()` for truncating string length, `wrap()` for wrapping a string to a fixed width, and `dedent()` for handling string indentation.

9. [Summary of Major Changes Between Python Versions](https://www.nicholashairs.com/posts/major-changes-between-python-versions/)

When were some of Python's new features introduced? The author has conveniently compiled a record of some important changes to the syntax and standard library, as well as indicating when each version will reach its end of life (for example, Python 3.8 will reach EOL in October of this year). (Note: This [website](https://endoflife.date/python) provides EOL dates for Python and many other projects.)

10. [Postgres as a Queue](https://leontrolski.github.io/postgres-as-queue.html)

If you use a database directly as a queue, will performance be significantly affected? The author's tests show that the impact is minimal. How exactly can you implement Postgres as a queue? How do you handle locks and transactions, task retries, and task timeouts?

11. [20 Django Packages That I Use in Every Project](https://learndjango.com/tutorials/20-django-packages-i-use-every-project)

The Django framework is suitable for building complex web projects, and the author introduces 20 commonly used packages that provide richer functionality beyond Django's core features.

12. [Real Case of Python Metaclass Application](https://dev.to/anbagu/real-case-of-python-metaclass-application-2pj8)

What is a metaclass in Python? Why should you learn about metaclasses? This advanced feature is not commonly used, but it's worth learning and understanding. The article explains how metaclasses work and demonstrates their powerful uses with real-world examples.

13. [One Trillion Row Challenge](https://blog.coiled.io/blog/1trc.html)

A programming challenge: given 100,000 files, each with 10 million rows, calculate the minimum, average, and maximum temperatures for each weather station. The data is stored on S3 and has a total size of 2.5 TB. The author provides their own implementation (which runs in 8.5 minutes), as well as a cost-optimized solution.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [uv: An extremely fast Python package installer and resolver, written in Rust](https://github.com/astral-sh/uv)

uv is an extremely fast Python package installer and resolver written in Rust. It is a product of the Ruff team and can directly replace commonly used commands such as `pip`, `pip-tools`, and `virtualenv`. (6.6K stars)

2. [sqlite-web: Web-based SQLite database browser written in Python](https://github.com/coleifer/sqlite-web)

A web-based SQLite database browser built with Flask, which allows you to visually manage your databases, tables, records, and indexes, and import and export data in JSON and CSV formats. (2.6k stars)

3. [celery-exporter: A Prometheus exporter for Celery metrics](https://github.com/danihodovic/celery-exporter)

Real-time monitoring metrics for Celery task state, worker threads, active tasks, etc. It follows Prometheus exporter best practices and provides Grafana dashboards and Prometheus alerts using Celery-mixin.

4. [pyupgrade: A tool (and pre-commit hook) to automatically upgrade syntax for newer versions of the language](https://github.com/asottile/pyupgrade)

A powerful tool and pre-commit hook to automatically remove redundant constructs, rewrite legacy code with modern syntax, refactor code to a more idiomatic style, and more. The project documentation provides many examples, which are worth checking out. (3.2k stars)

```python
# Two examples rewritten as dict comprehensions
-dict((a, b) for a, b in y)
+{a: b for a, b in y}
-dict([(a, b) for a, b in y])
+{a: b for a, b in y}
```

5. [ollama-python: Ollama Python library](https://github.com/ollama/ollama-python)

Supports Python 3.8+, easy and fast integration with large language models such as Llama 2, Code Llama, mistral, gemma, etc. It allows for custom clients and also enables the creation of asynchronous clients.

6. [web2pdf: CLI to convert Webpages to PDFs](https://github.com/dvcoolarun/web2pdf)

A command-line tool to convert webpages to beautifully formatted PDFs. It supports batch conversion, custom styling, appending CSS, complex layouts, page numbers, table of contents, and pagination, among other features.

7. [natural-sql: A series of top performing Text to SQL LLMs](https://github.com/cfahlgren1/natural-sql)

NaturalSQL-7B is a highly accurate text-to-SQL large language model that outperforms GPT-3.5-turbo and claude-2 on the SQL-Eval benchmark, as well as sqlcoder-7b with the same data size.

8. [rawdog: Generate and auto-execute Python scripts in the cli](https://github.com/AbanteAI/rawdog)

Rawdog (Recursive Augmentation with Deterministic Output Generation) is a novel alternative to RAG (Retrieval Augmented Generation) that can run scripts itself and take the output as context, then call itself again. The example in the demo video is mind-blowing. (star 1.6K)

9. [UFO: A UI-Focused Agent for Windows OS Interaction](https://github.com/microsoft/UFO)

Microsoft's new AI agent framework seamlessly operates across multiple applications to complete complex user tasks. It leverages GPT-Vision's multimodal capabilities to understand application UIs and interacts using Windows UI Automation controls. (1.9k stars)

10. [toolong: A terminal application to view, tail, merge, and search log files (plus JSONL)](https://github.com/Textualize/toolong)

Quickly view log files in a command-line terminal with features like live tailing, syntax highlighting, fast searching, automatic timestamp detection for merging logs, JSONL support, and automatic opening of .bz and .bz2 files. (2k stars)

11. [A personal wearable AI that runs locally](https://github.com/OwlAIProject/Owl)

Bring AI to your wearable device to listen and observe your life. It supports hardware like ESP platforms, Sony Spresense, or Apple Watch, local and online models, multimodal capture, speaker verification, and more.

12. [hyperdiv: Build reactive web UIs in Python](https://github.com/hyperdiv/hyperdiv)

A framework for rapidly developing reactive UI applications in Python, featuring built-in components, a concise declarative syntax, and minimal tooling boilerplate. It supports Shoelace components, Markdown support, Chart.js integration, browser cache read/write, form validation, and more.

13. [fabric: an open-source framework for augmenting humans using AI](https://github.com/danielmiessler/fabric)

This project aims to make AI accessible to everyone for solving everyday problems. Its approach is to break down problems into independent components and use structured, clear prompts to have AI complete tasks. (5.6k stars)

## 🐢Podcasts & Videos

1. [Meta loves Python](https://engineering.fb.com/2024/02/12/developer-tools/meta-loves-python/)

A podcast episode from Meta, discussing the contributions of their developer teams to recent versions of Python, including new hooks that allow for custom JITs (like Cinder), immortal objects, improvements to the type system, faster comprehensions, and more. Meta really is a big contributor to the Python community! (See also: [Google, Microsoft, Meta? Who's the biggest sponsor of Python?](https://pythoncat.top/posts/2022-11-21-sponsors))

2. [Episode #449 Building UIs in Python with FastUI](https://talkpython.fm/episodes/show/449/building-uis-in-python-with-fastui)

FastUI is a web frontend framework that lets you build responsive web applications using React without writing any JavaScript or dealing with npm. The creator of the framework joins the show to talk about it.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.