# Python Trending Weekly #38 (2024-02-03)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2024-02-03-weekly) of the weekly was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Building a FullStack Application with Django, Django REST & Next.js](https://dev.to/koladev/building-a-fullstack-application-with-django-django-rest-nextjs-3e26)

Django and Next.js are very powerful web frameworks for backend and frontend development. This tutorial builds a restaurant menu management project using Django 4.2 and Next.js 13.

2. [A day in the life of a developer - Building a dashboard app with SQL, Node.js, Django and Next.js](https://dev.to/andrewbaisden/a-day-in-the-life-of-a-developer-building-a-dashboard-app-with-sql-nodejs-django-and-nextjs-5en7)

This tutorial for a full-stack project is more comprehensive than the previous one. In addition to implementing CRUD operations, it also covers dashboards, form filtering, Tailwind CSS, working with different databases, and building the backend with Node.js and Django, respectively.

3. [Profiling your Numba code](https://pythonspeed.com/articles/numba-profiling/)

Numba is a popular solution to speed up Python code. The author open-sourced a library called [Profila](https://github.com/pythonspeed/profila) that is specifically designed to analyze the performance of Numba code itself. The article introduces how to use it and also discusses three limitations of performance analysis.

4. [Ten Python datetime pitfalls, and what libraries are (not) doing about it](https://dev.arie.bovenberg.net/blog/python-datetime-pitfalls/)

The author analyzes 10 pitfalls of the `datetime` module and introduces the situation of mainstream third-party libraries (such as `arrow`, `pendulum`, `DateType`, `heliclockter`), and finds that most of them have the same problems. What is a better date and time library? The author open-sourced a library that attempts to solve the problems in the article.

5. [4 Ways to Correct Grammar with Python](https://www.listendata.com/2024/01/4-ways-to-correct-grammar-with-python.html)

Here, "grammar" refers to writing grammar, not programming grammar. The article introduces four libraries, `language-tool-python`, `Gramformer`, `Ginger`, and `pyaspeller`, for checking and automatically correcting grammatical errors.

6. [Syntax Error #11: Debugging Python](https://www.syntaxerror.tech/syntax-error-11-debugging-python/)

This is the transcript of a talk the author gave at PyCon Sweden 2023, sharing his debugging mindset, tools, and techniques, including tools like `snoop`, `pdb/ipdb`, `PuDB`, `web-pdb`, `birdseye`, `Kolo`, and more.

7.  [Debugging a Mixed Python and C Language Stack](https://developer.nvidia.com/blog/debugging-mixed-python-and-c-language-stack/)

Debugging is hard, and debugging across multiple languages is even harder. This article introduces how to debug a mixed language issue, using GDB to debug Python+C, locating and fixing a deadlock issue, and sharing some debugging experiences.

8. [Analyzing "Sorting a million 32-bit integers in 2MB of RAM using Python"](https://www.bitecode.dev/p/analyzing-sorting-a-million-32-bit)

This article is an analysis and interpretation of Guido's 2008 article [Sorting a million 32-bit integers in 2MB of RAM using Python](http://neopythonic.blogspot.com/2008/10/sorting-million-32-bit-integers-in-2mb.html). The solution uses the less common modules `struct`, `array`, and `heapq`, as well as techniques such as context managers and generators.

9. [Implement Parsers with Pylasu](https://tomassetti.me/implement-parsers-with-pylasu/)

This tutorial shows how to define an AST with Pylasu, generate a parser using ANTLR, implement a transformation from the ANTLR parse tree to the Pylasu AST, and finally build a toy programming language parser with a CLI.

10. [Dynamic Programming is not Black Magic](https://qsantos.fr/2024/01/04/dynamic-programming-is-not-black-magic/)

What is dynamic programming? What are its features and advantages compared to other approaches? This article starts with a common programming problem and gradually introduces caching, optimizing the cache, and dynamic programming, unveiling the mystery of dynamic programming.

11. [Reasons to avoid static type checking](https://typing.readthedocs.io/en/latest/source/typing_anti_pitch.html)

Python supports type hints, but it's not mandatory. In fact, there are many cases where it's not recommended to use type hints. This document from the typing module lists some reasons why you might want to avoid using type hints.

12. [Running Open Source LLMs In Python - A Practical Guide](https://christophergs.com/blog/running-open-source-llms-in-python)

How to run large language models on your personal laptop? This tutorial provides a complete walkthrough of running llama.cpp on different operating systems, including selecting and downloading the model, setting prompts, formatting LLM outputs using GBNF grammars, streaming responses, multimodal models, and more.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [excelCPU: 16-bit CPU for Excel, and related files](https://github.com/InkboxSoftware/excelCPU)

This popular project has nearly 3K stars in just one week! The `CPU.xlsx` file provides a 16-bit CPU, 16 general-purpose registers, 128KB of RAM, and a 128x128 display area. It is compiled using Python. (3K stars)

2. [whenever: Foolproof datetimes for maintainable Python code](https://github.com/ariebovenberg/whenever)

This datetime library addresses some of the problems that the standard library and other third-party libraries don't solve very well, as mentioned earlier.

3. [deepSeek-Coder: Let the Code Write Itself](https://github.com/deepsSeek-ai/deepsSeek-coder/)

It consists of a series of code language models, each of which is a 2T token-trained model with multiple model sizes, advanced code-completion ability, and excellent performance in various benchmarks. (4.3k stars)

![Benchmark score comparison with other models](https://img.pythoncat.top/2024-02-03-coder.png)

4. [fastcrud: FastCRUD is a Python package for FastAPI, offering robust async CRUD operations and flexible endpoint creation utilities](https://github.com/igorbenav/fastcrud)

Features: Fully async, SQLAlchemy 2.0, Powerful CRUD, Dynamic construction of complex queries, Advanced SQL joins, Offset or cursor-based pagination, Modular and extensible, Autogenerated API.

5. [leptonai: A Pythonic framework to simplify AI service building](https://github.com/leptonai/leptonai)

This framework enables you to effortlessly build AI services with Python code. Its key features include: well-designed abstractions, model startup with just a few lines of code, built-in examples for common models (e.g., Llama, SDXL, Whisper), automatic batch processing, background tasks, and more. (1.9k stars)

6. [GPT Newspaper: Create Personalized Newspapers with GPT](https://github.com/assafelovic/gpt-newspaper)

Let AI curate, write, design, and edit content based on your personal taste and interests, powered by 6 specialized agents that search the web for the latest content and aggregate well-known news sources.

7. [apprise: Push Notifications that work with just about every platform!](https://github.com/caronc/apprise)

A lightweight notification library written in pure Python that allows you to send notifications via a plethora of services like Telegram, Discord, Slack, Amazon SNS, Gotify, and many more, supporting various notification formats such as SMS, email, and desktop notifications. (9.7K stars)

8. [procrastinate: PostgreSQL-based Task Queue for Python](https://github.com/procrastinate-org/procrastinate)

A distributed task processing library based on PostgreSQL, providing Django integration and easy to use with ASGI frameworks. It supports features like async, periodic tasks, retries, arbitrary task locks, etc.

9. [flent: The FLExible Network Tester](https://github.com/tohojo/flent)

It can run multiple instances of netperf/iperf/ping simultaneously and aggregate the results, presenting the data through an interactive GUI and an extensible plotting facility. It supports local and remote hosts and can collect statistics about CPU usage, WiFi, qdisc, and TCP sockets, among other things.

![](https://img.pythoncat.top/flent-screenshot.png)

10. [urllib3: New Version Supports Making HTTP Requests in the Browser](https://github.com/urllib3/urllib3/releases/tag/2.2.0)

urllib3 has released version 2.2.0, which brings support for use in the Pyodide runtime! The latter is a Python interpreter that runs in the browser and is the technical foundation for frameworks like PyScript and Jupyterlite. This has major implications for Python frontend development, and the future looks bright.

11. [gnuplotlib: gnuplot for numpy](https://github.com/dkogan/gnuplotlib)

Gnuplot is a powerful, open-source plotting tool for generating various types of 2D and 3D plots. This project integrates it with Numpy, leveraging its data handling and plotting capabilities.

12. [history_rag: Build a Chinese History Q&A App with RAG](https://github.com/wxywb/history_rag)

RAG (Retrieval-Augmented Generation) + vector database to build a Chinese history knowledge Q&A application, supporting both "Milvus Scheme" (on-premises) and "Zilliz Cloud Pipelines Scheme" (on cloud), providing a web UI interface based on gradio. The default model is GPT4, and other LLMs can be easily switched.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.