# Python Trending Weekly #37 (2024-01-27)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2024-01-27-weekly) of the weekly was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Xmas decorations, part 3](https://www.bitecode.dev/p/xmas-decorations-part-3)

This is the third article in the author's series on decorators, extracting three generic use cases from real-world usage in a variety of open source libraries: intercepting calls, acting as function registries, and enriching function behavior.

2. [This is not interview advice: a priority-expiry LRU cache without heaps or trees in Python](https://death.andgravity.com/lru-cache)

If this were a big company interview question, how would you implement the algorithm in the title without using heaps or binary search trees? The article teaches a lot by proposing a minimally viable solution, refining the code step by step, and comparing the time complexities of different approaches.

3. [Performance Analysis of Python's `dict()` and `{}`](https://madebyme.today/blog/python-dict-vs-curly-brackets/)

What are the differences between the two ways of creating a dictionary in Python: `dict()` and `{}`? This article provides an in-depth analysis by looking at their bytecode and the CPython interpreter source code. In terms of performance, the conclusion is that `{}` is faster than `dict()`. (Note: Python Why series has written about [Python Puzzle: Which is faster, `[]` or `list()`? Why? How much faster?](https://pythoncat.top/posts/2020-10-14-list)

4. [Augmenting the Markdown language for great Python Graphical Interfaces](https://www.taipy.io/posts/augmenting-the-markdown-language-for-great-python-graphical-interfaces)

The Taipy team has developed an enhanced Markdown API that generates graphical user interface elements in your content by adding tags.

![A demonstration of the graphical interface effects](https://img.pythoncat.top/taipy_markdown.gif)

5. [7 Python Memory Optimization Tricks To Enhance Your Code’s Efficiency](https://medium.com/techtofreedom/7-python-memory-optimization-tricks-to-enhance-your-codes-efficiency-5ef65bf415e7)

This article introduces seven techniques for optimizing memory in Python: using `__slots__` in class definitions, using generators, using `mmap` for handling large files, reducing the use of global variables, taking advantage of short-circuit evaluation of logical operators, choosing appropriate data types, and using string interning.

6. [Garbage collection in Python: things you need to know](https://rushter.com/blog/python-garbage-collector/)

How does Python garbage collection work? Why does CPython use reference counting? What problems can a generational garbage collector solve? How can you view and debug reference cycles?

7. [Postgres vs. DynamoDB: Which Database to Choose?](https://testdriven.io/blog/postgres-vs-dynamodb/)

How are **Postgres** and **DynamoDB** used and how should you choose between them? The article compares their ORM, queries, performance, backups, migrations, and provides recommendations for choosing a solution based on different scenarios.

8. [Building a dashboard in Python using Streamlit](https://blog.streamlit.io/crafting-a-dashboard-app-in-python-using-streamlit/)

A detailed official blog tutorial that uses Pandas for data cleaning, Altair/Plotly for data visualization, and Streamlit for the front end.

![](https://img.pythoncat.top/streamlit-dashboard-python.png)

9. [scrapscript.py](https://bernsteinbear.com/blog/scrapscript/)

Scrapscript is a tiny, pure, functional, content-addressable, web-first programming language. The author introduces its design principles, features, implemented and in-progress features, and the process of implementing it with Python.

10. [We build X.509 chains so you don’t have to](https://blog.trailofbits.com/2024/01/25/we-build-x-509-chains-so-you-dont-have-to/)

X.509 is a PKI standard that defines the format of digital certificates and standardizes certificate attributes. Version 42.0.0 of **Cryptography** provides X.509 related APIs. The article introduces its significance and the problems it solves.

11. [I am disappointed by dynamic typing](https://buttondown.email/hillelwayne/archive/i-am-disappointed-by-dynamic-typing/)

The author's disappointment is not about the drawbacks of dynamic typing compared to static typing, but that Python does not take full advantage of the strengths of dynamic typing. Dynamic is not the opposite of static; dynamic means types can change at runtime. The author hopes to enhance the power of dynamic analysis, hoping that "test amplification" of dynamic typing is easier, rather than turning to type annotations or static typing.

12. [Python’s “Disappointing” Superpowers](https://lukeplant.me.uk/blog/posts/pythons-disappointing-superpowers/)

This article is a response to the previous sharing, illustrating the superpowers of Python's dynamic typing through the magical techniques (monkey patching and dynamic metaprogramming) used by libraries such as Werkzeug, Pony, Django, fluent-compile, and Pytest. Python can do more than you might think.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [core: Production ready AI assistant framework](https://github.com/cheshire-cat-ai/core)

A framework for building custom AIs based on any large language model, deployed with Docker. API first, extensible with plugins, with an admin panel, and remembers conversations and documents. (star 1.6K)

![Dialog interface of AI framework](https://img.pythoncat.top/2024-01-26_core.png)

2. [van-gonography: Hide files of any type inside an image of your choice using steganography](https://github.com/JoshuaKasa/van-gonography)

This tool allows you to hide files of any type inside an image of your choice, without affecting the visual quality of the image. It supports image decoding, image comparison, CLI, UI, cross-platform, encryption, and compression.

3. [mpmath: Python library for arbitrary-precision floating-point arithmetic](https://github.com/mpmath/mpmath)

Supports real and complex floating-point arithmetic with arbitrary precision, and provides a large collection of functions specifically designed for mathematical use.

4. [sqlite-worker: Effortlessly manage SQLite in multi-threaded Python applications](https://github.com/roshanlam/sqlite-worker)

Provides a thread-safe interface for SQLite database operations, with queue-based statement execution.

5. [granian: A Rust HTTP server for Python applications](https://github.com/emmett-framework/granian)

A single HTTP implementation in Rust, avoiding the common dependency combination of Gunicorn + uvicorn + http-tools. Supports ASGI/3, RSGI, and WSGI interface applications, and HTTP/1 and HTTP/2 protocols. (1.5k stars)

6. [fasthx: FastAPI and HTMX, the right way](https://github.com/volfpeter/fasthx)

FastAPI + HTMX combination, featuring decorator syntax, support for any template engine and server-side rendering library, built-in Jinja2, support for both HTMX requests and regular requests, support for synchronous and asynchronous routes, and more...

7. [ml-engineering: Machine Learning Engineering Open Book](https://github.com/stas00/ml-engineering)

A technical manual for LLM/VLM training engineers and practitioners to help train large language models and multimodal models successfully. (6.9k stars)

8. [sglang: SGLang is a structured generation language designed for large language models](https://github.com/sgl-project/sglang)

By co-designing a frontend language and a runtime system, it makes interactive LLMs faster and more controllable. It supports multiple chained generative calls, advanced prompting techniques, control flow, multi-modality, parallelism, and external interactions, with a high-performance runtime powered by RadixAttention.

9. [chatgpt_telegram_bot](https://github.com/father-bot/chatgpt_telegram_bot)

Deploy ChatGPT as your own Telegram bot, supporting GPT-4, GPT-4 Turbo, and DALLE 2, supporting group chats, built-in 15 special dialogue modes, supporting viewing OpenAI API expenses, etc. (star 4.5K)

10. [HuixiangDou: Overcoming Group Chat Scenarios with LLM-based Technical Assistance](https://github.com/InternLM/HuixiangDou)

Its Chinese name is "HuixiangDou", which proposes a set of algorithms pipeline for answering technical questions, with low deployment cost, supporting complex scenarios such as group chats, supporting WeChat groups, lark groups, Feishu groups, DingTalk robots and other IMs.

11. [ComfyUI-InstantID: Unofficial implementation of InstantID for ComfyUI](https://github.com/ZHO-ZHO-ZHO/ComfyUI-InstantID)

Using models such as ID Base model, InsightFace model, ID ControlNet model, Ipadapter_instantid, etc., the official provides 8 styles.

![Beautiful Anne Hathaway](https://img.pythoncat.top/2024-01-27_ComfyUI-InstantID.png)

12. [ComfyUI-PhotoMaker-ZHO: Unofficial implementation of PhotoMaker for ComfyUI](https://github.com/ZHO-ZHO-ZHO/ComfyUI-PhotoMaker-ZHO)

Supports lora, supports multiple batches, supports general styler, the official provides 10 styles.

![](https://img.pythoncat.top/2024-01-27_ComfyUI-PhotoMaker.png)

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.