# Python Trending Weekly #36 (2024-01-20)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2024-01-20-weekly) of the weekly was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Python Packaging, One Year Later: A Look Back at 2023 in Python Packaging](https://chriswarrick.com/blog/2024/01/15/python-packaging-one-year-later/)

A year ago, the author complained about the miserable state of Python packaging. A year later, has anything improved? Or has it gotten worse? The article discusses the mainstream packaging tools in the community, the PEP standards and their implementation. Although there are many new things, it still seems bleak.

2. [All PyCon 2023 (US and AU) talks sorted by the view count](https://techtalksweekly.substack.com/p/all-pycon-2023-talks-sorted-by-views)

This article organizes 243 videos from last year's PyCon US and Python AU, sorted by the number of views on YouTube. None of them have many views, and the gap between the first and second place is huge.

![PyCon 2023 video views](https://img.pythoncat.top/2024-01-19_pycon.png)

3. [Synchronized in Python](https://thiagowfx.github.io/2024/01/synchronized-in-python/)

In Java, the `synchronized` keyword can be used to ensure that a variable is thread-safe. Is there anything in Python that can achieve the same effect? This article introduces the implementation方案 of the `threading` module's Lock + context manager + decorator.

4. [Type information for faster Python C extensions](https://bernsteinbear.com/blog/typed-c-extensions/)

PyPy is a Python interpreter with a compatibility layer for its C API that has some performance problems. The author is working on ways to make PyPy's C API faster, and this post describes the work that they have done.

5. [Comparing coroutines, by example, in Kotlin and Python](https://medium.com/@ms.carmen.alvarez/comparing-coroutines-by-example-in-kotlin-and-python-7e60746eae18)

The author has been exposed to coroutines while developing with Python and Kotlin, so she wrote several articles to compare their usage, analyze their details and working principles, covering file reading and writing, HTTP requests, sequences and generators, which can deepen your understanding of coroutines.

6. [The curious case of Pydantic and the 1970s timestamps](https://dev.arie.bovenberg.net/blog/pydantic-timestamps/)

Pydantic tries to guess whether Unix timestamps are in seconds or milliseconds, but this causes problems with timestamps from before 1970! As we know, timestamps in the computer world start from 1970-1-1 (the Unix epoch), which means that early timestamps have fewer digits, and if we interpret them as seconds, we'll be off by decades!

7. [In-browser code playgrounds](https://antonz.org/in-browser-code-playgrounds/)

How to execute code snippets in real time on a browser? The author open-sourced a tool based on WASI that allows you to execute Python, PHP, Ruby, Lua, Javascript, and SQLite code snippets on a browser.

8. [Django, SQLite, and the Database is Locked Error](https://blog.pecar.me/django-sqlite-dblock)

In a multi-threaded environment, using SQLite may cause the "database is locked" error. The article analyzes two main reasons (SQLite waiting for the lock to time out, writing after reading in a transaction), introduces the corresponding solutions, and specifically mentions the solution provided by Django itself.

9. [Polars Tutorial](https://www.cnblogs.com/traditional/p/17959796)

Polars is a high-performance Python data processing library built on Rust + Arrow. This tutorial provides a comprehensive introduction to Polars. (See also: [Polars Tutorial](https://pbpython.com/polars-intro.html))

10. [Building HTML components from Python functions](https://ricardoanderegg.com/posts/python-build-html-components-lxml/)

How to implement React-like components in Python? The author attempts to generate HTML with pure Python functions and render it using the `lxml` library. The article presents some basic experiments to demonstrate the feasibility.

11. [Happy New Year: GPT in 500 lines of SQL](https://explainextended.com/2023/12/31/happy-new-year-15/)

Can we implement a large language model in SQL? ChatGPT says it's beyond SQL's capability. However, the author disagrees! The article details the necessary knowledge to build GPT and eventually implements it in 500 lines of SQL! (See also: the author's annual tradition of doing something incredible with SQL since 2010, such as [solving a Rubik's Cube with SQL](https://explainextended.com/2022/12/31/happy-new-year-14/), [implementing a quantum computer simulator in SQL](https://explainextended.com/2021/12/31/happy-new-year-13/), ...)


🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [niquests: Requests but with HTTP/3, HTTP/2, Multiplexed Connections, System CAs, Certificate Revocation, DNS over HTTPS / TLS / QUIC or UDP, Async, DNSSEC, and (much) pain removed!](https://github.com/jawah/niquests)

Niquests: A drop-in replacement for Requests, with HTTP/3, HTTP/2, Multiplexed Connections, System CAs, Certificate Revocation, DNS over HTTPS / TLS / QUIC or UDP, Async, DNSSEC, and (much) pain removed!

2. [slotscheck: Ensure your `__slots__` are working properly](https://github.com/ariebovenberg/slotscheck/)

Python's `__slot__` variables can reduce instance memory and prevent adding dynamic attributes. But to work properly, all base classes must implement it. This library can check if it's broken, overlapping, redundant, and provides a pre-commit hook.

3. [panel: The powerful data exploration & web app framework for Python](https://github.com/holoviz/panel)

Supports drag-and-drop widgets, plots, tables, and other explorable Python objects to compose custom analysis tools and dashboards, with support for a wide range of visualization tools, including **ipywidgets**. (star 3.7K)

![Edit and see the results live](https://img.pythoncat.top/2024-01-20-panel.gif)

4. [QAnything: Question and Answer based on Anything](https://github.com/netease-youdao/QAnything)

A local knowledge base question and answer system that supports any format of files or databases and can be installed and used offline. One-click installation and deployment, supports cross-lingual Q&A, and supports selecting multiple knowledge bases for Q&A. (star 1.9K)

5. [Bert-VITS2-ext: Animation testing based on Bert-VITS2](https://github.com/see2023/Bert-VITS2-ext)

TTS synchronously generates facial expression data, voice to expression, and generates body animation.

6. [weread-exporter: Export books from WeChat Reading to formats like epub, pdf, mobi](https://github.com/drunkdream/weread-exporter)

By hooking the Canvas function in the Web page, it obtains information such as text and styles, converts it to Markdown format, and finally converts it to Epub, PDF, and Mobi formats.

7. [leetcode-solution: Explore diverse LeetCode solutions in Python, C++, JavaScript, SQL, and TypeScript](https://github.com/hogan-tech/leetcode-solution)

This project collects 400+ LeetCode problems and solutions in different languages.

8. [CapsWriter-Offline: CapsWriter Offline, a handy PC-based speech input tool](https://github.com/HaujetZhao/CapsWriter-Offline)

A PC-based speech input and subtitle transcription tool that is completely offline, has unlimited duration, low latency, high accuracy, supports mixed Chinese and English input, automatic Arabic numerals, and automatic adjustment of Chinese and English spacing. It supports hotkey functions, diary functions, transcription functions, etc.

9. [surya: Accurate line-level text detection and recognition (OCR) in any language](https://github.com/VikParuchuri/surya)

A multilingual document OCR toolkit that supports accurate line-level text detection. The downside is that it doesn't work for images and handwritten text. (3.6k stars)

10. [GPT-SoVITS: 1 min voice data can also be used to train a good TTS model!](https://github.com/RVC-Boss/GPT-SoVITS)

A powerful short-context voice conversion and text-to-speech WebUI, featuring zero-shot TTS, few-shot TTS, cross-lingual support, and a WebUI tool. (2.7k stars)

11. [trt-llm-rag-windows: A developer reference project for creating Retrieval Augmented Generation (RAG) chatbots on Windows using TensorRT-LLM](https://github.com/NVIDIA/trt-llm-rag-windows)

A RAG demo project on Windows, based on the LLaMa 2 13B model, TensorRT-LLM, and the FAISS vector search library.

12. [LangGPT: Empowering everyone to become a prompt expert! Structured Prompt，Language of GPT](https://github.com/EmbraceAGI/LangGPT)

Write high-quality ChatGPT prompts in a structured, templated way, overcoming the lack of systematicity and flexibility in regular prompt creation. (2.8k stars)

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.