# Python Trending Weekly #34 (2024-01-06)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2024-01-06-weekly) of the weekly  was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [A Simple Introduction About Python JIT](https://www.manjusaka.blog/posts/2024/01/03/a-simple-introduction-about-python-jit/)

Python 3.13 will introduce a copy-and-patch JIT compiler, which makes the most of the LLVM ecosystem. The compiler uses clang, the compiler parameter is set to -o3 to get the best performance, and the binary tools are llvm-objdump and llvm-readelf. The scheme can be described as both new and good.

2. [Fastest Way to Read Excel in Python](https://hakibenita.com/fast-excel-python)

How to read Excel files with Python? This article compares the performance of **Pandas, Tablib, Openpyxl, LibreOffice, DuckDB and Calamine** in terms of speed, type and correctness.

![Comparison of Python Libraries for Reading Excel](https://img.pythoncat.top/2024-01-05_excel.png)

3. [Build a Scalable Flask Web Project From Scratch](https://realpython.com/flask-project/)

Flask is a powerful and flexible web framework. This beginner-friendly tutorial covers how to set up a Flask project, develop a starter project, add multiple pages using blueprints, use Jinja templates, store static files, and more.

4. [Python, C, Assembly - 2'500x Faster Cosine Similarity](https://ashvardanian.com/posts/python-c-assembly-comparison/)

Cosine similarity is a widely used metric in machine learning and information retrieval. This article introduces some low-level optimizations, taking the cosine similarity as an example, starting with a pure Python version, NumPy slows it down, SciPy speeds it up by 2-5x, C brings a 200x speedup, SIMD intrinsics a 400x speedup, AVX-512 with BMI2 a 747x speedup, AVX-512FP16 a 1260x speedup, and AVX-512VNNI a 2521x speedup.

5. [AI or Not — detect AI-generated photos using AI](https://tolkunov.dev/posts/ai-or-not/)

The latest AI models like **Stable Diffusion XL** and **Midjourney v6** can generate extremely realistic images, making it harder for the human eye to distinguish between real and fake. The author trained a classifier that can detect AI-generated images with 99% accuracy.

6. [max is broken](https://mathspp.com/blog/max-is-broken)

The author keenly found that the functions **sum, all, any, and math.prod** all have proper default values when the input is an empty list, but the **max** and **min** functions will throw an error! The author thinks it should be equal to negative infinity, what do you think?

7. [App Automation Testing with Appium: Common Appium APIs and Operations](https://juejin.cn/post/7318952376593006633)

Appium is a commonly used Android UI automation testing tool, and this article is part of a series of tutorials on Appium automation testing.

8. [The simplest way to build an instant messaging app with Django](https://www.photondesigner.com/articles/instant-messenger)

How to add real-time events to your Django app asynchronously? Without Redis, using Django's new async features. This article demonstrates the development of a minimalistic web-based instant messaging application.

9. [Understanding Numeric Data Types in Python](https://fullspeedpython.com/articles/understanding-numeric-data-types/)

What are the commonly used numeric data types in Python? What are their characteristics and how are they implemented in CPython? The article introduces integer, floating-point, and complex types, as well as the math, decimal, and fractions modules. (Appendix: [PEP-3141--Numeric Tower](https://github.com/chinesehuazhou/peps-cn/blob/master/StandardsTrack/3141--%E6%95%B0%E5%AD%97%E7%9A%84%E7%B1%BB%E5%9E%8B%E5%B1%82%E7%BA%A7.md))

10. [Asyncio Logging Without Blocking](https://superfastpython.com/asyncio-log-blocking/)

How to implement non-blocking logging in asyncio programs? The article introduces how to use a shared Queue and QueueHandler to log, and use QueueListener to store the logs.

11. [How Instagram scaled to 14 million users with only 3 engineers](https://read.engineerscodex.com/p/how-instagram-scaled-to-14-million)

Instagram went from 0 to 14 million users in 2010-2011, with only 3 engineers! What tech stack did they use and what successful experiences can we learn from? The article introduces the relevant technologies and implementation schemes used.

![Instagram Early Architecture Overview](https://img.pythoncat.top/Architecture-Overview-of-Instagram.png)

12. [Language Design of Starlark by Google](https://github.com/bazelbuild/starlark/blob/master/design.md)

Google designed Starlark to replace Python as a build description language, and the syntax is very similar. This document explains some of its design principles and many differences from the Python language, such as its Boolean values are not integers, strings are not iterable, there is no "is" operator, for/if statements are not allowed outside of functions, and so on.

13. [The History and State of Data Engineering](https://www.dedp.online/part-1/1-introduction/history-and-state-of-data-engineering.html)

The article is from the free online e-book Data Engineering Design Patterns, which is being serialized. Data engineering has gone through stages such as SQL, dimensional modeling, business intelligence and big data, MapReduce and Hadoop, and the cloud revolution.

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [watchfiles: Simple, modern and fast file watching and code reload in python](https://github.com/samuelcolvin/watchfiles)

A simple, modern and fast file watching and code reload library for Python. It uses the `Notify` library from Rust to handle file system notifications under the hood, and supports both synchronous and asynchronous event handling. (1.4k stars)

```python
from watchfiles import watch

for changes in watch("./path/to/dir"):
    print(changes)
```

2. [hy: A dialect of Lisp that's embedded in Python](https://github.com/hylang/hy)

Hy is an alternative syntax for Python that provides a variety of additional features, generalizations, and syntactic simplifications over Python. Compared to other Lisps, it offers direct access to Python's built-in and third-party libraries. (star 4.7K)

3. [pyapp: Runtime installer for Python applications](https://github.com/ofek/pyapp)

A tool developed in Rust that builds self-contained Python applications with a runtime installer, creating a single binary for each platform.

4. [yarl: Yet another URL library](https://github.com/aio-libs/yarl)

Provides a URL class that makes it easy to parse and modify URLs, supporting access to each part of the URL via attributes. (1K stars)

5. [apispec: A pluggable API specification generator. Currently supports the OpenAPI Specification (f.k.a. the Swagger specification)](https://github.com/marshmallow-code/apispec)

Apispec: A pluggable API specification generator. It currently supports the OpenAPI Specification (formerly known as the Swagger specification). It is framework agnostic and has built-in support for marshmallow. (1.1K stars)

6. [marshmallow: A lightweight library for converting complex objects to and from simple Python datatypes](https://github.com/marshmallow-code/marshmallow)

A simple object serialization library that is ORM/ODM/framework agnostic and can be used for validating input data, serializing and deserializing, and comes with a rich set of field types and supports multiple data formats. (star 6.8K)

7. [jake: Effortlessly create and deploy your own one-link website on GitHub](https://github.com/thevahidal/jake)

A one-link website is suitable for use as a personal homepage. This website template uses GitHub Pages for deployment, allowing you to easily and effortlessly build a beautiful personal homepage.

8. [docflow: DocFlow is a powerful Document Management API designed to streamline document handling, including seamless uploading, downloading, organization, versioning, sharing, and more](https://github.com/jiisanda/docflow)

Simplify the handling of document types, supports authentication and authorization, list permission control, document CRUD, document preview, version control, etc.

9. [auto\_job\_\_find\_\_chatgpt\_\_rpa: This is a tool used to automatically generate a cover letter using chatgpt based on your resume and job description and send messages to bosses in China](https://github.com/Frrrrrrrrank/auto_job__find__chatgpt__rpa)

A Chinese-made tool that automatically generates cover letters using ChatGPT based on your resume and job description, and sends messages to hiring managers in China. Good luck in your job search during this winter hiring season!

10. [oshit: Get your hit of HackerNews in the terminal](https://github.com/davep/oshit)

A simplified Hacker News reader for the terminal, without features like login, voting, or posting, but with support for viewing user and comment information.

![Hacker News reader in the command line](https://img.pythoncat.top/2024-01-06_hacker_news.png)

11. [mixtral-offloading: Run Mixtral-8x7B models in Colab or consumer desktops](https://github.com/dvmazur/mixtral-offloading)

Enables efficient inference of Mixtral-8x7B models, requiring approximately 16 GB of VRAM and 11 GB of RAM. (1.4k stars)

12. [RecoverPy: Interactively find and recover deleted or overwritten files from your terminal](https://github.com/PabloLec/RecoverPy)

A file & data recovery tool for Linux that supports text search and interactive operation, allowing you to recover deleted or overwritten files. (1.1k stars)

13. [MobileVLM: MobileVLM: A Fast, Strong and Open Vision Language Assistant for Mobile Devices](https://github.com/Meituan-AutoML/MobileVLM)

A multimodal vision-language model (MMVLM) that runs on mobile devices, with 1.4B and 2.7B parameter sizes, achieving impressive performance of 21.5 tokens per second and 65.3 tokens per second on Qualcomm Snapdragon 888 CPU and NVIDIA Jeston Orin GPU, respectively.

![Architecture diagram of MobileVLM](https://img.pythoncat.top/mobilevlm_arch.png)

## 🐢Podcasts & Videos

1. [Snake Charmer Says Ep 44. Chatting with Tualatrix About Tech Stack for Indie Development](https://www.xiaoyuzhoufm.com/episode/65945c8c1e736aa25c935885?s=eyJ1IjoiNjEzYjhjYjRlMGY1ZTcyM2JiNWNlN7RmIn0%3D)

How do independent developers make technology selections? Why does Tualading use Python as the backend language for his projects? (Appendix: Another podcast two years ago [ByteTalk 3. Chatting with Tualading About the Things of Independent Developers](https://www.xiaoyuzhoufm.com/episode/618c9897fad86a854205b2a0?s=eyJ1IjoiNjEzYjhjYjRlMGY1ZTcyM2JiNWNlN2RmIn0%3D))

2. [An Introduction to Coding In Rust for Pythonistas](https://www.youtube.com/watch?v=MoqtsYLGCC4)

This video compares and contrasts Rust programming from the perspective of Python developers, highlighting key differences in features such as Python classes and Rust structs.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.