# Python Trending Weekly #33 (2023-12-30)

Welcome to the Python Trending Weekly, a weekly newsletter about Python, AI and general programming techniques, with the majority links in English and a small portion in Chinese. 

The [original version](https://pythoncat.top/posts/2023-12-30-weekly) of the weekly was written in Chinese. What you are reading here is mostly translated by LLMs. 

**Substack Channel** : [Click to subscribe](https://pythoncat.substack.com/s/python-trending-weekly) 

## 🦄Articles & Tutorials

1. [Flask is Dead, FastAPI is the Future](https://zhuanlan.zhihu.com/p/672806587)

An article with a very eye-catching and provocative title. To be honest, I'm used to avoiding reading articles with titles like "xxx is Dead", "Goodbye xxx" because I've seen too many of them trying to stir up emotions. It's perfectly reasonable to compare the pros and cons of frameworks, but it's narrow-minded to deliberately lead the discussion towards disparaging one side. (Attached: a response article [Flask is Dead, FastAPI Lives Forever](https://greyli.com/flask-fastapi-2023/), and a response to the response article [Rational Participation in the Discussion "Flask is Dead, FastAPI Lives Forever"](https://zhuanlan.zhihu.com/p/673847164))

2. [Python + Flask: Build Your Own RSS Security Feed](https://xz.aliyun.com/t/12980)

How to build your own RSS feed website with Python? This article introduces a complete Flask project that supports RSS docking, article parsing, and automatic updates. Finally, it is deployed online and Nginx is used as a reverse proxy.

3. [Microdot: Yet Another Python Web Framework](https://blog.miguelgrinberg.com/post/microdot-yet-another-python-web-framework)

The author introduces an open-source web framework with a syntax similar to Flask, which fully supports asyncio, Websocket, SSE, CORS, Jinja, and uTemplate templates. It is very small (the core framework code is 700+ lines) and can be used with MicroPython.

4. [Weekend AI Project: Running a 7B Large Language Model on a Nokia 9500 From 2004](https://ai.plainenglish.io/a-weekend-ai-project-running-a-7b-large-language-model-on-a-nokia-9500-from-2004-04f77e123194)

It's quite interesting to run the current hottest large language model on an early smartphone from nearly 20 years ago! The author used the 4GB-sized `Llama-2–7B-Chat-GPTQ` model, first tried to create an application with Streamlit, but found that its browser was not supported, and finally developed a simple web page with Flask to achieve interaction with the LLM!

![Large Language Model on Nokia 9500 Phone](https://img.pythoncat.top/2023-12-30_nokia.png)

5. [Three Common Pitfalls of Python Asyncio](https://so1n.me/2023/12/28/python_asyncio_lib_how_to_use_it_correctly/)

Asyncio came out late, unlike `go`, `Dart`, and `js`, which run event loops implicitly, and it uses the `async` and `await` syntax, so it's easy to misuse. This article introduces three pitfalls and the correct ways to avoid them.

6. [To Code and Beyond: A Neverland Adventure in Bash, Lua, Python, and Rust](https://dev.to/proteusiq/to-code-and-beyond-a-neverland-adventure-in-bash-lua-python-and-rust-1jon)

This is a short and recommended read. The article consists of three "adventure stories" that aim to show us the similarities and differences between Bash, Lua, Python, and Rust in implementing regular for loops, comprehensions, and iterators. (See also the author's other article, [Down the Data Rabbit Hole: Alice's Adventure from Pandas to DuckDB Wonderland](https://dev.to/proteusiq/down-the-data-rabbit-hole-alices-adventure-from-pandas-to-duckdb-wonderland-25h0).)

7. [YAML, Python, and the Holy Graal](https://yamlscript.org/posts/advent-2023/dec-21/)

YAMLScript is a functional programming language with a syntax encoded in YAML. It provides a `yamlscript` library for Python that can manipulate YAML files like `PyYAML` does, supports the latest YAML 1.2 specification, and can also generate or manipulate data using YAMLScript functions.

8. ["Python -m": The Coolest Python Flag That Deserves More Attention](https://www.blog.dailydoseofds.com/p/python-m-the-coolest-python-flag)

Python has quite a few command-line flags, and this article mainly introduces the usage of the "-m" flag. I highly agree with the use of "Coolest" in the original title to describe this flag. Back in 2019, I wrote a more detailed article, [Typical Usage, Principle Analysis, and Evolution of -m in Python](https://pythoncat.top/posts/2019-11-10-m), which I sincerely recommend if you haven't read it!

9. [A Beginner's Guide to CI in Python](https://switowski.com/blog/ci-101/)

Continuous Integration (CI) is the process of merging developers' code into a central repository, involving steps like pre-commit testing, code formatting, static analysis, conflict resolution, and more. Many tasks need to be automated, and the article details topics like getting started with CI, choosing a CI platform, CI tasks in practice, and extending CI tasks.

10. [A Concise Tutorial on Python Type Hints (Based on Python 3.12)](https://zhuanlan.zhihu.com/p/464979921)

A comprehensive tutorial on Type Hints, mostly summarizing the content of "Fluent Python 2nd Edition" and the official documentation, then reorganized and supplemented with new content based on Python 3.12. (Contributed by @[JayYoung2021](https://github.com/JayYoung2021))

11. [Pyinstaller EXE Detected as Virus? Solutions and Alternatives](https://coderslegacy.com/pyinstaller-exe-detected-as-virus-solutions/)

Pyinstaller can convert Python scripts into Windows executables. Why might code that is harmless in reality be detected as a virus? How can we avoid false positives from antivirus software? The article introduces solutions like avoiding the single-file mode, building Pyinstaller's bootloader yourself, using a code signing certificate, and using alternative tools like Nuitka/Inno Setup.

12. [Introducing Fontimize | Subset Fonts to Exactly and Only Your Website's Used Characters](https://daveon.design/introducing-fontimize-subset-fonts-to-exactly-and-only-your-websites-used-characters.html)

"Font subsetting" refers to a subset of a font file, which helps optimize performance and reduce download time. The author introduces his open-source Python library `fontimize ` for generating font subsets, which can reduce the font file size by about 95%.

13. [GH-113464: JIT compiler for copy-and-patch](https://github.com/python/cpython/pull/113465)

In issue 27, we shared the news that Python 3.13 is working on a JIT compiler, and now @brandtbucher has submitted a PR for it (just before Christmas)! The commit message is like a poem, quite interesting.

14. [Losing Metaphors: Zip and Paste](https://www.jefftk.com/p/losing-metaphors-zip-and-paste)

In Python, `zip` merges two lists together, like a zipper, while in Unix, the `paste` command does the same thing, with its metaphor being pasting: putting one column next to another. `paste` dates back to 1978, while `zip` dates back to 1988, but now both words are commonly seen in other meanings: `paste` is always used for "copy and paste", and `zip` is a compression file format.

15. [4 Billion IF Statements](https://andreasjhkarlsson.github.io//jekyll/update/2023/12/27/4-billion-if-statements.html)

The author made a seemingly boring attempt to successfully write 4 billion if statements into a 40GB file, which can quickly determine whether any 32-bit number is even or odd. Of course, this has no practical use, but reading the article will show you that doing this is not easy: how to efficiently write so many if statements? How to control the file size to avoid compilation errors? How to load and execute to improve performance?

🎁 Python Trending Weekly 🎁 organizes its content into seasons, with every 30 issues forming a season. The highlights from the first season have been compiled for your convenience. You can access them online [here](https://pythoncat.top/posts/2023-12-11-weekly) (Chinese).

## 🐿️Projects & Resources

1. [NiceGUI: A Pythonic Way to Build Web UIs](https://github.com/zauberzeug/nicegui)

A Python-based UI framework for creating standard front-end elements like buttons, dialogs, Markdown, 3D scenes, and plots, with built-in timers for refreshing data, support for Tailwind CSS autocompletion, and the ability to run in Jupyter Notebook. (6.2k stars)

2. [csvkit: Command-line tools for converting and processing CSV](https://github.com/wireservice/csvkit)

A set of command-line tools for converting and processing CSV files. Each command does one common task, including converting Excel to CSV, JSON to CSV, CSV to JSON, printing column names, finding rows that match a cell, generating summary statistics, querying tabular data with SQL syntax, and importing and querying data from databases. (5.7K stars)

```python
# Extract data from PostgreSQL into a CSV file
sql2csv --db postgresql:///database --query "select * from data" > new.csv
```

3. [evue: A high-performance GUI framework based on html/css](https://github.com/scriptiot/evue)

Developed based on Flutter/LVGL, it supports multiple operating systems, dark/light themes, and responsiveness. It adopts compile-time code generation technology, which has excellent performance; natively supports MVVM, data-driven UI.

![evue drag and drop to generate calculator](https://img.pythoncat.top/2023-12-29-evue.png)

4. [JARVIS: Your own personal voice assistant](https://github.com/AlexandreSajus/JARVIS)

Develop your own personal voice assistant that transcribes your voice to text, uses GPT-3 to generate a response, uses ElevenLabs to turn the large model's response into speech, uses Pygame to play it, and uses Taipy to display it on a web page.

5. [Gooey: Turn (almost) any Python command-line program into a full GUI application with one line](https://github.com/chriskiehl/Gooey)

Can you believe that you can turn a CLI program into a user-friendly GUI application by simply adding a single line of decorator code from this library? This project has been around for years and has a lot of stars. (20K stars)

6. [mod: Mojo's package manager tool](https://github.com/better-mojo/mod)

Mojo doesn't have an official package manager, so the author developed one in Python. It is mainly inspired by Rust `cargo` and Python `poetry`, and the planned capabilities are: mod = cargo + rustup + poetry + pyenv.

7. [Canopy: A RAG Framework and Context Engine Powered by Pinecone](https://github.com/pinecone-io/canopy)

Built on top of the Pinecone vector database, this RAG framework enables you to chat with your document data with simple commands. It includes features such as text data chunking and embedding, conversation history management, query optimization, contextual retrieval (including prompt engineering), and enhanced generation.

![Image of Canopy's workflow diagram](https://img.pythoncat.top/canopy.png)

8. [toogether-backend: Django REST Social Dating App Project](https://github.com/damianstone/toogether-backend)

This is a mobile social dating app project, which is the backend. It uses the Django framework and uses Gdal, Geos, and Postgis for geo-positioning. It supports functions such as recommended matching, chat, and group chat.

9. [DouyinLiveRecorder: A live streaming recording software with loopback and multi-person recording](https://github.com/ihmily/DouyinLiveRecorder)

Supports live streaming recording on platforms such as Douyin, Tiktok, Kuaishou, Huya, Douyu, Bilibili, and Xiaohongshu. It can capture live stream source addresses from multiple platforms, and parse Douyin and Kuaishou videos without watermarks. Based on FFmpeg, it supports custom configuration recording and live status push.

10. [StreamDiffusion: A Pipeline-Level Solution for Real-time Interactive Generation](https://github.com/cumulo-autumn/StreamDiffusion)

This project introduces significant performance enhancements to current diffusion-based image generation techniques using a novel approach. (6.4k stars)

[Image of real-time generation of ocean waves]

11. [sqlglot: A SQL Parser and Transpiler](https://github.com/tobymao/sqlglot)

A dependency-free SQL parser, transpiler, optimizer, and engine. It can be used to format SQL or translate between 20 different dialects, such as DuckDB, Presto/Trino, Spark/Databricks, Snowflake, and BigQuery. (4.4k stars)

12. [texify: A Mathematical OCR Model that Outputs LaTeX and Markdown](https://github.com/VikParuchuri/texify)

Converts images or PDFs containing mathematical formulas into Markdown and LaTeX formats. It can run on CPU, GPU, or MPS. Unlike similar projects like Pix2tex and nougat, it supports a wider variety of web scenarios.

13. [talebook: A Simple Online Personal Library](https://github.com/talebook/talebook)

A personal library management system based on Calibre that supports online reading. The backend uses the Tornado framework, and the frontend uses Vue.js and Readium.js. It has a beautiful interface and supports multiple users, online reading, batch import, email push, automatic book information updates, private mode, and other functions. (2k stars)

![talebook](https://img.pythoncat.top/talebook.png)

## 🐢Podcasts & Videos

1. [Why Do Python, Go, Rust, and Kotlin Not Have a Ternary Operator?](https://www.bilibili.com/video/BV1v64y1J7hS)

This is a video made by UP Master @今天晚放学 based on my article, which can be considered a New Year's Day gift for 2024! I believe many readers have already read the [article version](https://pythoncat.top/posts/2023-04-03-condition) (after all, I shared it on a whim in the last issue of the weekly), but I still recommend that you watch this video version. In addition, the author's "Programming Aesthetics" series of videos are really well done.

## 🐼Subscribe Welcome

- [Blog](https://pythoncat.top): Explore my independent blog where you can find a collection of original/translated technical articles over the years, along with some reflections since 2009.
- [Newsletter](https://pythoncat.substack.com/s/python-trending-weekly): Subscribe to my channel on Substack for a curated newsletter delivered straight to your inbox, keeping you updated on current affairs.
- [Github](https://github.com/chinesehuazhou/python-weekly): Access the Markdown source files of this weekly digest on Github and feel free to use them for anything you have in mind!
- [Telegram](https://t.me/pythontrendingweekly): Beyond notifications for the weekly digest, I consider it an "extra edition," providing additional, more diverse information.
- [Twitter](https://twitter.com/chinesehuazhou): Follow me on Twitter where my feed is filled with numerous accounts of developers and organizations in the Python community.